/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix.protocol.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import uk.betacraft.legacyfix.LegacyFixLauncher;
import uk.betacraft.legacyfix.protocol.impl.HandlerBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelListHandler
extends HandlerBase {
    private static final Pattern LEVEL_LIST_PATTERN = Pattern.compile("(http:\\/\\/(www\\.)?minecraft\\.net(:(.+)?)?\\/listmaps\\.jsp\\?user=(.+)?)");
    protected static final String LEVELS_DIR_PATH = System.getProperty("lf.levelsDir", LegacyFixLauncher.getGameDir() + "/levels");
    public static final String EMPTY_LEVEL = "-";

    public LevelListHandler(URL u, Pattern patternUsed) {
        super(u, patternUsed);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        String levels = "";
        for (int i = 0; i < 5; ++i) {
            levels = levels + "-;";
        }
        File levelsFolder = new File(LEVELS_DIR_PATH);
        File levelNames = new File(levelsFolder, "levels.txt");
        if (!levelNames.exists()) {
            return new ByteArrayInputStream(levels.getBytes());
        }
        return new FileInputStream(levelNames);
    }

    public static List<Pattern> regexPatterns() {
        return Arrays.asList(LEVEL_LIST_PATTERN);
    }
}

