/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix.patch;

import java.lang.instrument.Instrumentation;
import javassist.ClassPool;
import uk.betacraft.legacyfix.LegacyFixAgent;
import uk.betacraft.legacyfix.patch.PatchException;

public abstract class Patch {
    private final String id;
    private final String description;
    private final Object setting;
    private final boolean isDefault;
    protected static final ClassPool pool = ClassPool.getDefault();

    public Patch(String id, String description, boolean isDefault) {
        this.id = id;
        this.description = description;
        this.isDefault = isDefault;
        this.setting = LegacyFixAgent.getSettings().get("lf." + this.getId() + (isDefault ? ".disable" : ""));
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean shouldApply() {
        return this.isDefault ? this.setting == null : this.setting != null;
    }

    public abstract void apply(Instrumentation var1) throws PatchException, Exception;
}

