/*
 * Decompiled with CFR 0.152.
 */
package org.betacraft.launcher;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.betacraft.launcher.DownloadResult;
import org.betacraft.launcher.Lang;
import org.betacraft.launcher.LanguageElement;
import org.betacraft.launcher.Launcher;
import org.betacraft.launcher.Release;
import org.betacraft.launcher.ReleaseJson;
import org.betacraft.launcher.Util;
import org.betacraft.launcher.Window;
import uk.betacraft.auth.CustomResponse;
import uk.betacraft.auth.Request;
import uk.betacraft.auth.RequestUtil;
import uk.betacraft.json.lib.ModCategory;
import uk.betacraft.json.lib.ModObject;

public class ModsRepository
extends JFrame
implements ActionListener,
LanguageElement {
    public static ArrayList<ModCategory> mods = new ArrayList();
    static ArrayList<DefaultMutableTreeNode> treenodes;
    static JTree tree;
    static JScrollPane listScroller;
    static JButton more_button;
    static JButton LoadButton;
    static JButton CloseButton;
    static JPanel panel;
    static GridBagConstraints constr;

    public static void loadMods() {
        try {
            ModCategory[] mc;
            String modlistjson = new Request(){

                @Override
                public CustomResponse perform() {
                    this.REQUEST_URL = "http://api.betacraft.uk/getmods.jsp";
                    return new CustomResponse(RequestUtil.performGETRequest(this));
                }
            }.perform().response;
            for (ModCategory cat : mc = Util.gson.fromJson(modlistjson, ModCategory[].class)) {
                mods.add(cat);
            }
        }
        catch (Exception ex) {
            System.err.println("A critical error occurred while loading mod list!");
            ex.printStackTrace();
        }
    }

    public static ModObject getMod(String name) {
        for (ModCategory cat : mods) {
            for (ModObject obj : cat.mods) {
                if (!obj.full_name.equalsIgnoreCase(name)) continue;
                return obj;
            }
        }
        return null;
    }

    public ModsRepository() {
        System.out.println("Mods repository window opened.");
        this.setIconImage(Window.img);
        this.setMinimumSize(new Dimension(282, 386));
        this.setTitle(Lang.INSTANCE_MODS_REPOSITORY);
        this.setResizable(true);
        panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        constr = new GridBagConstraints();
        ModsRepository.constr.fill = 1;
        ModsRepository.constr.insets = new Insets(5, 5, 0, 5);
        ModsRepository.constr.gridwidth = -1;
        ModsRepository.constr.weightx = 1.0;
        more_button = new JButton(Lang.ADDON_SHOW_INFO);
        more_button.addActionListener(this);
        panel.add((Component)more_button, constr);
        this.add((Component)panel, "North");
        panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        ModsRepository.constr.gridy = 2;
        ModsRepository.constr.weighty = -1.0;
        ModsRepository.constr.gridheight = 1;
        ModsRepository.constr.insets = new Insets(0, 5, 5, 5);
        LoadButton = new JButton(Lang.LOAD);
        LoadButton.addActionListener(this);
        panel.add((Component)LoadButton, constr);
        ModsRepository.constr.gridx = 1;
        CloseButton = new JButton(Lang.CLOSE);
        CloseButton.addActionListener(this);
        panel.add((Component)CloseButton, constr);
        this.add((Component)panel, "South");
        panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.updateList();
        this.getContentPane().add((Component)panel, "Center");
        this.pack();
        this.setLocationRelativeTo(Window.mainWindow);
        this.setVisible(true);
    }

    @Override
    public void update() {
        this.setTitle(Lang.INSTANCE_MODS_REPOSITORY);
        LoadButton.setText(Lang.OPTIONS_OK);
        this.pack();
    }

    protected void updateList() {
        DefaultMutableTreeNode maintreenode = new DefaultMutableTreeNode("root");
        for (ModCategory cat : mods) {
            DefaultMutableTreeNode catnode = new DefaultMutableTreeNode(cat.mod_category);
            for (ModObject obj : cat.mods) {
                DefaultMutableTreeNode modnode = new DefaultMutableTreeNode(obj);
                catnode.add(modnode);
            }
            maintreenode.add(catnode);
        }
        tree = new JTree();
        tree.setRootVisible(false);
        tree.getSelectionModel().setSelectionMode(1);
        DefaultTreeModel treemodel = new DefaultTreeModel(maintreenode);
        tree.setModel(treemodel);
        ModsRepository.constr.weighty = 1.0;
        ModsRepository.constr.gridheight = -1;
        ModsRepository.constr.gridy = 1;
        if (listScroller != null) {
            panel.remove(listScroller);
        }
        listScroller = new JScrollPane(tree);
        listScroller.setWheelScrollingEnabled(true);
        panel.add((Component)listScroller, constr);
    }

    public void saveVersions() {
        TreePath treepath = tree.getSelectionPath();
        if (treepath == null) {
            JOptionPane.showMessageDialog(this, Lang.ERR_NO_SELECTION, "", 2);
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treepath.getLastPathComponent();
        Object o = node.getUserObject();
        if (o != null && o instanceof ModObject) {
            ModObject obj = (ModObject)o;
            DownloadResult download = new ReleaseJson(obj.full_name, obj.info_file_url).downloadJson();
            if (download.isOK()) {
                Release.loadVersions(Release.VersionRepository.BETACRAFT);
                Launcher.currentInstance.version = obj.full_name;
                Launcher.setInstance(Launcher.currentInstance);
                Launcher.currentInstance.saveInstance();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == LoadButton) {
            this.saveVersions();
        } else if (e.getSource() == CloseButton) {
            this.dispose();
            Window.modsRepo = null;
        } else if (e.getSource() == more_button) {
            TreePath treepath = tree.getSelectionPath();
            if (treepath == null) {
                JOptionPane.showMessageDialog(this, Lang.ERR_NO_SELECTION, "", 2);
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treepath.getLastPathComponent();
            Object o = node.getUserObject();
            String link = null;
            if (o instanceof String) {
                for (ModCategory modCat : mods) {
                    if (!modCat.mod_category.equals((String)o) || modCat.mods.length < 1) continue;
                    link = modCat.mods[0].website;
                    break;
                }
            } else if (o instanceof ModObject) {
                ModObject mod = (ModObject)o;
                link = mod.website;
            }
            if (link != null && !link.isEmpty()) {
                Util.openURL(link);
            }
        }
    }
}

