/*
 * Decompiled with CFR 0.152.
 */
package org.betacraft.launcher;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.betacraft.launcher.BC;
import org.betacraft.launcher.DownloadResult;
import org.betacraft.launcher.LanguageElement;
import org.betacraft.launcher.Launcher;
import org.betacraft.launcher.Util;
import org.betacraft.launcher.Window;

public class Lang
extends JFrame
implements LanguageElement {
    public static List<String> locales = new ArrayList<String>();
    static JList list;
    static DefaultListModel listModel;
    static JScrollPane listScroller;
    JButton OKButton;
    static JPanel panel;
    static GridBagConstraints constr;
    public static String locale_id;
    public static String UPDATE_FOUND;
    public static String WINDOW_PLAY;
    public static String WINDOW_SELECT_VERSION;
    public static String WINDOW_LANGUAGE;
    public static String WINDOW_OPTIONS;
    public static String WINDOW_TITLE;
    public static String WINDOW_DOWNLOADING;
    public static String WINDOW_DOWNLOADING_RESOURCE;
    public static String PACKING_MOD;
    public static String MANUAL_DOWNLOAD;
    public static String WINDOW_USERNAME_FIELD_EMPTY;
    public static String LANG;
    public static String OPTIONS_PROXY;
    public static String OPTIONS_UPDATE_HEADER;
    public static String OPTIONS_KEEP_OPEN;
    public static String OPTIONS_RPC;
    public static String OPTIONS_LAUNCH_ARGS;
    public static String OPTIONS_OK;
    public static String OPTIONS_WIDTH;
    public static String OPTIONS_HEIGHT;
    public static String OPTIONS_TITLE;
    public static String SORT_FROM_OLDEST;
    public static String SORT_FROM_NEWEST;
    public static String VERSION_LIST_TITLE;
    public static String ADDON_LIST_TITLE;
    public static String ADDON_NO_DESC;
    public static String ADDON_SHOW_INFO;
    public static String LOGGING_IN;
    public static String LOGIN_TITLE;
    public static String LOGIN_BUTTON;
    public static String LOGOUT_BUTTON;
    public static String LOGIN_EMAIL_NICKNAME;
    public static String LOGIN_PASSWORD;
    public static String LOGIN_MOJANG_HEADER;
    public static String LOGIN_MICROSOFT_BUTTON;
    public static String LOGIN_MICROSOFT_TITLE;
    public static String LOGIN_MICROSOFT_ERROR;
    public static String LOGIN_MICROSOFT_PARENT;
    public static String LOGIN_MICROSOFT_NO_XBOX;
    public static String LOGIN_MICROSOFT_NO_MINECRAFT;
    public static String LOGIN_MICROSOFT_CODE_LINE1;
    public static String LOGIN_MICROSOFT_CODE_LINE2;
    public static String LOGIN_RELOGIN;
    public static String LOGIN_FAILED;
    public static String LOGIN_FAILED_INVALID_CREDENTIALS;
    public static String JAVA_EXECUTABLE;
    public static String JAVA_INVALID;
    public static String JAVA_TOO_RECENT;
    public static String JAVA_RECOMMENDED_NOT_FOUND;
    public static String JAVA_WRONG_ARCH;
    public static String JAVA_SSL_NOT_SUPPORTED;
    public static String JAVA_SSL_TO_MICROSOFT_ACCOUNT;
    public static String JAVA_SSL_TO_DOWNLOAD_RESOURCE;
    public static String JAVA_SSL_TO_AUTHENTICATE;
    public static String JAVA_INTEL_GRAPHICS;
    public static String JAVA_INTEL_GRAPHICS_WIKI;
    public static String INSTANCE_REMOVE_DIRECTORY;
    public static String INSTANCE_DIRECTORY;
    public static String INSTANCE_GAME_DIRECTORY_TITLE;
    public static String INSTANCE_REMOVE_QUESTION;
    public static String INSTANCE_REMOVE_TITLE;
    public static String INSTANCE_CHANGE_ICON_NAME;
    public static String INSTANCE_CHANGE_ICON_TITLE;
    public static String INSTANCE_CHANGE_ICON_UNSUPPORTED;
    public static String INSTANCE_CHANGE_ICON_UNSUPPORTED_TITLE;
    public static String INSTANCE_CHANGE_ICON_FAILED;
    public static String INSTANCE_CHANGE_ICON_FAILED_TITLE;
    public static String INSTANCE_NAME;
    public static String INSTANCE_SELECT_ADDONS;
    public static String INSTANCE_MODS_REPOSITORY;
    public static String SELECT_INSTANCE_TITLE;
    public static String SELECT_INSTANCE_NEW;
    public static String TAB_CHANGELOG;
    public static String TAB_INSTANCES;
    public static String TAB_SERVERS;
    public static String VERSION_CUSTOM;
    public static String BROWSER_TITLE;
    public static String TAB_SRV_LOADING;
    public static String TAB_SRV_FAILED;
    public static String TAB_CL_LOADING;
    public static String TAB_CL_FAILED;
    public static String FORCE_UPDATE;
    public static String CONSOLE_OUTPUT_FOR;
    public static String CONSOLE_OUTPUT;
    public static String WRAP_USER;
    public static String WRAP_VERSION;
    public static String WRAP_SERVER;
    public static String WRAP_SERVER_TITLE;
    public static String WRAP_CLASSIC_RESIZE;
    public static String UNEXPECTED_ERROR;
    public static String ERR_NO_CONNECTION;
    public static String ERR_DL_FAIL;
    public static String ERR_NO_SELECTION;
    public static String YES;
    public static String NO;
    public static String CANCEL;
    public static String SELECT;
    public static String REMOVE;
    public static String BROWSE;
    public static String COPY;
    public static String CLEAR;
    public static String LOAD;
    public static String CLOSE;
    public static String LINK;
    public static String PAUSE;
    public static String UNPAUSE;

    public Lang() {
        boolean panelnull;
        System.out.println("Language selection window opened.");
        this.setIconImage(Window.img);
        this.setMinimumSize(new Dimension(282, 386));
        this.setTitle(LANG);
        this.setResizable(true);
        boolean bl = panelnull = panel == null;
        if (panelnull) {
            panel = new JPanel();
            panel.setLayout(new GridBagLayout());
        }
        constr = new GridBagConstraints();
        Lang.constr.gridx = 0;
        Lang.constr.fill = 1;
        Lang.constr.insets = new Insets(5, 5, 0, 5);
        Lang.constr.gridwidth = -1;
        Lang.constr.gridheight = -1;
        Lang.constr.gridy = 0;
        Lang.constr.weightx = 1.0;
        Lang.constr.weighty = 1.0;
        try {
            if (locales.isEmpty()) {
                this.initLang();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        ++Lang.constr.gridy;
        Lang.constr.weighty = -1.0;
        Lang.constr.gridheight = 1;
        Lang.constr.insets = new Insets(5, 5, 5, 5);
        if (panelnull) {
            this.OKButton = new JButton(OPTIONS_OK);
            this.OKButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Lang.this.setLang();
                    Window.lang = null;
                }
            });
            panel.add((Component)this.OKButton, constr);
        }
        this.add(panel);
        this.pack();
        this.setLocationRelativeTo(Window.mainWindow);
        this.setVisible(true);
    }

    @Override
    public void update() {
        this.setTitle(LANG);
        this.OKButton.setText(OPTIONS_OK);
    }

    public void setLang() {
        String lang = (String)list.getSelectedValue();
        if (!Lang.download(lang).isPositive()) {
            return;
        }
        BC.SETTINGS.setProperty("language", lang);
        BC.SETTINGS.flushToDisk();
        this.dispose();
        Launcher.restart(Launcher.javaRuntime.getAbsolutePath());
    }

    public void initLang() throws IOException {
        URL url = new URL("http://files.betacraft.uk/launcher/assets/lang/" + locale_id + "/list.txt");
        Scanner scanner = new Scanner(url.openStream(), "UTF-8");
        while (scanner.hasNextLine()) {
            String now = scanner.nextLine();
            if (now.equalsIgnoreCase("")) continue;
            locales.add(now);
        }
        scanner.close();
        int i = 0;
        int index = 0;
        listModel = new DefaultListModel();
        String lang = BC.SETTINGS.getProperty("language");
        for (String item : locales) {
            listModel.addElement(item);
            if (lang.equals(item)) {
                index = i;
            }
            ++i;
        }
        list = new JList(listModel);
        list.setSelectionMode(0);
        list.setLayoutOrientation(0);
        list.setVisibleRowCount(10);
        list.setSelectedIndex(index);
        if (listScroller != null) {
            panel.remove(listScroller);
        }
        listScroller = new JScrollPane(list);
        listScroller.setWheelScrollingEnabled(true);
        panel.add((Component)listScroller, constr);
    }

    public static void applyNamesSwing() {
        try {
            UIManager.put("OptionPane.okButtonText", OPTIONS_OK);
            UIManager.put("OptionPane.cancelButtonText", CANCEL);
            UIManager.put("OptionPane.yesButtonText", YES);
            UIManager.put("OptionPane.noButtonText", NO);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static boolean downloaded(String lang) {
        File file = new File(BC.get() + "launcher" + File.separator + "lang" + File.separator + lang + ".txt");
        return file.exists();
    }

    public static String encodeForURL(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8").replace("+", "%20");
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static DownloadResult download(String lang) {
        DownloadResult download = Launcher.download("http://files.betacraft.uk/launcher/assets/lang/" + locale_id + "/" + Lang.encodeForURL(lang) + ".txt", new File(BC.get() + "launcher" + File.separator + "lang", lang + ".txt"));
        if (!download.isPositive()) {
            JOptionPane.showMessageDialog(Window.mainWindow, "No Internet connection", "Language file download failed!", 0);
        }
        return download;
    }

    public static void refresh(boolean download, boolean force) {
        String lang = BC.SETTINGS.getProperty("language");
        if (lang == null) {
            Lang.applyNamesSwing();
            return;
        }
        File file = new File(BC.get() + "launcher" + File.separator + "lang" + File.separator + lang + ".txt");
        if (download && !Lang.download(lang).isOK() || !file.exists()) {
            Lang.applyNamesSwing();
            return;
        }
        String charset = "UTF-8";
        Util.PropertyFile langentries = new Util.PropertyFile(file, charset);
        if (langentries.hasProperty("version_button")) {
            WINDOW_SELECT_VERSION = langentries.getProperty("version_button");
        }
        if (langentries.hasProperty("play_button")) {
            WINDOW_PLAY = langentries.getProperty("play_button");
        }
        if (langentries.hasProperty("options_button")) {
            WINDOW_OPTIONS = langentries.getProperty("options_button");
        }
        if (langentries.hasProperty("launcher_title")) {
            WINDOW_TITLE = langentries.getProperty("launcher_title") + Launcher.VERSION;
        }
        if (langentries.hasProperty("language")) {
            WINDOW_LANGUAGE = langentries.getProperty("language");
        }
        if (langentries.hasProperty("downloading")) {
            WINDOW_DOWNLOADING = langentries.getProperty("downloading");
        }
        if (langentries.hasProperty("downloading_resource")) {
            WINDOW_DOWNLOADING_RESOURCE = langentries.getProperty("downloading_resource");
        }
        if (langentries.hasProperty("packing_mod")) {
            PACKING_MOD = langentries.getProperty("packing_mod");
        }
        if (langentries.hasProperty("manual_download")) {
            MANUAL_DOWNLOAD = langentries.getProperty("manual_download");
        }
        if (langentries.hasProperty("username_field_empty")) {
            WINDOW_USERNAME_FIELD_EMPTY = langentries.getProperty("username_field_empty");
        }
        if (langentries.hasProperty("lang_title")) {
            LANG = langentries.getProperty("lang_title");
        }
        if (langentries.hasProperty("unexpected_error")) {
            UNEXPECTED_ERROR = langentries.getProperty("unexpected_error");
        }
        if (langentries.hasProperty("no_connection")) {
            ERR_NO_CONNECTION = langentries.getProperty("no_connection");
        }
        if (langentries.hasProperty("download_fail")) {
            ERR_DL_FAIL = langentries.getProperty("download_fail");
        }
        if (langentries.hasProperty("no_selection")) {
            ERR_NO_SELECTION = langentries.getProperty("no_selection");
        }
        if (langentries.hasProperty("update_check")) {
            OPTIONS_UPDATE_HEADER = langentries.getProperty("update_check");
        }
        if (langentries.hasProperty("use_betacraft")) {
            OPTIONS_PROXY = langentries.getProperty("use_betacraft");
        }
        if (langentries.hasProperty("discord_rpc")) {
            OPTIONS_RPC = langentries.getProperty("discord_rpc");
        }
        if (langentries.hasProperty("launch_arguments")) {
            OPTIONS_LAUNCH_ARGS = langentries.getProperty("launch_arguments") + ":";
        }
        if (langentries.hasProperty("keep_launcher_open")) {
            OPTIONS_KEEP_OPEN = langentries.getProperty("keep_launcher_open");
        }
        if (langentries.hasProperty("width")) {
            OPTIONS_WIDTH = langentries.getProperty("width");
        }
        if (langentries.hasProperty("height")) {
            OPTIONS_HEIGHT = langentries.getProperty("height");
        }
        if (langentries.hasProperty("options_title")) {
            OPTIONS_TITLE = langentries.getProperty("options_title");
        }
        if (langentries.hasProperty("ok")) {
            OPTIONS_OK = langentries.getProperty("ok");
        }
        if (langentries.hasProperty("sort_oldest")) {
            SORT_FROM_OLDEST = langentries.getProperty("sort_oldest");
        }
        if (langentries.hasProperty("sort_newest")) {
            SORT_FROM_NEWEST = langentries.getProperty("sort_newest");
        }
        if (langentries.hasProperty("version_title")) {
            VERSION_LIST_TITLE = langentries.getProperty("version_title");
        }
        if (langentries.hasProperty("addon_list_title")) {
            ADDON_LIST_TITLE = langentries.getProperty("addon_list_title");
        }
        if (langentries.hasProperty("addon_no_desc")) {
            ADDON_NO_DESC = langentries.getProperty("addon_no_desc");
        }
        if (langentries.hasProperty("addon_show_info")) {
            ADDON_SHOW_INFO = langentries.getProperty("addon_show_info");
        }
        if (langentries.hasProperty("logging_in")) {
            LOGGING_IN = langentries.getProperty("logging_in");
        }
        if (langentries.hasProperty("login_title")) {
            LOGIN_TITLE = langentries.getProperty("login_title");
        }
        if (langentries.hasProperty("log_in_button")) {
            LOGIN_BUTTON = langentries.getProperty("log_in_button");
        }
        if (langentries.hasProperty("log_out_button")) {
            LOGOUT_BUTTON = langentries.getProperty("log_out_button");
        }
        if (langentries.hasProperty("login_email_nickname")) {
            LOGIN_EMAIL_NICKNAME = langentries.getProperty("login_email_nickname");
        }
        if (langentries.hasProperty("login_password")) {
            LOGIN_PASSWORD = langentries.getProperty("login_password");
        }
        if (langentries.hasProperty("login_mojang_header")) {
            LOGIN_MOJANG_HEADER = langentries.getProperty("login_mojang_header");
        }
        if (langentries.hasProperty("login_microsoft_button")) {
            LOGIN_MICROSOFT_BUTTON = langentries.getProperty("login_microsoft_button");
        }
        if (langentries.hasProperty("login_microsoft_title")) {
            LOGIN_MICROSOFT_TITLE = langentries.getProperty("login_microsoft_title");
        }
        if (langentries.hasProperty("login_microsoft_error")) {
            LOGIN_MICROSOFT_ERROR = langentries.getProperty("login_microsoft_error");
        }
        if (langentries.hasProperty("login_microsoft_parent")) {
            LOGIN_MICROSOFT_PARENT = langentries.getProperty("login_microsoft_parent");
        }
        if (langentries.hasProperty("login_microsoft_no_xbox")) {
            LOGIN_MICROSOFT_NO_XBOX = langentries.getProperty("login_microsoft_no_xbox");
        }
        if (langentries.hasProperty("login_microsoft_no_minecraft")) {
            LOGIN_MICROSOFT_NO_MINECRAFT = langentries.getProperty("login_microsoft_no_minecraft");
        }
        if (langentries.hasProperty("login_microsoft_code_line1")) {
            LOGIN_MICROSOFT_CODE_LINE1 = langentries.getProperty("login_microsoft_code_line1");
        }
        if (langentries.hasProperty("login_microsoft_code_line2")) {
            LOGIN_MICROSOFT_CODE_LINE2 = langentries.getProperty("login_microsoft_code_line2");
        }
        if (langentries.hasProperty("login_relogin")) {
            LOGIN_RELOGIN = langentries.getProperty("login_relogin");
        }
        if (langentries.hasProperty("login_failed")) {
            LOGIN_FAILED = langentries.getProperty("login_failed");
        }
        if (langentries.hasProperty("login_failed_invalid_credentials")) {
            LOGIN_FAILED_INVALID_CREDENTIALS = langentries.getProperty("login_failed_invalid_credentials");
        }
        if (langentries.hasProperty("java_executable")) {
            JAVA_EXECUTABLE = langentries.getProperty("java_executable");
        }
        if (langentries.hasProperty("java_invalid")) {
            JAVA_INVALID = langentries.getProperty("java_invalid");
        }
        if (langentries.hasProperty("java_too_recent")) {
            JAVA_TOO_RECENT = langentries.getProperty("java_too_recent");
        }
        if (langentries.hasProperty("java_recommended_not_found")) {
            JAVA_RECOMMENDED_NOT_FOUND = langentries.getProperty("java_recommended_not_found");
        }
        if (langentries.hasProperty("java_wrong_arch")) {
            JAVA_WRONG_ARCH = langentries.getProperty("java_wrong_arch");
        }
        if (langentries.hasProperty("java_ssl_not_supported")) {
            JAVA_SSL_NOT_SUPPORTED = langentries.getProperty("java_ssl_not_supported");
        }
        if (langentries.hasProperty("java_ssl_to_download_resource")) {
            JAVA_SSL_TO_DOWNLOAD_RESOURCE = langentries.getProperty("java_ssl_to_download_resource");
        }
        if (langentries.hasProperty("java_ssl_to_microsoft_account")) {
            JAVA_SSL_TO_MICROSOFT_ACCOUNT = langentries.getProperty("java_ssl_to_microsoft_account");
        }
        if (langentries.hasProperty("java_ssl_to_authenticate")) {
            JAVA_SSL_TO_AUTHENTICATE = langentries.getProperty("java_ssl_to_authenticate");
        }
        if (langentries.hasProperty("java_intel_graphics")) {
            JAVA_INTEL_GRAPHICS = langentries.getProperty("java_intel_graphics");
        }
        if (langentries.hasProperty("java_intel_graphics_wiki")) {
            JAVA_INTEL_GRAPHICS_WIKI = langentries.getProperty("java_intel_graphics_wiki");
        }
        if (langentries.hasProperty("instance_directory")) {
            INSTANCE_DIRECTORY = langentries.getProperty("instance_directory");
        }
        if (langentries.hasProperty("instance_remove_directory")) {
            INSTANCE_REMOVE_DIRECTORY = langentries.getProperty("instance_remove_directory");
        }
        if (langentries.hasProperty("instance_game_directory_title")) {
            INSTANCE_GAME_DIRECTORY_TITLE = langentries.getProperty("instance_game_directory_title");
        }
        if (langentries.hasProperty("instance_remove_question")) {
            INSTANCE_REMOVE_QUESTION = langentries.getProperty("instance_remove_question");
        }
        if (langentries.hasProperty("instance_remove_title")) {
            INSTANCE_REMOVE_TITLE = langentries.getProperty("instance_remove_title");
        }
        if (langentries.hasProperty("instance_change_icon_name")) {
            INSTANCE_CHANGE_ICON_NAME = langentries.getProperty("instance_change_icon_name");
        }
        if (langentries.hasProperty("instance_change_icon_title")) {
            INSTANCE_CHANGE_ICON_TITLE = langentries.getProperty("instance_change_icon_title");
        }
        if (langentries.hasProperty("instance_change_icon_unsupported")) {
            INSTANCE_CHANGE_ICON_UNSUPPORTED = langentries.getProperty("instance_change_icon_unsupported");
        }
        if (langentries.hasProperty("instance_change_icon_unsupported_title")) {
            INSTANCE_CHANGE_ICON_UNSUPPORTED_TITLE = langentries.getProperty("instance_change_icon_unsupported_title");
        }
        if (langentries.hasProperty("instance_change_icon_failed")) {
            INSTANCE_CHANGE_ICON_FAILED = langentries.getProperty("instance_change_icon_failed");
        }
        if (langentries.hasProperty("instance_change_icon_failed_title")) {
            INSTANCE_CHANGE_ICON_FAILED_TITLE = langentries.getProperty("instance_change_icon_failed_title");
        }
        if (langentries.hasProperty("instance_name")) {
            INSTANCE_NAME = langentries.getProperty("instance_name");
        }
        if (langentries.hasProperty("instance_select_addons")) {
            INSTANCE_SELECT_ADDONS = langentries.getProperty("instance_select_addons");
        }
        if (langentries.hasProperty("instance_mods_repository")) {
            INSTANCE_MODS_REPOSITORY = langentries.getProperty("instance_mods_repository");
        }
        if (langentries.hasProperty("select_instance_title")) {
            SELECT_INSTANCE_TITLE = langentries.getProperty("select_instance_title");
        }
        if (langentries.hasProperty("select_instance_new")) {
            SELECT_INSTANCE_NEW = langentries.getProperty("select_instance_new");
        }
        if (langentries.hasProperty("new_version_found")) {
            UPDATE_FOUND = langentries.getProperty("new_version_found");
        }
        if (langentries.hasProperty("nick")) {
            WRAP_USER = langentries.getProperty("nick");
        }
        if (langentries.hasProperty("version")) {
            WRAP_VERSION = langentries.getProperty("version");
        }
        if (langentries.hasProperty("server")) {
            WRAP_SERVER = langentries.getProperty("server");
        }
        if (langentries.hasProperty("server_title")) {
            WRAP_SERVER_TITLE = langentries.getProperty("server_title");
        }
        if (langentries.hasProperty("classic_resize")) {
            WRAP_CLASSIC_RESIZE = langentries.getProperty("classic_resize");
        }
        if (langentries.hasProperty("tab_changelog")) {
            TAB_CHANGELOG = langentries.getProperty("tab_changelog");
        }
        if (langentries.hasProperty("tab_instances")) {
            TAB_INSTANCES = langentries.getProperty("tab_instances");
        }
        if (langentries.hasProperty("tab_servers")) {
            TAB_SERVERS = langentries.getProperty("tab_servers");
        }
        if (langentries.hasProperty("version_custom")) {
            VERSION_CUSTOM = langentries.getProperty("version_custom");
        }
        if (langentries.hasProperty("browser_title")) {
            BROWSER_TITLE = langentries.getProperty("browser_title");
        }
        if (langentries.hasProperty("srv_loading")) {
            TAB_SRV_LOADING = langentries.getProperty("srv_loading");
        }
        if (langentries.hasProperty("srv_failed")) {
            TAB_SRV_FAILED = langentries.getProperty("srv_failed");
        }
        if (langentries.hasProperty("cl_loading")) {
            TAB_CL_LOADING = langentries.getProperty("cl_loading");
        }
        if (langentries.hasProperty("cl_failed")) {
            TAB_CL_FAILED = langentries.getProperty("cl_failed");
        }
        if (langentries.hasProperty("force_update")) {
            FORCE_UPDATE = langentries.getProperty("force_update");
        }
        if (langentries.hasProperty("console_output_for")) {
            CONSOLE_OUTPUT_FOR = langentries.getProperty("console_output_for");
        }
        if (langentries.hasProperty("console_output")) {
            CONSOLE_OUTPUT = langentries.getProperty("console_output");
        }
        if (langentries.hasProperty("yes")) {
            YES = langentries.getProperty("yes");
        }
        if (langentries.hasProperty("no")) {
            NO = langentries.getProperty("no");
        }
        if (langentries.hasProperty("cancel")) {
            CANCEL = langentries.getProperty("cancel");
        }
        if (langentries.hasProperty("select")) {
            SELECT = langentries.getProperty("select");
        }
        if (langentries.hasProperty("remove")) {
            REMOVE = langentries.getProperty("remove");
        }
        if (langentries.hasProperty("browse")) {
            BROWSE = langentries.getProperty("browse");
        }
        if (langentries.hasProperty("copy")) {
            COPY = langentries.getProperty("copy");
        }
        if (langentries.hasProperty("clear")) {
            CLEAR = langentries.getProperty("clear");
        }
        if (langentries.hasProperty("load")) {
            LOAD = langentries.getProperty("load");
        }
        if (langentries.hasProperty("close")) {
            CLOSE = langentries.getProperty("close");
        }
        if (langentries.hasProperty("link")) {
            LINK = langentries.getProperty("link");
        }
        if (langentries.hasProperty("pause")) {
            PAUSE = langentries.getProperty("pause");
        }
        if (langentries.hasProperty("unpause")) {
            UNPAUSE = langentries.getProperty("unpause");
        }
        Lang.applyNamesSwing();
        if (force) {
            Window.mainWindow.update();
            if (Window.addonsList != null) {
                Window.addonsList.update();
            }
            if (Window.modsRepo != null) {
                Window.modsRepo.update();
            }
            if (Window.lang != null) {
                Window.lang.update();
            }
            if (Window.instanceList != null) {
                Window.instanceList.update();
            }
            if (Window.instanceSettings != null) {
                Window.instanceSettings.update();
            }
            if (Window.versionsList != null) {
                Window.versionsList.update();
            }
        }
    }

    static {
        locale_id = "1.09_17";
        UPDATE_FOUND = "There is a new version of the launcher available (%s). Would you like to update?";
        WINDOW_PLAY = "Play";
        WINDOW_SELECT_VERSION = "Select version";
        WINDOW_LANGUAGE = "Language";
        WINDOW_OPTIONS = "Edit instance";
        WINDOW_TITLE = "BetaCraft Launcher v" + Launcher.VERSION;
        WINDOW_DOWNLOADING = "Downloading ...";
        WINDOW_DOWNLOADING_RESOURCE = "Downloading: %s";
        PACKING_MOD = "Packing mod ...";
        MANUAL_DOWNLOAD = "Manual download";
        WINDOW_USERNAME_FIELD_EMPTY = "The username field is empty!";
        LANG = "Select language";
        OPTIONS_PROXY = "Use skin & sound proxy";
        OPTIONS_UPDATE_HEADER = "Update available";
        OPTIONS_KEEP_OPEN = "Keep the launcher open";
        OPTIONS_RPC = "Discord RPC";
        OPTIONS_LAUNCH_ARGS = "JVM arguments:";
        OPTIONS_OK = "OK";
        OPTIONS_WIDTH = "width:";
        OPTIONS_HEIGHT = "height:";
        OPTIONS_TITLE = "Instance settings";
        SORT_FROM_OLDEST = "Sort: from oldest";
        SORT_FROM_NEWEST = "Sort: from newest";
        VERSION_LIST_TITLE = "Select version";
        ADDON_LIST_TITLE = "Addons list";
        ADDON_NO_DESC = "No description.";
        ADDON_SHOW_INFO = "About";
        LOGGING_IN = "Logging in...";
        LOGIN_TITLE = "Log in";
        LOGIN_BUTTON = "Log in";
        LOGOUT_BUTTON = "Log out";
        LOGIN_EMAIL_NICKNAME = "E-mail:";
        LOGIN_PASSWORD = "Password:";
        LOGIN_MOJANG_HEADER = "... or login with a Mojang account:";
        LOGIN_MICROSOFT_BUTTON = "Login with Microsoft";
        LOGIN_MICROSOFT_TITLE = "Login with your Microsoft account";
        LOGIN_MICROSOFT_ERROR = "Microsoft authentication error";
        LOGIN_MICROSOFT_PARENT = "Parental approval required. Add this account to Family to login.";
        LOGIN_MICROSOFT_NO_XBOX = "No Xbox account registered";
        LOGIN_MICROSOFT_NO_MINECRAFT = "You don't own Minecraft on this account.";
        LOGIN_MICROSOFT_CODE_LINE1 = "To proceed, open up:";
        LOGIN_MICROSOFT_CODE_LINE2 = "in a browser and type the code:";
        LOGIN_RELOGIN = "You need to re-login to your Microsoft account (token timed out)";
        LOGIN_FAILED = "Failed to complete the login process";
        LOGIN_FAILED_INVALID_CREDENTIALS = "Invalid e-mail or password.";
        JAVA_EXECUTABLE = "Java executable:";
        JAVA_INVALID = "Given Java path is not valid. Do you want the instance to use recommended Java?";
        JAVA_TOO_RECENT = "Given Java version is greater than 8. Do you want the instance to use recommended Java?";
        JAVA_RECOMMENDED_NOT_FOUND = "Could not find recommended Java in your system. Do you want to download and install it?";
        JAVA_WRONG_ARCH = "It seems that you're running the wrong architecture of Java (ARM or 32-bit x86). \nShould you run into issues, get 64-bit Java 8 from https://java.com and make your instance use it.";
        JAVA_SSL_NOT_SUPPORTED = "Your Java is too old to connect to the required resource. Update your Java to %s";
        JAVA_SSL_TO_MICROSOFT_ACCOUNT = "login to your Minecraft account.";
        JAVA_SSL_TO_DOWNLOAD_RESOURCE = "download the required resource.";
        JAVA_SSL_TO_AUTHENTICATE = "connect with this server.";
        JAVA_INTEL_GRAPHICS = "Your machine has Intel HD Graphics. In order for the game to run as intended, you may have to use Java 8u51 for your instance (your current Java: %s)";
        JAVA_INTEL_GRAPHICS_WIKI = "Learn how to get Java 8u51 here: https://github.com/betacraftuk/betacraft-launcher/wiki/intel";
        INSTANCE_REMOVE_DIRECTORY = "Would you want to permanently remove this instance's directory? This cannot be undone.";
        INSTANCE_DIRECTORY = "Instance directory:";
        INSTANCE_GAME_DIRECTORY_TITLE = "Choose a directory for the instance";
        INSTANCE_REMOVE_QUESTION = "Are you sure you want to remove this instance?";
        INSTANCE_REMOVE_TITLE = "Remove instance";
        INSTANCE_CHANGE_ICON_NAME = "Change icon";
        INSTANCE_CHANGE_ICON_TITLE = "Choose a new icon for the instance";
        INSTANCE_CHANGE_ICON_UNSUPPORTED = "Your icon file format is not supported. Currently supported formats: %s";
        INSTANCE_CHANGE_ICON_UNSUPPORTED_TITLE = "Unsupported image format";
        INSTANCE_CHANGE_ICON_FAILED = "Something went wrong: %s";
        INSTANCE_CHANGE_ICON_FAILED_TITLE = "Failed to save icon";
        INSTANCE_NAME = "Name:";
        INSTANCE_SELECT_ADDONS = "Select addons";
        INSTANCE_MODS_REPOSITORY = "Mods repository";
        SELECT_INSTANCE_TITLE = "Select instance";
        SELECT_INSTANCE_NEW = "New instance";
        TAB_CHANGELOG = "Changelog";
        TAB_INSTANCES = "Instances";
        TAB_SERVERS = "Server list";
        VERSION_CUSTOM = " [Custom]";
        BROWSER_TITLE = "Webpage viewer";
        TAB_SRV_LOADING = "Loading server list...";
        TAB_SRV_FAILED = "Failed to list servers!";
        TAB_CL_LOADING = "Loading update news...";
        TAB_CL_FAILED = "Failed to load update news!";
        FORCE_UPDATE = "Force update";
        CONSOLE_OUTPUT_FOR = "Game log for \"%s\"";
        CONSOLE_OUTPUT = "Game log";
        WRAP_USER = "User: %s";
        WRAP_VERSION = "Version: %s";
        WRAP_SERVER = "Server IP (leave blank if you don't want to play online):";
        WRAP_SERVER_TITLE = "Server IP";
        WRAP_CLASSIC_RESIZE = "<html><font size=5>Resize the window to the size you want to play on.<br />Click anywhere inside this window to start the game.</font></html>";
        UNEXPECTED_ERROR = "Unexpected error: %s";
        ERR_NO_CONNECTION = "No stable internet connection.";
        ERR_DL_FAIL = "Download failed.";
        ERR_NO_SELECTION = "You must select something first!";
        YES = "Yes";
        NO = "No";
        CANCEL = "Cancel";
        SELECT = "Select";
        REMOVE = "Remove";
        BROWSE = "Browse";
        COPY = "Copy";
        CLEAR = "Clear";
        LOAD = "Load";
        CLOSE = "Close";
        LINK = "Link";
        PAUSE = "Pause";
        UNPAUSE = "Unpause";
    }
}

