/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.auth;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.betacraft.launcher.Lang;
import org.betacraft.launcher.Launcher;
import org.betacraft.launcher.Window;
import uk.betacraft.auth.Authenticator;
import uk.betacraft.auth.Credentials;
import uk.betacraft.auth.Request;
import uk.betacraft.auth.RequestUtil;
import uk.betacraft.auth.jsons.microsoft.CheckTokenRequest;
import uk.betacraft.auth.jsons.microsoft.CheckTokenResponse;
import uk.betacraft.auth.jsons.microsoft.MinecraftAuthRequest;
import uk.betacraft.auth.jsons.microsoft.MinecraftAuthResponse;
import uk.betacraft.auth.jsons.microsoft.MinecraftProfileRequest;
import uk.betacraft.auth.jsons.microsoft.MinecraftProfileResponse;
import uk.betacraft.auth.jsons.microsoft.XBLAuthRequest;
import uk.betacraft.auth.jsons.microsoft.XBLXSTSAuthResponse;
import uk.betacraft.auth.jsons.microsoft.XSTSAuthRequest;
import uk.betacraft.util.WebData;

public class MicrosoftAuth
extends Authenticator {
    public static final String CLIENT_ID = "8075fa74-4091-4356-a0b8-a7c118ef121c";
    public Credentials credentials = null;

    public MicrosoftAuth(Credentials c) {
        this.credentials = c;
    }

    private void clearFields() {
        if (this.credentials != null) {
            Launcher.accounts.removeAccount(this.credentials);
        }
        this.credentials = null;
    }

    @Override
    public boolean authenticate() {
        MinecraftAuthResponse mcres;
        if (this.credentials.refresh_token == null) {
            return false;
        }
        CheckTokenResponse ctres = new CheckTokenRequest(null, this.credentials.refresh_token).perform();
        if (ctres == null) {
            MicrosoftAuth.displayError(null, Lang.LOGIN_MICROSOFT_ERROR, Lang.LOGIN_RELOGIN);
            return false;
        }
        XBLXSTSAuthResponse xblres = new XBLAuthRequest(ctres.access_token).perform();
        if (xblres == null || xblres.isEmpty()) {
            System.out.println("XBL failed!");
            return false;
        }
        XBLXSTSAuthResponse xstsres = new XSTSAuthRequest(xblres.Token).perform();
        if (xstsres == null || xblres.isEmpty()) {
            System.out.println("XSTS failed!");
            return false;
        }
        if (xstsres.Identity != null) {
            if (xstsres.XErr == 2148916233L) {
                System.out.println("No Xbox account registered");
                MicrosoftAuth.displayError(xstsres, Lang.LOGIN_MICROSOFT_ERROR, Lang.LOGIN_MICROSOFT_NO_XBOX);
                return false;
            }
            if (xstsres.XErr == 2148916238L) {
                System.out.println("PARENTAL CONTROL");
                MicrosoftAuth.displayError(xstsres, Lang.LOGIN_MICROSOFT_ERROR, Lang.LOGIN_MICROSOFT_PARENT);
                return false;
            }
            System.out.println("Unexpected error: " + xstsres.XErr);
            MicrosoftAuth.displayError(xstsres, Lang.LOGIN_MICROSOFT_ERROR, String.format(Lang.UNEXPECTED_ERROR, xstsres.XErr));
        }
        if ((mcres = new MinecraftAuthRequest(xblres.DisplayClaims.xui[0].uhs, xstsres.Token).perform()) == null || mcres.isEmpty()) {
            System.out.println("MinecraftAuth failed!");
            MicrosoftAuth.displayError(mcres, Lang.LOGIN_MICROSOFT_ERROR, Lang.LOGIN_MICROSOFT_NO_MINECRAFT);
            return false;
        }
        MinecraftProfileResponse mcpres = new MinecraftProfileRequest(mcres.access_token).perform();
        if (mcpres == null || mcpres.isEmpty()) {
            System.out.println("MinecraftProfile failed!");
            MicrosoftAuth.displayError(mcpres, Lang.LOGIN_MICROSOFT_ERROR, Lang.LOGIN_MICROSOFT_NO_MINECRAFT);
            return false;
        }
        this.clearFields();
        this.credentials = new Credentials();
        this.credentials.expires_at = ctres.expires_in * 1000L + System.currentTimeMillis();
        this.credentials.refresh_token = ctres.refresh_token;
        this.credentials.access_token = mcres.access_token;
        this.credentials.username = mcpres.name;
        this.credentials.local_uuid = mcpres.id;
        this.credentials.account_type = Credentials.AccountType.MICROSOFT;
        Launcher.accounts.addAccount(this.credentials);
        Launcher.accounts.setCurrent(this.getCredentials());
        Launcher.auth = this;
        this.authSuccess();
        System.out.println("USERNAME: " + this.credentials.username);
        System.out.println("ACC_UUID: " + this.credentials.local_uuid);
        return true;
    }

    @Override
    public boolean invalidate() {
        this.clearFields();
        return true;
    }

    @Override
    public Credentials getCredentials() {
        return this.credentials;
    }

    public static void displayError(Object error, final String title, final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(Window.mainWindow, msg, title, 0);
            }
        });
        if (error == null) {
            return;
        }
        System.out.println("-Stack of " + error.getClass().getSimpleName() + "-");
        for (Field f : error.getClass().getDeclaredFields()) {
            if (Modifier.isTransient(f.getModifiers())) continue;
            f.setAccessible(true);
            try {
                System.out.println(f.getName() + "=" + f.get(error));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        System.out.println("-----------------");
    }

    public static String fireAuthRequest(Request req) {
        WebData data;
        WebData webData = data = req.type == Request.RequestType.POST ? RequestUtil.performRawPOSTRequest(req) : RequestUtil.performRawGETRequest(req);
        if (data.getResponseCode() == -2) {
            JOptionPane.showMessageDialog(null, String.format(Lang.JAVA_SSL_NOT_SUPPORTED, Lang.JAVA_SSL_TO_MICROSOFT_ACCOUNT), "", 0);
        }
        return RequestUtil.webDataToString(data);
    }
}

