/*
 * Decompiled with CFR 0.152.
 */
package org.betacraft.launcher;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Scanner;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.betacraft.Classic12aWrapper;
import org.betacraft.Classic15aWrapper;
import org.betacraft.FkWrapper;
import org.betacraft.PreClassicWrapper;
import org.betacraft.PreClassicWrapper2;
import org.betacraft.Wrapper;
import org.betacraft.WrapperDetector;
import org.betacraft.launcher.Addon;
import org.betacraft.launcher.BC;
import org.betacraft.launcher.ConsoleLogFrame;
import org.betacraft.launcher.DownloadResult;
import org.betacraft.launcher.Instance;
import org.betacraft.launcher.Lang;
import org.betacraft.launcher.Logger;
import org.betacraft.launcher.ModsRepository;
import org.betacraft.launcher.OS;
import org.betacraft.launcher.Release;
import org.betacraft.launcher.ReleaseJson;
import org.betacraft.launcher.SimpleWebAddressFrame;
import org.betacraft.launcher.StartThread;
import org.betacraft.launcher.Util;
import org.betacraft.launcher.Window;
import uk.betacraft.auth.Accounts;
import uk.betacraft.auth.Authenticator;
import uk.betacraft.auth.Credentials;
import uk.betacraft.auth.CustomRequest;
import uk.betacraft.auth.CustomResponse;
import uk.betacraft.auth.DownloadRequest;
import uk.betacraft.auth.DownloadResponse;
import uk.betacraft.auth.NoAuth;
import uk.betacraft.json.lib.LaunchMethod;
import uk.betacraft.json.lib.ModObject;
import uk.betacraft.json.lib.MouseFixMacOSJson;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Launcher {
    public static String VERSION = "1.09_16";
    public static Instance currentInstance;
    public static boolean forceUpdate;
    public static boolean disableWarnings;
    public static ArrayList<Thread> totalThreads;
    public static Authenticator auth;
    public static Accounts accounts;
    public static String JAVA_HOME;
    public static File javaRuntime;

    public static void main(String[] args) {
        String javaver = System.getProperty("java.runtime.version");
        String javadistro = System.getProperty("java.vendor");
        System.out.println("Java version: " + javadistro + ", " + System.getProperty("java.runtime.name") + ", " + javaver);
        System.out.println("System: " + OS.OS + ", " + OS.VER + ", " + OS.ARCH);
        long nano = System.nanoTime();
        boolean systemlookandfeel = Boolean.parseBoolean(System.getProperty("betacraft.systemLookAndFeel", "true"));
        if (systemlookandfeel) {
            try {
                if (OS.isWindows()) {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                } else if (OS.isLinux()) {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
                }
            }
            catch (Exception ex) {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception ex1) {
                    ex1.printStackTrace();
                }
            }
        }
        try {
            String p = Window.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            if (OS.isWindows()) {
                p = p.substring(1, p.length());
            }
            BC.currentPath = new File(p);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (args.length >= 2 && (args[0].equals("update") || args[1].equals("update"))) {
            try {
                int e = 1;
                if (args[1].equals("update")) {
                    ++e;
                }
                String pathToJar = "";
                for (int i = e; i < args.length; ++i) {
                    pathToJar = pathToJar.equals("") ? args[i] : pathToJar + " " + args[i];
                }
                if (pathToJar.startsWith("//") && !OS.isWindows() || pathToJar.startsWith("/") && OS.isWindows()) {
                    pathToJar = pathToJar.substring(1, pathToJar.length());
                }
                File dest = new File(pathToJar);
                Util.copy(BC.currentPath, dest);
                ArrayList<String> pa = new ArrayList<String>();
                pa.add("java");
                pa.add("-jar");
                pa.add(dest.getAbsolutePath());
                new ProcessBuilder(pa).start();
                System.exit(0);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(0);
            }
            return;
        }
        if (args.length > 0 && args[0].equals("wrap")) {
            BC.wrapped = true;
            Logger.init();
            BC.SETTINGS_FILE = new File(BC.get() + "launcher", "launcher.settings");
            BC.SETTINGS = new Util.PropertyFile(BC.SETTINGS_FILE);
            Lang.refresh(false, false);
            String username = args[1];
            String sessionid = args[2];
            String server = args[3].equals("-") ? null : args[3];
            String mppass = args[4].equals("-") ? "0" : args[4];
            String uuid = args[5];
            StringBuilder split = new StringBuilder();
            for (int i = 6; i < args.length; ++i) {
                split.append(args[i] + " ");
            }
            String instanceName = split.toString();
            instanceName = instanceName.substring(0, instanceName.length() - 1);
            currentInstance = Instance.loadInstance(instanceName);
            ReleaseJson json = new ReleaseJson(Launcher.currentInstance.version);
            String meth = json.getLaunchMethod();
            ArrayList addons = new ArrayList();
            if (!Launcher.currentInstance.addons.isEmpty()) {
                try {
                    System.out.println("Loading addons...");
                    for (String s : Launcher.currentInstance.addons) {
                        try {
                            String path = BC.get() + "launcher" + File.separator + "addons" + File.separator + s + ".jar";
                            URLClassLoader loader = new URLClassLoader(new URL[]{new File(path).toURI().toURL()});
                            System.out.println("- " + s);
                            Launcher.loadClasses(path, loader);
                            Class<?> c = loader.loadClass(s);
                            addons.add(c);
                        }
                        catch (Exception ex) {
                            System.err.println("An error occurred while loading an addon: " + s);
                            ex.printStackTrace();
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if ((meth == null || meth.equalsIgnoreCase("")) && (meth = WrapperDetector.getLaunchMethod(BC.get() + "versions/" + Launcher.currentInstance.version + ".jar")).equals("custom")) {
                String err = "Error code 7 (ERRCONFIG): Couldn't determine the launch method for your JAR. Configure your version configuration file: " + BC.get() + "versions/jsons/" + Launcher.currentInstance.version + ".info";
                System.err.println(err);
                JOptionPane.showMessageDialog(Window.mainWindow, err, "Error", 1);
                System.exit(0);
            }
            System.out.println("Loaded in: " + (System.nanoTime() - nano) + " ns");
            if (meth.equalsIgnoreCase("rd") || meth.equalsIgnoreCase("mc")) {
                new Launcher().extractFromJar("/PreClassic.jar", new File(BC.get() + "launcher/", "PreClassic.jar"));
                new PreClassicWrapper2(username, Launcher.currentInstance.name, Launcher.currentInstance.version, sessionid, Launcher.currentInstance.gameDir, Launcher.currentInstance.height, Launcher.currentInstance.width, Launcher.currentInstance.RPC, meth, server, mppass, Lang.WRAP_USER, Lang.WRAP_VERSION, currentInstance.getIcon(), addons);
            } else if (meth.equalsIgnoreCase("preclassic")) {
                new PreClassicWrapper(username, Launcher.currentInstance.name, Launcher.currentInstance.version, sessionid, Launcher.currentInstance.gameDir, Launcher.currentInstance.height, Launcher.currentInstance.width, Launcher.currentInstance.RPC, meth, server, mppass, uuid, Lang.WRAP_USER, Lang.WRAP_VERSION, currentInstance.getIcon(), addons);
            } else if (meth.equalsIgnoreCase("classic12a")) {
                new Classic12aWrapper(username, Launcher.currentInstance.name, Launcher.currentInstance.version, sessionid, Launcher.currentInstance.gameDir, Launcher.currentInstance.height, Launcher.currentInstance.width, Launcher.currentInstance.RPC, meth, server, mppass, uuid, Lang.WRAP_USER, Lang.WRAP_VERSION, currentInstance.getIcon(), addons);
            } else if (meth.equalsIgnoreCase("classic15a")) {
                new Classic15aWrapper(username, Launcher.currentInstance.name, Launcher.currentInstance.version, sessionid, Launcher.currentInstance.gameDir, Launcher.currentInstance.height, Launcher.currentInstance.width, Launcher.currentInstance.RPC, meth, server, mppass, uuid, Lang.WRAP_USER, Lang.WRAP_VERSION, currentInstance.getIcon(), addons);
            } else if (meth.equalsIgnoreCase("indev") || meth.equalsIgnoreCase("classicmp") || meth.equalsIgnoreCase("classic")) {
                new Wrapper(username, Launcher.currentInstance.name, Launcher.currentInstance.version, sessionid, Launcher.currentInstance.gameDir, Launcher.currentInstance.height, Launcher.currentInstance.width, Launcher.currentInstance.RPC, meth, server, mppass, uuid, Lang.WRAP_USER, Lang.WRAP_VERSION, currentInstance.getIcon(), addons);
            } else if (meth.equalsIgnoreCase("4k")) {
                new FkWrapper(username, Launcher.currentInstance.name, Launcher.currentInstance.version, sessionid, Launcher.currentInstance.gameDir, Launcher.currentInstance.height, Launcher.currentInstance.width, Launcher.currentInstance.RPC, meth, server, mppass, Lang.WRAP_USER, Lang.WRAP_VERSION, currentInstance.getIcon(), addons);
            } else {
                try {
                    String path = BC.get() + "launcher" + File.separator + "launch-methods" + File.separator + meth + ".jar";
                    URLClassLoader loader = new URLClassLoader(new URL[]{new File(path).toURI().toURL()});
                    Launcher.loadClasses(path, loader);
                    System.out.println("Launch method: " + meth);
                    Class<?> c = loader.loadClass(meth);
                    Constructor<?> con = c.getConstructor(String.class, String.class, String.class, String.class, String.class, Integer.class, Integer.class, Boolean.class, String.class, String.class, String.class, String.class, String.class, String.class, Image.class, ArrayList.class);
                    con.newInstance(username, Launcher.currentInstance.name, Launcher.currentInstance.version, sessionid, Launcher.currentInstance.gameDir, Launcher.currentInstance.height, Launcher.currentInstance.width, Launcher.currentInstance.RPC, json.getLaunchMethod(), server, mppass, uuid, Lang.WRAP_USER, Lang.WRAP_VERSION, currentInstance.getIcon(), addons);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            return;
        }
        Logger.clearLauncherLog();
        Logger.init();
        BC.SETTINGS_FILE = new File(BC.get() + "launcher", "launcher.settings");
        BC.SETTINGS = new Util.PropertyFile(BC.SETTINGS_FILE);
        if (BC.SETTINGS_FILE.exists() && !"1".equals(BC.SETTINGS.getProperty("version"))) {
            Launcher.removeRecursively(new File(BC.get() + "launcher"), true, false);
            Launcher.writeDefault();
        }
        new File(BC.get() + "versions" + File.separator + "jsons").mkdirs();
        new File(BC.get() + "launcher" + File.separator + "lang").mkdirs();
        new File(BC.get() + "launcher" + File.separator + "addons").mkdirs();
        new File(BC.get() + "launcher" + File.separator + "instances").mkdirs();
        new File(BC.get() + "launcher" + File.separator + "launch-methods").mkdirs();
        new File(BC.get() + "bin" + File.separator + "natives").mkdirs();
        System.out.println("BetaCraft Launcher JE v" + VERSION + " loading...");
        System.out.println("Java version: " + System.getProperty("java.vendor") + ", " + System.getProperty("java.runtime.name") + ", " + System.getProperty("java.runtime.version"));
        System.out.println("Portable: " + BC.portable);
        System.out.println("EXE: " + BC.currentPath.getAbsolutePath().endsWith(".exe"));
        System.out.println("Prerelease: " + BC.prerelease);
        System.out.println("Nightly: " + BC.nightly);
        Lang.refresh(false, false);
        Util.readAccounts();
        if (!BC.SETTINGS_FILE.exists() || BC.SETTINGS.getProperty("lastInstance").equals("")) {
            Launcher.writeDefault();
            currentInstance = Instance.newInstance(BC.SETTINGS.getProperty("lastInstance"));
            currentInstance.saveInstance();
        } else {
            currentInstance = Instance.loadInstance(BC.SETTINGS.getProperty("lastInstance"));
            if (currentInstance == null) {
                currentInstance = Instance.newInstance(BC.SETTINGS.getProperty("lastInstance"));
                currentInstance.saveInstance();
            }
        }
        disableWarnings = "true".equals(BC.SETTINGS.getProperty("disableWarnings"));
        try {
            StartThread t = new StartThread();
            totalThreads.add(t);
            t.start();
        }
        catch (Exception ex) {
            System.err.println("A critical error has occurred while trying to initialize the launcher!");
            ex.printStackTrace();
        }
        System.out.println("Loaded in: " + (System.nanoTime() - nano) + " ns");
    }

    public void extractFromJar(String filepath, File to) {
        System.out.println("Extracting \"" + filepath + "\" to \"" + to.getAbsolutePath() + "\"");
        Util.copy(this.getClass().getResourceAsStream(filepath), to);
    }

    public static void loadClasses(String pathtojar, URLClassLoader loader) {
        try {
            JarFile jarFile = new JarFile(pathtojar);
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                String className = entry.getName().substring(0, entry.getName().length() - 6);
                className = className.replaceAll("/", ".");
                try {
                    loader.loadClass(className);
                }
                catch (NoClassDefFoundError ex) {
                    System.err.println("Couldn't find class " + className + ". Skipping!");
                    ex.printStackTrace();
                }
            }
            jarFile.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void restart(String javapath) {
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(javapath);
            params.add("-jar");
            params.add(BC.currentPath.getAbsolutePath());
            ProcessBuilder builder = new ProcessBuilder(params);
            builder.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Window.quit(true);
    }

    public static void setInstance(Instance instance) {
        currentInstance = instance;
        Window.selectedInstanceDisplay.setText(Launcher.currentInstance.name + " [" + Launcher.currentInstance.version + "]");
        BC.SETTINGS.setProperty("lastInstance", Launcher.currentInstance.name);
        BC.SETTINGS.flushToDisk();
    }

    public static void removeInstance(String instance) {
        Instance i = Instance.loadInstance(instance);
        if (i != null) {
            int res = JOptionPane.showConfirmDialog(null, Lang.INSTANCE_REMOVE_DIRECTORY + "\n" + i.gameDir);
            if (res == 0) {
                Launcher.removeRecursively(new File(i.gameDir), true, false);
            }
            i.removeInstance();
        }
        if (Instance.getInstances().size() > 0) {
            Launcher.setInstance(Instance.loadInstance(Instance.getInstances().get(0)));
        } else {
            Instance in = Instance.newInstance("default instance");
            in.saveInstance();
            Launcher.setInstance(in);
        }
    }

    public static void initStartup() {
        String json;
        DownloadResult res;
        Release rel;
        ModObject mo;
        File wrapper = new File(BC.get() + "launcher", "betacraft_wrapper.jar");
        if (BC.currentPath.length() != wrapper.length()) {
            try {
                Util.copy(BC.currentPath, wrapper);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(Window.mainWindow, "The file could not be copied! Try running with Administrator rights. If that won't help, contact: @Moresteck#1688", "Error", 0);
                return;
            }
        }
        if (Launcher.currentInstance.RPC) {
            File rpc = new File(BC.get() + "launcher/", "discord_rpc.jar");
            String expected_hash = new CustomRequest((String)"http://files.betacraft.uk/launcher/assets/discord_rpc.sha1").perform().response.replace("\n", "");
            if (rpc.exists()) {
                try {
                    String sha1 = Util.getSHA1(rpc);
                    if (!sha1.equals(expected_hash)) {
                        Launcher.downloadWithButtonOutput("http://files.betacraft.uk/launcher/assets/discord_rpc.jar", rpc, expected_hash);
                    }
                }
                catch (Throwable sha1) {
                    // empty catch block
                }
            }
            if (!rpc.exists() || forceUpdate) {
                Launcher.downloadWithButtonOutput("http://files.betacraft.uk/launcher/assets/discord_rpc.jar", rpc, expected_hash);
            }
        }
        if ((mo = ModsRepository.getMod((rel = Release.getReleaseByName(Launcher.currentInstance.version)).getInfo().getVersion())) == null) {
            rel.getInfo().downloadJson();
        } else if (!(mo == null || !mo.autoupdate && rel.getInfo().getInfoFile().exists() || (res = Launcher.download(mo.info_file_url, rel.getInfo().getInfoFile())).isOK())) {
            System.err.println("Failed to refresh mod: " + rel.getInfo().getVersion());
        }
        ReleaseJson info = new ReleaseJson(rel.getName());
        rel.setInfo(info);
        Launcher.readyVersion(info, forceUpdate);
        Launcher.updateLaunchMethod(Launcher.currentInstance.version);
        Launcher.readyAddons(currentInstance, forceUpdate);
        if (OS.isMac() && "true".equalsIgnoreCase(info.getEntry("macos-mousefix")) && (json = new CustomRequest((String)"http://files.betacraft.uk/launcher/assets/macos-mousefix.json").perform().response) != null) {
            MouseFixMacOSJson mousefix_json = Util.gsonPretty.fromJson(json, MouseFixMacOSJson.class);
            Util.installMacOSFix(mousefix_json, forceUpdate);
        }
        if (!(Launcher.checkDepends() && !forceUpdate || Launcher.downloadDepends())) {
            JOptionPane.showMessageDialog(Window.mainWindow, Lang.ERR_NO_CONNECTION, Lang.ERR_DL_FAIL, 0);
        }
    }

    public void launchGame(Instance instance) {
        Launcher.launchGame(instance, "-", "-");
    }

    public static void launchGame(Instance instance, String server, String mppass) {
        try {
            if (instance.version != null) {
                String line1;
                if (Launcher.getNickname().equals("")) {
                    JOptionPane.showMessageDialog(Window.mainWindow, Lang.WINDOW_USERNAME_FIELD_EMPTY, "Error", 0);
                    return;
                }
                ArrayList<String> params = new ArrayList<String>();
                params.add(instance.javaPath);
                String colon = ":";
                if (OS.isWindows()) {
                    colon = ";";
                    params.add("-XX:HeapDumpPath=java.exe_minecraft.exe.heapdump");
                }
                String add = "";
                if (instance.RPC) {
                    add = colon + BC.get() + "launcher" + File.separator + "discord_rpc.jar";
                }
                params.add("-Djava.util.Arrays.useLegacyMergeSort=true");
                Release.VersionInfo info = Release.getReleaseByName(instance.version).getInfo();
                if (OS.isMac() && "true".equalsIgnoreCase(info.getEntry("macos-mousefix"))) {
                    boolean useMacPatch;
                    boolean bl = useMacPatch = !instance.addons.contains("OfflineDATSave") && !instance.addons.contains("Fullscreen");
                    if (useMacPatch) {
                        params.add("-javaagent:" + BC.get() + "launcher/macos-javaagent.jar=" + BC.get());
                    }
                }
                if (OS.isLinux() && "true".equalsIgnoreCase(info.getEntry("linux-mousefix-earlyclassic"))) {
                    params.add("-Dbetacraft.linux_mousefix_earlyclassic=true");
                }
                if ("true".equalsIgnoreCase(info.getEntry("resize-applet"))) {
                    params.add("-Dbetacraft.resize_applet=true");
                }
                if ("true".equalsIgnoreCase(info.getEntry("do-not-get-mppass"))) {
                    params.add("-Dbetacraft.obtainMPpass=false");
                }
                if (info.getProtocol() != null && "classicmp".equals(info.getLaunchMethod())) {
                    params.add("-Dbetacraft.ask_for_server=true");
                }
                if (OS.isMac()) {
                    params.add("-Xdock:name=" + instance.name);
                    params.add("-Xdock:icon=" + instance.getIconLocation());
                }
                params.add("-Dhttp.nonProxyHosts=api.betacraft.uk|files.betacraft.uk|checkip.amazonaws.com");
                if (instance.launchArgs != null && !instance.launchArgs.equals("")) {
                    params.addAll(Launcher.getCustomParameters());
                }
                if (instance.proxy) {
                    String[] args;
                    for (String s : args = info.getProxyArgs().split(" ")) {
                        if (s.equals("")) continue;
                        params.add(s);
                    }
                }
                String token = Launcher.getAuthToken();
                params.add("-cp");
                params.add(BC.get() + "launcher" + File.separator + "betacraft_wrapper.jar" + add);
                params.add("org.betacraft.launcher.Launcher");
                params.add("wrap");
                params.add(Launcher.getNickname());
                params.add(token);
                params.add(server);
                params.add(mppass);
                if (!(auth instanceof NoAuth)) {
                    params.add(Launcher.auth.getCredentials().local_uuid);
                } else {
                    params.add("-");
                }
                params.add(Launcher.currentInstance.name);
                System.out.println(!token.equals("-") ? params.toString().replaceAll(token, "[censored sessionid]") : params.toString());
                ProcessBuilder builder = new ProcessBuilder(params);
                builder.redirectErrorStream(true);
                new File(instance.gameDir).mkdirs();
                builder.directory(new File(instance.gameDir));
                if (!instance.keepopen) {
                    Window.quit(false);
                }
                ConsoleLogFrame clf = new ConsoleLogFrame(instance.name, instance.console);
                Logger.clearClientLog();
                Process process = builder.start();
                InputStream output = process.getInputStream();
                InputStreamReader isr_log = new InputStreamReader(output);
                BufferedReader br_log = new BufferedReader(isr_log);
                while ((line1 = br_log.readLine()) != null) {
                    if (!token.equals("-")) {
                        line1 = line1.replace(token, "[censored sessionid]");
                    }
                    clf.log(line1 + "\n");
                }
                clf.log("\nClient closed.\n");
                System.out.println("Client closed.");
                if (!instance.keepopen) {
                    Window.quit(!clf.isVisible());
                }
                return;
            }
        }
        catch (Exception ex) {
            System.err.println("A critical error has occurred while attempting to launch the game!");
            ex.printStackTrace();
        }
    }

    public static void writeDefault() {
        BC.SETTINGS.setProperty("language", "English");
        BC.SETTINGS.setProperty("lastInstance", "default instance");
        BC.SETTINGS.setProperty("tab", Window.Tab.CHANGELOG.name());
        BC.SETTINGS.setProperty("disableWarnings", "false");
        BC.SETTINGS.setProperty("version", "1");
        BC.SETTINGS.flushToDisk();
    }

    public static void removeRecursively(File folder, boolean deleteFolderItself, boolean deleteOnlyFiles) {
        String[] entries;
        for (String s : entries = folder.list()) {
            File currentFile = new File(folder.getPath(), s);
            if (currentFile.isDirectory() && !deleteOnlyFiles) {
                Launcher.removeRecursively(currentFile, true, false);
                continue;
            }
            currentFile.delete();
        }
        if (deleteFolderItself) {
            folder.delete();
        }
    }

    public static File getVerFolder() {
        return new File(BC.get() + "versions" + File.separator);
    }

    public static void updateLaunchMethod(String version) {
        Release.VersionInfo json = Release.getReleaseByName(version).getInfo();
        String lmjsonurl = json.getLaunchMethodURL();
        if (lmjsonurl != null && !lmjsonurl.equals("")) {
            String name = json.getLaunchMethod();
            LaunchMethod lm = null;
            File file = new File(BC.get() + "launcher" + File.separator + "launch-methods", name + ".jar");
            if (file.exists() && file.isFile()) {
                try {
                    URL launchmethods = new URL(lmjsonurl);
                    lm = Util.gson.fromJson((Reader)new InputStreamReader(launchmethods.openStream(), "UTF-8"), LaunchMethod.class);
                    if (Util.getSHA1(file).equalsIgnoreCase(lm.hash)) {
                        return;
                    }
                }
                catch (Throwable t) {
                    System.out.println("Failed to read launchmethod from: " + lmjsonurl + " of version " + version);
                    t.printStackTrace();
                }
            }
            if (lm != null && !Launcher.downloadWithButtonOutput(lm.url, file, lm.hash).isPositive()) {
                JOptionPane.showMessageDialog(Window.mainWindow, Lang.ERR_DL_FAIL, Lang.ERR_DL_FAIL, 0);
            }
        }
    }

    public static void readyAddons(Instance instance, boolean force) {
        for (String s : instance.addons) {
            String filehash;
            boolean download = false;
            Addon a = Addon.addons.get(s);
            File destination = new File(BC.get() + "launcher" + File.separator + "addons", s + ".jar");
            if (!destination.exists()) {
                download = true;
            } else if (a.online && !(filehash = Util.getSHA1(destination)).equalsIgnoreCase(a.onlinehash)) {
                download = true;
            }
            if (!download || Launcher.downloadWithButtonOutput("http://files.betacraft.uk/launcher/assets/addons/" + Addon.addonVer + "/" + s + ".jar", destination, a.onlinehash).isPositive()) continue;
            JOptionPane.showMessageDialog(Window.mainWindow, "Couldn't download addon: " + s, "Error", 0);
        }
    }

    public static void readyVersion(ReleaseJson version, boolean force) {
        File dest = new File(Launcher.getVerFolder(), version.getVersion() + ".jar");
        if (version.baseVersion != null) {
            File fil = new File(Launcher.getVerFolder(), "mods");
            fil.mkdir();
            dest = new File(fil, version.getVersion() + ".jar");
        }
        if (version.sha1 != null) {
            String file_sha1;
            if (dest.exists() && (file_sha1 = Util.getSHA1(dest)).equalsIgnoreCase(version.sha1)) {
                if (version.baseVersion != null) {
                    Launcher.assembleWithBaseVersion(version);
                }
                return;
            }
        } else if (!force && dest.exists()) {
            if (version.baseVersion != null) {
                Launcher.assembleWithBaseVersion(version);
            }
            return;
        }
        if (!version.getDownloadURL().equals("")) {
            DownloadResult res = Launcher.downloadWithButtonOutput(version.getDownloadURL(), dest, version.sha1);
            if (!res.isPositive()) {
                JOptionPane.showMessageDialog(Window.mainWindow, Lang.ERR_NO_CONNECTION, Lang.ERR_DL_FAIL, 0);
            } else if (version.baseVersion != null) {
                Launcher.assembleWithBaseVersion(version);
            }
        } else {
            String err = "Error code 8 (ERRJAR): No jar for the version could be found or downloaded.";
            System.err.println(err);
            JOptionPane.showMessageDialog(Window.mainWindow, err, "Error", 1);
        }
    }

    public static void assembleWithBaseVersion(ReleaseJson version) {
        Release basever;
        Release.VersionInfo info;
        File dest = version.getJar();
        if (dest.exists()) {
            dest.delete();
        }
        if (!((info = (basever = Release.getReleaseByName(version.baseVersion)).getInfo()) instanceof ReleaseJson)) {
            info.downloadJson();
            info = new ReleaseJson(basever.getName());
            basever.setInfo(info);
        }
        ReleaseJson rinfo = (ReleaseJson)info;
        Launcher.readyVersion(rinfo, forceUpdate);
        ArrayList<File> sources = new ArrayList<File>();
        sources.add(rinfo.getJar());
        sources.add(new File(new File(Launcher.getVerFolder(), "mods"), version.getVersion() + ".jar"));
        Window.setStatus(Window.playButton, Lang.PACKING_MOD);
        Thread t = Util.rezip(sources.toArray(new File[0]), dest);
        while (t.isAlive()) {
        }
    }

    public static boolean checkDepends() {
        File bin = new File(BC.get() + "bin");
        if (bin.listFiles().length <= 1) {
            return false;
        }
        if (new File(bin, "natives").listFiles().length <= 1) {
            return false;
        }
        try {
            URL url = new URL("http://files.betacraft.uk/launcher/assets/depends-version.txt");
            Scanner s = new Scanner(url.openStream(), "UTF-8");
            String libs = s.nextLine().split(":")[1];
            String natives = s.nextLine().split(":")[1];
            s.close();
            boolean lastLibsMatch = libs.equals(BC.SETTINGS.getProperty("libs-version"));
            boolean lastNativesMatch = natives.equals(BC.SETTINGS.getProperty("natives-version"));
            return lastLibsMatch && lastNativesMatch;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return true;
        }
    }

    public static boolean downloadDepends() {
        File dest1;
        File destLibs = new File(BC.get() + "bin" + File.separator);
        File destNatives = new File(BC.get() + "bin" + File.separator + "natives" + File.separator);
        String link1 = "http://files.betacraft.uk/launcher/assets/natives-windows.zip";
        String link2 = "http://files.betacraft.uk/launcher/assets/libs-windows.zip";
        if (OS.isLinux()) {
            link2 = "http://files.betacraft.uk/launcher/assets/libs-linux.zip";
            link1 = "http://files.betacraft.uk/launcher/assets/natives-linux.zip";
        }
        if (OS.isMac()) {
            link2 = "http://files.betacraft.uk/launcher/assets/libs-osx.zip";
            link1 = "http://files.betacraft.uk/launcher/assets/natives-osx.zip";
        }
        if (!Launcher.downloadWithButtonOutput(link1, dest1 = new File(BC.get() + "launcher/", "natives.zip"), null).isPositive()) {
            return false;
        }
        File dest2 = new File(BC.get() + "launcher/", "libs.zip");
        if (!Launcher.downloadWithButtonOutput(link2, dest2, null).isPositive()) {
            return false;
        }
        CustomResponse res = new CustomRequest("http://files.betacraft.uk/launcher/assets/depends-version.txt").perform();
        Scanner s = new Scanner(res.response);
        String libs = s.nextLine().split(":")[1];
        String natives = s.nextLine().split(":")[1];
        s.close();
        BC.SETTINGS.setProperty("libs-version", libs);
        BC.SETTINGS.setProperty("natives-version", natives);
        BC.SETTINGS.flushToDisk();
        Launcher.removeRecursively(destNatives, true, false);
        Launcher.removeRecursively(destLibs, false, false);
        destNatives.mkdirs();
        totalThreads.add(Util.unzip(dest1, destNatives, true));
        totalThreads.add(Util.unzip(dest2, destLibs, true));
        return true;
    }

    public static ArrayList<String> getCustomParameters() {
        String params = Launcher.currentInstance.launchArgs;
        if (params.length() == 0) {
            return new ArrayList<String>();
        }
        String[] split = params.split(" ");
        ArrayList<String> parameters = new ArrayList<String>();
        for (String s : split) {
            parameters.add(s);
        }
        return parameters;
    }

    public static DownloadResult downloadWithButtonOutput(String link, final File folder, String sha1) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Window.setStatus(Window.playButton, String.format(Lang.WINDOW_DOWNLOADING_RESOURCE, BC.trimBetaCraftDir(folder.getAbsolutePath())));
            }
        });
        return Launcher.download(link, folder, sha1);
    }

    public static DownloadResult download(String link, File folder) {
        return Launcher.download(link, folder, null);
    }

    public static DownloadResult download(String link, File folder, String sha1) {
        System.out.println("Download started from: " + link);
        DownloadResponse response = new DownloadRequest(link, folder.getAbsolutePath(), sha1, true).perform();
        return response.result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void downloadUpdate(boolean release) {
        String update = Launcher.getUpdate(release);
        try {
            boolean yes = false;
            String update_name = update.startsWith("!") ? update.substring(1) : update;
            String rr = Lang.UPDATE_FOUND.replaceAll("%s", update_name);
            if (!update.startsWith("!")) {
                Object[] options = new Object[]{Lang.YES, Lang.NO, Lang.MANUAL_DOWNLOAD};
                int result = JOptionPane.showOptionDialog(Window.mainWindow, rr, Lang.OPTIONS_UPDATE_HEADER, -1, 1, null, options, options[0]);
                if (result == 0) {
                    System.out.println("The user wants to update to: " + update_name);
                    yes = true;
                } else {
                    if (result != 1) {
                        new SimpleWebAddressFrame("https://github.com/Moresteck/BetaCraft-Launcher-Java/releases/tag/" + update_name);
                        return;
                    }
                    System.out.println("The user doesn't want to update. The launcher stays at version: " + VERSION);
                }
            } else {
                System.out.println("Forced update to: " + update_name);
                yes = true;
            }
            if (!yes) return;
            String ending = ".jar";
            if (BC.currentPath.getAbsolutePath().endsWith(".exe")) {
                ending = ".exe";
            }
            if (BC.portable) {
                ending = "-portable" + ending;
            }
            String url = "http://files.betacraft.uk/launcher/launcher-" + update_name + ending;
            if (!release) {
                url = "http://files.betacraft.uk/launcher/launcher-" + update_name + ending;
            }
            Launcher.download(url, new File(BC.get(), "betacraft.jar$tmp"));
            String[] args = new String[]{"java", "-jar", BC.get() + "betacraft.jar$tmp", "update", BC.currentPath.getAbsolutePath()};
            Runtime.getRuntime().exec(args);
            Window.quit(true);
            return;
        }
        catch (Exception ex) {
            System.err.println("An error has occurred while updating the launcher!");
            ex.printStackTrace();
        }
    }

    public static boolean checkForUpdate(boolean release) {
        String update_name;
        String update = Launcher.getUpdate(release);
        if (update == null) {
            return false;
        }
        String string = update_name = update.startsWith("!") ? update.replace("!", "") : update;
        if (!VERSION.equalsIgnoreCase(update_name)) {
            System.out.println("Found a new version of the launcher (" + update + ").");
            return true;
        }
        return false;
    }

    public static String getUpdate(boolean release) {
        try {
            String Url = "http://files.betacraft.uk/launcher/rel.txt";
            if (!release) {
                Url = "http://files.betacraft.uk/launcher/pre.txt";
            }
            URL url = new URL(Url);
            Scanner s = new Scanner(url.openStream(), "UTF-8");
            String update = s.nextLine().split(":")[1];
            s.close();
            return update;
        }
        catch (UnknownHostException ex) {
            System.out.println("No connection, or the server is down");
        }
        catch (SocketTimeoutException ex) {
            System.out.println("No connection, or the server is down");
        }
        catch (SocketException ex) {
            System.out.println("No connection, or the server is down");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static String getNickname() {
        String name;
        Credentials c = auth.getCredentials();
        if (c != null && (name = c.username) != null && name.length() > 0) {
            return name;
        }
        return "";
    }

    public static String getAuthToken() {
        String token;
        Credentials c = auth.getCredentials();
        if (c != null && (token = c.access_token) != null && token.length() > 0) {
            return token;
        }
        return "-";
    }

    static {
        forceUpdate = false;
        disableWarnings = false;
        totalThreads = new ArrayList();
        accounts = new Accounts();
        JAVA_HOME = System.getProperty("java.home");
        javaRuntime = new File(JAVA_HOME, "bin/java" + (OS.isWindows() ? ".exe" : ""));
    }
}

