/*
 * Decompiled with CFR 0.152.
 */
package org.betacraft.launcher;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javafx.scene.Parent;
import org.betacraft.launcher.BC;
import org.betacraft.launcher.DownloadResult;
import org.betacraft.launcher.Launcher;
import org.betacraft.launcher.Logger;
import pl.betacraft.auth.Accounts;
import pl.betacraft.auth.Authenticator;
import pl.betacraft.auth.Credentials;
import pl.betacraft.auth.DownloadRequest;
import pl.betacraft.auth.DownloadResponse;
import pl.betacraft.auth.MicrosoftAuth;
import pl.betacraft.auth.MojangAuth;
import pl.betacraft.auth.NoAuth;
import pl.betacraft.json.lib.MouseFixMacOSJson;

public class Util {
    public static final Gson gson = new Gson();
    public static final Gson gsonPretty = new GsonBuilder().setPrettyPrinting().create();
    public static final int jsonVersion = 1;
    public static final File accountsFile = new File(BC.get() + "launcher/accounts.json");
    public static final File cert_file = new File(BC.get() + "launcher/ssl_cert.crt");
    public static final File old_lastlogin = new File(BC.get() + "lastlogin");

    private static void setupAccountConfiguration() {
        try {
            Launcher.auth = new NoAuth("");
            Accounts accs = new Accounts();
            accs.current = Launcher.auth.getCredentials().local_uuid;
            ArrayList<Credentials> list = new ArrayList<Credentials>();
            list.add(Launcher.auth.getCredentials());
            accs.accounts = list;
            Launcher.accounts = accs;
            Util.saveAccounts();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void saveAccounts() {
        try {
            if (!accountsFile.exists()) {
                accountsFile.createNewFile();
            }
            Files.write(accountsFile.toPath(), gsonPretty.toJson(Launcher.accounts).getBytes("UTF-8"), new OpenOption[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static Authenticator getAuthenticator(Credentials c) {
        if (c.account_type == Credentials.AccountType.MICROSOFT) {
            return new MicrosoftAuth(c);
        }
        if (c.account_type == Credentials.AccountType.MOJANG) {
            return new MojangAuth(c);
        }
        if (c.account_type == Credentials.AccountType.OFFLINE) {
            return new NoAuth(c);
        }
        return null;
    }

    public static void readAccounts() {
        try {
            if (!accountsFile.exists()) {
                Util.setupAccountConfiguration();
                return;
            }
            Accounts accs = null;
            try {
                accs = gson.fromJson(new String(Files.readAllBytes(accountsFile.toPath()), "UTF-8"), Accounts.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (accs == null || accs.accounts == null) {
                Util.setupAccountConfiguration();
                return;
            }
            for (Credentials c : accs.accounts) {
                if (c.local_uuid == null || !c.local_uuid.equals(accs.current)) continue;
                Launcher.auth = Util.getAuthenticator(c);
            }
            if (Launcher.auth == null) {
                Launcher.auth = Util.getAuthenticator(accs.accounts.get(0));
                accs.current = Launcher.auth.getCredentials().local_uuid;
            }
            Launcher.accounts = accs;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void write(File file, String[] lines, boolean append) {
        Util.write(file, lines, append, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, String[] lines, boolean append, String charset) {
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            System.out.println(file.toPath().toString());
            e.printStackTrace();
            Logger.printException(e);
        }
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), charset);
            for (int i = 0; i < lines.length; ++i) {
                if (lines[i] == null) continue;
                writer.write(lines[i] + "\n");
            }
        }
        catch (Exception ex) {
            Logger.a("A critical error occurred while attempting to write to file: " + file);
            ex.printStackTrace();
            Logger.printException(ex);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void setProperty(File file, String property, String value) {
        Util.setProperty(file, property, value, "UTF-8");
    }

    public static void setProperty(File file, String property, String value, String charset) {
        String[] lines = Util.read(file, charset);
        String[] newlines = new String[lines.length + 1];
        boolean found = false;
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i] == null) continue;
            if (lines[i].startsWith(property + ":")) {
                newlines[i] = property + ":" + value;
                found = true;
                continue;
            }
            newlines[i] = lines[i];
        }
        if (!found) {
            Util.write(file, new String[]{property + ":" + value}, true, charset);
            return;
        }
        Util.write(file, newlines, false, charset);
    }

    public static String getProperty(File file, String property) {
        return Util.getProperty(file, property, "UTF-8");
    }

    public static String getProperty(File file, String property, String charset) {
        String[] lines = Util.read(file, charset);
        String value = null;
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i] == null || !lines[i].startsWith(property + ":")) continue;
            value = lines[i].substring(property.length() + 1, lines[i].length());
            break;
        }
        return value;
    }

    public static boolean hasProperty(File file, String property, String charset) {
        String[] lines = Util.read(file, charset);
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i] == null || !lines[i].startsWith(property + ":")) continue;
            return true;
        }
        return false;
    }

    public static String[] excludeExistant(File file, String[] properties, String charset) {
        String[] lines = Util.read(file, charset);
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i] == null) continue;
            for (int i1 = 0; i1 < properties.length; ++i1) {
                if (!lines[i].startsWith(properties[i1] + ":")) continue;
                properties[i1] = null;
            }
        }
        return properties;
    }

    public static Thread unzip(File source, File dest_folder, boolean delete) {
        return Util.unzip(source.toPath().toString(), dest_folder.toPath().toString(), delete);
    }

    public static Thread unzip(final String source, final String dest_folder, final boolean delete) {
        Thread unrarthread = new Thread(){

            @Override
            public void run() {
                byte[] buffer = new byte[1024];
                try {
                    FileInputStream fis = new FileInputStream(source);
                    ZipInputStream zis = new ZipInputStream(fis);
                    ZipEntry entry = zis.getNextEntry();
                    while (entry != null) {
                        int length;
                        if (entry.isDirectory()) {
                            entry = zis.getNextEntry();
                            continue;
                        }
                        String fileName = entry.getName();
                        File newFile = new File(dest_folder + File.separator + fileName);
                        new File(newFile.getParent()).mkdirs();
                        FileOutputStream fos = new FileOutputStream(newFile);
                        while ((length = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, length);
                        }
                        fos.close();
                        zis.closeEntry();
                        entry = zis.getNextEntry();
                    }
                    zis.closeEntry();
                    zis.close();
                    fis.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Logger.printException(ex);
                }
                if (delete) {
                    new File(source).delete();
                }
                if (!Util.isStandalone()) {
                    Launcher.totalThreads.remove(this);
                }
            }
        };
        unrarthread.start();
        return unrarthread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] read(File file, String charset) {
        try {
            if (!file.exists()) {
                return new String[0];
            }
            if (file.createNewFile()) {
                Logger.a("Created a new file: " + file);
            }
        }
        catch (IOException e) {
            System.out.println(file.toPath().toString());
            e.printStackTrace();
            Logger.printException(e);
        }
        InputStreamReader reader = null;
        try {
            int readcount;
            reader = new InputStreamReader((InputStream)new FileInputStream(file), charset);
            StringBuilder inputB = new StringBuilder();
            char[] buffer = new char[1024];
            while ((readcount = reader.read(buffer)) >= 0) {
                inputB.append(buffer, 0, readcount);
            }
            String[] stringArray = inputB.toString().split("\n");
            return stringArray;
        }
        catch (Exception ex) {
            Logger.a("A critical error occurred while reading from file: " + file);
            ex.printStackTrace();
            Logger.printException(ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static boolean isStandalone() {
        try {
            Launcher.VERSION.length();
            return false;
        }
        catch (Throwable ex) {
            return true;
        }
    }

    public static String getSHA1(File file) {
        try {
            int numRead;
            FileInputStream fis = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            MessageDigest msgdig = MessageDigest.getInstance("SHA-1");
            do {
                if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                msgdig.update(buffer, 0, numRead);
            } while (numRead != -1);
            ((InputStream)fis).close();
            byte[] digest = msgdig.digest();
            String str_result = "";
            for (int i = 0; i < digest.length; ++i) {
                str_result = str_result + Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1);
            }
            return str_result;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static boolean installMacOSFix(MouseFixMacOSJson json, boolean force) {
        File javaagent = new File(BC.get() + "launcher/macos-javaagent.jar");
        File lwjgl = new File(BC.get() + "launcher/macos-mousefix-lwjgl.jar");
        File classes_folder = new File(BC.get() + "launcher/macos-java-mod/");
        File classes_temp_zip = new File(BC.get() + "launcher/macos-mousefix.zip");
        String local_javaagent_sha1 = javaagent.exists() ? Util.getSHA1(javaagent) : null;
        String local_lwjgl_sha1 = lwjgl.exists() ? Util.getSHA1(lwjgl) : null;
        String local_javamod_sha1 = Util.getProperty(BC.SETTINGS, "macosMouseFixClassesVersion");
        try {
            if (local_javaagent_sha1 == null || !local_javaagent_sha1.equals(json.agent_sha1) || force) {
                DownloadResponse agent_req = new DownloadRequest(json.agent_url, javaagent.toPath().toString(), json.agent_sha1, false).perform();
                if (agent_req.result != DownloadResult.OK) {
                    Logger.a("Failed to download macos javaagent");
                    return false;
                }
            }
            if (local_lwjgl_sha1 == null || !local_lwjgl_sha1.equals(json.lwjgl_sha1) || force) {
                DownloadResponse lwjgl_req = new DownloadRequest(json.lwjgl_url, lwjgl.toPath().toString(), json.lwjgl_sha1, false).perform();
                if (lwjgl_req.result != DownloadResult.OK) {
                    Logger.a("Failed to download macos-mousefix.zip");
                    return false;
                }
            }
            if (local_javamod_sha1 == null || !local_javamod_sha1.equals(json.classes_sha1) || force) {
                DownloadResponse classes_req = new DownloadRequest(json.classes_url, classes_temp_zip.toPath().toString(), json.classes_sha1, false).perform();
                if (classes_req.result != DownloadResult.OK) {
                    Logger.a("Failed to download macos-mousefix.zip");
                    return false;
                }
                if (classes_folder.exists() && classes_folder.list().length != 0) {
                    Launcher.removeRecursively(classes_folder, false, false);
                }
                classes_folder.mkdirs();
                Util.setProperty(BC.SETTINGS, "macosMouseFixClassesVersion", json.classes_sha1);
                Launcher.totalThreads.add(Util.unzip(classes_temp_zip, classes_folder, true));
            }
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public static boolean hasJFX() {
        try {
            Parent.class.getName();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static String getFullJavaVersion() {
        String line = null;
        try {
            ArrayList<String> arl = new ArrayList<String>();
            arl.add(Launcher.javaRuntime.toPath().toString());
            arl.add("-version");
            ProcessBuilder pb = new ProcessBuilder(arl);
            Process p = pb.start();
            InputStreamReader isr_log = new InputStreamReader(p.getErrorStream());
            BufferedReader br_log = new BufferedReader(isr_log);
            while ((line = br_log.readLine()) != null) {
                if (!line.contains("version")) continue;
                p.destroyForcibly();
                break;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        String verstart = line.substring(line.indexOf("\"") + 1);
        String fullver = verstart.substring(0, verstart.indexOf("\""));
        return fullver;
    }

    public static String getJavaVersion() {
        String fullver = Util.getFullJavaVersion();
        String whitelist = "0123456789.";
        for (int i = 0; i < fullver.length(); ++i) {
            if (whitelist.contains(Character.toString(fullver.charAt(i)))) continue;
            fullver = fullver.substring(0, i);
        }
        return fullver;
    }

    public static int getMajorJavaVersion() {
        String ver = Util.getJavaVersion();
        if (ver.startsWith("1.")) {
            return Integer.parseInt(ver.split("\\.")[1]);
        }
        int cut = ver.indexOf(46);
        if (cut == -1) {
            cut = ver.length();
        }
        return Integer.parseInt(ver.substring(0, cut));
    }

    public static void openURL(URI uri) {
        try {
            Object invoke = Class.forName("java.awt.Desktop").getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            invoke.getClass().getMethod("browse", URI.class).invoke(invoke, uri);
        }
        catch (Throwable t) {
            System.out.println("Failed to open link in a web browser: " + uri.toString());
        }
    }
}

