/*
 * Decompiled with CFR 0.152.
 */
package org.betacraft.launcher;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.betacraft.launcher.Addon;
import org.betacraft.launcher.BrowserWindow;
import org.betacraft.launcher.Lang;
import org.betacraft.launcher.LanguageElement;
import org.betacraft.launcher.Launcher;
import org.betacraft.launcher.Logger;
import org.betacraft.launcher.VersionSorter;
import org.betacraft.launcher.Window;

public class SelectAddons
extends JFrame
implements ActionListener,
LanguageElement {
    static JScrollPane listScroller;
    static JButton OK;
    static VersionSorter.Order order;
    static JPanel panel;
    static GridBagConstraints constr;
    protected static HashMap<JCheckBox, String> checkboxes;

    public SelectAddons() {
        Logger.a("Addons list window has been opened.");
        this.setIconImage(Window.img);
        this.setMinimumSize(new Dimension(282, 386));
        this.setPreferredSize(new Dimension(282, 386));
        this.setTitle(Lang.ADDON_LIST_TITLE);
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        this.makeList(false);
        this.updateList();
        this.add((Component)panel, "Center");
        this.pack();
        this.setLocationRelativeTo(Window.mainWindow);
        this.setVisible(true);
    }

    @Override
    public void update() {
        this.setTitle(Lang.ADDON_LIST_TITLE);
        OK.setText(Lang.OPTIONS_OK);
        this.pack();
    }

    protected void makeList(boolean addoninfo) {
        panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        constr = new GridBagConstraints();
        SelectAddons.constr.fill = 1;
        SelectAddons.constr.insets = new Insets(5, 5, 0, 5);
        SelectAddons.constr.gridwidth = -1;
        SelectAddons.constr.weightx = 1.0;
        panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        SelectAddons.constr.gridy = 2;
        SelectAddons.constr.weighty = -1.0;
        SelectAddons.constr.gridheight = 1;
        SelectAddons.constr.insets = new Insets(0, 5, 5, 5);
        OK = new JButton(Lang.OPTIONS_OK);
        OK.addActionListener(this);
        panel.add((Component)OK, constr);
        this.add((Component)panel, "South");
        panel = new JPanel();
        panel.setLayout(new GridBagLayout());
    }

    protected void updateList() {
        checkboxes.clear();
        JPanel listpanel = new JPanel();
        listpanel.setLayout(new GridBagLayout());
        GridBagConstraints constr1 = new GridBagConstraints();
        constr1.gridx = 0;
        constr1.gridy = 0;
        constr1.fill = 2;
        constr1.weightx = 0.0;
        constr1.insets = new Insets(5, 5, 0, 5);
        for (Addon item : Addon.addons.values()) {
            JCheckBox checkbox = new JCheckBox();
            for (String addon : Launcher.currentInstance.addons) {
                if (!addon.equals(item.name)) continue;
                checkbox.setSelected(true);
            }
            JLabel label = new JLabel(item.name);
            label.addMouseListener(new MouseListener(){

                @Override
                public void mousePressed(MouseEvent e) {
                    String name = ((JLabel)e.getSource()).getText();
                    Addon a = Addon.addons.get(name);
                    new BrowserWindow(a.getInfo());
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
            listpanel.add((Component)checkbox, constr1);
            constr1.gridx = 1;
            constr1.weightx = 1.0;
            listpanel.add((Component)label, constr1);
            constr1.gridx = 0;
            constr1.weightx = 0.0;
            checkboxes.put(checkbox, item.name);
            ++constr1.gridy;
        }
        SelectAddons.constr.weighty = 1.0;
        SelectAddons.constr.gridheight = -1;
        SelectAddons.constr.gridy = 1;
        SelectAddons.constr.insets = new Insets(5, 5, 5, 5);
        if (listScroller != null) {
            panel.remove(listScroller);
        }
        listScroller = new JScrollPane(listpanel);
        listScroller.setWheelScrollingEnabled(true);
        listScroller.getVerticalScrollBar().setUnitIncrement(10);
        panel.add((Component)listScroller, constr);
    }

    public void saveAddons() {
        ArrayList<String> elist = new ArrayList<String>();
        for (JCheckBox checkbox : checkboxes.keySet()) {
            String name = checkboxes.get(checkbox);
            if (!checkbox.isSelected()) continue;
            elist.add(name);
        }
        Launcher.currentInstance.setAddons(elist);
        this.setVisible(false);
        Launcher.currentInstance.saveInstance();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == OK) {
            this.saveAddons();
            Window.addonsList = null;
        }
    }

    static {
        order = VersionSorter.Order.FROM_OLDEST;
        checkboxes = new HashMap();
    }
}

