/*
 * Decompiled with CFR 0.152.
 */
package org.betacraft.launcher;

import java.io.File;
import java.util.Date;
import org.betacraft.launcher.BC;
import org.betacraft.launcher.Logger;
import org.betacraft.launcher.Release;
import org.betacraft.launcher.Util;

public class ReleaseJson
implements Release.VersionInfo {
    private long releaseTimestamp = 0L;
    private long timestamp = 0L;
    private String download = "";
    private String launchMethod = "";
    private String launchMethodLink = "";
    private String proxyArgs = "-Dhttp.proxyHost=betacraft.uk";
    private String otherName = "";
    private String protocol = "";
    private int fileVersion = -1;
    private final String version;
    public final File json;
    public boolean custom = false;

    public ReleaseJson(String version) {
        this.version = version;
        this.json = new File(BC.get() + "versions" + File.separator + "jsons", version + ".info");
        this.readJson();
    }

    public void readJson() {
        try {
            String file_ver;
            String proxy;
            String releaseDate = Util.getProperty(this.json, "release-date");
            String compileDate = Util.getProperty(this.json, "compile-date");
            try {
                this.releaseTimestamp = Long.parseLong(releaseDate);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.timestamp = Long.parseLong(compileDate);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.download = Util.getProperty(this.json, "url");
            this.launchMethod = Util.getProperty(this.json, "launch-method");
            this.launchMethodLink = Util.getProperty(this.json, "launch-method-link");
            this.proxyArgs = proxy = Util.hasProperty(this.json, "proxy-args", "UTF-8") ? Util.getProperty(this.json, "proxy-args") : this.proxyArgs;
            this.otherName = Util.getProperty(this.json, "other-name");
            this.protocol = Util.getProperty(this.json, "protocolVersion");
            String custom_flag_str = Util.getProperty(this.json, "custom");
            if (custom_flag_str != null) {
                try {
                    this.custom = Boolean.parseBoolean(custom_flag_str);
                }
                catch (Throwable t) {
                    Logger.a("Version " + this.version + " has an invalid `custom` parameter.");
                }
            }
            if ((file_ver = Util.getProperty(this.json, "file-ver")) != null) {
                try {
                    this.fileVersion = Integer.parseInt(file_ver);
                }
                catch (Throwable t) {
                    Logger.a("Version " + this.version + " has an invalid `file-ver` parameter.");
                    if (!Util.hasProperty(this.json, "file-ver", "UTF-8")) {
                        this.fileVersion = 0;
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Logger.printException(ex);
        }
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Date getCompileDate() {
        return new Date(this.timestamp);
    }

    @Override
    public Date getReleaseDate() {
        return new Date(this.releaseTimestamp);
    }

    @Override
    public String getOtherName() {
        return this.otherName;
    }

    @Override
    public String getProxyArgs() {
        return this.proxyArgs;
    }

    @Override
    public String getLaunchMethod() {
        return this.launchMethod;
    }

    @Override
    public String getLaunchMethodURL() {
        return this.launchMethodLink;
    }

    @Override
    public String getEntry(String entryname) {
        return Util.getProperty(this.json, entryname);
    }

    @Override
    public void setEntry(String entry, String value) {
        Util.setProperty(this.json, entry, value);
        this.readJson();
    }

    @Override
    public String getDownloadURL() {
        return this.download;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public int getFileVersion() {
        return this.fileVersion;
    }

    @Override
    public boolean isCustom() {
        return this.custom;
    }

    public static boolean exists(String name) {
        return new File(BC.get() + "versions/jsons/", name + ".info").exists();
    }
}

