/*
 * Decompiled with CFR 0.152.
 */
package org.betacraft.launcher;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Scanner;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.betacraft.Classic12aWrapper;
import org.betacraft.Classic15aWrapper;
import org.betacraft.CommandLine;
import org.betacraft.FkWrapper;
import org.betacraft.Minecraft13w16a;
import org.betacraft.PreClassicWrapper;
import org.betacraft.PreClassicWrapper2;
import org.betacraft.Wrapper;
import org.betacraft.WrapperDetector;
import org.betacraft.launcher.Addon;
import org.betacraft.launcher.BC;
import org.betacraft.launcher.DownloadResult;
import org.betacraft.launcher.Instance;
import org.betacraft.launcher.Lang;
import org.betacraft.launcher.ListenThread;
import org.betacraft.launcher.Logger;
import org.betacraft.launcher.OS;
import org.betacraft.launcher.Release;
import org.betacraft.launcher.ReleaseJson;
import org.betacraft.launcher.StartThread;
import org.betacraft.launcher.Util;
import org.betacraft.launcher.Window;
import pl.betacraft.auth.Accounts;
import pl.betacraft.auth.Authenticator;
import pl.betacraft.auth.Credentials;
import pl.betacraft.auth.CustomRequest;
import pl.betacraft.auth.CustomResponse;
import pl.betacraft.auth.DownloadRequest;
import pl.betacraft.auth.DownloadResponse;
import pl.betacraft.auth.NoAuth;
import pl.betacraft.json.lib.MouseFixMacOSJson;

public class Launcher {
    public static String VERSION = "1.09_15";
    public static Instance currentInstance;
    public static boolean forceUpdate;
    public static ArrayList<Thread> totalThreads;
    public static Authenticator auth;
    public static Accounts accounts;
    public static String JAVA_HOME;
    public static File javaRuntime;

    public static void main(String[] args) {
        if (ListenThread.isAvailable()) {
            new ListenThread().start();
        } else if (args.length > 0 && !args[0].equals("wrap") && !args[0].equals("update")) {
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(11799), 5000);
                DataOutputStream dout = new DataOutputStream(socket.getOutputStream());
                dout.writeUTF(args[0]);
                dout.flush();
                dout.close();
                socket.close();
                System.exit(0);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        String javaver = System.getProperty("java.runtime.version");
        String javadistro = System.getProperty("java.vendor");
        System.err.println("Java version: " + javadistro + ", " + System.getProperty("java.runtime.name") + ", " + javaver);
        System.err.println("System: " + OS.OS + ", " + OS.VER + ", " + OS.ARCH);
        long nano = System.nanoTime();
        boolean systemlookandfeel = Boolean.parseBoolean(System.getProperty("betacraft.systemLookAndFeel", "true"));
        if (systemlookandfeel && (!OS.VER.contains("arch") && !OS.VER.contains("manjaro") || javaver == null || !javaver.startsWith("16") || javadistro == null || javadistro.toLowerCase().contains("azul"))) {
            try {
                if (OS.isWindows()) {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                } else if (OS.isLinux()) {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
                }
            }
            catch (Exception ex) {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception ex1) {
                    ex1.printStackTrace();
                    Logger.printException(ex1);
                }
            }
        }
        try {
            String p = Window.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            if (OS.isWindows()) {
                p = p.substring(1, p.length());
            }
            BC.currentPath = new File(p);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (args.length >= 2 && (args[0].equals("update") || args[1].equals("update"))) {
            try {
                int e = 1;
                if (args[1].equals("update")) {
                    ++e;
                }
                String pathToJar = "";
                for (int i = e; i < args.length; ++i) {
                    pathToJar = pathToJar.equals("") ? args[i] : pathToJar + " " + args[i];
                }
                if (pathToJar.startsWith("//") && !OS.isWindows() || pathToJar.startsWith("/") && OS.isWindows()) {
                    pathToJar = pathToJar.substring(1, pathToJar.length());
                }
                File dest = new File(pathToJar);
                Files.copy(BC.currentPath.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
                ArrayList<String> pa = new ArrayList<String>();
                pa.add("java");
                pa.add("-jar");
                pa.add(dest.toPath().toString());
                new ProcessBuilder(pa).start();
                System.exit(0);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Logger.printException(ex);
                System.exit(0);
            }
            return;
        }
        if (args.length > 0 && args[0].equals("wrap")) {
            BC.wrapped = true;
            BC.SETTINGS = new File(BC.get() + "launcher", "launcher.settings");
            Lang.refresh(false, false);
            String username = args[1];
            String sessionid = args[2];
            String server = args[3].equals("-") ? null : args[3];
            String mppass = args[4].equals("-") ? "0" : args[4];
            String uuid = args[5];
            StringBuilder split = new StringBuilder();
            for (int i = 6; i < args.length; ++i) {
                split.append(args[i] + " ");
            }
            String instanceName = split.toString();
            instanceName = instanceName.substring(0, instanceName.length() - 1);
            currentInstance = Instance.loadInstance(instanceName);
            ReleaseJson json = new ReleaseJson(Launcher.currentInstance.version);
            String meth = json.getLaunchMethod();
            ArrayList addons = new ArrayList();
            if (!Launcher.currentInstance.addons.isEmpty()) {
                try {
                    System.err.println("Loading addons...");
                    for (String s : Launcher.currentInstance.addons) {
                        try {
                            String path = BC.get() + "launcher" + File.separator + "addons" + File.separator + s + ".jar";
                            System.err.println(path);
                            URLClassLoader loader = new URLClassLoader(new URL[]{new File(path).toURI().toURL()});
                            System.err.println("- " + s);
                            Launcher.loadClasses(path, loader);
                            Class<?> c = loader.loadClass(s);
                            addons.add(c);
                            loader.close();
                        }
                        catch (Exception ex) {
                            System.err.println("An error occurred while loading an addon: " + s);
                            ex.printStackTrace();
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Logger.printException(ex);
                }
            }
            if ((meth == null || meth.equalsIgnoreCase("")) && (meth = WrapperDetector.getLaunchMethod(BC.get() + "versions/" + Launcher.currentInstance.version + ".jar")).equals("custom")) {
                String err = "Error code 7 (ERRCONFIG): Couldn't determine the launch method for your JAR. Configure your version configuration file: " + BC.get() + "versions/jsons/" + Launcher.currentInstance.version + ".info";
                System.err.println(err);
                JOptionPane.showMessageDialog(Window.mainWindow, err, "Error", 1);
                System.exit(0);
            }
            Logger.a("Loaded in: " + (System.nanoTime() - nano) + " ns");
            if (meth.equalsIgnoreCase("rd") || meth.equalsIgnoreCase("mc")) {
                new Launcher().extractFromJar("/PreClassic.jar", new File(BC.get() + "launcher/", "PreClassic.jar"));
                new PreClassicWrapper2(username, Launcher.currentInstance.name, Launcher.currentInstance.version, sessionid, Launcher.currentInstance.gameDir, Launcher.currentInstance.height, Launcher.currentInstance.width, Launcher.currentInstance.RPC, meth, server, mppass, Lang.WRAP_USER, Lang.WRAP_VERSION, currentInstance.getIcon(), addons);
            } else if (meth.equalsIgnoreCase("preclassic")) {
                new PreClassicWrapper(username, Launcher.currentInstance.name, Launcher.currentInstance.version, sessionid, Launcher.currentInstance.gameDir, Launcher.currentInstance.height, Launcher.currentInstance.width, Launcher.currentInstance.RPC, meth, server, mppass, Lang.WRAP_USER, Lang.WRAP_VERSION, currentInstance.getIcon(), addons);
            } else if (meth.equalsIgnoreCase("classic12a")) {
                new Classic12aWrapper(username, Launcher.currentInstance.name, Launcher.currentInstance.version, sessionid, Launcher.currentInstance.gameDir, Launcher.currentInstance.height, Launcher.currentInstance.width, Launcher.currentInstance.RPC, meth, server, mppass, Lang.WRAP_USER, Lang.WRAP_VERSION, currentInstance.getIcon(), addons);
            } else if (meth.equalsIgnoreCase("classic15a")) {
                new Classic15aWrapper(username, Launcher.currentInstance.name, Launcher.currentInstance.version, sessionid, Launcher.currentInstance.gameDir, Launcher.currentInstance.height, Launcher.currentInstance.width, Launcher.currentInstance.RPC, meth, server, mppass, uuid, Lang.WRAP_USER, Lang.WRAP_VERSION, currentInstance.getIcon(), addons);
            } else if (meth.equalsIgnoreCase("indev") || meth.equalsIgnoreCase("classicmp") || meth.equalsIgnoreCase("classic")) {
                new Wrapper(username, Launcher.currentInstance.name, Launcher.currentInstance.version, sessionid, Launcher.currentInstance.gameDir, Launcher.currentInstance.height, Launcher.currentInstance.width, Launcher.currentInstance.RPC, meth, server, mppass, uuid, Lang.WRAP_USER, Lang.WRAP_VERSION, currentInstance.getIcon(), addons);
            } else if (meth.equalsIgnoreCase("commandline")) {
                new CommandLine(username, Launcher.currentInstance.name, Launcher.currentInstance.version, sessionid, Launcher.currentInstance.gameDir, Launcher.currentInstance.height, Launcher.currentInstance.width, Launcher.currentInstance.RPC, meth, server, mppass, Lang.WRAP_USER, Lang.WRAP_VERSION, currentInstance.getIcon(), addons);
            } else if (meth.equalsIgnoreCase("1.6")) {
                new Minecraft13w16a(username, Launcher.currentInstance.name, Launcher.currentInstance.version, sessionid, Launcher.currentInstance.gameDir, Launcher.currentInstance.height, Launcher.currentInstance.width, Launcher.currentInstance.RPC, meth, server, mppass, Lang.WRAP_USER, Lang.WRAP_VERSION, currentInstance.getIcon(), addons);
            } else if (meth.equalsIgnoreCase("4k")) {
                new FkWrapper(username, Launcher.currentInstance.name, Launcher.currentInstance.version, sessionid, Launcher.currentInstance.gameDir, Launcher.currentInstance.height, Launcher.currentInstance.width, Launcher.currentInstance.RPC, meth, server, mppass, Lang.WRAP_USER, Lang.WRAP_VERSION, currentInstance.getIcon(), addons);
            } else {
                try {
                    String path = BC.get() + "launcher" + File.separator + "launch-methods" + File.separator + meth + ".jar";
                    URLClassLoader loader = new URLClassLoader(new URL[]{new File(path).toURI().toURL()});
                    Launcher.loadClasses(path, loader);
                    System.err.println("Launch method: " + meth);
                    Class<?> c = loader.loadClass(meth);
                    Constructor<?> con = c.getConstructor(String.class, String.class, String.class, String.class, String.class, Integer.class, Integer.class, Boolean.class, String.class, String.class, String.class, String.class, String.class, Image.class, ArrayList.class);
                    con.newInstance(username, Launcher.currentInstance.name, Launcher.currentInstance.version, sessionid, Launcher.currentInstance.gameDir, Launcher.currentInstance.height, Launcher.currentInstance.width, Launcher.currentInstance.RPC, json.getLaunchMethod(), server, mppass, Lang.WRAP_USER, Lang.WRAP_VERSION, currentInstance.getIcon(), addons);
                    loader.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Logger.printException(ex);
                }
            }
            return;
        }
        BC.SETTINGS = new File(BC.get() + "launcher", "launcher.settings");
        if (BC.SETTINGS.exists() && !"1".equals(Util.getProperty(BC.SETTINGS, "version"))) {
            Launcher.removeRecursively(new File(BC.get() + "launcher"), true, false);
            Launcher.writeDefault();
        }
        new File(BC.get() + "versions" + File.separator + "jsons").mkdirs();
        new File(BC.get() + "launcher" + File.separator + "lang").mkdirs();
        new File(BC.get() + "launcher" + File.separator + "addons").mkdirs();
        new File(BC.get() + "launcher" + File.separator + "instances").mkdirs();
        new File(BC.get() + "launcher" + File.separator + "launch-methods").mkdirs();
        new File(BC.get() + "bin" + File.separator + "natives").mkdirs();
        Logger.a("BetaCraft Launcher JE v" + VERSION + " loading...");
        Logger.a("Java version: " + System.getProperty("java.vendor") + ", " + System.getProperty("java.runtime.name") + ", " + System.getProperty("java.runtime.version"));
        Logger.a("Portable: " + BC.portable);
        Logger.a("EXE: " + BC.currentPath.toPath().toString().endsWith(".exe"));
        Logger.a("Prerelease: " + BC.prerelease);
        Logger.a("Nightly: " + BC.nightly);
        Lang.refresh(false, false);
        Util.readAccounts();
        if (!BC.SETTINGS.exists() || Util.getProperty(BC.SETTINGS, "lastInstance").equals("")) {
            Launcher.writeDefault();
            currentInstance = Instance.newInstance(Util.getProperty(BC.SETTINGS, "lastInstance"));
            currentInstance.saveInstance();
        } else {
            currentInstance = Instance.loadInstance(Util.getProperty(BC.SETTINGS, "lastInstance"));
            if (currentInstance == null) {
                currentInstance = Instance.newInstance(Util.getProperty(BC.SETTINGS, "lastInstance"));
                currentInstance.saveInstance();
            }
        }
        try {
            StartThread t = new StartThread();
            totalThreads.add(t);
            t.start();
        }
        catch (Exception ex) {
            Logger.a("A critical error has occurred while trying to initialize the launcher!");
            ex.printStackTrace();
            Logger.printException(ex);
        }
        Logger.a("Loaded in: " + (System.nanoTime() - nano) + " ns");
    }

    public void extractFromJar(String filepath, File to) {
        try {
            Logger.a("Extracting \"" + filepath + "\" to \"" + to.toPath().toString() + "\"");
            Files.copy(this.getClass().getResourceAsStream(filepath), Paths.get(to.toPath().toString(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Logger.printException(ex);
        }
    }

    public void packToJar(String filepath, File to) {
        try {
            Logger.a("Extracting \"" + filepath + "\" to \"" + to.toPath().toString() + "\"");
            Files.copy(this.getClass().getResourceAsStream(filepath), Paths.get(to.toPath().toString(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Logger.printException(ex);
        }
    }

    public static void loadClasses(String pathtojar, URLClassLoader loader) {
        try {
            JarFile jarFile = new JarFile(pathtojar);
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                String className = entry.getName().substring(0, entry.getName().length() - 6);
                className = className.replaceAll("/", ".");
                try {
                    loader.loadClass(className);
                }
                catch (NoClassDefFoundError ex) {
                    Logger.a("Couldn't find class " + className + ". Skipping!");
                    ex.printStackTrace();
                    Logger.printException(ex);
                }
            }
            jarFile.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void restart() {
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(new File(JAVA_HOME, "bin/java" + (OS.isWindows() ? ".exe" : "")).toPath().toString());
            params.add("-jar");
            params.add(BC.currentPath.toPath().toString());
            ProcessBuilder builder = new ProcessBuilder(params);
            builder.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Logger.printException(ex);
        }
        Window.quit(true);
    }

    public static void setInstance(Instance instance) {
        currentInstance = instance;
        Window.selectedInstanceDisplay.setText(Launcher.currentInstance.name + " [" + Launcher.currentInstance.version + "]");
        Util.setProperty(BC.SETTINGS, "lastInstance", Launcher.currentInstance.name);
    }

    public static void initStartup() {
        Object json;
        Release rel;
        File wrapper = new File(BC.get() + "launcher", "betacraft_wrapper.jar");
        if (BC.currentPath.length() != wrapper.length()) {
            try {
                Files.copy(BC.currentPath.toPath(), wrapper.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (FileSystemException fileSystemException) {
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Logger.printException(ex);
                JOptionPane.showMessageDialog(Window.mainWindow, "The file could not be copied! Try running with Administrator rights. If that won't help, contact: @Moresteck#1688", "Error", 0);
                return;
            }
        }
        if (Launcher.currentInstance.RPC) {
            File rpc = new File(BC.get() + "launcher/", "discord_rpc.jar");
            if (rpc.exists()) {
                try {
                    String sha1 = Util.getSHA1(rpc);
                    String expected_hash = new CustomRequest((String)"http://files.betacraft.uk/launcher/assets/discord_rpc.sha1").perform().response.replace("\n", "");
                    if (!sha1.equals(expected_hash)) {
                        Launcher.downloadWithButtonOutput("http://files.betacraft.uk/launcher/assets/discord_rpc.jar", rpc);
                    }
                }
                catch (Throwable sha1) {
                    // empty catch block
                }
            }
            if (!rpc.exists() || forceUpdate) {
                Launcher.downloadWithButtonOutput("http://files.betacraft.uk/launcher/assets/discord_rpc.jar", rpc);
            }
        }
        if (!(rel = Release.getReleaseByName(Launcher.currentInstance.version)).getInfo().isCustom()) {
            rel.getInfo().downloadJson();
        }
        ReleaseJson info = new ReleaseJson(rel.getName());
        info.custom = rel.getInfo().isCustom();
        rel.setInfo(info);
        if (!(Launcher.isVersionReady(Launcher.currentInstance.version) && !forceUpdate || (json = Release.getReleaseByName(Launcher.currentInstance.version).getInfo()).getDownloadURL().equals("") || Launcher.downloadWithButtonOutput(Release.getReleaseByName(Launcher.currentInstance.version).getInfo().getDownloadURL(), new File(Launcher.getVerFolder(), Launcher.currentInstance.version + ".jar")).isPositive())) {
            JOptionPane.showMessageDialog(Window.mainWindow, Lang.ERR_NO_CONNECTION, Lang.ERR_DL_FAIL, 0);
        }
        if (!Launcher.isLaunchMethodReady(Launcher.currentInstance.version) || forceUpdate) {
            Launcher.downloadLaunchMethod(Launcher.currentInstance.version);
        }
        Launcher.readyAddons(currentInstance, forceUpdate);
        if (OS.isMac() && "true".equalsIgnoreCase(info.getEntry("macos-mousefix")) && (json = new CustomRequest((String)"http://files.betacraft.uk/launcher/assets/macos-mousefix.json").perform().response) != null) {
            MouseFixMacOSJson mousefix_json = Util.gsonPretty.fromJson((String)json, MouseFixMacOSJson.class);
            Util.installMacOSFix(mousefix_json, forceUpdate);
        }
        if (!(Launcher.checkDepends() && !forceUpdate || Launcher.downloadDepends())) {
            JOptionPane.showMessageDialog(Window.mainWindow, Lang.ERR_NO_CONNECTION, Lang.ERR_DL_FAIL, 0);
        }
    }

    public void launchGame(Instance instance) {
        Launcher.launchGame(instance, "-", "-");
    }

    public static void launchGame(Instance instance, String server, String mppass) {
        try {
            if (instance.version != null) {
                String line1;
                if (Launcher.getNickname().equals("")) {
                    JOptionPane.showMessageDialog(Window.mainWindow, Lang.WINDOW_USERNAME_FIELD_EMPTY, "Error", 0);
                    return;
                }
                ArrayList<String> params = new ArrayList<String>();
                params.add(new File(JAVA_HOME, "bin/java" + (OS.isWindows() ? ".exe" : "")).toPath().toString());
                String colon = ":";
                if (OS.isWindows()) {
                    colon = ";";
                    params.add("-XX:HeapDumpPath=MojangTricksIntelDriversForPerformance_javaw.exe_minecraft.exe.heapdump");
                }
                if (OS.ARCH.contains("x86")) {
                    params.add("-Xss1M");
                }
                String add = "";
                if (instance.RPC) {
                    add = colon + BC.get() + "launcher" + File.separator + "discord_rpc.jar";
                }
                params.add("-Djava.util.Arrays.useLegacyMergeSort=true");
                Release.VersionInfo info = Release.getReleaseByName(instance.version).getInfo();
                if (OS.isMac() && "true".equalsIgnoreCase(info.getEntry("macos-mousefix"))) {
                    params.add("-javaagent:" + BC.get() + "launcher/macos-javaagent.jar=" + BC.get());
                }
                if (OS.isLinux() && "true".equalsIgnoreCase(info.getEntry("linux-mousefix-earlyclassic"))) {
                    params.add("-Dbetacraft.linux_mousefix_earlyclassic=true");
                }
                if ("true".equalsIgnoreCase(info.getEntry("resize-applet"))) {
                    params.add("-Dbetacraft.resize_applet=true");
                }
                if ("true".equalsIgnoreCase(info.getEntry("do-not-get-mppass"))) {
                    params.add("-Dbetacraft.obtainMPpass=false");
                }
                if (info.getProtocol() != null && "classicmp".equals(info.getLaunchMethod())) {
                    params.add("-Dbetacraft.ask_for_server=true");
                }
                if (OS.isMac()) {
                    params.add("-Xdock:name=" + instance.name);
                    params.add("-Xdock:icon=" + instance.getIconLocation());
                }
                params.add("-Dhttp.nonProxyHosts=api.betacraft.uk");
                if (instance.launchArgs != null && !instance.launchArgs.equals("")) {
                    params.addAll(Launcher.getCustomParameters());
                }
                if (instance.proxy) {
                    String[] args;
                    for (String s : args = info.getProxyArgs().split(" ")) {
                        if (s.equals("")) continue;
                        params.add(s);
                    }
                }
                String token = Launcher.getAuthToken();
                params.add("-cp");
                params.add(BC.get() + "launcher" + File.separator + "betacraft_wrapper.jar" + add);
                params.add("org.betacraft.launcher.Launcher");
                params.add("wrap");
                params.add(Launcher.getNickname());
                params.add(token);
                params.add(server);
                params.add(mppass);
                if (!(auth instanceof NoAuth)) {
                    params.add(Launcher.auth.getCredentials().local_uuid);
                } else {
                    params.add("-");
                }
                params.add(Launcher.currentInstance.name);
                System.out.println(params.toString());
                Logger.a(!token.equals("-") ? params.toString().replaceAll(token, "[censored sessionid]") : params.toString());
                ProcessBuilder builder = new ProcessBuilder(params);
                builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
                new File(instance.gameDir).mkdirs();
                builder.directory(new File(instance.gameDir));
                if (!instance.keepopen) {
                    Window.quit(false);
                }
                Process process = builder.start();
                InputStream output = process.getInputStream();
                InputStream err = process.getErrorStream();
                InputStreamReader isr_log = new InputStreamReader(output);
                InputStreamReader isr_err = new InputStreamReader(err);
                BufferedReader br_log = new BufferedReader(isr_log);
                BufferedReader br_err = new BufferedReader(isr_err);
                while ((line1 = br_log.readLine()) != null || (line1 = br_err.readLine()) != null) {
                    if (!token.equals("-")) {
                        line1 = line1.replaceAll(token, "[censored sessionid]");
                    }
                    Logger.logClient(line1);
                }
                Logger.logClient("End of client input");
                Logger.a("Client closed.");
                if (!instance.keepopen) {
                    Window.quit(true);
                }
                return;
            }
        }
        catch (Exception ex) {
            Logger.a("A critical error has occurred while attempting to launch the game!");
            ex.printStackTrace();
            Logger.printException(ex);
        }
    }

    public static void writeDefault() {
        Util.setProperty(BC.SETTINGS, "language", "English");
        Util.setProperty(BC.SETTINGS, "lastInstance", "(default instance)");
        Util.setProperty(BC.SETTINGS, "tab", Window.Tab.CHANGELOG.name());
        Util.setProperty(BC.SETTINGS, "version", "1");
    }

    public static void removeRecursively(File folder, boolean deleteFolderItself, boolean deleteOnlyFiles) {
        String[] entries;
        for (String s : entries = folder.list()) {
            File currentFile = new File(folder.getPath(), s);
            if (currentFile.isDirectory() && !deleteOnlyFiles) {
                for (String s1 : currentFile.list()) {
                    new File(currentFile.getPath(), s1).delete();
                }
                try {
                    Files.delete(currentFile.toPath());
                }
                catch (Exception exception) {}
                continue;
            }
            currentFile.delete();
        }
        if (deleteFolderItself) {
            folder.delete();
        }
    }

    public static File getVerFolder() {
        return new File(BC.get() + "versions" + File.separator);
    }

    public static void downloadLaunchMethod(String version) {
        Release.VersionInfo json = Release.getReleaseByName(version).getInfo();
        if (!json.getLaunchMethodURL().equals("") && !Launcher.downloadWithButtonOutput(json.getLaunchMethodURL(), new File(BC.get() + "launcher" + File.separator + "launch-methods", json.getLaunchMethod() + ".jar")).isPositive()) {
            JOptionPane.showMessageDialog(Window.mainWindow, "Couldn't download the launch method for this version.", "Error", 0);
        }
    }

    public static boolean isLaunchMethodReady(String version) {
        boolean bol1 = true;
        Release.VersionInfo json = Release.getReleaseByName(version).getInfo();
        if (json.getLaunchMethodURL() != null && !new File(BC.get() + "launcher" + File.separator + "launch-methods", json.getLaunchMethod() + ".jar").exists()) {
            bol1 = false;
        }
        return bol1;
    }

    public static void readyAddons(Instance instance, boolean force) {
        for (String s : instance.addons) {
            String filehash;
            boolean download = false;
            Addon a = Addon.addons.get(s);
            File destination = new File(BC.get() + "launcher" + File.separator + "addons", s + ".jar");
            if (!destination.exists()) {
                download = true;
            } else if (a.online && !(filehash = Util.getSHA1(destination)).equalsIgnoreCase(a.onlinehash)) {
                download = true;
            }
            if (!download || Launcher.downloadWithButtonOutput("http://files.betacraft.uk/launcher/assets/addons/" + Addon.addonVer + "/" + s + ".jar", destination).isPositive()) continue;
            JOptionPane.showMessageDialog(Window.mainWindow, "Couldn't download addon: " + s, "Error", 0);
        }
    }

    public static boolean isVersionReady(String version) {
        File file = new File(Launcher.getVerFolder(), version + ".jar");
        boolean bol = false;
        if (file.exists() && !file.isDirectory()) {
            bol = true;
        }
        return bol;
    }

    public static boolean checkDepends() {
        File bin = new File(BC.get() + "bin");
        if (bin.listFiles().length <= 1) {
            return false;
        }
        if (new File(bin, "natives").listFiles().length <= 1) {
            return false;
        }
        try {
            URL url = new URL("http://files.betacraft.uk/launcher/assets/depends-version.txt");
            Scanner s = new Scanner(url.openStream(), "UTF-8");
            String libs = s.nextLine().split(":")[1];
            String natives = s.nextLine().split(":")[1];
            s.close();
            boolean lastLibsMatch = libs.equals(Util.getProperty(BC.SETTINGS, "libs-version"));
            boolean lastNativesMatch = natives.equals(Util.getProperty(BC.SETTINGS, "natives-version"));
            return lastLibsMatch && lastNativesMatch;
        }
        catch (Throwable t) {
            t.printStackTrace();
            Logger.printException(t);
            return true;
        }
    }

    public static boolean downloadDepends() {
        File dest1;
        File destLibs = new File(BC.get() + "bin" + File.separator);
        File destNatives = new File(BC.get() + "bin" + File.separator + "natives" + File.separator);
        String link1 = "http://files.betacraft.uk/launcher/assets/natives-windows.zip";
        String link2 = "http://files.betacraft.uk/launcher/assets/libs-windows.zip";
        if (OS.isLinux()) {
            link2 = "http://files.betacraft.uk/launcher/assets/libs-linux.zip";
            link1 = "http://files.betacraft.uk/launcher/assets/natives-linux.zip";
        }
        if (OS.isMac()) {
            link2 = "http://files.betacraft.uk/launcher/assets/libs-osx.zip";
            link1 = "http://files.betacraft.uk/launcher/assets/natives-osx.zip";
        }
        if (!Launcher.downloadWithButtonOutput(link1, dest1 = new File(BC.get() + "launcher/", "natives.zip")).isPositive()) {
            return false;
        }
        File dest2 = new File(BC.get() + "launcher/", "libs.zip");
        if (!Launcher.downloadWithButtonOutput(link2, dest2).isPositive()) {
            return false;
        }
        CustomResponse res = new CustomRequest("http://files.betacraft.uk/launcher/assets/depends-version.txt").perform();
        Scanner s = new Scanner(res.response);
        String libs = s.nextLine().split(":")[1];
        String natives = s.nextLine().split(":")[1];
        s.close();
        Util.setProperty(BC.SETTINGS, "libs-version", libs);
        Util.setProperty(BC.SETTINGS, "natives-version", natives);
        Launcher.removeRecursively(destNatives, true, false);
        Launcher.removeRecursively(destLibs, false, false);
        destNatives.mkdirs();
        totalThreads.add(Util.unzip(dest1, destNatives, true));
        totalThreads.add(Util.unzip(dest2, destLibs, true));
        return true;
    }

    public static ArrayList<String> getCustomParameters() {
        String params = Launcher.currentInstance.launchArgs;
        if (params.length() == 0) {
            return new ArrayList<String>();
        }
        String[] split = params.split(" ");
        ArrayList<String> parameters = new ArrayList<String>();
        for (String s : split) {
            parameters.add(s);
        }
        return parameters;
    }

    public static DownloadResult downloadWithButtonOutput(String link, File folder) {
        SwingUtilities.invokeLater(() -> Window.setStatus(Window.playButton, "Downloading: " + BC.trimBetaCraftDir(folder.toPath().toString())));
        return Launcher.download(link, folder);
    }

    public static DownloadResult download(String link, File folder) {
        Logger.a("Download started from: " + link);
        DownloadResponse response = new DownloadRequest(link, folder.toPath().toString(), null, true).perform();
        return response.result;
    }

    public static void downloadUpdate(boolean release) {
        String update = Launcher.getUpdate(release);
        try {
            boolean yes = false;
            String update_name = update.startsWith("!") ? update.substring(1) : update;
            String rr = Lang.UPDATE_FOUND.replaceAll("%s", update_name);
            if (!update.startsWith("!")) {
                int result = JOptionPane.showConfirmDialog(Window.mainWindow, rr, Lang.OPTIONS_UPDATE_HEADER, 0);
                if (result == 0) {
                    Logger.a("The user wants to update to: " + update_name);
                    yes = true;
                } else {
                    Logger.a("The user doesn't want to update. The launcher stays at version: " + VERSION);
                }
            } else {
                Logger.a("Forced update to: " + update_name);
                yes = true;
            }
            if (yes) {
                String ending = ".jar";
                if (BC.currentPath.toPath().toString().endsWith(".exe")) {
                    ending = ".exe";
                }
                if (BC.portable) {
                    ending = "-portable" + ending;
                }
                String url = "http://files.betacraft.uk/launcher/launcher-" + update_name + ending;
                if (!release) {
                    url = "http://files.betacraft.uk/launcher/launcher-" + update_name + ending;
                }
                Launcher.download(url, new File(BC.get(), "betacraft.jar$tmp"));
                String[] args = new String[]{"java", "-jar", BC.get() + "betacraft.jar$tmp", "update", BC.currentPath.toPath().toString()};
                Runtime.getRuntime().exec(args);
                Window.quit(true);
            }
        }
        catch (Exception ex) {
            Logger.a("An error has occurred while updating the launcher!");
            ex.printStackTrace();
            Logger.printException(ex);
        }
    }

    public static boolean checkForUpdate(boolean release) {
        String update_name;
        String update = Launcher.getUpdate(release);
        if (update == null) {
            return false;
        }
        String string = update_name = update.startsWith("!") ? update.replace("!", "") : update;
        if (!VERSION.equalsIgnoreCase(update_name)) {
            Logger.a("Found a new version of the launcher (" + update + ").");
            return true;
        }
        return false;
    }

    public static String getUpdate(boolean release) {
        try {
            String Url = "http://files.betacraft.uk/launcher/rel.txt";
            if (!release) {
                Url = "http://files.betacraft.uk/launcher/pre.txt";
            }
            URL url = new URL(Url);
            Scanner s = new Scanner(url.openStream(), "UTF-8");
            String update = s.nextLine().split(":")[1];
            s.close();
            return update;
        }
        catch (UnknownHostException ex) {
            Logger.a(null);
        }
        catch (SocketTimeoutException ex) {
            Logger.a(null);
        }
        catch (SocketException ex) {
            Logger.a(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Logger.printException(ex);
        }
        return null;
    }

    public static String getNickname() {
        String name;
        Credentials c = auth.getCredentials();
        if (c != null && (name = c.username) != null && name.length() > 0) {
            return name;
        }
        return "";
    }

    public static String getAuthToken() {
        String token;
        Credentials c = auth.getCredentials();
        if (c != null && (token = c.access_token) != null && token.length() > 0) {
            return token;
        }
        return "-";
    }

    public static void clearCookies() {
        CookieHandler.setDefault(new CookieManager());
    }

    static {
        forceUpdate = false;
        totalThreads = new ArrayList();
        accounts = new Accounts();
        JAVA_HOME = System.getProperty("java.home");
        javaRuntime = new File(JAVA_HOME, "bin/java" + (OS.isWindows() ? ".exe" : ""));
    }
}

