/*
 * Decompiled with CFR 0.152.
 */
package org.betacraft.launcher;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.betacraft.launcher.BC;
import org.betacraft.launcher.DownloadResult;
import org.betacraft.launcher.LanguageElement;
import org.betacraft.launcher.Launcher;
import org.betacraft.launcher.Logger;
import org.betacraft.launcher.Util;
import org.betacraft.launcher.Window;

public class Lang
extends JFrame
implements LanguageElement {
    public static List<String> locales = new ArrayList<String>();
    static JList list;
    static DefaultListModel listModel;
    static JScrollPane listScroller;
    JButton OKButton;
    static JPanel panel;
    static GridBagConstraints constr;
    public static String locale_id;
    public static String UPDATE_FOUND;
    public static String WINDOW_PLAY;
    public static String WINDOW_SELECT_VERSION;
    public static String WINDOW_LANGUAGE;
    public static String WINDOW_OPTIONS;
    public static String WINDOW_TITLE;
    public static String WINDOW_DOWNLOADING;
    public static String WINDOW_USERNAME_FIELD_EMPTY;
    public static String LANG;
    public static String OPTIONS_PROXY;
    public static String OPTIONS_UPDATE_HEADER;
    public static String OPTIONS_KEEP_OPEN;
    public static String OPTIONS_RPC;
    public static String OPTIONS_LAUNCH_ARGS;
    public static String OPTIONS_OK;
    public static String OPTIONS_WIDTH;
    public static String OPTIONS_HEIGHT;
    public static String OPTIONS_TITLE;
    public static String SORT_FROM_OLDEST;
    public static String SORT_FROM_NEWEST;
    public static String VERSION_LIST_TITLE;
    public static String ADDON_LIST_TITLE;
    public static String ADDON_NO_DESC;
    public static String ADDON_SHOW_INFO;
    public static String LOGIN_TITLE;
    public static String LOGIN_BUTTON;
    public static String LOGOUT_BUTTON;
    public static String LOGIN_EMAIL_NICKNAME;
    public static String LOGIN_PASSWORD;
    public static String LOGIN_MOJANG_HEADER;
    public static String LOGIN_MICROSOFT_BUTTON;
    public static String LOGIN_MICROSOFT_TITLE;
    public static String LOGIN_MICROSOFT_ERROR;
    public static String LOGIN_MICROSOFT_PARENT;
    public static String LOGIN_MICROSOFT_NO_XBOX;
    public static String LOGIN_MICROSOFT_NO_MINECRAFT;
    public static String LOGIN_MICROSOFT_NO_JFX_TITLE;
    public static String LOGIN_MICROSOFT_NO_JFX_CONTENT;
    public static String LOGIN_FAILED;
    public static String LOGIN_FAILED_INVALID_CREDENTIALS;
    public static String INSTANCE_GAME_DIRECTORY;
    public static String INSTANCE_GAME_DIRECTORY_TITLE;
    public static String INSTANCE_REMOVE_QUESTION;
    public static String INSTANCE_REMOVE_TITLE;
    public static String INSTANCE_CHANGE_ICON_NAME;
    public static String INSTANCE_CHANGE_ICON_TITLE;
    public static String INSTANCE_CHANGE_ICON_UNSUPPORTED;
    public static String INSTANCE_CHANGE_ICON_UNSUPPORTED_TITLE;
    public static String INSTANCE_CHANGE_ICON_FAILED;
    public static String INSTANCE_CHANGE_ICON_FAILED_TITLE;
    public static String INSTANCE_NAME;
    public static String INSTANCE_SELECT_ADDONS;
    public static String INSTANCE_MODS_REPOSITORY;
    public static String SELECT_INSTANCE_TITLE;
    public static String SELECT_INSTANCE_NEW;
    public static String TAB_CHANGELOG;
    public static String TAB_INSTANCES;
    public static String TAB_SERVERS;
    public static String VERSION_CUSTOM;
    public static String BROWSER_TITLE;
    public static String TAB_SRV_LOADING;
    public static String TAB_SRV_FAILED;
    public static String TAB_CL_LOADING;
    public static String TAB_CL_FAILED;
    public static String FORCE_UPDATE;
    public static String WRAP_USER;
    public static String WRAP_VERSION;
    public static String WRAP_SERVER;
    public static String WRAP_SERVER_TITLE;
    public static String WRAP_CLASSIC_RESIZE;
    public static String UNEXPECTED_ERROR;
    public static String ERR_NO_CONNECTION;
    public static String ERR_DL_FAIL;
    public static String YES;
    public static String NO;
    public static String CANCEL;

    public Lang() {
        boolean panelnull;
        Logger.a("Language option window has been opened.");
        this.setIconImage(Window.img);
        this.setMinimumSize(new Dimension(282, 386));
        this.setTitle(LANG);
        this.setResizable(true);
        boolean bl = panelnull = panel == null;
        if (panelnull) {
            panel = new JPanel();
            panel.setLayout(new GridBagLayout());
        }
        constr = new GridBagConstraints();
        Lang.constr.gridx = 0;
        Lang.constr.fill = 1;
        Lang.constr.insets = new Insets(5, 5, 0, 5);
        Lang.constr.gridwidth = -1;
        Lang.constr.gridheight = -1;
        Lang.constr.gridy = 0;
        Lang.constr.weightx = 1.0;
        Lang.constr.weighty = 1.0;
        try {
            if (locales.isEmpty()) {
                this.initLang();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
            Logger.printException(e1);
        }
        ++Lang.constr.gridy;
        Lang.constr.weighty = -1.0;
        Lang.constr.gridheight = 1;
        Lang.constr.insets = new Insets(5, 5, 5, 5);
        if (panelnull) {
            this.OKButton = new JButton(OPTIONS_OK);
            this.OKButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Lang.this.setLang();
                    Window.lang = null;
                }
            });
            panel.add((Component)this.OKButton, constr);
        }
        this.add(panel);
        this.pack();
        this.setLocationRelativeTo(Window.mainWindow);
        this.setVisible(true);
    }

    @Override
    public void update() {
        this.setTitle(LANG);
        this.OKButton.setText(OPTIONS_OK);
    }

    public void setLang() {
        String lang = (String)list.getSelectedValue();
        if (Lang.download(lang) == DownloadResult.FAILED_WITHOUT_BACKUP) {
            return;
        }
        Util.setProperty(BC.SETTINGS, "language", lang);
        this.setVisible(false);
        Launcher.restart();
    }

    public void initLang() throws IOException {
        URL url = new URL("http://files.betacraft.uk/launcher/assets/lang/" + locale_id + "/list.txt");
        Scanner scanner = new Scanner(url.openStream(), "UTF-8");
        while (scanner.hasNextLine()) {
            String now = scanner.nextLine();
            if (now.equalsIgnoreCase("")) continue;
            locales.add(now);
        }
        scanner.close();
        int i = 0;
        int index = 0;
        listModel = new DefaultListModel();
        String lang = Util.getProperty(BC.SETTINGS, "language");
        for (String item : locales) {
            listModel.addElement(item);
            if (lang.equals(item)) {
                index = i;
            }
            ++i;
        }
        list = new JList(listModel);
        list.setSelectionMode(0);
        list.setLayoutOrientation(0);
        list.setVisibleRowCount(3);
        list.setSelectedIndex(index);
        if (listScroller != null) {
            panel.remove(listScroller);
        }
        listScroller = new JScrollPane(list);
        listScroller.setWheelScrollingEnabled(true);
        panel.add((Component)listScroller, constr);
    }

    public static void applyNamesSwing() {
        try {
            UIManager.put("OptionPane.okButtonText", OPTIONS_OK);
            UIManager.put("OptionPane.cancelButtonText", CANCEL);
            UIManager.put("OptionPane.yesButtonText", YES);
            UIManager.put("OptionPane.noButtonText", NO);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static boolean downloaded(String lang) {
        File file = new File(BC.get() + "launcher" + File.separator + "lang" + File.separator + lang + ".txt");
        return file.exists();
    }

    public static DownloadResult download(String lang) {
        DownloadResult download = Launcher.download("http://files.betacraft.uk/launcher/assets/lang/" + locale_id + "/" + lang + ".txt", new File(BC.get() + "launcher" + File.separator + "lang", lang + ".txt"));
        if (!download.isPositive()) {
            JOptionPane.showMessageDialog(Window.mainWindow, "No Internet connection", "Language file download failed!", 0);
        }
        return download;
    }

    public static void refresh(boolean download, boolean force) {
        String lang = Util.getProperty(BC.SETTINGS, "language");
        if (lang == null) {
            lang = "English";
        }
        File file = new File(BC.get() + "launcher" + File.separator + "lang" + File.separator + lang + ".txt");
        if (download && !Lang.download(lang).isPositive() || !file.exists()) {
            Lang.applyNamesSwing();
            return;
        }
        String charset = "UTF-8";
        if (lang.equalsIgnoreCase("Russian")) {
            charset = "Cp1251";
        }
        WINDOW_SELECT_VERSION = Util.getProperty(file, "version_button", charset);
        WINDOW_PLAY = Util.getProperty(file, "play_button", charset);
        WINDOW_OPTIONS = Util.getProperty(file, "options_button", charset);
        WINDOW_TITLE = Util.getProperty(file, "launcher_title", charset) + Launcher.VERSION;
        WINDOW_LANGUAGE = Util.getProperty(file, "language", charset);
        WINDOW_DOWNLOADING = Util.getProperty(file, "downloading", charset);
        WINDOW_USERNAME_FIELD_EMPTY = Util.getProperty(file, "username_field_empty", charset);
        LANG = Util.getProperty(file, "lang_title", charset);
        UNEXPECTED_ERROR = Util.getProperty(file, "unexpected_error", charset);
        ERR_NO_CONNECTION = Util.getProperty(file, "no_connection", charset);
        ERR_DL_FAIL = Util.getProperty(file, "download_fail", charset);
        OPTIONS_UPDATE_HEADER = Util.getProperty(file, "update_check", charset);
        OPTIONS_PROXY = Util.getProperty(file, "use_betacraft", charset);
        OPTIONS_RPC = Util.getProperty(file, "discord_rpc", charset);
        OPTIONS_LAUNCH_ARGS = Util.getProperty(file, "launch_arguments", charset) + ":";
        OPTIONS_KEEP_OPEN = Util.getProperty(file, "keep_launcher_open", charset);
        OPTIONS_WIDTH = Util.getProperty(file, "width", charset);
        OPTIONS_OK = Util.getProperty(file, "ok", charset);
        OPTIONS_HEIGHT = Util.getProperty(file, "height", charset);
        OPTIONS_TITLE = Util.getProperty(file, "options_title", charset);
        SORT_FROM_OLDEST = Util.getProperty(file, "sort_oldest", charset);
        SORT_FROM_NEWEST = Util.getProperty(file, "sort_newest", charset);
        VERSION_LIST_TITLE = Util.getProperty(file, "version_title", charset);
        ADDON_LIST_TITLE = Util.getProperty(file, "addon_list_title", charset);
        ADDON_NO_DESC = Util.getProperty(file, "addon_no_desc", charset);
        ADDON_SHOW_INFO = Util.getProperty(file, "addon_show_info", charset);
        LOGIN_TITLE = Util.getProperty(file, "login_title", charset);
        LOGIN_BUTTON = Util.getProperty(file, "log_in_button", charset);
        LOGOUT_BUTTON = Util.getProperty(file, "log_out_button", charset);
        LOGIN_EMAIL_NICKNAME = Util.getProperty(file, "login_email_nickname", charset);
        LOGIN_PASSWORD = Util.getProperty(file, "login_password", charset);
        LOGIN_MOJANG_HEADER = Util.getProperty(file, "login_mojang_header", charset);
        LOGIN_MICROSOFT_BUTTON = Util.getProperty(file, "login_microsoft_button", charset);
        LOGIN_MICROSOFT_TITLE = Util.getProperty(file, "login_microsoft_title", charset);
        LOGIN_MICROSOFT_ERROR = Util.getProperty(file, "login_microsoft_error", charset);
        LOGIN_MICROSOFT_PARENT = Util.getProperty(file, "login_microsoft_parent", charset);
        LOGIN_MICROSOFT_NO_XBOX = Util.getProperty(file, "login_microsoft_no_xbox", charset);
        LOGIN_MICROSOFT_NO_MINECRAFT = Util.getProperty(file, "login_microsoft_no_minecraft", charset);
        LOGIN_MICROSOFT_NO_JFX_TITLE = Util.getProperty(file, "login_microsoft_no_jfx_title", charset);
        LOGIN_MICROSOFT_NO_JFX_CONTENT = Util.getProperty(file, "login_microsoft_no_jfx_content", charset);
        LOGIN_FAILED = Util.getProperty(file, "login_failed", charset);
        LOGIN_FAILED_INVALID_CREDENTIALS = Util.getProperty(file, "login_failed_invalid_credentials", charset);
        INSTANCE_GAME_DIRECTORY = Util.getProperty(file, "instance_game_directory", charset);
        INSTANCE_GAME_DIRECTORY_TITLE = Util.getProperty(file, "instance_game_directory_title", charset);
        INSTANCE_REMOVE_QUESTION = Util.getProperty(file, "instance_remove_question", charset);
        INSTANCE_REMOVE_TITLE = Util.getProperty(file, "instance_remove_title", charset);
        INSTANCE_CHANGE_ICON_NAME = Util.getProperty(file, "instance_change_icon_name", charset);
        INSTANCE_CHANGE_ICON_TITLE = Util.getProperty(file, "instance_change_icon_title", charset);
        INSTANCE_CHANGE_ICON_UNSUPPORTED = Util.getProperty(file, "instance_change_icon_unsupported", charset);
        INSTANCE_CHANGE_ICON_UNSUPPORTED_TITLE = Util.getProperty(file, "instance_change_icon_unsupported_title", charset);
        INSTANCE_CHANGE_ICON_FAILED = Util.getProperty(file, "instance_change_icon_failed", charset);
        INSTANCE_CHANGE_ICON_FAILED_TITLE = Util.getProperty(file, "instance_change_icon_failed_title", charset);
        INSTANCE_NAME = Util.getProperty(file, "instance_name", charset);
        INSTANCE_SELECT_ADDONS = Util.getProperty(file, "instance_select_addons", charset);
        INSTANCE_MODS_REPOSITORY = Util.getProperty(file, "instance_mods_repository", charset);
        SELECT_INSTANCE_TITLE = Util.getProperty(file, "select_instance_title", charset);
        SELECT_INSTANCE_NEW = Util.getProperty(file, "select_instance_new", charset);
        UPDATE_FOUND = Util.getProperty(file, "new_version_found", charset);
        WRAP_USER = Util.getProperty(file, "nick", charset);
        WRAP_VERSION = Util.getProperty(file, "version", charset);
        WRAP_SERVER = Util.getProperty(file, "server", charset);
        WRAP_SERVER_TITLE = Util.getProperty(file, "server_title", charset);
        WRAP_CLASSIC_RESIZE = Util.getProperty(file, "classic_resize", charset);
        TAB_CHANGELOG = Util.getProperty(file, "tab_changelog", charset);
        TAB_INSTANCES = Util.getProperty(file, "tab_instances", charset);
        TAB_SERVERS = Util.getProperty(file, "tab_servers", charset);
        VERSION_CUSTOM = Util.getProperty(file, "version_custom", charset);
        BROWSER_TITLE = Util.getProperty(file, "browser_title", charset);
        TAB_SRV_LOADING = Util.getProperty(file, "srv_loading", charset);
        TAB_SRV_FAILED = Util.getProperty(file, "srv_failed", charset);
        TAB_CL_LOADING = Util.getProperty(file, "cl_loading", charset);
        TAB_CL_FAILED = Util.getProperty(file, "cl_failed", charset);
        FORCE_UPDATE = Util.getProperty(file, "force_update", charset);
        YES = Util.getProperty(file, "yes", charset);
        NO = Util.getProperty(file, "no", charset);
        CANCEL = Util.getProperty(file, "cancel", charset);
        Lang.applyNamesSwing();
        if (force) {
            Window.mainWindow.update();
            if (Window.addonsList != null) {
                Window.addonsList.update();
            }
            if (Window.modsRepo != null) {
                Window.modsRepo.update();
            }
            if (Window.lang != null) {
                Window.lang.update();
            }
            if (Window.instanceList != null) {
                Window.instanceList.update();
            }
            if (Window.instanceSettings != null) {
                Window.instanceSettings.update();
            }
            if (Window.versionsList != null) {
                Window.versionsList.update();
            }
            if (Window.loginPanel != null) {
                Window.loginPanel.update();
            }
        }
    }

    static {
        locale_id = "1.09_15";
        UPDATE_FOUND = "There is a new version of the launcher available (%s). Would you like to update?";
        WINDOW_PLAY = "Play";
        WINDOW_SELECT_VERSION = "Select version";
        WINDOW_LANGUAGE = "Language";
        WINDOW_OPTIONS = "Edit instance";
        WINDOW_TITLE = "BetaCraft Launcher JE v" + Launcher.VERSION;
        WINDOW_DOWNLOADING = "Downloading ...";
        WINDOW_USERNAME_FIELD_EMPTY = "The username field is empty!";
        LANG = "Select language";
        OPTIONS_PROXY = "Use skin & sound proxy";
        OPTIONS_UPDATE_HEADER = "Update check";
        OPTIONS_KEEP_OPEN = "Keep the launcher open";
        OPTIONS_RPC = "Discord RPC";
        OPTIONS_LAUNCH_ARGS = "Launch arguments:";
        OPTIONS_OK = "OK";
        OPTIONS_WIDTH = "width:";
        OPTIONS_HEIGHT = "height:";
        OPTIONS_TITLE = "Instance settings";
        SORT_FROM_OLDEST = "Sort: from oldest";
        SORT_FROM_NEWEST = "Sort: from newest";
        VERSION_LIST_TITLE = "Versions list";
        ADDON_LIST_TITLE = "Addons list";
        ADDON_NO_DESC = "No description.";
        ADDON_SHOW_INFO = "Show info";
        LOGIN_TITLE = "Log in";
        LOGIN_BUTTON = "Log in";
        LOGOUT_BUTTON = "Log out";
        LOGIN_EMAIL_NICKNAME = "E-mail:";
        LOGIN_PASSWORD = "Password:";
        LOGIN_MOJANG_HEADER = "... or login with a Mojang account:";
        LOGIN_MICROSOFT_BUTTON = "Login with Microsoft";
        LOGIN_MICROSOFT_TITLE = "Login with your Microsoft account";
        LOGIN_MICROSOFT_ERROR = "Microsoft authentication error";
        LOGIN_MICROSOFT_PARENT = "Parental approval required. Add this account to Family to login.";
        LOGIN_MICROSOFT_NO_XBOX = "No Xbox account registered";
        LOGIN_MICROSOFT_NO_MINECRAFT = "You don't own Minecraft on this account.";
        LOGIN_MICROSOFT_NO_JFX_TITLE = "No JFX detected.";
        LOGIN_MICROSOFT_NO_JFX_CONTENT = "You need to additionally install JavaFX in order to login with Microsoft.\nIt's recommended to install JRE 8 from: https://java.com";
        LOGIN_FAILED = "Failed to complete the login process";
        LOGIN_FAILED_INVALID_CREDENTIALS = "Invalid e-mail or password.";
        INSTANCE_GAME_DIRECTORY = "Game directory";
        INSTANCE_GAME_DIRECTORY_TITLE = "Choose a directory for the instance";
        INSTANCE_REMOVE_QUESTION = "Are you sure you want to remove this instance?";
        INSTANCE_REMOVE_TITLE = "Remove instance";
        INSTANCE_CHANGE_ICON_NAME = "Change icon";
        INSTANCE_CHANGE_ICON_TITLE = "Choose a new icon for the instance";
        INSTANCE_CHANGE_ICON_UNSUPPORTED = "Your icon file format is not supported. Currently supported formats: %s";
        INSTANCE_CHANGE_ICON_UNSUPPORTED_TITLE = "Unsupported image format";
        INSTANCE_CHANGE_ICON_FAILED = "Something went wrong: %s";
        INSTANCE_CHANGE_ICON_FAILED_TITLE = "Failed to save icon";
        INSTANCE_NAME = "Name:";
        INSTANCE_SELECT_ADDONS = "Select addons";
        INSTANCE_MODS_REPOSITORY = "Mods repository";
        SELECT_INSTANCE_TITLE = "Select instance";
        SELECT_INSTANCE_NEW = "New instance";
        TAB_CHANGELOG = "Changelog";
        TAB_INSTANCES = "Instances";
        TAB_SERVERS = "Servers";
        VERSION_CUSTOM = " [Custom]";
        BROWSER_TITLE = "Webpage viewer";
        TAB_SRV_LOADING = "Loading servers list...";
        TAB_SRV_FAILED = "Failed to list classic servers!";
        TAB_CL_LOADING = "Loading update news...";
        TAB_CL_FAILED = "Failed to load update news!";
        FORCE_UPDATE = "Force update";
        WRAP_USER = "User: %s";
        WRAP_VERSION = "Version: %s";
        WRAP_SERVER = "Server IP (leave blank if you don't want to play online):";
        WRAP_SERVER_TITLE = "Server IP";
        WRAP_CLASSIC_RESIZE = "<html><font size=5>Resize the window to the size you want to play on.<br />Click anywhere inside this window to start the game.</font></html>";
        UNEXPECTED_ERROR = "Unexpected error: %s";
        ERR_NO_CONNECTION = "No stable internet connection.";
        ERR_DL_FAIL = "Download failed.";
        YES = "Yes";
        NO = "No";
        CANCEL = "Cancel";
    }
}

