/*
 * Decompiled with CFR 0.152.
 */
package org.betacraft.launcher;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.betacraft.launcher.Launcher;
import org.betacraft.launcher.Logger;
import org.betacraft.launcher.WebsitePanel;
import org.betacraft.launcher.Window;

public class InfoPanel
extends JPanel {
    static Image aroundBackground = null;
    static Image renderHelper;

    public InfoPanel(boolean isConnection) {
        this.setLayout(new GridLayout(2, 1));
        this.setMinimumSize(new Dimension(800, 550));
        try {
            aroundBackground = ImageIO.read(Launcher.class.getResource("/icons/stone.png")).getScaledInstance(32, 32, 64);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            Logger.printException(e2);
            return;
        }
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.fill = 11;
        constr.insets = new Insets(0, 0, 0, 0);
        constr.gridwidth = -1;
        constr.gridy = 0;
        constr.weightx = 1.0;
        constr.gridheight = 1;
        JButton button = new JButton("bruh");
        this.add((Component)button, constr);
        constr.gridy = 1;
        constr.gridheight = -1;
        if (Window.tab == Window.Tab.CHANGELOG) {
            this.add((Component)new WebsitePanel().getUpdateNews(isConnection), constr);
        }
        if (Window.tab == Window.Tab.SERVER_LIST) {
            this.add(new WebsitePanel().getServers(isConnection));
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth() / 2;
        int h = this.getHeight() / 2;
        if (w <= 0 || h <= 0) {
            return;
        }
        if (renderHelper == null) {
            renderHelper = this.createImage(w, h);
        }
        Graphics g3 = renderHelper.getGraphics();
        for (int x = 0; x <= w / 32; ++x) {
            for (int y = 0; y <= h / 32; ++y) {
                g3.drawImage(aroundBackground, x * 32, y * 32, null);
            }
        }
        g3.dispose();
        g.drawImage(renderHelper, 0, 0, w * 2, h * 2, null);
    }
}

