/*
 * Decompiled with CFR 0.152.
 */
package pl.betacraft.auth;

import java.awt.Component;
import java.awt.Dimension;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JFrame;
import org.betacraft.launcher.Lang;
import org.betacraft.launcher.LoginPanel;
import org.betacraft.launcher.Window;
import pl.betacraft.auth.MicrosoftAuth;

public class MSPrompt
extends JFrame {
    private MicrosoftAuth auth;
    WebView browser;
    WebEngine webEngine;

    public MSPrompt(MicrosoftAuth auth) {
        System.out.println("Opening Microsoft auth prompt");
        this.setAuth(auth);
        this.setIconImage(Window.img);
        this.setTitle(Lang.LOGIN_MICROSOFT_TITLE);
        this.setResizable(true);
        this.setMinimumSize(new Dimension(640, 480));
        JFXPanel jfxPanel = new JFXPanel();
        this.add((Component)jfxPanel);
        Platform.runLater(() -> {
            this.browser = new WebView();
            this.webEngine = this.browser.getEngine();
            jfxPanel.setScene(new Scene((Parent)this.browser));
            this.webEngine.setJavaScriptEnabled(true);
            this.webEngine.locationProperty().addListener((obs, oldLocation, newLocation) -> {
                if (newLocation != null && newLocation.startsWith("http://localhost:11799/msaresponse")) {
                    this.auth.code = newLocation.substring(newLocation.indexOf("=") + 1, newLocation.indexOf("&"));
                    this.setVisible(false);
                    LoginPanel.continueMSA(this.auth);
                }
            });
            this.webEngine.load("https://login.live.com/oauth20_authorize.srf?client_id=8075fa74-4091-4356-a0b8-a7c118ef121c&response_type=code&scope=service::user.auth.xboxlive.com::MBI_SSL&prompt=select_account&redirect_uri=http://localhost:11799/msaresponse");
        });
        this.setLocationRelativeTo(Window.mainWindow);
        this.setVisible(true);
    }

    public void setAuth(MicrosoftAuth auth) {
        this.auth = auth;
    }

    public void reShow() {
        this.webEngine.reload();
        this.setVisible(true);
    }
}

