/*
 * Decompiled with CFR 0.152.
 */
package org.betacraft.launcher;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.betacraft.launcher.Lang;
import org.betacraft.launcher.LanguageElement;
import org.betacraft.launcher.Launcher;
import org.betacraft.launcher.Logger;
import org.betacraft.launcher.Release;
import org.betacraft.launcher.VersionSorter;
import org.betacraft.launcher.Window;

public class SelectVersion
extends JFrame
implements ActionListener,
LanguageElement {
    static JList list;
    static DefaultListModel listModel;
    public static JScrollPane listScroller;
    static JButton sort_button;
    static JButton OK;
    static VersionSorter.Order order;
    static JPanel panel;
    static GridBagConstraints constr;

    public SelectVersion() {
        Logger.a("Version list window has been opened.");
        this.setIconImage(Window.img);
        this.setMinimumSize(new Dimension(282, 386));
        this.setTitle(Lang.VERSION_LIST_TITLE);
        this.setResizable(true);
        panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        constr = new GridBagConstraints();
        SelectVersion.constr.fill = 1;
        SelectVersion.constr.insets = new Insets(5, 5, 0, 5);
        SelectVersion.constr.gridwidth = -1;
        SelectVersion.constr.weightx = 1.0;
        String name = order == VersionSorter.Order.FROM_OLDEST ? Lang.SORT_FROM_OLDEST : Lang.SORT_FROM_NEWEST;
        sort_button = new JButton(name);
        sort_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (order == VersionSorter.Order.FROM_OLDEST) {
                    order = VersionSorter.Order.FROM_NEWEST;
                    sort_button.setText(Lang.SORT_FROM_NEWEST);
                } else {
                    order = VersionSorter.Order.FROM_OLDEST;
                    sort_button.setText(Lang.SORT_FROM_OLDEST);
                }
                SelectVersion.this.updateList();
            }
        });
        panel.add((Component)sort_button, constr);
        this.updateList();
        SelectVersion.constr.gridy = 2;
        SelectVersion.constr.weighty = -1.0;
        SelectVersion.constr.gridheight = 1;
        SelectVersion.constr.insets = new Insets(0, 5, 5, 5);
        OK = new JButton(Lang.OPTIONS_OK);
        OK.addActionListener(this);
        panel.add((Component)OK, constr);
        this.getContentPane().add((Component)panel, "Center");
        this.pack();
        this.setLocationRelativeTo(Window.mainWindow);
        this.setVisible(true);
    }

    @Override
    public void update() {
        this.setTitle(Lang.VERSION_LIST_TITLE);
        String name = order == VersionSorter.Order.FROM_OLDEST ? Lang.SORT_FROM_OLDEST : Lang.SORT_FROM_NEWEST;
        sort_button.setText(name);
        OK.setText(Lang.OPTIONS_OK);
        this.pack();
    }

    protected void updateList() {
        int i = 0;
        int index = 0;
        listModel = null;
        listModel = new DefaultListModel();
        for (Release item : VersionSorter.sort(order)) {
            listModel.addElement(item);
            if (Launcher.currentInstance.version.equalsIgnoreCase(item.getName())) {
                index = i;
            }
            ++i;
        }
        SelectVersion.constr.weighty = 1.0;
        SelectVersion.constr.gridheight = -1;
        SelectVersion.constr.gridy = 1;
        list = new JList(listModel);
        list.setSelectionMode(0);
        list.setLayoutOrientation(0);
        list.setVisibleRowCount(3);
        list.setSelectedIndex(index);
        if (listScroller != null) {
            panel.remove(listScroller);
        }
        listScroller = new JScrollPane(list);
        listScroller.setWheelScrollingEnabled(true);
        listScroller.requestFocus();
        panel.add((Component)listScroller, constr);
    }

    public void saveVersion() {
        Release ver = (Release)list.getSelectedValue();
        if (ver != null) {
            Launcher.currentInstance.version = ver.getName();
            Launcher.setInstance(Launcher.currentInstance);
            Launcher.currentInstance.saveInstance();
        }
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == OK) {
            this.saveVersion();
            Window.versionsList = null;
        }
    }

    static {
        order = VersionSorter.Order.FROM_OLDEST;
    }
}

