/*
 * Decompiled with CFR 0.152.
 */
package org.betacraft.launcher;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.betacraft.launcher.BrowserWindow;
import org.betacraft.launcher.Lang;
import org.betacraft.launcher.LanguageElement;
import org.betacraft.launcher.Launcher;
import org.betacraft.launcher.Logger;
import org.betacraft.launcher.Release;
import org.betacraft.launcher.ReleaseJson;
import org.betacraft.launcher.WebsitePanel;
import org.betacraft.launcher.Window;

public class ModsRepository
extends JFrame
implements ActionListener,
LanguageElement {
    public static ArrayList<String> mods = new ArrayList();
    static JList list;
    static DefaultListModel listModel;
    static JScrollPane listScroller;
    static JButton more_button;
    static JButton OK;
    static JPanel panel;
    static GridBagConstraints constr;

    public static void loadMods() {
        try {
            URL url = new URL("http://files.betacraft.uk/launcher/assets/mods/1.09_10/list.txt");
            InputStream onlineListStream = null;
            try {
                onlineListStream = url.openStream();
            }
            catch (UnknownHostException ex) {
                Logger.a(null);
            }
            catch (SocketTimeoutException ex) {
                Logger.a(null);
            }
            catch (SocketException ex) {
                Logger.a(null);
            }
            catch (Exception ex) {
                Logger.a("A critical error has occurred while attempting to get the online addons list!");
                ex.printStackTrace();
                Logger.printException(ex);
            }
            if (onlineListStream == null) {
                return;
            }
            Scanner onlineListScanner = new Scanner(onlineListStream, "UTF-8");
            for (String ver : ModsRepository.scan(onlineListScanner)) {
                mods.add(ver);
            }
            onlineListScanner.close();
            onlineListStream.close();
        }
        catch (Exception ex) {
            Logger.a("A critical error occurred while initializing addons list!");
            ex.printStackTrace();
            Logger.printException(ex);
        }
    }

    protected static List<String> scan(Scanner scanner) {
        ArrayList<String> results = new ArrayList<String>();
        String currentLine = null;
        while (scanner.hasNextLine()) {
            currentLine = scanner.nextLine();
            if (currentLine.equalsIgnoreCase("")) continue;
            results.add(currentLine);
        }
        return results;
    }

    public ModsRepository() {
        Logger.a("Mods repository window has been opened.");
        this.setIconImage(Window.img);
        this.setMinimumSize(new Dimension(282, 386));
        this.setTitle(Lang.INSTANCE_MODS_REPOSITORY);
        this.setResizable(true);
        panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        constr = new GridBagConstraints();
        ModsRepository.constr.fill = 1;
        ModsRepository.constr.insets = new Insets(5, 5, 0, 5);
        ModsRepository.constr.gridwidth = -1;
        ModsRepository.constr.weightx = 1.0;
        more_button = new JButton(Lang.ADDON_SHOW_INFO);
        more_button.addActionListener(this);
        panel.add((Component)more_button, constr);
        this.add((Component)panel, "North");
        panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        ModsRepository.constr.gridy = 2;
        ModsRepository.constr.weighty = -1.0;
        ModsRepository.constr.gridheight = 1;
        ModsRepository.constr.insets = new Insets(0, 5, 5, 5);
        OK = new JButton(Lang.OPTIONS_OK);
        OK.addActionListener(this);
        panel.add((Component)OK, constr);
        this.add((Component)panel, "South");
        panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.updateList();
        this.getContentPane().add((Component)panel, "Center");
        this.pack();
        this.setLocationRelativeTo(Window.mainWindow);
        this.setVisible(true);
    }

    @Override
    public void update() {
        this.setTitle(Lang.INSTANCE_MODS_REPOSITORY);
        OK.setText(Lang.OPTIONS_OK);
        this.pack();
    }

    protected void updateList() {
        listModel = null;
        listModel = new DefaultListModel();
        for (String s : mods) {
            listModel.addElement(s);
        }
        ModsRepository.constr.weighty = 1.0;
        ModsRepository.constr.gridheight = -1;
        ModsRepository.constr.gridy = 1;
        list = new JList(listModel);
        list.setSelectionMode(2);
        list.setLayoutOrientation(0);
        list.setVisibleRowCount(3);
        if (listScroller != null) {
            panel.remove(listScroller);
        }
        listScroller = new JScrollPane(list);
        listScroller.setWheelScrollingEnabled(true);
        panel.add((Component)listScroller, constr);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String mod = (String)list.getSelectedValue();
            }
        });
    }

    public void saveVersions() {
        if (list.getSelectedValuesList().size() != 0) {
            for (Object o : list.getSelectedValuesList()) {
                String s = (String)o;
                new ReleaseJson(s).downloadJson();
            }
            try {
                Release.loadVersions(Release.VersionRepository.BETACRAFT);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Logger.printException(ex);
            }
            if (list.getSelectedValuesList().size() == 1) {
                Launcher.currentInstance.version = (String)list.getSelectedValuesList().get(0);
                Launcher.setInstance(Launcher.currentInstance);
                Launcher.currentInstance.saveInstance();
            }
        }
        this.setVisible(false);
    }

    public JScrollPane getInfo(String name) {
        JEditorPane pane = new JEditorPane();
        pane.setEditable(false);
        pane.setOpaque(false);
        pane.setContentType("text/html;charset=UTF-8");
        pane.addHyperlinkListener(WebsitePanel.EXTERNAL_HYPERLINK_LISTENER);
        try {
            pane.setPage(new URL("http://files.betacraft.uk/launcher/assets/mods/" + name + ".html"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Logger.printException(ex);
            pane.setText(Lang.ADDON_NO_DESC);
        }
        JScrollPane scrlPane = new JScrollPane(pane);
        scrlPane.setBorder(null);
        scrlPane.setWheelScrollingEnabled(true);
        return scrlPane;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == OK) {
            this.saveVersions();
            Window.modsRepo = null;
        } else if (e.getSource() == more_button) {
            for (Object l : list.getSelectedValuesList()) {
                String mod = (String)l;
                new BrowserWindow(this.getInfo(mod));
            }
        }
    }
}

