/*
 * Decompiled with CFR 0.152.
 */
package org.betacraft.launcher;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.betacraft.launcher.InstanceSettings;
import org.betacraft.launcher.Lang;
import org.betacraft.launcher.LanguageElement;
import org.betacraft.launcher.Launcher;
import org.betacraft.launcher.Logger;
import org.betacraft.launcher.Util;
import org.betacraft.launcher.Window;
import pl.betacraft.auth.MicrosoftAuth;
import pl.betacraft.auth.MojangAuth;

public class LoginPanel
extends JFrame
implements LanguageElement {
    static JLabel emailText;
    static JTextField email;
    static JLabel passwordText;
    static JTextField password;
    static JButton OKButton;

    public LoginPanel() {
        Logger.a("Auth window has been opened.");
        this.setIconImage(Window.img);
        this.setTitle(Lang.LOGIN_TITLE);
        this.setResizable(true);
        this.setMinimumSize(new Dimension(400, 200));
        InstanceSettings.OptionsPanel panel = new InstanceSettings.OptionsPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 0;
        constr.fill = 1;
        constr.gridwidth = 1;
        constr.weightx = 1.0;
        constr.insets = new Insets(10, 10, 0, 10);
        constr.gridwidth = 3;
        JButton microsoftbrowser = new JButton(Lang.LOGIN_MICROSOFT_BUTTON);
        microsoftbrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Util.openURL(new URL("https://login.live.com/oauth20_authorize.srf?client_id=8075fa74-4091-4356-a0b8-a7c118ef121c&response_type=code&scope=XboxLive.signin%20offline_access&prompt=select_account&redirect_uri=http://localhost:11799/msaresponse").toURI());
                    LoginPanel.this.setVisible(false);
                    Window.loginPanel = null;
                    Window.mainWindow.waitForInput();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
        panel.add((Component)microsoftbrowser, constr);
        ++constr.gridy;
        constr.fill = 2;
        constr.gridwidth = 3;
        constr.gridx = 0;
        constr.weightx = 0.0;
        JLabel mojangauth = new JLabel(Lang.LOGIN_MOJANG_HEADER);
        mojangauth.setForeground(Color.LIGHT_GRAY);
        panel.add((Component)mojangauth, constr);
        ++constr.gridy;
        emailText = new JLabel(Lang.LOGIN_EMAIL_NICKNAME);
        emailText.setForeground(Color.LIGHT_GRAY);
        panel.add((Component)emailText, constr);
        constr.gridx = 1;
        constr.gridwidth = 3;
        email = new JTextField("", 6);
        panel.add((Component)email, constr);
        constr.gridx = 0;
        ++constr.gridy;
        constr.gridwidth = 1;
        passwordText = new JLabel(Lang.LOGIN_PASSWORD);
        passwordText.setForeground(Color.LIGHT_GRAY);
        panel.add((Component)passwordText, constr);
        constr.gridx = 1;
        constr.gridwidth = 3;
        password = new JPasswordField("", 6);
        panel.add((Component)password, constr);
        InstanceSettings.OptionsPanel okPanel = new InstanceSettings.OptionsPanel();
        okPanel.setLayout(new GridBagLayout());
        constr.fill = 2;
        constr.gridx = 0;
        ++constr.gridy;
        constr.weighty = 1.0;
        constr.insets = new Insets(2, 2, 2, 2);
        constr.gridwidth = -1;
        constr.gridheight = 1;
        constr.weightx = 1.0;
        OKButton = new JButton(Lang.OPTIONS_OK);
        OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MojangAuth auth = new MojangAuth(email.getText(), password.getText());
                if (auth.authenticate()) {
                    Launcher.accounts.setCurrent(auth.getCredentials());
                    Launcher.auth = auth;
                }
                Util.saveAccounts();
                LoginPanel.this.setVisible(false);
                Window.loginPanel = null;
            }
        });
        okPanel.add((Component)OKButton, constr);
        okPanel.setBackground(Color.WHITE);
        this.getContentPane().add((Component)panel, "Center");
        this.getContentPane().add((Component)okPanel, "Last");
        this.pack();
        this.setLocationRelativeTo(Window.mainWindow);
        this.setVisible(true);
        email.requestFocus();
    }

    public static void continueMSA(MicrosoftAuth auth) {
        if (auth.authenticate()) {
            Util.saveAccounts();
        } else {
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(Window.mainWindow, Lang.LOGIN_FAILED, Lang.LOGIN_MICROSOFT_ERROR, 0));
        }
        Window.mainWindow.input();
    }

    @Override
    public void update() {
        this.setTitle(Lang.LOGIN_TITLE);
        emailText.setText(Lang.LOGIN_EMAIL_NICKNAME);
        passwordText.setText(Lang.LOGIN_PASSWORD);
        OKButton.setText(Lang.OPTIONS_OK);
        this.pack();
    }
}

