/*
 * Decompiled with CFR 0.152.
 */
package org.betacraft.launcher;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.betacraft.launcher.Instance;
import org.betacraft.launcher.Lang;
import org.betacraft.launcher.LanguageElement;
import org.betacraft.launcher.Launcher;
import org.betacraft.launcher.Logger;
import org.betacraft.launcher.Window;

public class InstanceList
extends JFrame
implements LanguageElement {
    static JList list;
    static DefaultListModel listModel;
    static JScrollPane listScroller;
    static JButton newButton;
    static JButton OKButton;
    static JPanel panel;
    static GridBagConstraints constr;

    public InstanceList() {
        Logger.a("Instances list window has been opened.");
        this.setIconImage(Window.img);
        this.setMinimumSize(new Dimension(282, 386));
        this.setTitle(Lang.SELECT_INSTANCE_TITLE);
        this.setResizable(true);
        panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        constr = new GridBagConstraints();
        InstanceList.constr.fill = 1;
        InstanceList.constr.insets = new Insets(5, 5, 0, 5);
        InstanceList.constr.gridwidth = -1;
        InstanceList.constr.weightx = 1.0;
        newButton = new JButton(Lang.SELECT_INSTANCE_NEW);
        newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newName = JOptionPane.showInputDialog(InstanceList.this, Lang.INSTANCE_NAME, Lang.SELECT_INSTANCE_NEW, -1);
                if (newName != null && !newName.equals("")) {
                    Instance.newInstance(newName).saveInstance();
                }
                InstanceList.this.makeList();
                InstanceList.this.pack();
            }
        });
        panel.add((Component)newButton, constr);
        this.makeList();
        ++InstanceList.constr.gridy;
        InstanceList.constr.weighty = -1.0;
        InstanceList.constr.gridheight = 1;
        InstanceList.constr.insets = new Insets(5, 5, 5, 5);
        OKButton = new JButton(Lang.OPTIONS_OK);
        OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Launcher.setInstance(Instance.loadInstance((String)list.getSelectedValue()));
                InstanceList.this.setVisible(false);
                Window.instanceList = null;
            }
        });
        panel.add((Component)OKButton, constr);
        this.add(panel);
        this.pack();
        this.setLocationRelativeTo(Window.mainWindow);
        this.setVisible(true);
    }

    @Override
    public void update() {
        this.setTitle(Lang.SELECT_INSTANCE_TITLE);
        OKButton.setText(Lang.OPTIONS_OK);
        this.pack();
    }

    public void makeList() {
        int i = 0;
        int index = 0;
        listModel = new DefaultListModel();
        String current = Launcher.currentInstance.name;
        for (String item : Instance.getInstances()) {
            listModel.addElement(item);
            if (current.equals(item)) {
                index = i;
            }
            ++i;
        }
        InstanceList.constr.weighty = 1.0;
        InstanceList.constr.gridheight = -1;
        InstanceList.constr.gridy = 1;
        list = new JList(listModel);
        list.setSelectionMode(0);
        list.setLayoutOrientation(0);
        list.setVisibleRowCount(3);
        list.setSelectedIndex(index);
        if (listScroller != null) {
            panel.remove(listScroller);
        }
        listScroller = new JScrollPane(list);
        listScroller.setWheelScrollingEnabled(true);
        panel.add((Component)listScroller, constr);
    }
}

