/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.level.stronghold;

import java.util.List;
import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.level.EnumDoor;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.stronghold.ComponentStronghold;
import net.minecraft.src.game.level.stronghold.ComponentStrongholdCrossing;
import net.minecraft.src.game.level.stronghold.ComponentStrongholdStairs2;
import net.minecraft.src.game.level.structure.StructureBoundingBox;
import net.minecraft.src.game.level.structure.StructureComponent;
import net.minecraft.src.game.level.structure.StructureStrongholdPieces;

public class ComponentStrongholdStairs
extends ComponentStronghold {
    private final boolean field_35036_a;
    private final EnumDoor doorType;

    public ComponentStrongholdStairs(int i, Random random, int j, int k) {
        super(i);
        this.field_35036_a = true;
        this.coordBaseMode = random.nextInt(4);
        this.doorType = EnumDoor.OPENING;
        switch (this.coordBaseMode) {
            case 0: 
            case 2: {
                this.boundingBox = new StructureBoundingBox(j, 64, k, j + 5 - 1, 74, k + 5 - 1);
                break;
            }
            default: {
                this.boundingBox = new StructureBoundingBox(j, 64, k, j + 5 - 1, 74, k + 5 - 1);
            }
        }
    }

    public ComponentStrongholdStairs(int i, Random random, StructureBoundingBox structureboundingbox, int j) {
        super(i);
        this.field_35036_a = false;
        this.coordBaseMode = j;
        this.doorType = this.getRandomDoor(random);
        this.boundingBox = structureboundingbox;
    }

    @Override
    public void buildComponent(StructureComponent structurecomponent, List list, Random random) {
        if (this.field_35036_a) {
            StructureStrongholdPieces.func_40751_a(ComponentStrongholdCrossing.class);
        }
        this.func_35028_a((ComponentStrongholdStairs2)structurecomponent, list, random, 1, 1);
    }

    public static ComponentStrongholdStairs getStrongholdStairsComponent(List list, Random random, int i, int j, int k, int l, int i1) {
        StructureBoundingBox structureboundingbox = StructureBoundingBox.getComponentToAddBoundingBox(i, j, k, -1, -7, 0, 5, 11, 5, l);
        if (!ComponentStrongholdStairs.canStrongholdGoDeeper(structureboundingbox) || StructureComponent.getIntersectingStructureComponent(list, structureboundingbox) != null) {
            return null;
        }
        return new ComponentStrongholdStairs(i1, random, structureboundingbox, l);
    }

    @Override
    public boolean addComponentParts(World world, Random random, StructureBoundingBox structureboundingbox) {
        if (this.isLiquidInStructureBoundingBox(world, structureboundingbox)) {
            return false;
        }
        if (!this.field_35036_a) {
            // empty if block
        }
        this.fillWithRandomizedBlocks(world, structureboundingbox, 0, 0, 0, 4, 10, 4, true, random, StructureStrongholdPieces.getStrongholdStones());
        this.placeDoor(world, random, structureboundingbox, this.doorType, 1, 7, 0);
        this.placeDoor(world, random, structureboundingbox, EnumDoor.OPENING, 1, 1, 4);
        this.placeBlockAtCurrentPosition(world, Block.stoneBrick.blockID, 0, 2, 6, 1, structureboundingbox);
        this.placeBlockAtCurrentPosition(world, Block.stoneBrick.blockID, 0, 1, 5, 1, structureboundingbox);
        this.placeBlockAtCurrentPosition(world, Block.slabSingleRock.blockID, 0, 1, 6, 1, structureboundingbox);
        this.placeBlockAtCurrentPosition(world, Block.stoneBrick.blockID, 0, 1, 5, 2, structureboundingbox);
        this.placeBlockAtCurrentPosition(world, Block.stoneBrick.blockID, 0, 1, 4, 3, structureboundingbox);
        this.placeBlockAtCurrentPosition(world, Block.slabSingleRock.blockID, 0, 1, 5, 3, structureboundingbox);
        this.placeBlockAtCurrentPosition(world, Block.stoneBrick.blockID, 0, 2, 4, 3, structureboundingbox);
        this.placeBlockAtCurrentPosition(world, Block.stoneBrick.blockID, 0, 3, 3, 3, structureboundingbox);
        this.placeBlockAtCurrentPosition(world, Block.slabSingleRock.blockID, 0, 3, 4, 3, structureboundingbox);
        this.placeBlockAtCurrentPosition(world, Block.stoneBrick.blockID, 0, 3, 3, 2, structureboundingbox);
        this.placeBlockAtCurrentPosition(world, Block.stoneBrick.blockID, 0, 3, 2, 1, structureboundingbox);
        this.placeBlockAtCurrentPosition(world, Block.slabSingleRock.blockID, 0, 3, 3, 1, structureboundingbox);
        this.placeBlockAtCurrentPosition(world, Block.stoneBrick.blockID, 0, 2, 2, 1, structureboundingbox);
        this.placeBlockAtCurrentPosition(world, Block.stoneBrick.blockID, 0, 1, 1, 1, structureboundingbox);
        this.placeBlockAtCurrentPosition(world, Block.slabSingleRock.blockID, 0, 1, 2, 1, structureboundingbox);
        this.placeBlockAtCurrentPosition(world, Block.stoneBrick.blockID, 0, 1, 1, 2, structureboundingbox);
        this.placeBlockAtCurrentPosition(world, Block.slabSingleRock.blockID, 0, 1, 1, 3, structureboundingbox);
        return true;
    }
}

