/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.level.map;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.chunk.ChunkCoordIntPair;
import net.minecraft.src.game.level.chunk.ChunkPosition;
import net.minecraft.src.game.level.chunk.IChunkProvider;
import net.minecraft.src.game.level.map.MapGenBase;
import net.minecraft.src.game.level.structure.StructureBoundingBox;
import net.minecraft.src.game.level.structure.StructureComponent;
import net.minecraft.src.game.level.structure.StructureStart;

public abstract class MapGenStructure
extends MapGenBase {
    protected HashMap coordMap = new HashMap();

    @Override
    public void generate(IChunkProvider ichunkprovider, World world, int i, int j, byte[] abyte0) {
        super.generate(ichunkprovider, world, i, j, abyte0);
    }

    @Override
    protected void recursiveGenerate(World world, int i, int j, int k, int l, byte[] abyte0) {
        if (this.coordMap.containsKey(ChunkCoordIntPair.chunkXZ2Int(i, j))) {
            return;
        }
        this.rand.nextInt();
        if (this.canSpawnStructureAtCoords(i, j)) {
            StructureStart structurestart = this.getStructureStart(i, j);
            this.coordMap.put(Long.valueOf(ChunkCoordIntPair.chunkXZ2Int(i, j)), structurestart);
        }
    }

    public boolean generateStructuresInChunk(World world, Random random, int i, int j) {
        int k = (i << 4) + 8;
        int l = (j << 4) + 8;
        boolean flag = false;
        for (StructureStart structurestart : this.coordMap.values()) {
            if (!structurestart.isSizeableStructure() || !structurestart.getBoundingBox().isInsideStructureBB(k, l, k + 15, l + 15)) continue;
            structurestart.generateStructure(world, random, new StructureBoundingBox(k, l, k + 15, l + 15));
            flag = true;
        }
        return flag;
    }

    public boolean func_40483_a(int i, int j, int k) {
        block2: {
            for (StructureStart structurestart : this.coordMap.values()) {
                if (!structurestart.isSizeableStructure() || !structurestart.getBoundingBox().isInsideStructureBB(i, k, i, k)) continue;
                for (StructureComponent structurecomponent : structurestart.func_40560_b()) {
                    if (!structurecomponent.getBoundingBox().isVecInside(i, j, k)) continue;
                    break block2;
                }
            }
            return false;
        }
        return true;
    }

    public ChunkPosition func_40484_a(World world, int i, int j, int k) {
        World worldObj = world;
        this.rand.setSeed(world.getWorldSeed());
        long l = this.rand.nextLong();
        long l1 = this.rand.nextLong();
        long l2 = (long)(i >> 4) * l;
        long l3 = (long)(k >> 4) * l1;
        this.rand.setSeed(l2 ^ l3 ^ world.getWorldSeed());
        this.recursiveGenerate(world, i >> 4, k >> 4, 0, 0, null);
        double d = Double.MAX_VALUE;
        ChunkPosition chunkposition = null;
        for (StructureStart structurestart : this.coordMap.values()) {
            if (!structurestart.isSizeableStructure()) continue;
            StructureComponent structurecomponent = (StructureComponent)structurestart.func_40560_b().get(0);
            ChunkPosition chunkposition2 = structurecomponent.func_40008_a_();
            int i1 = chunkposition2.x - i;
            int k1 = chunkposition2.y - j;
            int j2 = chunkposition2.z - k;
            double d1 = i1 + i1 * k1 * k1 + j2 * j2;
            if (!(d1 < d)) continue;
            d = d1;
            chunkposition = chunkposition2;
        }
        if (chunkposition != null) {
            return chunkposition;
        }
        List obj = this.func_40482_a();
        if (obj != null) {
            ChunkPosition chunkposition1 = null;
            for (ChunkPosition chunkposition3 : (List)obj) {
                int j1 = chunkposition3.x - i;
                int i2 = chunkposition3.y - j;
                int k2 = chunkposition3.z - k;
                double d2 = j1 + j1 * i2 * i2 + k2 * k2;
                if (!(d2 < d)) continue;
                d = d2;
                chunkposition1 = chunkposition3;
            }
            return chunkposition1;
        }
        return null;
    }

    protected List func_40482_a() {
        return null;
    }

    protected abstract boolean canSpawnStructureAtCoords(int var1, int var2);

    protected abstract StructureStart getStructureStart(int var1, int var2);
}

