/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.level.features;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockGrass;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.WorldGenerator;
import net.minecraft.src.game.level.features.WorldGenSwampGrass;

public class WorldGenTreeShapeSwampNoWater
extends WorldGenerator {
    protected int leavesID;
    protected int logID;
    protected int heightMod;
    protected Random treeRand = new Random();

    public WorldGenTreeShapeSwampNoWater(int leavesID, int logID, int heightMod) {
        this.leavesID = leavesID;
        this.logID = logID;
        this.heightMod = heightMod;
    }

    @Override
    public boolean generate(World world, Random random, int i, int j, int k) {
        int trunkLength = random.nextInt(4) + this.heightMod;
        boolean flag = true;
        if (j >= 1 && j + trunkLength + 1 <= 127) {
            int i3;
            int j2;
            int k1;
            int sinkToFloor = j;
            while (sinkToFloor <= j + 1 + trunkLength) {
                int byte0 = 1;
                if (sinkToFloor == j) {
                    byte0 = 0;
                }
                if (sinkToFloor >= j + 1 + trunkLength - 2) {
                    byte0 = 2;
                }
                k1 = i - byte0;
                while (k1 <= i + byte0 && flag) {
                    j2 = k - byte0;
                    while (j2 <= k + byte0 && flag) {
                        if (sinkToFloor >= 0 && sinkToFloor < 127) {
                            i3 = world.getBlockId(k1, sinkToFloor, j2);
                            if (i3 != 0 && i3 != this.leavesID) {
                                flag = false;
                            }
                        } else {
                            flag = false;
                        }
                        ++j2;
                    }
                    ++k1;
                }
                ++sinkToFloor;
            }
            if (!flag) {
                return false;
            }
            sinkToFloor = 0;
            while (world.getBlockId(i, j - sinkToFloor - 1, k) == Block.grass.blockID) {
                if (sinkToFloor > 3) {
                    return false;
                }
                ++sinkToFloor;
            }
            int baseId = world.getBlockId(i, (j -= sinkToFloor) - 1, k);
            if ((Block.blocksList[baseId] instanceof BlockGrass || baseId == Block.dirt.blockID) && j < 127 - trunkLength + sinkToFloor - 1) {
                world.setBlockWithNotify(i, j - 1, k, Block.dirt.blockID);
                k1 = j - 3 + trunkLength + sinkToFloor;
                while (k1 <= j + trunkLength + sinkToFloor) {
                    j2 = k1 - (j + trunkLength + sinkToFloor);
                    i3 = 2 - j2 / 2;
                    int k3 = i - i3;
                    while (k3 <= i + i3) {
                        int l3 = k3 - i;
                        int i4 = k - i3;
                        while (i4 <= k + i3) {
                            int j4 = i4 - k;
                            if ((Math.abs(l3) != i3 || Math.abs(j4) != i3 || random.nextInt(2) != 0 && j2 != 0) && !Block.opaqueCubeLookup[world.getBlockId(k3, k1, i4)]) {
                                world.setBlockWithNotify(k3, k1, i4, this.leavesID);
                                if (this.treeRand.nextInt(5) == 0) {
                                    int vineLength = this.treeRand.nextInt(5);
                                    int q = 0;
                                    while (q < vineLength) {
                                        if (world.getBlockId(k3, k1 - q, i4) == 0) {
                                            world.setBlock(k3, k1 - q, i4, this.leavesID);
                                        }
                                        ++q;
                                    }
                                }
                            }
                            ++i4;
                        }
                        ++k3;
                    }
                    ++k1;
                }
                k1 = 0;
                while (k1 < trunkLength + sinkToFloor) {
                    j2 = world.getBlockId(i, j + k1, k);
                    if (j2 == 0 || j2 == this.leavesID || j2 == Block.grass.blockID) {
                        world.setBlockWithNotify(i, j + k1, k, this.logID);
                    }
                    ++k1;
                }
                new WorldGenSwampGrass().generate(world, this.treeRand, i, 127, k);
                return true;
            }
            return false;
        }
        return false;
    }
}

