/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.level.features;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockGrass;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.WorldGenerator;
import net.minecraft.src.game.level.features.WorldGenLogjam;

public class WorldGenTreeShapeSwamp
extends WorldGenerator {
    protected int leavesID;
    protected int logID;
    protected int heightMod;
    protected Random treeRand = new Random();

    public WorldGenTreeShapeSwamp(int leavesID, int logID, int heightMod) {
        this.leavesID = leavesID;
        this.logID = logID;
        this.heightMod = heightMod;
    }

    @Override
    public boolean generate(World world, Random random, int xCoord, int yCoord, int zCoord) {
        int trunkLength = random.nextInt(4) + this.heightMod;
        boolean flag = true;
        if (yCoord >= 1 && yCoord + trunkLength + 1 <= 127) {
            int i3;
            int j2;
            int k1;
            int sinkToFloor = yCoord;
            while (sinkToFloor <= yCoord + 1 + trunkLength) {
                int byte0 = 1;
                if (sinkToFloor == yCoord) {
                    byte0 = 0;
                }
                if (sinkToFloor >= yCoord + 1 + trunkLength - 2) {
                    byte0 = 2;
                }
                k1 = xCoord - byte0;
                while (k1 <= xCoord + byte0 && flag) {
                    j2 = zCoord - byte0;
                    while (j2 <= zCoord + byte0 && flag) {
                        if (sinkToFloor >= 0 && sinkToFloor < 127) {
                            i3 = world.getBlockId(k1, sinkToFloor, j2);
                            if (i3 != 0 && i3 != this.leavesID) {
                                flag = false;
                            }
                        } else {
                            flag = false;
                        }
                        ++j2;
                    }
                    ++k1;
                }
                ++sinkToFloor;
            }
            if (!flag) {
                return false;
            }
            sinkToFloor = 0;
            while (world.getBlockId(xCoord, yCoord - sinkToFloor - 1, zCoord) == Block.waterStill.blockID) {
                if (sinkToFloor > 3) {
                    return false;
                }
                ++sinkToFloor;
            }
            int baseId = world.getBlockId(xCoord, (yCoord -= sinkToFloor) - 1, zCoord);
            if ((Block.blocksList[baseId] instanceof BlockGrass || baseId == Block.dirt.blockID) && yCoord < 127 - trunkLength + sinkToFloor - 1) {
                world.setBlockWithNotify(xCoord, yCoord - 1, zCoord, Block.dirt.blockID);
                k1 = yCoord - 3 + trunkLength + sinkToFloor;
                while (k1 <= yCoord + trunkLength + sinkToFloor) {
                    j2 = k1 - (yCoord + trunkLength + sinkToFloor);
                    i3 = 2 - j2 / 2;
                    int k3 = xCoord - i3;
                    while (k3 <= xCoord + i3) {
                        int l3 = k3 - xCoord;
                        int i4 = zCoord - i3;
                        while (i4 <= zCoord + i3) {
                            int j4 = i4 - zCoord;
                            if ((Math.abs(l3) != i3 || Math.abs(j4) != i3 || random.nextInt(2) != 0 && j2 != 0) && !Block.opaqueCubeLookup[world.getBlockId(k3, k1, i4)]) {
                                world.setBlockWithNotify(k3, k1, i4, this.leavesID);
                                if (this.treeRand.nextInt(5) == 0) {
                                    int vineLength = this.treeRand.nextInt(5);
                                    int q = 0;
                                    while (q < vineLength) {
                                        if (world.getBlockId(k3, k1 - q, i4) == 0) {
                                            world.setBlock(k3, k1 - q, i4, this.leavesID);
                                        }
                                        ++q;
                                    }
                                }
                            }
                            ++i4;
                        }
                        ++k3;
                    }
                    ++k1;
                }
                k1 = 0;
                while (k1 < trunkLength + sinkToFloor) {
                    j2 = world.getBlockId(xCoord, yCoord + k1, zCoord);
                    if (j2 == 0 || j2 == this.leavesID || j2 == Block.waterStill.blockID || j2 == Block.waterMoving.blockID) {
                        world.setBlockWithNotify(xCoord, yCoord + k1, zCoord, this.logID);
                    }
                    ++k1;
                }
                new WorldGenLogjam().generate(world, this.treeRand, xCoord, yCoord, zCoord);
                return true;
            }
            return false;
        }
        return false;
    }
}

