/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.level.features;

import java.util.Random;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.WorldGenerator;

public class WorldGenSwampMinable
extends WorldGenerator {
    private int minableBlockId;
    private int numberOfBlocks;

    public WorldGenSwampMinable(int blockid, int amount) {
        this.minableBlockId = blockid;
        this.numberOfBlocks = amount;
    }

    @Override
    public boolean generate(World world, Random rand, int xCoord, int yCoord, int zCoord) {
        float radius = rand.nextFloat() * (float)Math.PI;
        double xPositive = (float)(xCoord + 8) + MathHelper.sin(radius) * (float)this.numberOfBlocks / 8.0f;
        double xNegative = (float)(xCoord + 8) - MathHelper.sin(radius) * (float)this.numberOfBlocks / 8.0f;
        double zPositive = (float)(zCoord + 8) + MathHelper.cos(radius) * (float)this.numberOfBlocks / 8.0f;
        double zNegative = (float)(zCoord + 8) - MathHelper.cos(radius) * (float)this.numberOfBlocks / 8.0f;
        double yPositive = yCoord + rand.nextInt(3) + 2;
        double yNegative = yCoord + rand.nextInt(3) + 2;
        int var19 = 0;
        while (var19 <= this.numberOfBlocks) {
            double xTotal = xPositive + (xNegative - xPositive) * (double)var19 / (double)this.numberOfBlocks;
            double yTotal = yPositive + (yNegative - yPositive) * (double)var19 / (double)this.numberOfBlocks;
            double zTotal = zPositive + (zNegative - zPositive) * (double)var19 / (double)this.numberOfBlocks;
            double var26 = rand.nextDouble() * (double)this.numberOfBlocks / 16.0;
            double var28 = (double)(MathHelper.sin((float)var19 * (float)Math.PI / (float)this.numberOfBlocks) + 1.0f) * var26 + 1.0;
            double var30 = (double)(MathHelper.sin((float)var19 * (float)Math.PI / (float)this.numberOfBlocks) + 1.0f) * var26 + 4.0;
            int xTotalPos = MathHelper.floor_double(xTotal - var28 / 2.0);
            int yTotalPos = MathHelper.floor_double(yTotal - var30 / 2.0);
            int zTotalPos = MathHelper.floor_double(zTotal - var28 / 2.0);
            int xTotalNeg = MathHelper.floor_double(xTotal + var28 / 2.0);
            int yTotalNeg = MathHelper.floor_double(yTotal + var30 / 2.0);
            int zTotalNeg = MathHelper.floor_double(zTotal + var28 / 2.0);
            int xFinal = xTotalPos;
            while (xFinal <= xTotalNeg) {
                double var39 = ((double)xFinal + 0.5 - xTotal) / (var28 / 2.0);
                if (var39 * var39 < 1.0) {
                    int yFinal = yTotalPos;
                    while (yFinal <= yTotalNeg) {
                        double var42 = ((double)yFinal + 0.5 - yTotal) / (var30 / 2.0);
                        if (var39 * var39 + var42 * var42 < 1.0) {
                            int zFinal = zTotalPos;
                            while (zFinal <= zTotalNeg) {
                                double var45 = ((double)zFinal + 0.5 - zTotal) / (var28 / 2.0);
                                if (var39 * var39 + var42 * var42 + var45 * var45 < 1.0 && world.getBlockId(xFinal, yFinal, zFinal) == Block.logjam.blockID) {
                                    world.setBlock(xFinal, yFinal, zFinal, this.minableBlockId);
                                }
                                if (var39 * var39 + var42 * var42 + var45 * var45 < 1.0 && world.getBlockId(xFinal, yFinal, zFinal) == Block.dirt.blockID) {
                                    world.setBlock(xFinal, yFinal, zFinal, this.minableBlockId);
                                }
                                if (var39 * var39 + var42 * var42 + var45 * var45 < 1.0 && world.getBlockId(xFinal, yFinal, zFinal) == Block.grass.blockID) {
                                    world.setBlock(xFinal, yFinal, zFinal, this.minableBlockId);
                                }
                                ++zFinal;
                            }
                        }
                        ++yFinal;
                    }
                }
                ++xFinal;
            }
            ++var19;
        }
        return true;
    }
}

