/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.level.features;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.WorldGenerator;

public class WorldGenCaveSpikesFloor
extends WorldGenerator {
    private int blockId;

    public WorldGenCaveSpikesFloor(int block) {
        this.blockId = block;
    }

    @Override
    public boolean generate(World world, Random rand, int xCoord, int yCoord, int zCoord) {
        if (!world.isAirBlock(xCoord, yCoord, zCoord)) {
            return false;
        }
        if (world.getBlockId(xCoord, yCoord - 1, zCoord) != Block.stone.blockID && world.getBlockId(xCoord, yCoord - 1, zCoord) != Block.dirt.blockID && world.getBlockId(xCoord, yCoord - 1, zCoord) != Block.mossyCobblestone.blockID) {
            return false;
        }
        int attemptRatio = 0;
        while (attemptRatio < 64) {
            int zGenerated;
            int yGenerated;
            int xGenerated = xCoord + rand.nextInt(8) - rand.nextInt(8);
            if (world.getBlockId(xGenerated, yGenerated = yCoord + rand.nextInt(4), zGenerated = zCoord + rand.nextInt(8) - rand.nextInt(8)) == 0 && world.getBlockId(xGenerated, yGenerated - 1, zGenerated) == Block.stone.blockID) {
                world.setBlock(xGenerated, yGenerated, zGenerated, this.blockId);
            }
            ++attemptRatio;
        }
        return true;
    }
}

