/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.level.features;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.tileentity.TileEntityChest;
import net.minecraft.src.game.block.tileentity.TileEntityMobSpawner;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.WorldGenerator;

public class WorldGenBarrenTemple
extends WorldGenerator {
    public static ArrayList centerCoords = new ArrayList();
    public static final int blockStoneBrickId = Block.stoneBrick.blockID;
    public static final int blockCobblestoneId = Block.cobblestone.blockID;
    public static final int maxRoomSections = 3;
    public static final int maxDepth = 2;
    public static final int newConnectionChance = 8;
    public static World world;
    public static Random rand;
    private boolean firstRoom = true;

    public WorldGenBarrenTemple() {
    }

    public WorldGenBarrenTemple(boolean par1) {
    }

    @Override
    public boolean generate(World world, Random rand, int x, int y, int z) {
        WorldGenBarrenTemple.world = world;
        WorldGenBarrenTemple.rand = rand;
        this.firstRoom = true;
        System.out.println("New temple!");
        if (rand.nextInt(2) == 0) {
            this.fullRoomDirectionZ(x, y, z, 3, 0);
        } else {
            this.fullRoomDirectionX(x, y, z, 3, 0);
        }
        return true;
    }

    public void archPlaneXY(int x, int y, int z) {
        this.cubeFillerSimple(x + 1, y, z, x + 1, y + 8, z, blockStoneBrickId, 0);
        this.cubeFillerSimple(x + 9, y, z, x + 9, y + 8, z, blockStoneBrickId, 0);
        this.cubeFillerSimple(x + 3, y + 10, z, x + 7, y + 10, z, blockStoneBrickId, 0);
        world.setBlockAndMetadata(x + 2, y + 9, z, blockStoneBrickId, 0);
        world.setBlockAndMetadata(x + 8, y + 9, z, blockStoneBrickId, 0);
    }

    public void archPlaneYZ(int x, int y, int z) {
        this.cubeFillerSimple(x, y, z + 1, x, y + 8, z + 1, blockStoneBrickId, 0);
        this.cubeFillerSimple(x, y, z + 9, x, y + 8, z + 9, blockStoneBrickId, 0);
        this.cubeFillerSimple(x, y + 10, z + 3, x, y + 10, z + 7, blockStoneBrickId, 0);
        world.setBlockAndMetadata(x, y + 9, z + 2, blockStoneBrickId, 0);
        world.setBlockAndMetadata(x, y + 9, z + 8, blockStoneBrickId, 0);
    }

    public void wallEndPlaneXY(int x, int y, int z) {
        this.cubeFillerSimple(x + 2, y + 11, z, x + 8, y + 11, z, blockStoneBrickId, 0);
        this.cubeFillerSimple(x + 1, y + 10, z, x + 9, y + 10, z, blockStoneBrickId, 0);
        this.cubeFillerSimple(x, y, z, x + 10, y + 9, z, blockStoneBrickId, 0);
    }

    public void wallEndPlaneYZ(int x, int y, int z) {
        this.cubeFillerSimple(x, y + 11, z + 2, x, y + 11, z + 8, blockStoneBrickId, 0);
        this.cubeFillerSimple(x, y + 10, z + 1, x, y + 10, z + 9, blockStoneBrickId, 0);
        this.cubeFillerSimple(x, y, z, x, y + 9, z + 10, blockStoneBrickId, 0);
    }

    public void vaultDirectionZ(int x, int y, int z) {
        this.cubeFillerSimple(x, y, z, x, y + 9, z + 6, blockStoneBrickId, 0);
        this.cubeFillerSimple(x + 10, y, z, x + 10, y + 9, z + 6, blockStoneBrickId, 0);
        this.cubeFillerSimple(x + 2, y + 11, z, x + 8, y + 11, z + 6, blockStoneBrickId, 0);
        this.cubeFillerSimple(x + 1, y + 9, z, x + 1, y + 10, z + 6, blockStoneBrickId, 0);
        this.cubeFillerSimple(x + 2, y + 10, z, x + 2, y + 10, z + 6, blockStoneBrickId, 0);
        this.cubeFillerSimple(x + 8, y + 10, z, x + 8, y + 10, z + 6, blockStoneBrickId, 0);
        this.cubeFillerSimple(x + 9, y + 9, z, x + 9, y + 10, z + 6, blockStoneBrickId, 0);
        this.cubeFillerSimple(x + 1, y, z, x + 9, y + 8, z + 6, 0, 0);
        this.cubeFillerSimple(x + 2, y + 9, z, x + 8, y + 9, z + 6, 0, 0);
        this.cubeFillerSimple(x + 3, y + 10, z, x + 7, y + 10, z + 6, 0, 0);
        this.cubeRubbleFillerSimple(x + 1, z, x + 9, z + 6, y);
    }

    public void vaultDirectionX(int x, int y, int z) {
        this.cubeFillerSimple(x, y, z, x + 6, y + 9, z, blockStoneBrickId, 0);
        this.cubeFillerSimple(x, y, z + 10, x + 6, y + 9, z + 10, blockStoneBrickId, 0);
        this.cubeFillerSimple(x, y + 11, z + 2, x + 6, y + 11, z + 8, blockStoneBrickId, 0);
        this.cubeFillerSimple(x, y + 9, z + 1, x + 6, y + 10, z + 1, blockStoneBrickId, 0);
        this.cubeFillerSimple(x, y + 10, z + 2, x + 6, y + 10, z + 2, blockStoneBrickId, 0);
        this.cubeFillerSimple(x, y + 10, z + 8, x + 6, y + 10, z + 8, blockStoneBrickId, 0);
        this.cubeFillerSimple(x, y + 9, z + 9, x + 6, y + 10, z + 9, blockStoneBrickId, 0);
        this.cubeFillerSimple(x, y, z + 1, x + 6, y + 8, z + 9, 0, 0);
        this.cubeFillerSimple(x, y + 9, z + 2, x + 6, y + 9, z + 8, 0, 0);
        this.cubeFillerSimple(x, y + 10, z + 3, x + 6, y + 10, z + 7, 0, 0);
        this.cubeRubbleFillerSimple(x, z + 1, x + 6, z + 9, y);
    }

    public void fullRoomDirectionZ(int x, int y, int z, int sections, int depth) {
        int frX = x + 3;
        int frY = y;
        int frZ = z + 1;
        boolean digUp = false;
        if (this.firstRoom) {
            digUp = true;
            this.firstRoom = false;
            System.out.println("[Z] Dig up @ " + (frX + 2) + ", " + (frZ + 2));
        }
        this.wallEndPlaneXY(x, y, z);
        ++z;
        int i = 0;
        while (i < sections) {
            int newRoomSections;
            int b;
            this.vaultDirectionZ(x, y, z);
            this.archPlaneXY(x, y, z);
            this.cubeFillerSimple(x, y - 1, z - 1, x + 10, y - 1, z + 7, blockCobblestoneId, 0);
            if (rand.nextInt(2 - depth + 1) == 0) {
                int chestMeta;
                int chestX;
                if (rand.nextInt(2) == 0) {
                    chestX = x + 1;
                    chestMeta = 5;
                } else {
                    chestX = x + 9;
                    chestMeta = 4;
                }
                int chestZ = z + 3;
                world.setBlockWithNotify(chestX, y, chestZ, Block.chest.blockID);
                world.setBlockMetadata(chestX, y, chestZ, chestMeta);
                TileEntityChest entityChest = (TileEntityChest)world.getBlockTileEntity(chestX, y, chestZ);
                if (entityChest != null) {
                    int chestCount = 0;
                    while (chestCount < 8) {
                        ItemStack itemstack = this.randomLootItem(rand);
                        if (itemstack != null) {
                            entityChest.setInventorySlotContents(rand.nextInt(entityChest.getSizeInventory()), itemstack);
                        }
                        ++chestCount;
                    }
                }
            }
            if (rand.nextInt(8) == 0 && (b = world.getBlockId(x - 11, y - 1, z + 3)) != blockCobblestoneId) {
                this.corridorDirectionX(x - 5, y, z + 1);
                newRoomSections = 1 + rand.nextInt(3);
                int totalSections = 0;
                while (totalSections < newRoomSections && !this.collisionRectangle(x - (11 + 6 * totalSections) - 1, z - 2, x - (6 + 6 * totalSections), z - 2 + 10, y - 1)) {
                    ++totalSections;
                }
                if (totalSections > 0) {
                    this.fullRoomDirectionX(x - (3 + totalSections * 6) - 5, y, z - 2, totalSections, depth);
                    this.cubeFillerSimple(x, y, z + 2, x, y + 2, z + 4, blockStoneBrickId, 0);
                    this.cubeFillerSimple(x, y, z + 3, x, y + 1, z + 3, 0, 0);
                    this.cubeFillerSimple(x - 6, y, z + 2, x - 6, y + 2, z + 4, blockStoneBrickId, 0);
                    this.cubeFillerSimple(x - 6, y, z + 3, x - 6, y + 1, z + 3, 0, 0);
                }
            }
            if (rand.nextInt(8) == 0 && (b = world.getBlockId(x + 21, y - 1, z + 3)) != blockCobblestoneId) {
                this.corridorDirectionX(x + 11, y, z + 1);
                newRoomSections = 1 + rand.nextInt(3);
                if (!this.collisionRectangle(x + 16, z - 2, x + 21, z - 2 + 10, y - 1)) {
                    this.fullRoomDirectionX(x + 16, y, z - 2, newRoomSections, depth);
                    this.cubeFillerSimple(x + 10, y, z + 2, x + 10, y + 2, z + 4, blockStoneBrickId, 0);
                    this.cubeFillerSimple(x + 10, y, z + 3, x + 10, y + 1, z + 3, 0, 0);
                    this.cubeFillerSimple(x + 16, y, z + 2, x + 16, y + 2, z + 4, blockStoneBrickId, 0);
                    this.cubeFillerSimple(x + 16, y, z + 3, x + 16, y + 1, z + 3, 0, 0);
                }
            }
            if (rand.nextInt(8) == 0) {
                if (depth < 2) {
                    int newRoomSections2 = 1 + rand.nextInt(3);
                    this.fullRoomDirectionX(x, y - 16, z - 2, newRoomSections2, depth + 1);
                    this.verticalConnector(x + 3, y - 16, z + 1);
                }
            } else if (depth > 0 && rand.nextInt(2 - depth + 2) == 0) {
                world.setBlockWithNotify(x + 5, y, z + 3, Block.mobSpawner.blockID);
                TileEntityMobSpawner entitySpawner = (TileEntityMobSpawner)world.getBlockTileEntity(x + 5, y, z + 3);
                if (entitySpawner != null) {
                    entitySpawner.delay = 200;
                    entitySpawner.setMobID("PigZombie");
                }
            }
            if (this.collisionRectangle(x, (z += 6) + 2, x + 10, z + 7, y - 1)) break;
            ++i;
        }
        this.archPlaneXY(x, y, z);
        this.wallEndPlaneXY(x, y, ++z);
        if (digUp) {
            y = frY + 11;
            while (world.getBlockId(frX + 2, y, frZ + 2) != 0) {
                this.cubeFillerSimple(frX, y, frZ, frX + 4, y, frZ + 4, blockStoneBrickId, 0);
                this.cubeFillerSimple(frX + 1, y, frZ + 1, frX + 3, y, frZ + 3, 0, 0);
                ++y;
            }
            this.cubeFillerSimple(frX - 2, y, frZ - 2, frX + 7, y + 4, frZ + 7, 0, 0);
            this.cubeFillerSimple(frX + 1, y, frZ + 1, frX + 3, y, frZ + 3, blockStoneBrickId, 0);
            world.setBlockAndMetadata(frX + 2, y + 1, frZ + 2, blockStoneBrickId, 0);
            world.setBlock(frX + 2, y + 2, frZ + 2, Block.torch.blockID);
            i = frY;
            while (i < frY + 11) {
                world.setBlock(frX + 2, i, frZ, blockCobblestoneId);
                ++i;
            }
            i = frY;
            while (i < y) {
                world.setBlockAndMetadata(frX + 2, i, frZ + 1, Block.ladder.blockID, 3);
                ++i;
            }
        }
    }

    public void fullRoomDirectionX(int x, int y, int z, int sections, int depth) {
        int frX = x + 1;
        int frY = y;
        int frZ = z + 3;
        boolean digUp = false;
        if (this.firstRoom) {
            digUp = true;
            this.firstRoom = false;
            System.out.println("[X] Dig up @ " + (frX + 2) + ", " + (frZ + 2));
        }
        this.wallEndPlaneYZ(x, y, z);
        ++x;
        int i = 0;
        while (i < sections) {
            int newRoomSections;
            int b;
            this.vaultDirectionX(x, y, z);
            this.archPlaneYZ(x, y, z);
            this.cubeFillerSimple(x - 1, y - 1, z, x + 7, y - 1, z + 10, blockCobblestoneId, 0);
            if (rand.nextInt(2 - depth + 1) == 0) {
                int chestMeta;
                int chestZ;
                if (rand.nextInt(2) == 0) {
                    chestZ = z + 1;
                    chestMeta = 3;
                } else {
                    chestZ = z + 9;
                    chestMeta = 2;
                }
                int chestX = x + 3;
                System.out.println("CHEST " + x + ", " + y + ", " + z);
                world.setBlockWithNotify(chestX, y, chestZ, Block.chest.blockID);
                world.setBlockMetadata(chestX, y, chestZ, chestMeta);
                TileEntityChest entityChest = (TileEntityChest)world.getBlockTileEntity(chestX, y, chestZ);
                if (entityChest != null) {
                    int chestCount = 0;
                    while (chestCount < 8) {
                        ItemStack itemstack = this.randomLootItem(rand);
                        if (itemstack != null) {
                            entityChest.setInventorySlotContents(rand.nextInt(entityChest.getSizeInventory()), itemstack);
                        }
                        ++chestCount;
                    }
                }
            }
            if (rand.nextInt(8) == 0 && (b = world.getBlockId(x + 3, y - 1, z - 11)) != blockCobblestoneId) {
                this.corridorDirectionZ(x + 1, y, z - 5);
                newRoomSections = 1 + rand.nextInt(3);
                int totalSections = 0;
                while (totalSections < newRoomSections && !this.collisionRectangle(x - 2, z - (11 + 6 * totalSections) - 1, x - 2 + 10, z - (6 + 6 * totalSections), y - 1)) {
                    ++totalSections;
                }
                if (totalSections > 0) {
                    this.fullRoomDirectionZ(x - 2, y, z - (3 + totalSections * 6) - 5, totalSections, depth);
                    this.cubeFillerSimple(x + 2, y, z, x + 4, y + 2, z, blockStoneBrickId, 0);
                    this.cubeFillerSimple(x + 3, y, z, x + 3, y + 1, z, 0, 0);
                    this.cubeFillerSimple(x + 2, y, z - 6, x + 4, y + 2, z - 6, blockStoneBrickId, 0);
                    this.cubeFillerSimple(x + 3, y, z - 6, x + 3, y + 1, z - 6, 0, 0);
                }
            }
            if (rand.nextInt(8) == 0 && (b = world.getBlockId(x + 3, y - 1, z + 21)) != blockCobblestoneId) {
                this.corridorDirectionZ(x + 1, y, z + 11);
                newRoomSections = 1 + rand.nextInt(3);
                if (!this.collisionRectangle(x - 2, z + 16, x - 2 + 10, z + 21, y - 1)) {
                    this.fullRoomDirectionZ(x - 2, y, z + 16, newRoomSections, depth);
                    this.cubeFillerSimple(x + 2, y, z + 10, x + 4, y + 2, z + 10, blockStoneBrickId, 0);
                    this.cubeFillerSimple(x + 3, y, z + 10, x + 3, y + 1, z + 10, 0, 0);
                    this.cubeFillerSimple(x + 2, y, z + 16, x + 4, y + 2, z + 16, blockStoneBrickId, 0);
                    this.cubeFillerSimple(x + 3, y, z + 16, x + 3, y + 1, z + 16, 0, 0);
                }
            }
            if (rand.nextInt(8) == 0) {
                if (depth < 2) {
                    int newRoomSections2 = 1 + rand.nextInt(3);
                    this.fullRoomDirectionZ(x - 2, y - 16, z, newRoomSections2, depth + 1);
                    this.verticalConnector(x + 1, y - 16, z + 3);
                }
            } else if (depth > 0 && rand.nextInt(2 - depth + 2) == 0) {
                world.setBlockWithNotify(x + 3, y, z + 5, Block.mobSpawner.blockID);
                TileEntityMobSpawner entitySpawner = (TileEntityMobSpawner)world.getBlockTileEntity(x + 3, y, z + 5);
                if (entitySpawner != null) {
                    entitySpawner.delay = 200;
                    entitySpawner.setMobID("PigZombie");
                }
            }
            if (this.collisionRectangle((x += 6) + 2, z, x + 7, z + 10, y - 1)) break;
            ++i;
        }
        this.archPlaneYZ(x, y, z);
        this.wallEndPlaneYZ(++x, y, z);
        if (digUp) {
            y = frY + 11;
            while (world.getBlockId(frX + 2, y, frZ + 2) != 0) {
                this.cubeFillerSimple(frX, y, frZ, frX + 4, y, frZ + 4, blockStoneBrickId, 0);
                this.cubeFillerSimple(frX + 1, y, frZ + 1, frX + 3, y, frZ + 3, 0, 0);
                ++y;
            }
            this.cubeFillerSimple(frX - 2, y, frZ - 2, frX + 7, y + 4, frZ + 7, 0, 0);
            this.cubeFillerSimple(frX + 1, y, frZ + 1, frX + 3, y, frZ + 3, blockStoneBrickId, 0);
            world.setBlockAndMetadata(frX + 2, y + 1, frZ + 2, blockStoneBrickId, 0);
            world.setBlock(frX + 2, y + 2, frZ + 2, Block.torch.blockID);
            i = frY;
            while (i < frY + 11) {
                world.setBlock(frX, i, frZ + 2, blockCobblestoneId);
                ++i;
            }
            i = frY;
            while (i < y) {
                world.setBlockAndMetadata(frX + 1, i, frZ + 2, Block.ladder.blockID, 5);
                ++i;
            }
        }
    }

    public void corridorDirectionZ(int x, int y, int z) {
        this.cubeFillerSimple(x, y, z, x, y + 2, z + 5, blockCobblestoneId, 0);
        this.cubeFillerSimple(x + 4, y, z, x + 4, y + 2, z + 5, blockCobblestoneId, 0);
        this.cubeFillerSimple(x + 1, y + 3, z, x + 3, y + 3, z + 5, blockCobblestoneId, 0);
        this.cubeFillerSimple(x + 1, y, z, x + 3, y + 2, z + 5, 0, 0);
        this.cubeFillerSimple(x, y - 1, z, x + 4, y - 1, z + 5, blockCobblestoneId, 0);
    }

    public void corridorDirectionX(int x, int y, int z) {
        this.cubeFillerSimple(x, y, z, x + 5, y + 2, z, blockCobblestoneId, 0);
        this.cubeFillerSimple(x, y, z + 4, x + 5, y + 2, z + 4, blockCobblestoneId, 0);
        this.cubeFillerSimple(x, y + 3, z + 1, x + 5, y + 3, z + 3, blockCobblestoneId, 0);
        this.cubeFillerSimple(x, y, z + 1, x + 5, y + 2, z + 3, 0, 0);
        this.cubeFillerSimple(x, y - 1, z, x + 5, y - 1, z + 4, blockCobblestoneId, 0);
    }

    public void verticalConnector(int x, int y, int z) {
        this.cubeFillerSimple(x, y + 16, z, x + 4, y + 16, z + 4, blockStoneBrickId, 0);
        this.cubeFillerSimple(x, y + 12, z, x + 4, y + 15, z + 4, blockCobblestoneId, 0);
        this.cubeFillerSimple(x + 1, y, z + 1, x + 3, y + 16, z + 3, 0, 0);
        this.cubeFillerSimple(x + 2, y, z + 4, x + 2, y + 11, z + 4, blockCobblestoneId, 0);
        this.cubeFillerSimple(x + 2, y, z + 3, x + 2, y + 16, z + 3, Block.ladder.blockID, 2);
    }

    public void cubeFillerSimple(int x1, int y1, int z1, int x2, int y2, int z2, int blockId, int blockAttr) {
        int x = x1;
        while (x <= x2) {
            int y = y1;
            while (y <= y2) {
                int z = z1;
                while (z <= z2) {
                    this.setBlockFast(x, y, z, blockId, blockAttr);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public void cubeRubbleFillerSimple(int x1, int z1, int x2, int z2, int y) {
        int rx = x2 - x1;
        int rz = z2 - z1;
        int n = rx * rz / 2;
        int i = 0;
        while (i < n) {
            int x = x1 + rand.nextInt(rx);
            int z = z1 + rand.nextInt(rz);
            int blockId = rand.nextInt(2) == 0 ? Block.sand.blockID : Block.gravel.blockID;
            int yy = y;
            while (world.getBlockId(x, yy, z) != 0) {
                ++yy;
            }
            world.setBlock(x, yy, z, blockId);
            ++i;
        }
    }

    public boolean collisionRectangle(int x1, int z1, int x2, int z2, int y) {
        return world.getBlockId(x1, y, z1) == blockCobblestoneId || world.getBlockId(x1, y, z2) == blockCobblestoneId || world.getBlockId(x2, y, z1) == blockCobblestoneId || world.getBlockId(x2, y, z2) == blockCobblestoneId;
    }

    public void setBlockFast(int x, int y, int z, int id, int meta) {
        world.getChunkFromChunkCoords(x >> 4, z >> 4).setBlockID(x & 0xF, y, z & 0xF, id);
    }

    public ItemStack randomLootItem(Random random) {
        switch (random.nextInt(10)) {
            case 1: {
                return new ItemStack(Item.ingotIron, random.nextInt(4) + 1);
            }
            case 2: {
                return new ItemStack(Item.ingotGold, random.nextInt(4) + 1);
            }
            case 3: {
                return new ItemStack(Item.gunpowder, random.nextInt(4) + 1);
            }
            case 4: {
                return new ItemStack(Item.bucketEmpty);
            }
            case 5: {
                if (random.nextInt(50) == 0) {
                    return new ItemStack(Item.appleGold);
                }
                return null;
            }
            case 6: {
                return new ItemStack(Item.itemsList[Item.record13.itemID + random.nextInt(2)]);
            }
            case 7: {
                return new ItemStack(Item.diamond);
            }
        }
        return null;
    }
}

