/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.level.chunk;

import java.util.Random;
import net.minecraft.src.client.IProgressUpdate;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockSand;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.WorldGenerator;
import net.minecraft.src.game.level.biomes.BiomeGenBase;
import net.minecraft.src.game.level.chunk.Chunk;
import net.minecraft.src.game.level.chunk.IChunkProvider;
import net.minecraft.src.game.level.features.WorldGenCaveSpikesCeiling;
import net.minecraft.src.game.level.features.WorldGenCaveSpikesFloor;
import net.minecraft.src.game.level.features.WorldGenClay;
import net.minecraft.src.game.level.features.WorldGenCoralBlue;
import net.minecraft.src.game.level.features.WorldGenCoralDead;
import net.minecraft.src.game.level.features.WorldGenCoralRed;
import net.minecraft.src.game.level.features.WorldGenCoralYellow;
import net.minecraft.src.game.level.features.WorldGenDungeons;
import net.minecraft.src.game.level.features.WorldGenFlowers;
import net.minecraft.src.game.level.features.WorldGenLiquids;
import net.minecraft.src.game.level.features.WorldGenMinable;
import net.minecraft.src.game.level.features.WorldGenPumpkin;
import net.minecraft.src.game.level.features.WorldGenReed;
import net.minecraft.src.game.level.features.WorldGenTallGrass;
import net.minecraft.src.game.level.features.WorldGenTrees;
import net.minecraft.src.game.level.map.MapGenBase;
import net.minecraft.src.game.level.map.MapGenCaves;
import net.minecraft.src.game.level.noisegen.NoiseGeneratorOctaves;
import net.minecraft.src.game.level.noisegen.oldgen.InfdevOldNoiseGeneratorOctaves;

public class ChunkProviderIndev
implements IChunkProvider {
    protected Random rand;
    protected double[] sandNoise = new double[256];
    protected double[] gravelNoise = new double[256];
    protected double[] stoneNoise = new double[256];
    protected InfdevOldNoiseGeneratorOctaves noiseGen1a;
    protected InfdevOldNoiseGeneratorOctaves noiseGen2a;
    protected InfdevOldNoiseGeneratorOctaves noiseGen3a;
    protected InfdevOldNoiseGeneratorOctaves noiseGen4a;
    protected InfdevOldNoiseGeneratorOctaves noiseGen5a;
    protected InfdevOldNoiseGeneratorOctaves noiseGen6a;
    protected NoiseGeneratorOctaves beachNoise;
    protected NoiseGeneratorOctaves soilNoise;
    public NoiseGeneratorOctaves mobSpawnerNoise;
    public World worldObj;
    private MapGenBase mapGenBase = new MapGenCaves();
    private BiomeGenBase[] field_28075_v;
    private double[] generatedTemperatures;

    public ChunkProviderIndev(World world, long l) {
        this.worldObj = world;
        this.rand = new Random(l);
        this.noiseGen1a = new InfdevOldNoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2a = new InfdevOldNoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3a = new InfdevOldNoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4a = new InfdevOldNoiseGeneratorOctaves(this.rand, 4);
        this.noiseGen5a = new InfdevOldNoiseGeneratorOctaves(this.rand, 4);
        this.noiseGen6a = new InfdevOldNoiseGeneratorOctaves(this.rand, 5);
        this.beachNoise = new NoiseGeneratorOctaves(this.rand, 4);
        this.soilNoise = new NoiseGeneratorOctaves(this.rand, 4);
        new InfdevOldNoiseGeneratorOctaves(this.rand, 3);
        new InfdevOldNoiseGeneratorOctaves(this.rand, 3);
        new InfdevOldNoiseGeneratorOctaves(this.rand, 3);
        this.mobSpawnerNoise = new NoiseGeneratorOctaves(this.rand, 8);
    }

    public void generateTerrain(int i11, int j11, byte[] abyte0, BiomeGenBase[] biomething, double[] var500) {
        int i = i11 << 4;
        int g11 = j11 << 4;
        int j = 0;
        int k = i;
        while (k < i + 16) {
            int l = g11;
            while (l < g11 + 16) {
                float f1 = (float)(this.noiseGen1a.a((float)k / 0.03125f, 0.0, (float)l / 0.03125f) - this.noiseGen2a.a((float)k / 0.015625f, 0.0, (float)l / 0.015625f)) / 512.0f / 4.0f;
                float f2 = (float)this.noiseGen4a.func_806_a((float)k / 4.0f, (float)l / 4.0f);
                float f3 = (float)this.noiseGen6a.func_806_a((float)k / 8.0f, (float)l / 8.0f) / 8.0f;
                f2 = f2 <= 0.0f ? (float)(this.noiseGen5a.func_806_a((float)k * 0.2571428f, (float)l * 0.2571428f) * (double)f3) : (float)(this.noiseGen3a.func_806_a((float)k * 0.2571428f * 2.0f, (float)l * 0.2571428f * 2.0f) * (double)f3 / 4.0);
                f1 = (int)(f1 + 64.0f + f2);
                if ((float)this.noiseGen5a.func_806_a(k, l) < 0.0f) {
                    f1 = (int)f1 / 2 << 1;
                    if ((float)this.noiseGen5a.func_806_a((double)k / 5.0, (double)l / 5.0) < 0.0f) {
                        f1 += 1.0f;
                    }
                }
                int genBlockY = 0;
                while (genBlockY < 128) {
                    int l1 = 0;
                    if ((k == 0 && i11 == 0 || l == 0 && j11 == 0) && (float)genBlockY <= f1) {
                        l1 = Block.stone.blockID;
                    }
                    if ((float)genBlockY == f1 + 1.0f && f1 >= 64.0f && Math.random() < 0.02) {
                        l1 = 0;
                    } else if ((float)genBlockY == f1 && f1 >= 64.0f) {
                        l1 = Block.stone.blockID;
                    } else if ((float)genBlockY <= f1 - 2.0f) {
                        l1 = Block.stone.blockID;
                    } else if ((float)genBlockY <= f1) {
                        l1 = Block.stone.blockID;
                    } else if (genBlockY <= 64) {
                        l1 = Block.waterStill.blockID;
                    }
                    this.rand.setSeed(i11 + j11 * 13871);
                    int i2 = (i11 << 10) + 128 + this.rand.nextInt(128);
                    int j2 = (j11 << 10) + 128 + this.rand.nextInt(128);
                    i2 = k - i2;
                    j2 = l - j2;
                    if (i2 < 0) {
                        i2 = -i2;
                    }
                    if (j2 < 0) {
                        j2 = -j2;
                    }
                    if (j2 > i2) {
                        i2 = j2;
                    }
                    if ((i2 = 127 - i2) == 255) {
                        i2 = 1;
                    }
                    if ((float)i2 < f1) {
                        i2 = (int)f1;
                    }
                    if (genBlockY <= i2 && (l1 == 0 || l1 == Block.waterStill.blockID || l1 == Block.lavaStill.blockID)) {
                        l1 = Block.brick.blockID;
                    }
                    if (l1 < 0) {
                        l1 = 0;
                    }
                    abyte0[j++] = (byte)l1;
                    ++genBlockY;
                }
                ++l;
            }
            ++k;
        }
    }

    public void replaceBlocksForBiome(int i, int j, byte[] abyte0, BiomeGenBase[] biomething2) {
        int seaLevel = 64;
        double d = 0.03125;
        this.sandNoise = this.beachNoise.generateNoiseOctaves(this.sandNoise, i * 16, j * 16, 0.0, 16, 16, 1, d, d, 1.0);
        this.gravelNoise = this.beachNoise.generateNoiseOctaves(this.gravelNoise, i * 16, 109.0134, j * 16, 16, 1, 16, d, 1.0, d);
        this.stoneNoise = this.soilNoise.generateNoiseOctaves(this.stoneNoise, i * 16, j * 16, 0.0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
        int k = 0;
        while (k < 16) {
            int l = 0;
            while (l < 16) {
                boolean flag = this.sandNoise[k + l * 16] + this.rand.nextDouble() * 0.2 > 0.0;
                boolean flag1 = this.gravelNoise[k + l * 16] + this.rand.nextDouble() * 0.2 > 3.0;
                int i1 = (int)(this.stoneNoise[k + l * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int j1 = -1;
                byte byte1 = (byte)Block.grass.blockID;
                byte byte2 = (byte)Block.dirt.blockID;
                int k1 = 127;
                while (k1 >= 0) {
                    int l1 = (k * 16 + l) * 128 + k1;
                    if (k1 <= 0 + this.rand.nextInt(6) - 1) {
                        abyte0[l1] = (byte)Block.bedrock.blockID;
                    } else {
                        byte byte3 = abyte0[l1];
                        if (byte3 == 0) {
                            j1 = -1;
                        } else if (byte3 == Block.stone.blockID) {
                            if (j1 == -1) {
                                if (i1 <= 0) {
                                    byte1 = 0;
                                    byte2 = (byte)Block.stone.blockID;
                                } else if (k1 >= seaLevel - 4 && k1 <= seaLevel + 1) {
                                    if (flag1) {
                                        byte1 = 0;
                                    }
                                    if (flag1) {
                                        byte2 = (byte)Block.gravel.blockID;
                                    }
                                    if (flag) {
                                        byte1 = (byte)Block.sand.blockID;
                                    }
                                    if (flag) {
                                        byte2 = (byte)Block.sand.blockID;
                                    }
                                }
                                if (k1 < seaLevel && byte1 == 0) {
                                    byte1 = (byte)Block.waterStill.blockID;
                                }
                                j1 = i1;
                                abyte0[l1] = k1 >= seaLevel - 1 ? byte1 : byte2;
                            } else if (j1 > 0) {
                                --j1;
                                abyte0[l1] = byte2;
                            }
                        }
                    }
                    --k1;
                }
                ++l;
            }
            ++k;
        }
    }

    protected double[] initializeNoiseField(double[] ad, int i, int j, int k, int l, int i1, int j1) {
        return ad;
    }

    @Override
    public boolean chunkExists(int i, int j) {
        return true;
    }

    @Override
    public void populate(IChunkProvider ichunkprovider, int i, int j) {
        int var16;
        int var15;
        int var14;
        int var19;
        int j16;
        int l13;
        int i9;
        int var162;
        int var152;
        int var142;
        BlockSand.fallInstantly = true;
        int k = i * 16;
        int l = j * 16;
        BiomeGenBase var6 = this.worldObj.getWorldChunkManager().getBiomeGenAt(k + 16, l + 16);
        this.rand.setSeed(this.worldObj.getRandomSeed());
        long l1 = this.rand.nextLong() / 2L * 2L + 1L;
        long l2 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)i * l1 + (long)j * l2 ^ this.worldObj.getRandomSeed());
        double d = 0.25;
        int i1 = 0;
        while (i1 < 8) {
            int i4 = k + this.rand.nextInt(16) + 8;
            int j6 = this.rand.nextInt(128);
            int i11 = l + this.rand.nextInt(16) + 8;
            new WorldGenDungeons().generate(this.worldObj, this.rand, i4, j6, i11);
            ++i1;
        }
        if (!(k <= 512 && k >= -512 || l <= 512 && l >= -512 || this.rand.nextInt(256) != 2)) {
            int y = 0;
            while (y < 128) {
                short inc = (short)(y - 128);
                int x = k + inc + 1;
                while (x < k - inc) {
                    int z = l + inc + 1;
                    while (z < l - inc) {
                        if (!this.worldObj.isBlockNormalCube(x, y, z) && Math.abs(x) > 512 && Math.abs(z) > 512) {
                            this.worldObj.setBlockWithNotify(x, y, z, Block.brick.blockID);
                        }
                        ++z;
                    }
                    ++x;
                }
                y = (short)(y + 1);
            }
        }
        int j1 = 0;
        while (j1 < 10) {
            int j4 = k + this.rand.nextInt(16);
            int k6 = this.rand.nextInt(64);
            int j11 = l + this.rand.nextInt(16);
            new WorldGenClay(32).generate(this.worldObj, this.rand, j4, k6, j11);
            ++j1;
        }
        int j2 = 0;
        while (j2 < 20) {
            int i5 = k + this.rand.nextInt(16);
            int j7 = this.rand.nextInt(128);
            int i12 = l + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreCoal.blockID, 16).generate(this.worldObj, this.rand, i5, j7, i12);
            ++j2;
        }
        int k2 = 0;
        while (k2 < 20) {
            int j5 = k + this.rand.nextInt(16);
            int k7 = this.rand.nextInt(64);
            int j12 = l + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreIron.blockID, 8).generate(this.worldObj, this.rand, j5, k7, j12);
            ++k2;
        }
        int i3 = 0;
        while (i3 < 2) {
            int k5 = k + this.rand.nextInt(16);
            int l7 = this.rand.nextInt(32);
            int k12 = l + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreGold.blockID, 8).generate(this.worldObj, this.rand, k5, l7, k12);
            ++i3;
        }
        int k3 = 0;
        while (k3 < 1) {
            int i6 = k + this.rand.nextInt(16);
            int j8 = this.rand.nextInt(16);
            int i13 = l + this.rand.nextInt(16);
            new WorldGenMinable(Block.oreDiamond.blockID, 7).generate(this.worldObj, this.rand, i6, j8, i13);
            ++k3;
        }
        int k1 = 0;
        while (k1 < 20) {
            int k4 = k + this.rand.nextInt(16);
            int l6 = this.rand.nextInt(128);
            int k11 = l + this.rand.nextInt(16);
            new WorldGenMinable(Block.dirt.blockID, 32).generate(this.worldObj, this.rand, k4, l6, k11);
            ++k1;
        }
        int i2 = 0;
        while (i2 < 10) {
            int l4 = k + this.rand.nextInt(16);
            int i7 = this.rand.nextInt(128);
            int l11 = l + this.rand.nextInt(16);
            new WorldGenMinable(Block.gravel.blockID, 32).generate(this.worldObj, this.rand, l4, i7, l11);
            ++i2;
        }
        i2 = 0;
        while (i2 < 10) {
            var142 = k + this.rand.nextInt(16);
            var152 = this.rand.nextInt(16);
            var162 = l + this.rand.nextInt(16);
            new WorldGenMinable(Block.basalt.blockID, 52).generate(this.worldObj, this.rand, var142, var152, var162);
            ++i2;
        }
        i2 = 0;
        while (i2 < 20) {
            var142 = k + this.rand.nextInt(16);
            var152 = this.rand.nextInt(128);
            var162 = l + this.rand.nextInt(16);
            new WorldGenMinable(Block.mossyCobblestone.blockID, 32).generate(this.worldObj, this.rand, var142, var152, var162);
            ++i2;
        }
        int var13 = 0;
        while (var13 < 10) {
            var142 = k + this.rand.nextInt(16) + 8;
            var152 = this.rand.nextInt(40) + 18;
            var162 = l + this.rand.nextInt(16) + 8;
            new WorldGenCoralBlue().generate(this.worldObj, this.rand, var142, var152, var162);
            ++var13;
        }
        var13 = 0;
        while (var13 < 10) {
            var142 = k + this.rand.nextInt(16) + 8;
            var152 = this.rand.nextInt(40) + 18;
            var162 = l + this.rand.nextInt(16) + 8;
            new WorldGenCoralRed().generate(this.worldObj, this.rand, var142, var152, var162);
            ++var13;
        }
        var13 = 0;
        while (var13 < 10) {
            var142 = k + this.rand.nextInt(16) + 8;
            var152 = this.rand.nextInt(40) + 18;
            var162 = l + this.rand.nextInt(16) + 8;
            new WorldGenCoralYellow().generate(this.worldObj, this.rand, var142, var152, var162);
            ++var13;
        }
        var13 = 0;
        while (var13 < 10) {
            var142 = k + this.rand.nextInt(16) + 8;
            var152 = this.rand.nextInt(40) + 18;
            var162 = l + this.rand.nextInt(16) + 8;
            new WorldGenCoralDead().generate(this.worldObj, this.rand, var142, var152, var162);
            ++var13;
        }
        d = 0.5;
        int l3 = (int)((this.mobSpawnerNoise.func_806_a((double)k * d, (double)l * d) / 8.0 + this.rand.nextDouble() * 4.0 + 4.0) / 3.0);
        if (l3 < 0) {
            l3 = 0;
        }
        if (this.rand.nextInt(10) == 0) {
            ++l3;
        }
        WorldGenTrees obj = new WorldGenTrees();
        int k8 = 0;
        while (k8 < l3) {
            int j13 = k + this.rand.nextInt(16) + 8;
            int l15 = l + this.rand.nextInt(16) + 8;
            obj.func_517_a(1.0, 1.0, 1.0);
            ((WorldGenerator)obj).generate(this.worldObj, this.rand, j13, this.worldObj.getHeightValue(j13, l15), l15);
            ++k8;
        }
        int l8 = 0;
        while (l8 < 2) {
            int k13 = k + this.rand.nextInt(16) + 8;
            int i16 = this.rand.nextInt(128);
            int j18 = l + this.rand.nextInt(16) + 8;
            new WorldGenFlowers(Block.dandelion.blockID).generate(this.worldObj, this.rand, k13, i16, j18);
            ++l8;
        }
        if (this.rand.nextInt(2) == 0) {
            i9 = k + this.rand.nextInt(16) + 8;
            l13 = this.rand.nextInt(128);
            j16 = l + this.rand.nextInt(16) + 8;
            new WorldGenFlowers(Block.roseRed.blockID).generate(this.worldObj, this.rand, i9, l13, j16);
        }
        if (this.rand.nextInt(1) == 0) {
            i9 = k + this.rand.nextInt(16) + 8;
            l13 = this.rand.nextInt(128);
            j16 = l + this.rand.nextInt(16) + 8;
            new WorldGenFlowers(Block.roseCyan.blockID).generate(this.worldObj, this.rand, i9, l13, j16);
        }
        if (this.rand.nextInt(1) == 0) {
            i9 = k + this.rand.nextInt(16) + 8;
            l13 = this.rand.nextInt(128);
            j16 = l + this.rand.nextInt(16) + 8;
            new WorldGenFlowers(Block.paeonia.blockID).generate(this.worldObj, this.rand, i9, l13, j16);
        }
        int var4 = k;
        int var5 = l;
        int var17 = 0;
        while (var17 < 2) {
            var19 = var4 + this.rand.nextInt(16) + 8;
            int var20 = this.rand.nextInt(128);
            int var21 = var5 + this.rand.nextInt(16) + 8;
            new WorldGenTallGrass(Block.tallGrass.blockID, 1).generate(this.worldObj, this.rand, var19, var20, var21);
            ++var17;
        }
        int var132 = 0;
        while (var132 < 83) {
            var14 = var4 + this.rand.nextInt(16) + 8;
            var15 = this.rand.nextInt(60);
            var16 = var5 + this.rand.nextInt(16) + 8;
            new WorldGenCaveSpikesCeiling(Block.stalactite.blockID).generate(this.worldObj, this.rand, var14, var15, var16);
            ++var132;
        }
        var132 = 0;
        while (var132 < 64) {
            var14 = var4 + this.rand.nextInt(16) + 8;
            var15 = this.rand.nextInt(96);
            var16 = var5 + this.rand.nextInt(16) + 8;
            new WorldGenCaveSpikesCeiling(Block.cobweb.blockID).generate(this.worldObj, this.rand, var14, var15, var16);
            ++var132;
        }
        var132 = 0;
        while (var132 < 59) {
            var14 = var4 + this.rand.nextInt(16) + 8;
            var15 = this.rand.nextInt(96);
            var16 = var5 + this.rand.nextInt(16) + 8;
            new WorldGenCaveSpikesCeiling(Block.caveRoots.blockID).generate(this.worldObj, this.rand, var14, var15, var16);
            ++var132;
        }
        var132 = 0;
        while (var132 < 59) {
            var14 = var4 + this.rand.nextInt(16) + 8;
            var15 = this.rand.nextInt(60);
            var16 = var5 + this.rand.nextInt(16) + 8;
            new WorldGenCaveSpikesFloor(Block.stalagmite.blockID).generate(this.worldObj, this.rand, var14, var15, var16);
            ++var132;
        }
        var132 = 0;
        while (var132 < 49) {
            var14 = var4 + this.rand.nextInt(16) + 8;
            var15 = this.rand.nextInt(60);
            var16 = var5 + this.rand.nextInt(16) + 8;
            new WorldGenCaveSpikesFloor(Block.cobweb.blockID).generate(this.worldObj, this.rand, var14, var15, var16);
            ++var132;
        }
        var132 = 0;
        while (var132 < 24) {
            var14 = var4 + this.rand.nextInt(16) + 8;
            var15 = this.rand.nextInt(60);
            var16 = var5 + this.rand.nextInt(16) + 8;
            new WorldGenCaveSpikesFloor(Block.mushroomGlowing.blockID).generate(this.worldObj, this.rand, var14, var15, var16);
            ++var132;
        }
        if (this.rand.nextInt(4) == 0) {
            int j9 = k + this.rand.nextInt(16) + 8;
            int i14 = this.rand.nextInt(128);
            int k16 = l + this.rand.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomBrown.blockID).generate(this.worldObj, this.rand, j9, i14, k16);
        }
        if (this.rand.nextInt(8) == 0) {
            int k9 = k + this.rand.nextInt(16) + 8;
            int j14 = this.rand.nextInt(128);
            int l16 = l + this.rand.nextInt(16) + 8;
            new WorldGenFlowers(Block.mushroomRed.blockID).generate(this.worldObj, this.rand, k9, j14, l16);
        }
        int l9 = 0;
        while (l9 < 10) {
            int k14 = k + this.rand.nextInt(16) + 8;
            int i17 = this.rand.nextInt(128);
            int k18 = l + this.rand.nextInt(16) + 8;
            new WorldGenReed().generate(this.worldObj, this.rand, k14, i17, k18);
            ++l9;
        }
        if (this.rand.nextInt(32) == 0) {
            var17 = var4 + this.rand.nextInt(16) + 8;
            int var25 = this.rand.nextInt(128);
            var19 = var5 + this.rand.nextInt(16) + 8;
            new WorldGenPumpkin().generate(this.worldObj, this.rand, var17, var25, var19);
        }
        int j10 = 0;
        while (j10 < 50) {
            int i15 = k + this.rand.nextInt(16) + 8;
            int k17 = this.rand.nextInt(this.rand.nextInt(120) + 8);
            int i19 = l + this.rand.nextInt(16) + 8;
            new WorldGenLiquids(Block.waterMoving.blockID).generate(this.worldObj, this.rand, i15, k17, i19);
            ++j10;
        }
        int k10 = 0;
        while (k10 < 20) {
            int j15 = k + this.rand.nextInt(16) + 8;
            int l17 = this.rand.nextInt(this.rand.nextInt(this.rand.nextInt(112) + 8) + 8);
            int j19 = l + this.rand.nextInt(16) + 8;
            new WorldGenLiquids(Block.lavaMoving.blockID).generate(this.worldObj, this.rand, j15, l17, j19);
            ++k10;
        }
        BlockSand.fallInstantly = false;
    }

    @Override
    public Chunk prepareChunk(int var1, int var2) {
        return this.provideChunk(var1, var2);
    }

    @Override
    public Chunk provideChunk(int var1, int var2) {
        this.rand.setSeed((long)var1 * 341873128712L + (long)var2 * 132897987541L);
        byte[] abyte0 = new byte[32768];
        Chunk chunk = new Chunk(this.worldObj, abyte0, var1, var2);
        double[] var5 = this.worldObj.getWorldChunkManager().temperature;
        this.generateTerrain(var1, var2, abyte0, this.field_28075_v, var5);
        this.replaceBlocksForBiome(var1, var2, abyte0, this.field_28075_v);
        this.mapGenBase.generate(this, this.worldObj, var1, var2, abyte0);
        chunk.func_1024_c();
        return chunk;
    }

    @Override
    public boolean saveChunks(boolean var1, IProgressUpdate var2) {
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        return false;
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public String makeString() {
        return "RandomLevelSource";
    }
}

