/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.level.chunk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.src.client.IProgressUpdate;
import net.minecraft.src.game.level.EmptyChunk;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.chunk.Chunk;
import net.minecraft.src.game.level.chunk.ChunkCoordIntPair;
import net.minecraft.src.game.level.chunk.IChunkLoader;
import net.minecraft.src.game.level.chunk.IChunkProvider;

public class ChunkProvider
implements IChunkProvider {
    private Set droppedChunksSet = new HashSet();
    private Chunk field_28064_b;
    private IChunkProvider chunkProvider;
    private IChunkLoader chunkLoader;
    private Map chunkMap = new HashMap();
    private List chunkList = new ArrayList();
    private World field_28066_g;

    public ChunkProvider(World var1, IChunkLoader var2, IChunkProvider var3) {
        this.field_28064_b = new EmptyChunk(var1, new byte[32768], 0, 0);
        this.field_28066_g = var1;
        this.chunkLoader = var2;
        this.chunkProvider = var3;
    }

    @Override
    public boolean chunkExists(int var1, int var2) {
        return this.chunkMap.containsKey(ChunkCoordIntPair.chunkXZ2Int(var1, var2));
    }

    @Override
    public Chunk prepareChunk(int var1, int var2) {
        int var3 = ChunkCoordIntPair.chunkXZ2Int(var1, var2);
        this.droppedChunksSet.remove(var3);
        Chunk var4 = (Chunk)this.chunkMap.get(var3);
        if (var4 == null) {
            var4 = this.loadChunkFromFile(var1, var2);
            if (var4 == null) {
                var4 = this.chunkProvider == null ? this.field_28064_b : this.chunkProvider.provideChunk(var1, var2);
            }
            this.chunkMap.put(var3, var4);
            this.chunkList.add(var4);
            if (var4 != null) {
                var4.func_4143_d();
                var4.onChunkLoad();
            }
            if (!var4.isTerrainPopulated && this.chunkExists(var1 + 1, var2 + 1) && this.chunkExists(var1, var2 + 1) && this.chunkExists(var1 + 1, var2)) {
                this.populate(this, var1, var2);
            }
            if (this.chunkExists(var1 - 1, var2) && !this.provideChunk((int)(var1 - 1), (int)var2).isTerrainPopulated && this.chunkExists(var1 - 1, var2 + 1) && this.chunkExists(var1, var2 + 1) && this.chunkExists(var1 - 1, var2)) {
                this.populate(this, var1 - 1, var2);
            }
            if (this.chunkExists(var1, var2 - 1) && !this.provideChunk((int)var1, (int)(var2 - 1)).isTerrainPopulated && this.chunkExists(var1 + 1, var2 - 1) && this.chunkExists(var1, var2 - 1) && this.chunkExists(var1 + 1, var2)) {
                this.populate(this, var1, var2 - 1);
            }
            if (this.chunkExists(var1 - 1, var2 - 1) && !this.provideChunk((int)(var1 - 1), (int)(var2 - 1)).isTerrainPopulated && this.chunkExists(var1 - 1, var2 - 1) && this.chunkExists(var1, var2 - 1) && this.chunkExists(var1 - 1, var2)) {
                this.populate(this, var1 - 1, var2 - 1);
            }
        }
        return var4;
    }

    @Override
    public Chunk provideChunk(int var1, int var2) {
        Chunk var3 = (Chunk)this.chunkMap.get(ChunkCoordIntPair.chunkXZ2Int(var1, var2));
        return var3 == null ? this.prepareChunk(var1, var2) : var3;
    }

    private Chunk loadChunkFromFile(int var1, int var2) {
        if (this.chunkLoader == null) {
            return null;
        }
        try {
            Chunk var3 = this.chunkLoader.loadChunk(this.field_28066_g, var1, var2);
            if (var3 != null) {
                var3.lastSaveTime = this.field_28066_g.getWorldTime();
            }
            return var3;
        }
        catch (Exception var4) {
            var4.printStackTrace();
            return null;
        }
    }

    private void func_28063_a(Chunk var1) {
        if (this.chunkLoader != null) {
            try {
                this.chunkLoader.saveExtraChunkData(this.field_28066_g, var1);
            }
            catch (Exception var3) {
                var3.printStackTrace();
            }
        }
    }

    private void func_28062_b(Chunk var1) {
        if (this.chunkLoader != null) {
            try {
                var1.lastSaveTime = this.field_28066_g.getWorldTime();
                this.chunkLoader.saveChunk(this.field_28066_g, var1);
            }
            catch (IOException var3) {
                var3.printStackTrace();
            }
        }
    }

    @Override
    public void populate(IChunkProvider var1, int var2, int var3) {
        Chunk var4 = this.provideChunk(var2, var3);
        if (!var4.isTerrainPopulated) {
            var4.isTerrainPopulated = true;
            if (this.chunkProvider != null) {
                this.chunkProvider.populate(var1, var2, var3);
                var4.setChunkModified();
            }
        }
    }

    @Override
    public boolean saveChunks(boolean var1, IProgressUpdate var2) {
        int var3 = 0;
        int var4 = 0;
        while (var4 < this.chunkList.size()) {
            Chunk var5 = (Chunk)this.chunkList.get(var4);
            if (var1 && !var5.neverSave) {
                this.func_28063_a(var5);
            }
            if (var5.needsSaving(var1)) {
                this.func_28062_b(var5);
                var5.isModified = false;
                if (++var3 == 24 && !var1) {
                    return false;
                }
            }
            ++var4;
        }
        if (var1) {
            if (this.chunkLoader == null) {
                return true;
            }
            this.chunkLoader.saveExtraData();
        }
        return true;
    }

    @Override
    public boolean unload100OldestChunks() {
        int var1 = 0;
        while (var1 < 100) {
            if (!this.droppedChunksSet.isEmpty()) {
                Integer var2 = (Integer)this.droppedChunksSet.iterator().next();
                Chunk var3 = (Chunk)this.chunkMap.get(var2);
                var3.onChunkUnload();
                this.func_28062_b(var3);
                this.func_28063_a(var3);
                this.droppedChunksSet.remove(var2);
                this.chunkMap.remove(var2);
                this.chunkList.remove(var3);
            }
            ++var1;
        }
        if (this.chunkLoader != null) {
            this.chunkLoader.func_814_a();
        }
        return this.chunkProvider.unload100OldestChunks();
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public String makeString() {
        return "ServerChunkCache: " + this.chunkMap.size() + " Drop: " + this.droppedChunksSet.size();
    }
}

