/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.level.chunk;

import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.block.tileentity.TileEntity;
import net.minecraft.src.game.level.EnumSkyBlock;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.WorldChunkManager;
import net.minecraft.src.game.level.chunk.Chunk;

public class ChunkCache
implements IBlockAccess {
    private int chunkX;
    private int chunkZ;
    private Chunk[][] chunkArray;
    private World worldObj;

    public ChunkCache(World var1, int var2, int var3, int var4, int var5, int var6, int var7) {
        this.worldObj = var1;
        this.chunkX = var2 >> 4;
        this.chunkZ = var4 >> 4;
        int var8 = var5 >> 4;
        int var9 = var7 >> 4;
        this.chunkArray = new Chunk[var8 - this.chunkX + 1][var9 - this.chunkZ + 1];
        int var10 = this.chunkX;
        while (var10 <= var8) {
            int var11 = this.chunkZ;
            while (var11 <= var9) {
                this.chunkArray[var10 - this.chunkX][var11 - this.chunkZ] = var1.getChunkFromChunkCoords(var10, var11);
                ++var11;
            }
            ++var10;
        }
    }

    @Override
    public int getBlockId(int var1, int var2, int var3) {
        if (var2 < 0) {
            return 0;
        }
        if (var2 >= 128) {
            return 0;
        }
        int var4 = (var1 >> 4) - this.chunkX;
        int var5 = (var3 >> 4) - this.chunkZ;
        if (var4 >= 0 && var4 < this.chunkArray.length && var5 >= 0 && var5 < this.chunkArray[var4].length) {
            Chunk var6 = this.chunkArray[var4][var5];
            return var6 == null ? 0 : var6.getBlockID(var1 & 0xF, var2, var3 & 0xF);
        }
        return 0;
    }

    @Override
    public TileEntity getBlockTileEntity(int var1, int var2, int var3) {
        int var4 = (var1 >> 4) - this.chunkX;
        int var5 = (var3 >> 4) - this.chunkZ;
        return this.chunkArray[var4][var5].getChunkBlockTileEntity(var1 & 0xF, var2, var3 & 0xF);
    }

    @Override
    public float getBrightness(int var1, int var2, int var3, int var4) {
        int var5 = this.getLightValue(var1, var2, var3);
        if (var5 < var4) {
            var5 = var4;
        }
        return this.worldObj.worldProvider.lightBrightnessTable[var5];
    }

    @Override
    public float getLightBrightness(int var1, int var2, int var3) {
        return this.worldObj.worldProvider.lightBrightnessTable[this.getLightValue(var1, var2, var3)];
    }

    public int getLightValue(int var1, int var2, int var3) {
        return this.getLightValueExt(var1, var2, var3, true);
    }

    public int getLightValueExt(int var1, int var2, int var3, boolean var4) {
        if (var1 >= -32000000 && var3 >= -32000000 && var1 < 32000000 && var3 <= 32000000) {
            int var5;
            if (var4 && ((var5 = this.getBlockId(var1, var2, var3)) == Block.slabSingleRock.blockID || var5 == Block.slabSingleWood.blockID || var5 == Block.slabSingleSponge.blockID || var5 == Block.tilledField.blockID || var5 == Block.path.blockID || var5 == Block.stairsBrick.blockID || var5 == Block.stairsCobblestone.blockID || var5 == Block.stairsPlanks.blockID || var5 == Block.stairsPlanksCrimson.blockID || var5 == Block.stairsPlanksFir.blockID || var5 == Block.spongeStairs.blockID || var5 == Block.table.blockID || var5 == Block.tableCrimson.blockID || var5 == Block.tableFir.blockID || var5 == Block.glassTable.blockID)) {
                int var6 = this.getLightValueExt(var1, var2 + 1, var3, false);
                int var7 = this.getLightValueExt(var1 + 1, var2, var3, false);
                int var8 = this.getLightValueExt(var1 - 1, var2, var3, false);
                int var9 = this.getLightValueExt(var1, var2, var3 + 1, false);
                int var10 = this.getLightValueExt(var1, var2, var3 - 1, false);
                if (var7 > var6) {
                    var6 = var7;
                }
                if (var8 > var6) {
                    var6 = var8;
                }
                if (var9 > var6) {
                    var6 = var9;
                }
                if (var10 > var6) {
                    var6 = var10;
                }
                return var6;
            }
            if (var2 < 0) {
                return 0;
            }
            if (var2 >= 128) {
                var5 = 15 - this.worldObj.skylightSubtracted;
                if (var5 < 0) {
                    var5 = 0;
                }
                return var5;
            }
            var5 = (var1 >> 4) - this.chunkX;
            int var6 = (var3 >> 4) - this.chunkZ;
            return this.chunkArray[var5][var6].getBlockLightValue(var1 & 0xF, var2, var3 & 0xF, this.worldObj.skylightSubtracted);
        }
        return 15;
    }

    @Override
    public int getBlockMetadata(int var1, int var2, int var3) {
        if (var2 < 0) {
            return 0;
        }
        if (var2 >= 128) {
            return 0;
        }
        int var4 = (var1 >> 4) - this.chunkX;
        int var5 = (var3 >> 4) - this.chunkZ;
        return this.chunkArray[var4][var5].getBlockMetadata(var1 & 0xF, var2, var3 & 0xF);
    }

    @Override
    public Material getBlockMaterial(int var1, int var2, int var3) {
        int var4 = this.getBlockId(var1, var2, var3);
        return var4 == 0 ? Material.air : Block.blocksList[var4].blockMaterial;
    }

    @Override
    public WorldChunkManager getWorldChunkManager() {
        return this.worldObj.getWorldChunkManager();
    }

    @Override
    public boolean isBlockOpaqueCube(int var1, int var2, int var3) {
        Block var4 = Block.blocksList[this.getBlockId(var1, var2, var3)];
        return var4 == null ? false : var4.isOpaqueCube();
    }

    @Override
    public boolean isBlockNormalCube(int var1, int var2, int var3) {
        Block var4 = Block.blocksList[this.getBlockId(var1, var2, var3)];
        if (var4 == null) {
            return false;
        }
        return var4.blockMaterial.getIsSolid() && var4.renderAsNormalBlock();
    }

    public int getSkyBlockTypeBrightness(EnumSkyBlock var1, int var2, int var3, int var4) {
        if (var3 < 0) {
            var3 = 0;
        }
        if (var3 >= 128) {
            var3 = 127;
        }
        if (var3 >= 0 && var3 < 128 && var2 >= -30000000 && var4 >= -30000000 && var2 < 30000000 && var4 <= 30000000) {
            if (Block.field_28032_t[this.getBlockId(var2, var3, var4)]) {
                int var5 = this.getSpecialBlockBrightness(var1, var2, var3 + 1, var4);
                int var6 = this.getSpecialBlockBrightness(var1, var2 + 1, var3, var4);
                int var7 = this.getSpecialBlockBrightness(var1, var2 - 1, var3, var4);
                int var8 = this.getSpecialBlockBrightness(var1, var2, var3, var4 + 1);
                int var9 = this.getSpecialBlockBrightness(var1, var2, var3, var4 - 1);
                if (var6 > var5) {
                    var5 = var6;
                }
                if (var7 > var5) {
                    var5 = var7;
                }
                if (var8 > var5) {
                    var5 = var8;
                }
                if (var9 > var5) {
                    var5 = var9;
                }
                return var5;
            }
            int var5 = (var2 >> 4) - this.chunkX;
            int var6 = (var4 >> 4) - this.chunkZ;
            return this.chunkArray[var5][var6].getSavedLightValue(var1, var2 & 0xF, var3, var4 & 0xF);
        }
        return var1.field_1722_c;
    }

    public int getSpecialBlockBrightness(EnumSkyBlock var1, int var2, int var3, int var4) {
        if (var3 < 0) {
            var3 = 0;
        }
        if (var3 >= 128) {
            var3 = 127;
        }
        if (var3 >= 0 && var3 < 128 && var2 >= -30000000 && var4 >= -30000000 && var2 < 30000000 && var4 <= 30000000) {
            int var5 = (var2 >> 4) - this.chunkX;
            int var6 = (var4 >> 4) - this.chunkZ;
            return this.chunkArray[var5][var6].getSavedLightValue(var1, var2 & 0xF, var3, var4 & 0xF);
        }
        return var1.field_1722_c;
    }

    @Override
    public int getLightBrightnessForSkyBlocks(int var1, int var2, int var3, int var4) {
        int var5 = this.getSkyBlockTypeBrightness(EnumSkyBlock.Sky, var1, var2, var3);
        int var6 = this.getSkyBlockTypeBrightness(EnumSkyBlock.Block, var1, var2, var3);
        if (var6 < var4) {
            var6 = var4;
        }
        return var5 << 20 | var6 << 4;
    }
}

