/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.level.biomes;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.entity.EnumCreatureType;
import net.minecraft.src.game.entity.animals.EntityChicken;
import net.minecraft.src.game.entity.animals.EntityCow;
import net.minecraft.src.game.entity.animals.EntityPig;
import net.minecraft.src.game.entity.animals.EntitySheep;
import net.minecraft.src.game.entity.monster.EntityCreeper;
import net.minecraft.src.game.entity.monster.EntitySkeleton;
import net.minecraft.src.game.entity.monster.EntitySlime;
import net.minecraft.src.game.entity.monster.EntitySpider;
import net.minecraft.src.game.entity.monster.EntityZombie;
import net.minecraft.src.game.level.SpawnListEntry;
import net.minecraft.src.game.level.WorldGenerator;
import net.minecraft.src.game.level.biomes.BiomeGenDesert;
import net.minecraft.src.game.level.biomes.BiomeGenFlowerForest;
import net.minecraft.src.game.level.biomes.BiomeGenForest;
import net.minecraft.src.game.level.biomes.BiomeGenHell;
import net.minecraft.src.game.level.biomes.BiomeGenMushroomIsland;
import net.minecraft.src.game.level.biomes.BiomeGenRainforest;
import net.minecraft.src.game.level.biomes.BiomeGenSky;
import net.minecraft.src.game.level.biomes.BiomeGenSwamp;
import net.minecraft.src.game.level.biomes.BiomeGenTaiga;
import net.minecraft.src.game.level.biomes.BiomeGenTundra;
import net.minecraft.src.game.level.features.WorldGenBigTree;
import net.minecraft.src.game.level.features.WorldGenNetherTrees;
import net.minecraft.src.game.level.features.WorldGenTaiga1;
import net.minecraft.src.game.level.features.WorldGenTaiga2;
import net.minecraft.src.game.level.features.WorldGenTrees;

public class BiomeGenBase {
    public static final BiomeGenBase plains = new BiomeGenDesert(0).setBiomeName("Plains");
    public static final BiomeGenBase forest = new BiomeGenForest(1).setBiomeName("Forest").func_4124_a(5159473);
    public static final BiomeGenBase savanna = new BiomeGenDesert(2).setBiomeName("Savanna");
    public static final BiomeGenBase shrubland = new BiomeGenBase(3).setBiomeName("Shrubland");
    public static final BiomeGenBase desert = new BiomeGenDesert(4).setBiomeName("Desert").setDisableRain();
    public static final BiomeGenBase swampland = new BiomeGenSwamp(5).setBiomeName("Swampland").func_4124_a(9154376);
    public static final BiomeGenBase flowerForest = new BiomeGenFlowerForest(6).setBiomeName("Flower Forest");
    public static final BiomeGenBase rainforest = new BiomeGenRainforest(7).setBiomeName("Rainforest").func_4124_a(2094168);
    public static final BiomeGenBase mushroomIsland = new BiomeGenMushroomIsland(8).setBiomeName("Mushroom Island");
    public static final BiomeGenBase taiga = new BiomeGenTaiga(9).setBiomeName("Taiga").setEnableSnow().func_4124_a(8107825);
    public static final BiomeGenBase tundra = new BiomeGenTundra(10).setBiomeName("Tundra").setEnableSnow().func_4124_a(12899129);
    public static final BiomeGenBase seasonalForest = new BiomeGenBase(11).setBiomeName("Seasonal Forest");
    public static final BiomeGenBase iceDesert = new BiomeGenDesert(12).setBiomeName("Ice Desert").setEnableSnow().setDisableRain().func_4124_a(12899129);
    public static final BiomeGenBase hell = new BiomeGenHell(13).setBiomeName("Hell").setDisableRain();
    public static final BiomeGenBase sky = new BiomeGenSky(14).setBiomeName("Sky").setDisableRain();
    public String biomeName;
    public int color;
    public byte topBlock;
    public byte fillerBlock;
    public int field_6502_q;
    protected List spawnableMonsterList;
    protected List spawnableCreatureList;
    protected List spawnableWaterCreatureList;
    private boolean enableSnow;
    private boolean enableRain;
    public static BiomeGenBase[] biomeLookupTable = new BiomeGenBase[4096];
    private static Random rand;
    public float temperature;
    public float rainfall;
    public int biomeID;

    static {
        BiomeGenBase.generateBiomeLookup();
    }

    protected BiomeGenBase(int var1) {
        this.topBlock = (byte)Block.grass.blockID;
        this.fillerBlock = (byte)Block.dirt.blockID;
        this.field_6502_q = 5169201;
        this.spawnableMonsterList = new ArrayList();
        this.spawnableCreatureList = new ArrayList();
        this.spawnableWaterCreatureList = new ArrayList();
        this.enableRain = true;
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySpider.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityZombie.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySkeleton.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(EntityCreeper.class, 10));
        this.spawnableMonsterList.add(new SpawnListEntry(EntitySlime.class, 10));
        this.spawnableCreatureList.add(new SpawnListEntry(EntitySheep.class, 12));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityPig.class, 10));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityChicken.class, 10));
        this.spawnableCreatureList.add(new SpawnListEntry(EntityCow.class, 8));
        this.biomeID = var1;
    }

    public BiomeGenBase debugBiomeName(String string) {
        this.biomeName = string;
        return this;
    }

    private BiomeGenBase setDisableRain() {
        this.enableRain = false;
        return this;
    }

    public static byte swampblocks() {
        return rand.nextInt(2) == 1 ? (byte)Block.waterMoving.blockID : (byte)Block.soulSand.blockID;
    }

    public static void generateBiomeLookup() {
        int var0 = 0;
        while (var0 < 64) {
            int var1 = 0;
            while (var1 < 64) {
                BiomeGenBase.biomeLookupTable[var0 + var1 * 64] = BiomeGenBase.getBiome((float)var0 / 63.0f, (float)var1 / 63.0f);
                ++var1;
            }
            ++var0;
        }
        BiomeGenBase.mushroomIsland.topBlock = (byte)Block.mycelium.blockID;
        BiomeGenBase.desert.topBlock = BiomeGenBase.desert.fillerBlock = (byte)Block.sand.blockID;
        BiomeGenBase.hell.topBlock = BiomeGenBase.hell.fillerBlock = (byte)Block.netherrack.blockID;
        BiomeGenBase.iceDesert.topBlock = BiomeGenBase.iceDesert.fillerBlock = (byte)Block.sand.blockID;
    }

    public WorldGenerator getRandomWorldGenForTrees(Random var1) {
        return var1.nextInt(10) == 0 ? new WorldGenBigTree() : new WorldGenTrees();
    }

    public WorldGenerator getRandomWorldGenForNetherTrees(Random var1) {
        return var1.nextInt(10) == 0 ? new WorldGenNetherTrees() : new WorldGenNetherTrees();
    }

    public WorldGenerator getRandomWorldGenForSkyTrees(Random var1) {
        return var1.nextInt(10) == 0 ? new WorldGenTaiga2() : new WorldGenTaiga1();
    }

    protected BiomeGenBase setEnableSnow() {
        this.enableSnow = true;
        return this;
    }

    protected BiomeGenBase setBiomeName(String var1) {
        this.biomeName = var1;
        return this;
    }

    protected BiomeGenBase func_4124_a(int var1) {
        this.field_6502_q = var1;
        return this;
    }

    public static BiomeGenBase getBiomeFromLookup(double var0, double var2) {
        int var4 = (int)(var0 * 63.0);
        int var5 = (int)(var2 * 63.0);
        return biomeLookupTable[var4 + var5 * 64];
    }

    public static BiomeGenBase getBiome(float temperature, float rainfall) {
        rainfall *= temperature;
        if (temperature < 0.1f) {
            return tundra;
        }
        if (rainfall < 0.2f) {
            if (temperature < 0.5f) {
                return tundra;
            }
            return temperature < 0.95f ? plains : desert;
        }
        if (rainfall > 0.5f && temperature < 0.8f) {
            return swampland;
        }
        if (rainfall > 0.4f && temperature < 0.75f) {
            return mushroomIsland;
        }
        if (temperature < 0.4f) {
            return taiga;
        }
        if (temperature < 0.9f) {
            if (rainfall < 0.1f) {
                return flowerForest;
            }
            if (rainfall < 0.35f) {
                return shrubland;
            }
            return forest;
        }
        if (rainfall < 0.6f) {
            return savanna;
        }
        return rainfall < 0.8f ? flowerForest : rainforest;
    }

    public int getSkyColorByTemp(float var1) {
        if ((var1 /= 3.0f) < -1.0f) {
            var1 = -1.0f;
        }
        if (var1 > 1.0f) {
            var1 = 1.0f;
        }
        return Color.getHSBColor(0.62222224f - var1 * 0.05f, 0.5f + var1 * 0.1f, 1.0f).getRGB();
    }

    public List getSpawnableList(EnumCreatureType var1) {
        if (var1 == EnumCreatureType.monster) {
            return this.spawnableMonsterList;
        }
        if (var1 == EnumCreatureType.creature) {
            return this.spawnableCreatureList;
        }
        return var1 == EnumCreatureType.waterCreature ? this.spawnableWaterCreatureList : null;
    }

    public boolean getEnableSnow() {
        return this.enableSnow;
    }

    public boolean canSpawnLightningBolt() {
        return this.enableSnow ? false : this.enableRain;
    }
}

