/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.level;

import net.minecraft.src.client.renderer.Vec3D;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.level.WorldChunkManagerHell;
import net.minecraft.src.game.level.WorldProvider;
import net.minecraft.src.game.level.biomes.BiomeGenBase;
import net.minecraft.src.game.level.chunk.ChunkProviderSky;
import net.minecraft.src.game.level.chunk.IChunkProvider;

public class WorldProviderSky
extends WorldProvider {
    @Override
    public void registerWorldChunkManager() {
        this.worldChunkMgr = new WorldChunkManagerHell(BiomeGenBase.sky, 0.5, 0.0);
        this.worldType = 1;
    }

    @Override
    public IChunkProvider getChunkProvider() {
        return new ChunkProviderSky(this.worldObj, this.worldObj.getRandomSeed());
    }

    @Override
    public float calculateCelestialAngle(long var1, float var3) {
        return 0.0f;
    }

    @Override
    public float[] calcSunriseSunsetColors(float var1, float var2) {
        return null;
    }

    @Override
    public Vec3D func_4096_a(float var1, float var2) {
        int var3 = 0x8080A0;
        float var4 = MathHelper.cos(var1 * (float)Math.PI * 2.0f) * 2.0f + 0.5f;
        if (var4 < 0.0f) {
            var4 = 0.0f;
        }
        if (var4 > 1.0f) {
            var4 = 1.0f;
        }
        float var5 = (float)(var3 >> 16 & 0xFF) / 255.0f;
        float var6 = (float)(var3 >> 8 & 0xFF) / 255.0f;
        float var7 = (float)(var3 & 0xFF) / 255.0f;
        return Vec3D.createVector(var5 *= var4 * 0.94f + 0.06f, var6 *= var4 * 0.94f + 0.06f, var7 *= var4 * 0.91f + 0.09f);
    }

    @Override
    public boolean func_28112_c() {
        return false;
    }

    @Override
    public float getCloudHeight() {
        return 8.0f;
    }

    @Override
    public boolean canCoordinateBeSpawn(int var1, int var2) {
        int var3 = this.worldObj.getFirstUncoveredBlock(var1, var2);
        return var3 == 0 ? false : Block.blocksList[var3].blockMaterial.getIsSolid();
    }
}

