/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.item;

import net.minecraft.src.game.Facing;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.entity.animals.EntityChicken;
import net.minecraft.src.game.entity.animals.EntityCow;
import net.minecraft.src.game.entity.animals.EntityFox;
import net.minecraft.src.game.entity.animals.EntityMoobloom;
import net.minecraft.src.game.entity.animals.EntityMooshroom;
import net.minecraft.src.game.entity.animals.EntityPig;
import net.minecraft.src.game.entity.animals.EntitySheep;
import net.minecraft.src.game.entity.animals.EntityWolf;
import net.minecraft.src.game.entity.monster.EntityBlaze;
import net.minecraft.src.game.entity.monster.EntityCreeper;
import net.minecraft.src.game.entity.monster.EntityGiantZombie;
import net.minecraft.src.game.entity.monster.EntityPigZombie;
import net.minecraft.src.game.entity.monster.EntitySkeleton;
import net.minecraft.src.game.entity.monster.EntitySlime;
import net.minecraft.src.game.entity.monster.EntitySpider;
import net.minecraft.src.game.entity.monster.EntityZombie;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;

public class ItemSpawnEgg
extends Item {
    public World worldObj;
    public EntityPlayer player;
    public String entity;

    public ItemSpawnEgg(int var1, String flavor) {
        super(var1);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
        this.entity = flavor;
    }

    @Override
    public boolean onItemUse(ItemStack itemstack, EntityPlayer thePlayer, World world, int par4, int par5, int par6, int par7) {
        --itemstack.stackSize;
        if (ItemSpawnEgg.func_48440_a(world, itemstack.getItemDamage(), par4 += Facing.offsetsXForSide[par7], par5 += Facing.offsetsYForSide[par7], par6 += Facing.offsetsZForSide[par7], this.entity)) {
            --itemstack.stackSize;
        }
        return true;
    }

    public static boolean func_48440_a(World world, int par1, int xCoord, int yCoord, int zCoord, String flavor) {
        block52: {
            EntityLiving spawnedmob;
            if (world.multiplayerWorld) break block52;
            switch (flavor) {
                case "chicken": {
                    spawnedmob = new EntityChicken(world);
                    break;
                }
                case "cow": {
                    spawnedmob = new EntityCow(world);
                    break;
                }
                case "wolf": {
                    spawnedmob = new EntityWolf(world);
                    break;
                }
                case "fox": {
                    spawnedmob = new EntityFox(world);
                    break;
                }
                case "sheep": {
                    spawnedmob = new EntitySheep(world);
                    break;
                }
                case "pig": {
                    spawnedmob = new EntityPig(world);
                    break;
                }
                case "slime": {
                    spawnedmob = new EntitySlime(world);
                    break;
                }
                case "zombie": {
                    spawnedmob = new EntityZombie(world);
                    break;
                }
                case "skeleton": {
                    spawnedmob = new EntitySkeleton(world);
                    break;
                }
                case "creeper": {
                    spawnedmob = new EntityCreeper(world);
                    break;
                }
                case "spider": {
                    spawnedmob = new EntitySpider(world);
                    break;
                }
                case "pigzombie": {
                    spawnedmob = new EntityPigZombie(world);
                    break;
                }
                case "blaze": {
                    spawnedmob = new EntityBlaze(world);
                    break;
                }
                case "mooshroom": {
                    spawnedmob = new EntityMooshroom(world);
                    break;
                }
                case "moobloom": {
                    spawnedmob = new EntityMoobloom(world);
                    break;
                }
                case "giant": {
                    spawnedmob = new EntityGiantZombie(world);
                    break;
                }
                default: {
                    spawnedmob = new EntityFox(world);
                }
            }
            spawnedmob.setLocationAndAngles((double)xCoord + 0.5, (double)yCoord + 0.05, (double)zCoord + 0.5, 0.0f, 0.0f);
            world.entityJoinedWorld(spawnedmob);
        }
        return true;
    }
}

