/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.item;

import net.minecraft.src.client.physics.MovingObjectPosition;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.EnumMovingObjectType;
import net.minecraft.src.game.level.World;

public class ItemLilyPad
extends Item {
    Block block;

    public ItemLilyPad(int i, Block blockid) {
        super(i);
        this.block = blockid;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        MovingObjectPosition movingobjectposition = this.func_40402_a(world, entityplayer, true);
        if (movingobjectposition == null) {
            return itemstack;
        }
        if (movingobjectposition.typeOfHit == EnumMovingObjectType.TILE) {
            int i = movingobjectposition.blockX;
            int j = movingobjectposition.blockY;
            int k = movingobjectposition.blockZ;
            if (!world.canMineBlock(entityplayer, i, j, k)) {
                return itemstack;
            }
            if (!entityplayer.func_35190_e(i, j, k)) {
                return itemstack;
            }
            if (world.getBlockMaterial(i, j, k) == Material.water && world.getBlockMetadata(i, j, k) == 0 && world.isAirBlock(i, j + 1, k)) {
                entityplayer.swingItem();
                world.setBlockWithNotify(i, j + 1, k, this.block.blockID);
                world.playSoundEffect((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "step.waterlily.place", 1.0f, 1.0f);
                if (!entityplayer.capabilities.depleteItems) {
                    --itemstack.stackSize;
                }
            }
        }
        return itemstack;
    }
}

