/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.item;

import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.entity.other.EntityItem;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.EnumToolMaterial;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.item.ItemTool;
import net.minecraft.src.game.level.World;

public class ItemHoe
extends ItemTool {
    private static Block[] blocksEffectiveAgainst = new Block[]{Block.ashPile, Block.ashBlock, Block.crops, Block.cropsPotato, Block.cropsCarrot};

    public ItemHoe(int var1, EnumToolMaterial var2) {
        super(var1, 1, var2, blocksEffectiveAgainst);
        this.maxStackSize = 1;
        this.setMaxDamage(var2.getMaxUses());
    }

    @Override
    public boolean canHarvestBlock(Block var1) {
        if (var1 == Block.ashPile) {
            return true;
        }
        return var1 == Block.ashBlock;
    }

    @Override
    public boolean onItemUse(ItemStack var1, EntityPlayer var2, World var3, int var4, int var5, int var6, int var7) {
        EntityItem var17;
        float var16;
        float var15;
        float var14;
        float var13;
        int var12;
        int var11;
        int var8 = var3.getBlockId(var4, var5, var6);
        int var9 = var3.getBlockId(var4, var5 + 1, var6);
        if ((var7 == 0 || var9 != 0 || var8 != Block.grass.blockID) && var8 != Block.dirt.blockID && var8 != Block.mycelium.blockID) {
            return false;
        }
        Block var10 = Block.tilledField;
        var3.playSoundEffect((float)var4 + 0.5f, (float)var5 + 0.5f, (float)var6 + 0.5f, var10.stepSound.func_1145_d(), (var10.stepSound.getVolume() + 1.0f) / 2.0f, var10.stepSound.getPitch() * 0.8f);
        if (var3.multiplayerWorld) {
            return true;
        }
        var3.setBlockWithNotify(var4, var5, var6, var10.blockID);
        if (!var2.capabilities.depleteItems) {
            var1.damageItem(1, var2);
        }
        if (var3.rand.nextInt(20) == 0 && var8 == Block.grass.blockID) {
            var11 = 1;
            var12 = 0;
            while (var12 < var11) {
                var13 = 0.7f;
                var14 = var3.rand.nextFloat() * var13 + (1.0f - var13) * 0.5f;
                var15 = 1.2f;
                var16 = var3.rand.nextFloat() * var13 + (1.0f - var13) * 0.5f;
                var17 = new EntityItem(var3, (float)var4 + var14, (float)var5 + var15, (float)var6 + var16, new ItemStack(Item.seeds));
                var17.delayBeforeCanPickup = 10;
                var3.entityJoinedWorld(var17);
                ++var12;
            }
        }
        if (var3.rand.nextInt(20) == 0 && var8 == Block.grass.blockID) {
            var11 = 1;
            var12 = 0;
            while (var12 < var11) {
                var13 = 0.7f;
                var14 = var3.rand.nextFloat() * var13 + (1.0f - var13) * 0.5f;
                var15 = 1.2f;
                var16 = var3.rand.nextFloat() * var13 + (1.0f - var13) * 0.5f;
                var17 = new EntityItem(var3, (float)var4 + var14, (float)var5 + var15, (float)var6 + var16, new ItemStack(Item.carrotSeeds));
                var17.delayBeforeCanPickup = 10;
                var3.entityJoinedWorld(var17);
                ++var12;
            }
        }
        if (var3.rand.nextInt(20) == 0 && var8 == Block.grass.blockID) {
            var11 = 1;
            var12 = 0;
            while (var12 < var11) {
                var13 = 0.7f;
                var14 = var3.rand.nextFloat() * var13 + (1.0f - var13) * 0.5f;
                var15 = 1.2f;
                var16 = var3.rand.nextFloat() * var13 + (1.0f - var13) * 0.5f;
                var17 = new EntityItem(var3, (float)var4 + var14, (float)var5 + var15, (float)var6 + var16, new ItemStack(Item.potato));
                var17.delayBeforeCanPickup = 10;
                var3.entityJoinedWorld(var17);
                ++var12;
            }
        }
        return true;
    }

    @Override
    public boolean isFull3D() {
        return true;
    }
}

