/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.item;

import java.awt.Color;
import java.util.Random;
import net.minecraft.src.client.physics.MovingObjectPosition;
import net.minecraft.src.client.renderer.Vec3D;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.EnumAction;
import net.minecraft.src.game.item.EnumToolMaterial;
import net.minecraft.src.game.item.ItemArmor;
import net.minecraft.src.game.item.ItemArrow;
import net.minecraft.src.game.item.ItemAxe;
import net.minecraft.src.game.item.ItemBed;
import net.minecraft.src.game.item.ItemBoat;
import net.minecraft.src.game.item.ItemBow;
import net.minecraft.src.game.item.ItemBowlOfFood;
import net.minecraft.src.game.item.ItemBrick;
import net.minecraft.src.game.item.ItemBucket;
import net.minecraft.src.game.item.ItemChair;
import net.minecraft.src.game.item.ItemChairCrimson;
import net.minecraft.src.game.item.ItemChairFirwood;
import net.minecraft.src.game.item.ItemChairStone;
import net.minecraft.src.game.item.ItemCookie;
import net.minecraft.src.game.item.ItemDoor;
import net.minecraft.src.game.item.ItemDye;
import net.minecraft.src.game.item.ItemDynamite;
import net.minecraft.src.game.item.ItemEgg;
import net.minecraft.src.game.item.ItemFireSword;
import net.minecraft.src.game.item.ItemFishingRod;
import net.minecraft.src.game.item.ItemFlintAndSteel;
import net.minecraft.src.game.item.ItemFood;
import net.minecraft.src.game.item.ItemHoe;
import net.minecraft.src.game.item.ItemLilyPad;
import net.minecraft.src.game.item.ItemMap;
import net.minecraft.src.game.item.ItemMilkBucket;
import net.minecraft.src.game.item.ItemMinecart;
import net.minecraft.src.game.item.ItemPainting;
import net.minecraft.src.game.item.ItemPickaxe;
import net.minecraft.src.game.item.ItemPlaceable;
import net.minecraft.src.game.item.ItemPotion;
import net.minecraft.src.game.item.ItemRecord;
import net.minecraft.src.game.item.ItemRedstone;
import net.minecraft.src.game.item.ItemSaddle;
import net.minecraft.src.game.item.ItemSeeds;
import net.minecraft.src.game.item.ItemShears;
import net.minecraft.src.game.item.ItemSign;
import net.minecraft.src.game.item.ItemSlice;
import net.minecraft.src.game.item.ItemSlimeBucket;
import net.minecraft.src.game.item.ItemSnowball;
import net.minecraft.src.game.item.ItemSpade;
import net.minecraft.src.game.item.ItemSpawnEgg;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.item.ItemSword;
import net.minecraft.src.game.item.ItemTable;
import net.minecraft.src.game.item.ItemTableCrimson;
import net.minecraft.src.game.item.ItemTableFirwood;
import net.minecraft.src.game.item.ItemTableGlass;
import net.minecraft.src.game.item.ItemTorch;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.stats.StatCollector;
import net.minecraft.src.game.stats.StatList;

public class Item {
    private int tooltipColor = -1073741824;
    public static final int COLOR_RED = Color.red.getRGB();
    public static final int COLOR_ORANGE = -119696024;
    public static final int COLOR_ORANGE_OTHER = -119896024;
    public static final int COLOR_YELLOW = -100999924;
    public static final int COLOR_GREEN = -999696024;
    public static final int COLOR_BLUE = -500000024;
    public static final int COLOR_PURPLE = -1100000024;
    public static final int COLOR_WHITE = -2130706433;
    protected static Random itemRand = new Random();
    public static Item[] itemsList = new Item[32000];
    public static Item shovelSteel = new ItemSpade(0, EnumToolMaterial.IRON).setIconCoord(2, 5).setItemName("shovelIron");
    public static Item pickaxeSteel = new ItemPickaxe(1, EnumToolMaterial.IRON).setIconCoord(2, 6).setItemName("pickaxeIron");
    public static Item axeSteel = new ItemAxe(2, EnumToolMaterial.IRON).setIconCoord(2, 7).setItemName("hatchetIron");
    public static Item flintAndSteel = new ItemFlintAndSteel(3).setIconCoord(0, 9).setItemName("flintAndSteel");
    public static Item appleRed = new ItemFood(4, 4, false).setIconCoord(10, 0).setItemName("apple");
    public static Item bow = new ItemBow(5).setIconCoord(1, 9).setItemName("bow");
    public static Item arrow = new ItemArrow(6).setIconCoord(2, 9).setItemName("arrow");
    public static Item coal = new Item(7).setIconCoord(7, 0).setItemName("coal");
    public static Item diamond = new Item(8).setIconCoord(7, 3).setItemName("emerald").setTooltipColor(-500000024);
    public static Item ingotIron = new Item(9).setIconCoord(7, 1).setItemName("ingotIron");
    public static Item ingotGold = new Item(10).setIconCoord(7, 2).setItemName("ingotGold").setTooltipColor(-100999924);
    public static Item swordSteel = new ItemSword(11, EnumToolMaterial.IRON).setIconCoord(2, 4).setItemName("swordIron");
    public static Item swordWood = new ItemSword(12, EnumToolMaterial.WOOD).setIconCoord(0, 4).setItemName("swordWood");
    public static Item shovelWood = new ItemSpade(13, EnumToolMaterial.WOOD).setIconCoord(0, 5).setItemName("shovelWood");
    public static Item pickaxeWood = new ItemPickaxe(14, EnumToolMaterial.WOOD).setIconCoord(0, 6).setItemName("pickaxeWood");
    public static Item axeWood = new ItemAxe(15, EnumToolMaterial.WOOD).setIconCoord(0, 7).setItemName("hatchetWood");
    public static Item swordStone = new ItemSword(16, EnumToolMaterial.STONE).setIconCoord(1, 4).setItemName("swordStone");
    public static Item shovelStone = new ItemSpade(17, EnumToolMaterial.STONE).setIconCoord(1, 5).setItemName("shovelStone");
    public static Item pickaxeStone = new ItemPickaxe(18, EnumToolMaterial.STONE).setIconCoord(1, 6).setItemName("pickaxeStone");
    public static Item axeStone = new ItemAxe(19, EnumToolMaterial.STONE).setIconCoord(1, 7).setItemName("hatchetStone");
    public static Item swordDiamond = new ItemSword(20, EnumToolMaterial.EMERALD).setIconCoord(3, 4).setItemName("swordDiamond").setTooltipColor(-500000024);
    public static Item shovelDiamond = new ItemSpade(21, EnumToolMaterial.EMERALD).setIconCoord(3, 5).setItemName("shovelDiamond").setTooltipColor(-500000024);
    public static Item pickaxeDiamond = new ItemPickaxe(22, EnumToolMaterial.EMERALD).setIconCoord(3, 6).setItemName("pickaxeDiamond").setTooltipColor(-500000024);
    public static Item axeDiamond = new ItemAxe(23, EnumToolMaterial.EMERALD).setIconCoord(3, 7).setItemName("hatchetDiamond").setTooltipColor(-500000024);
    public static Item stick = new Item(24).setIconCoord(3, 9).setFull3D().setItemName("stick");
    public static Item bowlEmpty = new Item(25).setIconCoord(7, 4).setItemName("bowl");
    public static Item bowlSoup = new ItemBowlOfFood(26, 8).setIconCoord(8, 4).setItemName("mushroomStew");
    public static Item swordGold = new ItemSword(27, EnumToolMaterial.GOLD).setIconCoord(4, 4).setItemName("swordGold").setTooltipColor(-100999924);
    public static Item shovelGold = new ItemSpade(28, EnumToolMaterial.GOLD).setIconCoord(4, 5).setItemName("shovelGold").setTooltipColor(-100999924);
    public static Item pickaxeGold = new ItemPickaxe(29, EnumToolMaterial.GOLD).setIconCoord(4, 6).setItemName("pickaxeGold").setTooltipColor(-100999924);
    public static Item axeGold = new ItemAxe(30, EnumToolMaterial.GOLD).setIconCoord(4, 7).setItemName("hatchetGold").setTooltipColor(-100999924);
    public static Item silk = new Item(31).setIconCoord(8, 0).setItemName("string");
    public static Item feather = new Item(32).setIconCoord(8, 1).setItemName("feather");
    public static Item gunpowder = new Item(33).setIconCoord(8, 2).setItemName("sulphur");
    public static Item hoeWood = new ItemHoe(34, EnumToolMaterial.WOOD).setIconCoord(0, 8).setItemName("hoeWood");
    public static Item hoeStone = new ItemHoe(35, EnumToolMaterial.STONE).setIconCoord(1, 8).setItemName("hoeStone");
    public static Item hoeSteel = new ItemHoe(36, EnumToolMaterial.IRON).setIconCoord(2, 8).setItemName("hoeIron");
    public static Item hoeDiamond = new ItemHoe(37, EnumToolMaterial.EMERALD).setIconCoord(3, 8).setItemName("hoeDiamond").setTooltipColor(-500000024);
    public static Item hoeGold = new ItemHoe(38, EnumToolMaterial.GOLD).setIconCoord(4, 8).setItemName("hoeGold").setTooltipColor(-100999924);
    public static Item seeds = new ItemSeeds(39, Block.crops.blockID).setIconCoord(9, 0).setItemName("seeds");
    public static Item wheat = new Item(40).setIconCoord(9, 1).setItemName("wheat");
    public static Item bread = new ItemFood(41, 5, false).setIconCoord(9, 2).setItemName("bread");
    public static Item helmetLeather = new ItemArmor(42, 99, 0, 0).setIconCoord(0, 0).setItemName("helmetCloth");
    public static Item plateLeather = new ItemArmor(43, 144, 0, 1).setIconCoord(0, 1).setItemName("chestplateCloth");
    public static Item legsLeather = new ItemArmor(44, 135, 0, 2).setIconCoord(0, 2).setItemName("leggingsCloth");
    public static Item bootsLeather = new ItemArmor(45, 117, 0, 3).setIconCoord(0, 3).setItemName("bootsCloth");
    public static Item helmetChain = new ItemArmor(46, 264, 1, 0).setIconCoord(1, 0).setItemName("helmetChain");
    public static Item plateChain = new ItemArmor(47, 384, 1, 1).setIconCoord(1, 1).setItemName("chestplateChain");
    public static Item legsChain = new ItemArmor(48, 360, 1, 2).setIconCoord(1, 2).setItemName("leggingsChain");
    public static Item bootsChain = new ItemArmor(49, 312, 1, 3).setIconCoord(1, 3).setItemName("bootsChain");
    public static Item helmetSteel = new ItemArmor(50, 330, 2, 0).setIconCoord(2, 0).setItemName("helmetIron");
    public static Item plateSteel = new ItemArmor(51, 480, 2, 1).setIconCoord(2, 1).setItemName("chestplateIron");
    public static Item legsSteel = new ItemArmor(52, 450, 2, 2).setIconCoord(2, 2).setItemName("leggingsIron");
    public static Item bootsSteel = new ItemArmor(53, 390, 2, 3).setIconCoord(2, 3).setItemName("bootsIron");
    public static Item helmetDiamond = new ItemArmor(54, 792, 3, 0).setIconCoord(3, 0).setItemName("helmetDiamond").setTooltipColor(-500000024);
    public static Item plateDiamond = new ItemArmor(55, 1152, 3, 1).setIconCoord(3, 1).setItemName("chestplateDiamond").setTooltipColor(-500000024);
    public static Item legsDiamond = new ItemArmor(56, 1080, 3, 2).setIconCoord(3, 2).setItemName("leggingsDiamond").setTooltipColor(-500000024);
    public static Item bootsDiamond = new ItemArmor(57, 936, 3, 3).setIconCoord(3, 3).setItemName("bootsDiamond").setTooltipColor(-500000024);
    public static Item helmetGold = new ItemArmor(58, 330, 5, 0).setIconCoord(4, 0).setItemName("helmetGold").setTooltipColor(-100999924);
    public static Item plateGold = new ItemArmor(59, 480, 5, 1).setIconCoord(4, 1).setItemName("chestplateGold").setTooltipColor(-100999924);
    public static Item legsGold = new ItemArmor(60, 450, 5, 2).setIconCoord(4, 2).setItemName("leggingsGold").setTooltipColor(-100999924);
    public static Item bootsGold = new ItemArmor(61, 390, 5, 3).setIconCoord(4, 3).setItemName("bootsGold").setTooltipColor(-100999924);
    public static Item flint = new Item(62).setIconCoord(6, 0).setItemName("flint");
    public static Item porkRaw = new ItemFood(63, 3, true).setIconCoord(7, 5).setItemName("porkchopRaw");
    public static Item porkCooked = new ItemFood(64, 8, true).setIconCoord(8, 5).setItemName("porkchopCooked");
    public static Item painting = new ItemPainting(65).setIconCoord(10, 1).setItemName("painting");
    public static Item appleGold = new ItemFood(66, 42, false).setIconCoord(11, 0).setItemName("appleGold").setTooltipColor(-100999924);
    public static Item sign = new ItemSign(67).setIconCoord(10, 2).setItemName("sign");
    public static Item doorWood = new ItemDoor(68, Material.wood, 0).setIconCoord(11, 2).setItemName("doorWood");
    public static Item bucketEmpty = new ItemBucket(69, 0).setIconCoord(10, 4).setItemName("bucket");
    public static Item bucketWater = new ItemBucket(70, Block.waterMoving.blockID).setIconCoord(11, 4).setItemName("bucketWater").setContainerItem(bucketEmpty);
    public static Item bucketLava = new ItemBucket(71, Block.lavaMoving.blockID).setIconCoord(12, 4).setItemName("bucketLava").setContainerItem(bucketEmpty);
    public static Item minecartEmpty = new ItemMinecart(72, 0).setIconCoord(7, 8).setItemName("minecart");
    public static Item saddle = new ItemSaddle(73).setIconCoord(8, 6).setItemName("saddle").setTooltipColor(-999696024);
    public static Item doorSteel = new ItemDoor(74, Material.iron, 0).setIconCoord(12, 2).setItemName("doorIron");
    public static Item redstone = new ItemRedstone(75).setIconCoord(8, 3).setItemName("redstone");
    public static Item snowball = new ItemSnowball(76).setIconCoord(14, 0).setItemName("snowball");
    public static Item boat = new ItemBoat(77).setIconCoord(8, 8).setItemName("boat");
    public static Item leather = new Item(78).setIconCoord(7, 6).setItemName("leather");
    public static Item bucketMilk = new ItemMilkBucket(79).setIconCoord(13, 4).setItemName("milk").setContainerItem(bucketEmpty);
    public static Item brick = new ItemBrick(80).setIconCoord(6, 1).setItemName("brick");
    public static Item clay = new Item(81).setIconCoord(9, 3).setItemName("clay");
    public static Item reed = new ItemPlaceable(82, Block.sugarCane).setIconCoord(11, 1).setItemName("reeds");
    public static Item paper = new Item(83).setIconCoord(10, 3).setItemName("paper");
    public static Item book = new Item(84).setIconCoord(11, 3).setItemName("book");
    public static Item slimeBall = new Item(85).setIconCoord(14, 1).setItemName("slimeball");
    public static Item minecartCrate = new ItemMinecart(86, 1).setIconCoord(7, 9).setItemName("minecartChest");
    public static Item minecartPowered = new ItemMinecart(87, 2).setIconCoord(7, 10).setItemName("minecartFurnace");
    public static Item egg = new ItemEgg(88).setIconCoord(12, 0).setItemName("egg");
    public static Item compass = new Item(89).setIconCoord(6, 3).setItemName("compass");
    public static Item fishingRod = new ItemFishingRod(90).setIconCoord(4, 9).setItemName("fishingRod");
    public static Item clock = new Item(91).setIconCoord(6, 4).setItemName("clock");
    public static Item lightStoneDust = new Item(92).setIconCoord(9, 4).setItemName("yellowDust");
    public static Item fishRaw = new ItemFood(93, 2, false).setIconCoord(9, 5).setItemName("fishRaw");
    public static Item fishCooked = new ItemFood(94, 5, false).setIconCoord(10, 5).setItemName("fishCooked");
    public static Item dyePowder = new ItemDye(95).setIconCoord(14, 4).setItemName("dyePowder");
    public static Item bone = new Item(96).setIconCoord(12, 1).setItemName("bone").setFull3D();
    public static Item sugar = new Item(97).setIconCoord(13, 0).setItemName("sugar").setFull3D();
    public static Item cake = new ItemPlaceable(98, Block.cake).setMaxStackSize(1).setIconCoord(13, 1).setItemName("cake");
    public static Item bed = new ItemBed(99).setMaxStackSize(1).setIconCoord(13, 2).setItemName("bed");
    public static Item redstoneRepeater = new ItemPlaceable(100, Block.blockLapis).setIconCoord(6, 5).setItemName("diode");
    public static Item cookie = new ItemCookie(101, 1, false, 8, false).setIconCoord(12, 5).setItemName("cookie");
    public static ItemMap mapItem = (ItemMap)new ItemMap(102).setIconCoord(12, 3).setItemName("map");
    public static ItemShears shears = (ItemShears)new ItemShears(103).setIconCoord(13, 5).setItemName("shears");
    public static Item record13 = new ItemRecord(2000, "13").setIconCoord(0, 15).setItemName("record").setTooltipColor(-999696024);
    public static Item recordCat = new ItemRecord(2001, "cat").setIconCoord(1, 15).setItemName("record").setTooltipColor(-999696024);
    public static Item goldenArrow = new ItemArrow(104).setIconCoord(7, 7).setItemName("goldArrow").setTooltipColor(-100999924);
    public static Item blueberry = new ItemCookie(105, 1, false, 8, true).setIconCoord(8, 7).setItemName("blueberry");
    public static Item potato = new ItemSeeds(106, Block.cropsPotato.blockID).setIconCoord(9, 6).setItemName("potato");
    public static Item potatoCooked = new ItemFood(107, 6, true).setIconCoord(10, 6).setItemName("potatoCooked");
    public static Item carrotSeeds = new ItemSeeds(108, Block.cropsCarrot.blockID).setIconCoord(9, 7).setItemName("carrotSeeds");
    public static Item carrot = new ItemFood(109, 3, true).setIconCoord(10, 7).setItemName("carrot");
    public static Item chairOak = new ItemChair(110, 0).setIconCoord(13, 9).setItemName("chair");
    public static Item chairCrimson = new ItemChairCrimson(111, 0).setIconCoord(13, 10).setItemName("chair.crimson");
    public static Item chairFir = new ItemChairFirwood(112, 0).setIconCoord(13, 11).setItemName("chair.firwood");
    public static Item tableOak = new ItemTable(113, 0).setIconCoord(13, 6).setItemName("table");
    public static Item tableCrimson = new ItemTableCrimson(114, 0).setIconCoord(13, 7).setItemName("table.crimson");
    public static Item tableFir = new ItemTableFirwood(115, 0).setIconCoord(13, 8).setItemName("table.firwood");
    public static Item chairStone = new ItemChairStone(116, 0).setIconCoord(13, 12).setItemName("chair.stone");
    public static Item bucketSlime = new ItemSlimeBucket(117).setIconCoord(0, 10).setItemName("bucketSlime");
    public static Item doorCrimsonItem = new ItemDoor(118, Material.wood, 1).setIconCoord(11, 6).setItemName("doorCrimson");
    public static Item doorFirwoodItem = new ItemDoor(119, Material.wood, 2).setIconCoord(11, 7).setItemName("doorFirwood");
    public static Item dynamite = new ItemDynamite(120).setIconCoord(6, 5).setItemName("dynamite");
    public static Item waterlily = new ItemLilyPad(121, Block.waterlily).setIconCoord(11, 10).setItemName("waterlily");
    public static Item lilypad = new ItemLilyPad(122, Block.lilypad).setIconCoord(10, 10).setItemName("lilypad");
    public static Item tableGlass = new ItemTableGlass(123, 0).setIconCoord(13, 14).setItemName("tableGlass");
    public static Item cakeSlice;
    public static Item cheddarCheese;
    public static Item cheeseWheel;
    public static Item cowSpawnEgg;
    public static Item pigSpawnEgg;
    public static Item chickenSpawnEgg;
    public static Item zombieSpawnEgg;
    public static Item skeletonSpawnEgg;
    public static Item creeperSpawnEgg;
    public static Item spiderSpawnEgg;
    public static Item blazeSpawnEgg;
    public static Item zombiepigmanSpawnEgg;
    public static Item slimeSpawnEgg;
    public static Item mooshroomSpawnEgg;
    public static Item moobloomSpawnEgg;
    public static Item sheepSpawnEgg;
    public static Item stroldianSpawnEgg;
    public static Item armoredZombieSpawnEgg;
    public static Item armoredSkeletonSpawnEgg;
    public static Item giantZombieSpawnEgg;
    public static Item foxSpawnEgg;
    public static Item wolfSpawnEgg;
    public static Item stickyTorch;
    public static Item swordFire;
    public static Item shovelFire;
    public static Item pickaxeFire;
    public static Item axeFire;
    public static Item hoeFire;
    public static Item ash;
    public static Item elytra;
    public static Item eggCooked;
    public static Item bowlIceCream;
    public static Item ears;
    public static Item swordObsidian;
    public static Item shovelObsidian;
    public static Item pickaxeObsidian;
    public static Item axeObsidian;
    public static Item hoeObsidian;
    public static Item potion;
    public static Item bottle;
    public final int itemID;
    protected int maxStackSize = 64;
    private int maxDamage = 0;
    protected int iconIndex;
    protected boolean bFull3D = false;
    protected boolean hasSubtypes = false;
    private Item containerItem = null;
    private String itemName;
    protected boolean cFull3D = false;
    protected boolean dFull3D = false;
    public int itemCooldown = 0;

    static {
        cheddarCheese = new ItemSlice(124, 2, 4).setIconCoord(6, 10).setItemName("cheddarCheese");
        cakeSlice = new ItemSlice(125, 9, 2).setIconCoord(6, 8).setItemName("cakeSlice");
        cheeseWheel = new ItemPlaceable(126, Block.cheeseWheel).setMaxStackSize(1).setIconCoord(6, 11).setItemName("cheeseWheel");
        cowSpawnEgg = new ItemSpawnEgg(127, "cow").setIconCoord(6, 31).setItemName("spawnEgg.cow");
        pigSpawnEgg = new ItemSpawnEgg(128, "pig").setIconCoord(3, 31).setItemName("spawnEgg.pig");
        chickenSpawnEgg = new ItemSpawnEgg(129, "chicken").setIconCoord(6, 30).setItemName("spawnEgg.chicken");
        sheepSpawnEgg = new ItemSpawnEgg(130, "sheep").setIconCoord(2, 31).setItemName("spawnEgg.sheep");
        slimeSpawnEgg = new ItemSpawnEgg(131, "slime").setIconCoord(0, 31).setItemName("spawnEgg.slime");
        foxSpawnEgg = new ItemSpawnEgg(132, "fox").setIconCoord(14, 31).setItemName("spawnEgg.fox");
        wolfSpawnEgg = new ItemSpawnEgg(133, "wolf").setIconCoord(11, 31).setItemName("spawnEgg.wolf");
        zombieSpawnEgg = new ItemSpawnEgg(134, "zombie").setIconCoord(5, 31).setItemName("spawnEgg.zombie");
        skeletonSpawnEgg = new ItemSpawnEgg(135, "skeleton").setIconCoord(1, 31).setItemName("spawnEgg.skeleton");
        creeperSpawnEgg = new ItemSpawnEgg(136, "creeper").setIconCoord(7, 31).setItemName("spawnEgg.creeper");
        spiderSpawnEgg = new ItemSpawnEgg(137, "spider").setIconCoord(4, 31).setItemName("spawnEgg.spider");
        zombiepigmanSpawnEgg = new ItemSpawnEgg(138, "pigzombie").setIconCoord(8, 31).setItemName("spawnEgg.zombiepigman");
        blazeSpawnEgg = new ItemSpawnEgg(139, "blaze").setIconCoord(10, 31).setItemName("spawnEgg.blaze");
        mooshroomSpawnEgg = new ItemSpawnEgg(140, "mooshroom").setIconCoord(12, 31).setItemName("spawnEgg.mooshroom");
        moobloomSpawnEgg = new ItemSpawnEgg(141, "moobloom").setIconCoord(13, 31).setItemName("spawnEgg.moobloom");
        giantZombieSpawnEgg = new ItemSpawnEgg(142, "giant").setIconCoord(5, 29).setItemName("spawnEgg.giantZombie");
        stickyTorch = new ItemTorch(143).setIconCoord(6, 6).setItemName("torch");
        swordFire = new ItemFireSword(144).setIconCoord(5, 4).setItemName("swordFire").setTooltipColor(COLOR_RED);
        shovelFire = new ItemSpade(145, EnumToolMaterial.FIRE).setIconCoord(5, 5).setItemName("shovelFire").setTooltipColor(COLOR_RED);
        pickaxeFire = new ItemPickaxe(146, EnumToolMaterial.FIRE).setIconCoord(5, 6).setItemName("pickaxeFire").setTooltipColor(COLOR_RED);
        axeFire = new ItemAxe(147, EnumToolMaterial.FIRE).setIconCoord(5, 7).setItemName("hatchetFire").setTooltipColor(COLOR_RED);
        hoeFire = new ItemHoe(148, EnumToolMaterial.FIRE).setIconCoord(5, 8).setItemName("hoeFire").setTooltipColor(COLOR_RED);
        ash = new Item(149).setIconCoord(8, 3).setItemName("ash");
        eggCooked = new ItemFood(150, 5, false).setIconCoord(4, 10).setItemName("cookedEgg");
        bowlIceCream = new ItemBowlOfFood(151, 10).setIconCoord(5, 10).setItemName("icecream");
        swordObsidian = new ItemSword(160, EnumToolMaterial.OBSITE).setIconCoord(1, 10).setItemName("swordObsidian").setTooltipColor(-1100000024);
        shovelObsidian = new ItemSpade(161, EnumToolMaterial.OBSITE).setIconCoord(1, 11).setItemName("shovelObsidian").setTooltipColor(-1100000024);
        pickaxeObsidian = new ItemPickaxe(162, EnumToolMaterial.OBSITE).setIconCoord(1, 12).setItemName("pickaxeObsidian").setTooltipColor(-1100000024);
        axeObsidian = new ItemAxe(163, EnumToolMaterial.OBSITE).setIconCoord(1, 13).setItemName("hatchetObsidian").setTooltipColor(-1100000024);
        hoeObsidian = new ItemHoe(164, EnumToolMaterial.OBSITE).setIconCoord(1, 14).setItemName("hoeObsidian").setTooltipColor(-1100000024);
        potion = new ItemPotion(165).setIconCoord(2, 16).setItemName("potion");
        bottle = new Item(166).setIconCoord(3, 16).setItemName("bottle");
        StatList.func_25151_b();
    }

    protected Item(int id) {
        this.itemID = 256 + id;
        if (itemsList[256 + id] != null) {
            System.out.println("CONFLICT WITH ITEM ID " + id);
        }
        Item.itemsList[256 + id] = this;
    }

    public Item setIconIndex(int indexCoord) {
        this.iconIndex = indexCoord;
        return this;
    }

    public Item setMaxStackSize(int maxAmount) {
        this.maxStackSize = maxAmount;
        return this;
    }

    public Item setIconCoord(int xPos, int yPos) {
        this.iconIndex = xPos + yPos * 16;
        return this;
    }

    public int getIconFromDamage(int damageMetadata) {
        return this.iconIndex;
    }

    public final int getIconIndex(ItemStack itemstack) {
        return this.getIconFromDamage(itemstack.getItemDamage());
    }

    public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int xCoord, int yCoord, int zCoord, int var7) {
        return false;
    }

    public float getStrVsBlock(ItemStack itemstack, Block block) {
        return 1.0f;
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        return itemstack;
    }

    public int getItemStackLimit() {
        return this.maxStackSize;
    }

    public int getPlacedBlockMetadata(int damageMetadata) {
        return 0;
    }

    public boolean getHasSubtypes() {
        return this.hasSubtypes;
    }

    protected Item setHasSubtypes(boolean bool) {
        this.hasSubtypes = bool;
        return this;
    }

    public int getMaxDamage() {
        return this.maxDamage;
    }

    protected Item setMaxDamage(int maxDamageMetadata) {
        this.maxDamage = maxDamageMetadata;
        return this;
    }

    public boolean isDamagable() {
        return this.maxDamage > 0 && !this.hasSubtypes;
    }

    public boolean hitEntity(ItemStack itemstack, EntityLiving entitylivingTarget, EntityLiving entitylivingOperator) {
        return false;
    }

    public boolean onBlockDestroyed(ItemStack itemstack, int xCoord, int yCoord, int zCoord, int damageMetadata, EntityLiving entityliving) {
        return false;
    }

    public int getDamageVsEntity(Entity entity) {
        return 1;
    }

    public boolean canHarvestBlock(Block block) {
        return false;
    }

    public void saddleEntity(ItemStack itemstack, EntityLiving entityliving, EntityPlayer player) {
    }

    public Item setFull3D() {
        this.bFull3D = true;
        return this;
    }

    public boolean isFull3D() {
        return this.bFull3D;
    }

    public boolean isBow3D() {
        return this.cFull3D;
    }

    public boolean isArrow3D() {
        return this.dFull3D;
    }

    public boolean shouldRotateAroundWhenRendering() {
        return false;
    }

    public Item setItemName(String itemDisplayName) {
        this.itemName = "item." + itemDisplayName;
        return this;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getItemNameIS(ItemStack itemstack) {
        return this.itemName;
    }

    public Item setContainerItem(Item item) {
        if (this.maxStackSize > 1) {
            throw new IllegalArgumentException("Max stack size must be 1 for items with crafting results");
        }
        this.containerItem = item;
        return this;
    }

    public Item getContainerItem() {
        return this.containerItem;
    }

    public boolean hasContainerItem() {
        return this.containerItem != null;
    }

    public String getStatName() {
        return StatCollector.translateToLocal(String.valueOf(this.getItemName()) + ".name");
    }

    public int getColorFromDamage(int var1) {
        return 0xFFFFFF;
    }

    public int setCurrentCooldown(int cooldown) {
        this.itemCooldown = cooldown;
        return this.itemCooldown;
    }

    public void onUpdate(ItemStack itemstack, World world, Entity entity, int var4, boolean var5) {
        if (entity instanceof EntityPlayer && this instanceof ItemFood) {
            EntityPlayer player = (EntityPlayer)entity;
            ItemFood foodItem = (ItemFood)this;
            foodItem.itemCooldown = player.itemCooldown;
        }
    }

    public void onCreated(ItemStack itemstack, World world, EntityPlayer entityliving) {
    }

    public Item setTooltipColor(int color) {
        this.tooltipColor = color;
        return this;
    }

    public int getTooltipColor() {
        return this.tooltipColor;
    }

    protected MovingObjectPosition func_40402_a(World world, EntityPlayer entityplayer, boolean flag) {
        float posAligned = 1.0f;
        float playerPitch = entityplayer.prevRotationPitch + (entityplayer.rotationPitch - entityplayer.prevRotationPitch) * posAligned;
        float playerYaw = entityplayer.prevRotationYaw + (entityplayer.rotationYaw - entityplayer.prevRotationYaw) * posAligned;
        double playerXCoord = entityplayer.prevPosX + (entityplayer.posX - entityplayer.prevPosX) * (double)posAligned;
        double playerYCoord = entityplayer.prevPosY + (entityplayer.posY - entityplayer.prevPosY) * (double)posAligned + 1.62 - (double)entityplayer.yOffset;
        double playerZCoord = entityplayer.prevPosZ + (entityplayer.posZ - entityplayer.prevPosZ) * (double)posAligned;
        Vec3D vectorPosition = Vec3D.createVector(playerXCoord, playerYCoord, playerZCoord);
        float f3 = MathHelper.cos(-playerYaw * 0.01745329f - 3.141593f);
        float f4 = MathHelper.sin(-playerYaw * 0.01745329f - 3.141593f);
        float f5 = -MathHelper.cos(-playerPitch * 0.01745329f);
        float f6 = MathHelper.sin(-playerPitch * 0.01745329f);
        float f7 = f4 * f5;
        float f8 = f6;
        float f9 = f3 * f5;
        double raytraceAligned = 5.0;
        Vec3D vectorRaytrace = vectorPosition.addVector((double)f7 * raytraceAligned, (double)f8 * raytraceAligned, (double)f9 * raytraceAligned);
        MovingObjectPosition movingobjectposition = world.rayTraceBlocks_do_do(vectorPosition, vectorRaytrace, flag, !flag);
        return movingobjectposition;
    }

    public EnumAction getItemUseAction(ItemStack var1) {
        return EnumAction.none;
    }

    public int getMaxItemUseDuration(ItemStack var1) {
        return 0;
    }

    public void onPlayerStoppedUsing(ItemStack var1, World var2, EntityPlayer var3, int var4) {
    }

    public ItemStack onFoodEaten(ItemStack var1, World var2, EntityPlayer var3) {
        return var1;
    }
}

