/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.entity.player;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.src.client.gui.Container;
import net.minecraft.src.client.gui.ContainerPlayer;
import net.minecraft.src.client.inventory.IInventory;
import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.client.renderer.Vec3D;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.achievements.AchievementList;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockBed;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.block.tileentity.TileEntity;
import net.minecraft.src.game.block.tileentity.TileEntityAnvil;
import net.minecraft.src.game.block.tileentity.TileEntityBlastFurnace;
import net.minecraft.src.game.block.tileentity.TileEntityDispenser;
import net.minecraft.src.game.block.tileentity.TileEntityFurnace;
import net.minecraft.src.game.block.tileentity.TileEntitySign;
import net.minecraft.src.game.entity.DamageSource;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.entity.EntityMob;
import net.minecraft.src.game.entity.animals.EntityFox;
import net.minecraft.src.game.entity.animals.EntityPig;
import net.minecraft.src.game.entity.animals.EntityWolf;
import net.minecraft.src.game.entity.monster.EntityBlaze;
import net.minecraft.src.game.entity.monster.EntityCreeper;
import net.minecraft.src.game.entity.monster.EntityGhast;
import net.minecraft.src.game.entity.other.EntityArrow;
import net.minecraft.src.game.entity.other.EntityArrowPurple;
import net.minecraft.src.game.entity.other.EntityBoat;
import net.minecraft.src.game.entity.other.EntityFish;
import net.minecraft.src.game.entity.other.EntityItem;
import net.minecraft.src.game.entity.other.EntityMinecart;
import net.minecraft.src.game.entity.player.EnumPlayerAction;
import net.minecraft.src.game.entity.player.InventoryPlayer;
import net.minecraft.src.game.entity.player.PlayerCapabilities;
import net.minecraft.src.game.item.EnumAction;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.EnumStatus;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.level.chunk.ChunkCoordinates;
import net.minecraft.src.game.level.chunk.IChunkProvider;
import net.minecraft.src.game.nbt.NBTTagCompound;
import net.minecraft.src.game.nbt.NBTTagList;
import net.minecraft.src.game.stats.StatBase;
import net.minecraft.src.game.stats.StatList;
import org.lwjgl.input.Mouse;

public abstract class EntityPlayer
extends EntityLiving {
    public InventoryPlayer inventory = new InventoryPlayer(this);
    public Container inventorySlots;
    public Container craftingInventory;
    public byte field_9371_f = 0;
    public long score = 0L;
    public float field_775_e;
    public float field_774_f;
    public boolean isSwinging = false;
    public int swingProgressInt = 0;
    public String username;
    public int dimension;
    public String playerCloakUrl;
    public double field_20066_r;
    public double field_20065_s;
    public double field_20064_t;
    public double field_20063_u;
    public double field_20062_v;
    public double field_20061_w;
    protected boolean sleeping;
    public ChunkCoordinates bedChunkCoordinates;
    private int sleepTimer;
    public float field_22063_x;
    public float field_22062_y;
    public float field_22061_z;
    private ChunkCoordinates playerSpawnCoordinate;
    private ChunkCoordinates startMinecartRidingCoordinate;
    public int timeUntilPortal = 20;
    protected boolean inPortal = false;
    public float timeInPortal;
    public float prevTimeInPortal;
    private int damageRemainder = 0;
    public EntityFish fishEntity = null;
    public PlayerCapabilities capabilities;
    public DamageSource damagesource;
    protected int flyToggleTimer;
    public boolean isWearingGlassHelmet = false;
    private EnumPlayerAction action = EnumPlayerAction.NORMAL;
    public int bowCounter;
    public float fovModif = 0.0f;
    protected int ticksElytraFlying = 0;
    public float rotateElytraX;
    public float rotateElytraY;
    public float rotateElytraZ;
    public int speedCounter;
    public int stamina = 0;
    public int staminaNegation = 0;
    public boolean exhausted = false;
    public int itemCooldown = 0;
    public List effects = new ArrayList();
    public int zoomFov = 0;
    public boolean showExtraDebug = true;
    private ItemStack itemInUse;
    private int itemInUseCount;

    public EntityPlayer(World var1) {
        super(var1);
        this.craftingInventory = this.inventorySlots = new ContainerPlayer(this.inventory, !var1.multiplayerWorld);
        this.yOffset = 1.62f;
        ChunkCoordinates var2 = var1.getSpawnPoint();
        this.setLocationAndAngles((double)var2.x + 0.5, var2.y + 1, (double)var2.z + 0.5, 0.0f, 0.0f);
        this.health = 20;
        this.field_9351_C = "humanoid";
        this.field_9353_B = 180.0f;
        this.fireResistance = 20;
        this.texture = "/mob/char.png";
        this.capabilities = new PlayerCapabilities();
        this.flyToggleTimer = 0;
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (byte)0);
    }

    @Override
    public void onUpdate() {
        if (this.itemInUse != null) {
            ItemStack var1 = this.inventory.getCurrentItem();
            if (var1 != this.itemInUse) {
                this.clearItemInUse();
            } else {
                if (this.itemInUseCount <= 25 && this.itemInUseCount % 4 == 0) {
                    this.updateItemUse(var1, 5);
                }
                if (--this.itemInUseCount == 0 && !this.worldObj.isRemote) {
                    this.onItemUseFinish();
                }
            }
        }
        this.effects.clear();
        if (this.itemCooldown > 0) {
            --this.itemCooldown;
        }
        if (this.speedCounter > 0) {
            --this.speedCounter;
        }
        if (this.action.equals((Object)EnumPlayerAction.BOW)) {
            ++this.bowCounter;
            if (this.bowCounter > 14) {
                this.bowCounter = 14;
            }
        }
        if (this.action.equals((Object)EnumPlayerAction.NORMAL)) {
            this.bowCounter = 0;
        }
        if (this.isPlayerSleeping()) {
            ++this.sleepTimer;
            if (this.sleepTimer > 100) {
                this.sleepTimer = 100;
            }
            if (!this.worldObj.multiplayerWorld) {
                if (!this.isInBed()) {
                    this.wakeUpPlayer(true, true, false);
                } else if (this.worldObj.isDaytime()) {
                    this.wakeUpPlayer(false, true, true);
                }
            }
        } else if (this.sleepTimer > 0) {
            ++this.sleepTimer;
            if (this.sleepTimer >= 110) {
                this.sleepTimer = 0;
            }
        }
        super.onUpdate();
        if (!this.worldObj.multiplayerWorld && this.craftingInventory != null && !this.craftingInventory.isUsableByPlayer(this)) {
            this.closeScreen();
            this.craftingInventory = this.inventorySlots;
        }
        if (this.capabilities.isFlying) {
            int i = 0;
            while (i < 8) {
                ++i;
            }
        }
        if (this.isBurning() && this.capabilities.disableDamage) {
            this.func_40045_B();
        }
        this.field_20066_r = this.field_20063_u;
        this.field_20065_s = this.field_20062_v;
        this.field_20064_t = this.field_20061_w;
        double var1 = this.posX - this.field_20063_u;
        double var3 = this.posY - this.field_20062_v;
        double var5 = this.posZ - this.field_20061_w;
        double var7 = 10.0;
        if (var1 > var7) {
            this.field_20066_r = this.field_20063_u = this.posX;
        }
        if (var5 > var7) {
            this.field_20064_t = this.field_20061_w = this.posZ;
        }
        if (var3 > var7) {
            this.field_20065_s = this.field_20062_v = this.posY;
        }
        if (var1 < -var7) {
            this.field_20066_r = this.field_20063_u = this.posX;
        }
        if (var5 < -var7) {
            this.field_20064_t = this.field_20061_w = this.posZ;
        }
        if (var3 < -var7) {
            this.field_20065_s = this.field_20062_v = this.posY;
        }
        this.field_20063_u += var1 * 0.25;
        this.field_20061_w += var5 * 0.25;
        this.field_20062_v += var3 * 0.25;
        this.addStat(StatList.minutesPlayedStat, 1);
        if (this.ridingEntity == null) {
            this.startMinecartRidingCoordinate = null;
        }
        this.ticksElytraFlying = this.isElytraFlying() ? ++this.ticksElytraFlying : 0;
        if (this.isElytraFlying()) {
            double d11;
            double d3;
            float f5;
            if (this.motionY > -0.5) {
                this.fallDistance = 1.0f;
            }
            Vec3D vec3d = this.getLookVec();
            float f = this.rotationPitch * ((float)Math.PI / 180);
            double d6 = Math.sqrt(vec3d.xCoord * vec3d.xCoord + vec3d.zCoord * vec3d.zCoord);
            double d8 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
            double d1 = vec3d.lengthVector();
            float f4 = MathHelper.cos(f);
            f4 = (float)((double)f4 * (double)f4 * Math.min(1.0, d1 / 0.4));
            this.motionY += -0.08 + (double)f4 * 0.06;
            if (this.motionY < 0.0 && d6 > 0.0) {
                double d2 = this.motionY * -0.1 * (double)f4;
                this.motionY += d2;
                this.motionX += vec3d.xCoord * d2 / d6;
                this.motionZ += vec3d.zCoord * d2 / d6;
            }
            if (f < 0.0f) {
                double d10 = d8 * (double)(-MathHelper.sin(f)) * 0.04;
                this.motionY += d10 * 3.2;
                this.motionX -= vec3d.xCoord * d10 / d6;
                this.motionZ -= vec3d.zCoord * d10 / d6;
            }
            if (d6 > 0.0) {
                this.motionX += (vec3d.xCoord / d6 * d8 - this.motionX) * 0.1;
                this.motionZ += (vec3d.zCoord / d6 * d8 - this.motionZ) * 0.1;
            }
            this.motionX *= (double)0.99f;
            this.motionY *= (double)0.98f;
            this.motionZ *= (double)0.99f;
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            if (this.isCollidedHorizontally && !this.worldObj.multiplayerWorld && (f5 = (float)((d3 = d8 - (d11 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ))) * 10.0 - 3.0)) > 0.0f) {
                this.attackEntityFrom(null, (int)f5 * 5);
            }
            if (this.onGround && !this.worldObj.multiplayerWorld) {
                this.setEntityFlag(7, false);
            }
        }
    }

    @Override
    protected boolean isMovementBlocked() {
        return this.health <= 0 || this.isPlayerSleeping();
    }

    protected void closeScreen() {
        this.craftingInventory = this.inventorySlots;
    }

    @Override
    public void updateCloak() {
        this.cloakUrl = this.playerCloakUrl = "http://www.betacraft.uk/MinecraftCloaks/" + this.username + ".png";
    }

    @Override
    public void updateRidden() {
        double var1 = this.posX;
        double var3 = this.posY;
        double var5 = this.posZ;
        super.updateRidden();
        this.field_775_e = this.field_774_f;
        this.field_774_f = 0.0f;
        this.addMountedMovementStat(this.posX - var1, this.posY - var3, this.posZ - var5);
    }

    @Override
    public void preparePlayerToSpawn() {
        this.yOffset = 1.62f;
        this.setSize(0.6f, 1.8f);
        super.preparePlayerToSpawn();
        this.health = 20;
        this.deathTime = 0;
    }

    @Override
    protected void updatePlayerActionState() {
        if (this.isSwinging) {
            ++this.swingProgressInt;
            if (this.swingProgressInt >= 8) {
                this.swingProgressInt = 0;
                this.isSwinging = false;
            }
        } else {
            this.swingProgressInt = 0;
        }
        this.swingProgress = (float)this.swingProgressInt / 8.0f;
    }

    @Override
    public void onLivingUpdate() {
        List var3;
        if (this.flyToggleTimer > 0) {
            --this.flyToggleTimer;
        }
        if (this.worldObj.difficultySetting == 0 && this.health < 20 && this.ticksExisted % 20 * 12 == 0) {
            this.heal(1);
        }
        this.inventory.decrementAnimations();
        this.field_775_e = this.field_774_f;
        super.onLivingUpdate();
        float var1 = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
        float var2 = (float)Math.atan(-this.motionY * (double)0.2f) * 15.0f;
        if (var1 > 0.1f) {
            var1 = 0.1f;
        }
        if (!this.onGround || this.health <= 0) {
            var1 = 0.0f;
        }
        if (this.onGround || this.health <= 0) {
            var2 = 0.0f;
        }
        this.field_774_f += (var1 - this.field_774_f) * 0.4f;
        this.field_9328_R += (var2 - this.field_9328_R) * 0.8f;
        if (this.health > 0 && (var3 = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.expand(1.0, 0.0, 1.0))) != null) {
            int var4 = 0;
            while (var4 < var3.size()) {
                Entity var5 = (Entity)var3.get(var4);
                if (!var5.isDead) {
                    this.collideWithPlayer(var5);
                }
                ++var4;
            }
        }
    }

    private void collideWithPlayer(Entity var1) {
        var1.onCollideWithPlayer(this);
    }

    public long getScore() {
        return this.score;
    }

    @Override
    public void onDeath(Entity var1) {
        super.onDeath(var1);
        this.setSize(0.2f, 0.2f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.motionY = 0.1f;
        if (this.username.equals("Notch")) {
            this.dropPlayerItemWithRandomChoice(new ItemStack(Item.appleRed, 1), true);
        }
        this.inventory.dropAllItems();
        if (var1 != null) {
            this.motionX = -MathHelper.cos((this.attackedAtYaw + this.rotationYaw) * (float)Math.PI / 180.0f) * 0.1f;
            this.motionZ = -MathHelper.sin((this.attackedAtYaw + this.rotationYaw) * (float)Math.PI / 180.0f) * 0.1f;
        } else {
            this.motionZ = 0.0;
            this.motionX = 0.0;
        }
        this.yOffset = 0.1f;
        this.addStat(StatList.deathsStat, 1);
    }

    @Override
    public void addToPlayerScore(Entity var1, int var2) {
        this.score += (long)var2;
        if (var1 instanceof EntityPlayer) {
            this.addStat(StatList.playerKillsStat, 1);
        } else {
            this.addStat(StatList.mobKillsStat, 1);
        }
    }

    public void dropCurrentItem() {
        this.dropPlayerItemWithRandomChoice(this.inventory.decrStackSize(this.inventory.currentItem, 1), false);
    }

    public void dropCurrentItemStack() {
        this.dropPlayerItemWithRandomChoice(this.inventory.decrStackSize(this.inventory.currentItem, this.inventory.getCurrentItem().stackSize), false);
    }

    public void dropPlayerItem(ItemStack var1) {
        this.dropPlayerItemWithRandomChoice(var1, false);
    }

    public void dropPlayerItemWithRandomChoice(ItemStack var1, boolean var2) {
        if (var1 != null) {
            EntityItem var3 = new EntityItem(this.worldObj, this.posX, this.posY - 1.600000011920929 + (double)this.getEyeHeight(), this.posZ, var1);
            var3.delayBeforeCanPickup = 40;
            float var4 = 0.1f;
            if (var2) {
                float var5 = this.rand.nextFloat() * 0.5f;
                float var6 = this.rand.nextFloat() * (float)Math.PI * 2.0f;
                var3.motionX = -MathHelper.sin(var6) * var5;
                var3.motionZ = MathHelper.cos(var6) * var5;
                var3.motionY = 0.2f;
            } else {
                var4 = 0.3f;
                var3.motionX = -MathHelper.sin(this.rotationYaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.rotationPitch / 180.0f * (float)Math.PI) * var4;
                var3.motionZ = MathHelper.cos(this.rotationYaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.rotationPitch / 180.0f * (float)Math.PI) * var4;
                var3.motionY = -MathHelper.sin(this.rotationPitch / 180.0f * (float)Math.PI) * var4 + 0.1f;
                var4 = 0.02f;
                float var5 = this.rand.nextFloat() * (float)Math.PI * 2.0f;
                var3.motionX += Math.cos(var5) * (double)(var4 *= this.rand.nextFloat());
                var3.motionY += (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.1f);
                var3.motionZ += Math.sin(var5) * (double)var4;
            }
            this.joinEntityItemWithWorld(var3);
            this.addStat(StatList.dropStat, 1);
        }
    }

    protected void joinEntityItemWithWorld(EntityItem var1) {
        this.worldObj.entityJoinedWorld(var1);
    }

    public float getCurrentPlayerStrVsBlock(Block var1) {
        float var2 = this.inventory.getStrVsBlock(var1);
        if (this.isInsideOfMaterial(Material.water) && this.effecttimers[2] < 1) {
            var2 /= 5.0f;
        }
        if (this.effecttimers[6] > 1) {
            var2 += (float)(this.effectlevel[6] + 1);
        }
        if (this.effecttimers[7] > 1) {
            var2 /= (float)(this.effectlevel[7] + 1);
        }
        if (!this.onGround) {
            var2 /= 5.0f;
        }
        return var2;
    }

    public boolean canHarvestBlock(Block var1) {
        return this.inventory.canHarvestBlock(var1);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound var1) {
        super.readEntityFromNBT(var1);
        NBTTagList var2 = var1.getTagList("Inventory");
        this.inventory.readFromNBT(var2);
        this.dimension = var1.getInteger("Dimension");
        this.sleeping = var1.getBoolean("Sleeping");
        this.sleepTimer = var1.getShort("SleepTimer");
        if (this.sleeping) {
            this.bedChunkCoordinates = new ChunkCoordinates(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ));
            this.wakeUpPlayer(true, true, false);
        }
        if (var1.hasKey("SpawnX") && var1.hasKey("SpawnY") && var1.hasKey("SpawnZ")) {
            this.playerSpawnCoordinate = new ChunkCoordinates(var1.getInteger("SpawnX"), var1.getInteger("SpawnY"), var1.getInteger("SpawnZ"));
        }
        this.capabilities.func_40600_b(var1);
        this.exhausted = var1.getBoolean("Exhaustion");
        this.stamina = var1.getInteger("Stamina");
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound var1) {
        super.writeEntityToNBT(var1);
        var1.setTag("Inventory", this.inventory.writeToNBT(new NBTTagList()));
        var1.setInteger("Dimension", this.dimension);
        var1.setBoolean("Sleeping", this.sleeping);
        var1.setShort("SleepTimer", (short)this.sleepTimer);
        if (this.playerSpawnCoordinate != null) {
            var1.setInteger("SpawnX", this.playerSpawnCoordinate.x);
            var1.setInteger("SpawnY", this.playerSpawnCoordinate.y);
            var1.setInteger("SpawnZ", this.playerSpawnCoordinate.z);
        }
        this.capabilities.func_40601_a(var1);
        var1.setBoolean("FallFlying", this.isElytraFlying());
        var1.setBoolean("Exhaustion", this.exhausted);
        var1.setInteger("Stamina", this.stamina);
    }

    public void displayGUIChest(IInventory var1) {
    }

    public void displayWorkbenchGUI(int var1, int var2, int var3) {
    }

    public void onItemPickup(Entity var1, int var2) {
    }

    protected void resetHeight() {
        this.yOffset = 1.62f;
    }

    @Override
    public boolean attackEntityFrom(Entity var1, int var2) {
        if (this.capabilities.disableDamage) {
            return false;
        }
        this.entityAge = 0;
        if (this.health <= 0) {
            return false;
        }
        if (this.isPlayerSleeping() && !this.worldObj.multiplayerWorld) {
            this.wakeUpPlayer(true, true, false);
        }
        if (var1 instanceof EntityMob || var1 instanceof EntityArrowPurple) {
            if (this.worldObj.difficultySetting == 0) {
                var2 = 0;
            }
            if (this.worldObj.difficultySetting == 1) {
                var2 = var2 / 3 + 1;
            }
            if (this.worldObj.difficultySetting == 3) {
                var2 = var2 * 3 / 2;
            }
        }
        if (var2 == 0) {
            return false;
        }
        Entity var3 = var1;
        if (var1 instanceof EntityArrow && ((EntityArrow)var1).shootingEntity != null) {
            var3 = ((EntityArrow)var1).shootingEntity;
        }
        if (var1 instanceof EntityArrowPurple && ((EntityArrowPurple)var1).owner != null) {
            var3 = ((EntityArrowPurple)var1).owner;
        }
        if (var3 instanceof EntityLiving) {
            this.alertWolves((EntityLiving)var3, false);
        }
        if (var3 instanceof EntityLiving) {
            this.alertFoxes((EntityLiving)var3, false);
        }
        this.addStat(StatList.damageTakenStat, var2);
        return super.attackEntityFrom(var1, var2);
    }

    protected boolean func_27025_G() {
        return false;
    }

    protected void alertWolves(EntityLiving var1, boolean var2) {
        if (!(var1 instanceof EntityCreeper || var1 instanceof EntityGhast || var1 instanceof EntityBlaze || var1 instanceof EntityFox)) {
            EntityWolf var3;
            if (var1 instanceof EntityWolf && (var3 = (EntityWolf)var1).isWolfTamed() && this.username.equals(var3.getWolfOwner())) {
                return;
            }
            if (!(var1 instanceof EntityPlayer) || this.func_27025_G()) {
                List var7 = this.worldObj.getEntitiesWithinAABB(EntityWolf.class, AxisAlignedBB.getBoundingBoxFromPool(this.posX, this.posY, this.posZ, this.posX + 1.0, this.posY + 1.0, this.posZ + 1.0).expand(16.0, 4.0, 16.0));
                Iterator var4 = var7.iterator();
                while (true) {
                    if (!var4.hasNext()) {
                        return;
                    }
                    Entity var5 = (Entity)var4.next();
                    EntityWolf var6 = (EntityWolf)var5;
                    if (!var6.isWolfTamed() || var6.getTarget() != null || !this.username.equals(var6.getWolfOwner()) || var2 && var6.isWolfSitting()) continue;
                    var6.setWolfSitting(false);
                    var6.setTarget(var1);
                }
            }
        }
    }

    @Override
    protected void damageEntity(int var1) {
        if (this.action.equals((Object)EnumPlayerAction.BLOCKING)) {
            var1 = (int)Math.round((double)var1 / 2.0);
        }
        int var2 = 25 - this.inventory.getTotalArmorValue();
        int var3 = var1 * var2 + this.damageRemainder;
        this.inventory.damageArmor(var1);
        var1 = var3 / 25;
        this.damageRemainder = var3 % 25;
        super.damageEntity(var1);
    }

    public void displayGUIFurnace(TileEntityFurnace var1) {
    }

    public void displayGUIAnvil(TileEntityAnvil var1, int var2, int var3, int var4) {
    }

    public void displayGUIBlastFurnace(TileEntityBlastFurnace var1) {
    }

    public void displayGUIDispenser(TileEntityDispenser var1) {
    }

    public void displayGUIEditSign(TileEntitySign var1) {
    }

    public void useCurrentItemOnEntity(Entity var1) {
        ItemStack var2;
        if (!var1.interact(this) && (var2 = this.getCurrentEquippedItem()) != null && var1 instanceof EntityLiving) {
            var2.useItemOnEntity((EntityLiving)var1, this);
            if (var2.stackSize <= 0) {
                var2.func_1097_a(this);
                this.destroyCurrentEquippedItem();
            }
        }
    }

    public ItemStack getCurrentEquippedItem() {
        return this.inventory.getCurrentItem();
    }

    public void destroyCurrentEquippedItem() {
        this.inventory.setInventorySlotContents(this.inventory.currentItem, null);
    }

    @Override
    public double getYOffset() {
        return this.yOffset - 0.5f;
    }

    public void swingItem() {
        this.swingProgressInt = -1;
        this.isSwinging = true;
    }

    public void attackTargetEntityWithCurrentItem(Entity var1) {
        int var2 = this.inventory.getDamageVsEntity(var1);
        if (this.effecttimers[8] > 0) {
            var2 += this.effectlevel[8];
        }
        if (this.effecttimers[9] > 0) {
            var2 -= this.effectlevel[9];
        }
        if (var2 > 0) {
            if (this.motionY < 0.0) {
                ++var2;
            }
            var1.attackEntityFrom(this, var2);
            ItemStack var3 = this.getCurrentEquippedItem();
            if (var3 != null && var1 instanceof EntityLiving) {
                var3.hitEntity((EntityLiving)var1, this);
                if (var3.stackSize <= 0) {
                    var3.func_1097_a(this);
                    this.destroyCurrentEquippedItem();
                }
            }
            if (var1 instanceof EntityLiving) {
                if (var1.isEntityAlive()) {
                    this.alertWolves((EntityLiving)var1, true);
                }
                this.addStat(StatList.damageDealtStat, var2);
            }
            if (var1 instanceof EntityLiving) {
                if (var1.isEntityAlive()) {
                    this.alertFoxes((EntityLiving)var1, true);
                }
                this.addStat(StatList.damageDealtStat, var2);
            }
        }
    }

    public void respawnPlayer() {
    }

    public abstract void func_6420_o();

    public void onItemStackChanged(ItemStack var1) {
    }

    @Override
    public void setEntityDead() {
        super.setEntityDead();
        this.inventorySlots.onCraftGuiClosed(this);
        if (this.craftingInventory != null) {
            this.craftingInventory.onCraftGuiClosed(this);
        }
    }

    @Override
    public boolean isEntityInsideOpaqueBlock() {
        return !this.sleeping && super.isEntityInsideOpaqueBlock();
    }

    public EnumStatus sleepInBedAt(int var1, int var2, int var3) {
        if (!this.worldObj.multiplayerWorld) {
            if (!this.isPlayerSleeping() && this.isEntityAlive()) {
                if (this.worldObj.worldProvider.isNether) {
                    return EnumStatus.NOT_POSSIBLE_HERE;
                }
                if (this.worldObj.isDaytime()) {
                    return EnumStatus.NOT_POSSIBLE_NOW;
                }
                if (!(Math.abs(this.posX - (double)var1) <= 3.0 && Math.abs(this.posY - (double)var2) <= 2.0 && Math.abs(this.posZ - (double)var3) <= 3.0)) {
                    return EnumStatus.TOO_FAR_AWAY;
                }
            } else {
                return EnumStatus.OTHER_PROBLEM;
            }
        }
        this.setSize(0.2f, 0.2f);
        this.yOffset = 0.2f;
        if (this.worldObj.blockExists(var1, var2, var3)) {
            int var4 = this.worldObj.getBlockMetadata(var1, var2, var3);
            int var5 = BlockBed.getDirectionFromMetadata(var4);
            float var6 = 0.5f;
            float var7 = 0.5f;
            switch (var5) {
                case 0: {
                    var7 = 0.9f;
                    break;
                }
                case 1: {
                    var6 = 0.1f;
                    break;
                }
                case 2: {
                    var7 = 0.1f;
                    break;
                }
                case 3: {
                    var6 = 0.9f;
                }
            }
            this.func_22052_e(var5);
            this.setPosition((float)var1 + var6, (float)var2 + 0.9375f, (float)var3 + var7);
        } else {
            this.setPosition((float)var1 + 0.5f, (float)var2 + 0.9375f, (float)var3 + 0.5f);
        }
        this.sleeping = true;
        this.sleepTimer = 0;
        this.bedChunkCoordinates = new ChunkCoordinates(var1, var2, var3);
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.motionX = 0.0;
        if (!this.worldObj.multiplayerWorld) {
            this.worldObj.updateAllPlayersSleepingFlag();
        }
        return EnumStatus.OK;
    }

    private void func_22052_e(int var1) {
        this.field_22063_x = 0.0f;
        this.field_22061_z = 0.0f;
        switch (var1) {
            case 0: {
                this.field_22061_z = -1.8f;
                break;
            }
            case 1: {
                this.field_22063_x = 1.8f;
                break;
            }
            case 2: {
                this.field_22061_z = 1.8f;
                break;
            }
            case 3: {
                this.field_22063_x = -1.8f;
            }
        }
    }

    public void wakeUpPlayer(boolean var1, boolean var2, boolean var3) {
        this.setSize(0.6f, 1.8f);
        this.resetHeight();
        ChunkCoordinates var4 = this.bedChunkCoordinates;
        ChunkCoordinates var5 = this.bedChunkCoordinates;
        if (var4 != null && this.worldObj.getBlockId(var4.x, var4.y, var4.z) == Block.blockBed.blockID) {
            BlockBed.setBedOccupied(this.worldObj, var4.x, var4.y, var4.z, false);
            var5 = BlockBed.getNearestEmptyChunkCoordinates(this.worldObj, var4.x, var4.y, var4.z, 0);
            if (var5 == null) {
                var5 = new ChunkCoordinates(var4.x, var4.y + 1, var4.z);
            }
            this.setPosition((float)var5.x + 0.5f, (float)var5.y + this.yOffset + 0.1f, (float)var5.z + 0.5f);
        }
        this.sleeping = false;
        if (!this.worldObj.multiplayerWorld && var2) {
            this.worldObj.updateAllPlayersSleepingFlag();
        }
        this.sleepTimer = var1 ? 0 : 100;
        if (var3) {
            this.setPlayerSpawnCoordinate(this.bedChunkCoordinates);
        }
    }

    private boolean isInBed() {
        return this.worldObj.getBlockId(this.bedChunkCoordinates.x, this.bedChunkCoordinates.y, this.bedChunkCoordinates.z) == Block.blockBed.blockID;
    }

    public static ChunkCoordinates func_25060_a(World var0, ChunkCoordinates var1) {
        IChunkProvider var2 = var0.getIChunkProvider();
        var2.prepareChunk(var1.x - 3 >> 4, var1.z - 3 >> 4);
        var2.prepareChunk(var1.x + 3 >> 4, var1.z - 3 >> 4);
        var2.prepareChunk(var1.x - 3 >> 4, var1.z + 3 >> 4);
        var2.prepareChunk(var1.x + 3 >> 4, var1.z + 3 >> 4);
        if (var0.getBlockId(var1.x, var1.y, var1.z) != Block.blockBed.blockID) {
            return null;
        }
        ChunkCoordinates var3 = BlockBed.getNearestEmptyChunkCoordinates(var0, var1.x, var1.y, var1.z, 0);
        return var3;
    }

    public float getBedOrientationInDegrees() {
        if (this.bedChunkCoordinates != null) {
            int var1 = this.worldObj.getBlockMetadata(this.bedChunkCoordinates.x, this.bedChunkCoordinates.y, this.bedChunkCoordinates.z);
            int var2 = BlockBed.getDirectionFromMetadata(var1);
            switch (var2) {
                case 0: {
                    return 90.0f;
                }
                case 1: {
                    return 0.0f;
                }
                case 2: {
                    return 270.0f;
                }
                case 3: {
                    return 180.0f;
                }
            }
        }
        return 0.0f;
    }

    @Override
    public boolean isPlayerSleeping() {
        return this.sleeping;
    }

    public boolean isPlayerFullyAsleep() {
        return this.sleeping && this.sleepTimer >= 100;
    }

    public int func_22060_M() {
        return this.sleepTimer;
    }

    public void addChatMessage(String var1) {
    }

    public ChunkCoordinates getPlayerSpawnCoordinate() {
        return this.playerSpawnCoordinate;
    }

    public void setPlayerSpawnCoordinate(ChunkCoordinates var1) {
        this.playerSpawnCoordinate = var1 != null ? new ChunkCoordinates(var1) : null;
    }

    public void triggerAchievement(StatBase var1) {
        this.addStat(var1, 1);
    }

    public void playAchievementSound() {
        this.worldObj.playSoundAtEntity(this, "random.levelup", 1.0f, 1.0f);
    }

    public void addStat(StatBase var1, int var2) {
    }

    @Override
    protected void jump() {
        super.jump();
        this.addStat(StatList.jumpStat, 1);
    }

    @Override
    public void moveEntityWithHeading(float var1, float var2) {
        double var3 = this.posX;
        double var5 = this.posY;
        double var7 = this.posZ;
        if (this.capabilities.isFlying) {
            double d3 = this.motionY;
            float f2 = this.jumpMovementFactor;
            this.jumpMovementFactor = 0.05f;
            super.moveEntityWithHeading(var1, var2);
            this.motionY = d3 * 0.6;
            this.jumpMovementFactor = f2;
        } else {
            super.moveEntityWithHeading(var1, var2);
        }
        this.addMovementStat(this.posX - var3, this.posY - var5, this.posZ - var7);
    }

    private void addMovementStat(double var1, double var3, double var5) {
        if (this.ridingEntity == null) {
            if (this.isInsideOfMaterial(Material.water)) {
                int var7 = Math.round(MathHelper.sqrt_double(var1 * var1 + var3 * var3 + var5 * var5) * 100.0f);
                if (var7 > 0) {
                    this.addStat(StatList.distanceDoveStat, var7);
                }
            } else if (this.isInWater()) {
                int var7 = Math.round(MathHelper.sqrt_double(var1 * var1 + var5 * var5) * 100.0f);
                if (var7 > 0) {
                    this.addStat(StatList.distanceSwumStat, var7);
                }
            } else if (this.isOnLadder()) {
                if (var3 > 0.0) {
                    this.addStat(StatList.distanceClimbedStat, (int)Math.round(var3 * 100.0));
                }
            } else if (this.onGround) {
                int var7 = Math.round(MathHelper.sqrt_double(var1 * var1 + var5 * var5) * 100.0f);
                if (var7 > 0) {
                    this.addStat(StatList.distanceWalkedStat, var7);
                }
            } else {
                int var7 = Math.round(MathHelper.sqrt_double(var1 * var1 + var5 * var5) * 100.0f);
                if (var7 > 25) {
                    this.addStat(StatList.distanceFlownStat, var7);
                }
            }
        }
    }

    private void addMountedMovementStat(double var1, double var3, double var5) {
        int var7;
        if (this.ridingEntity != null && (var7 = Math.round(MathHelper.sqrt_double(var1 * var1 + var3 * var3 + var5 * var5) * 100.0f)) > 0) {
            if (this.ridingEntity instanceof EntityMinecart) {
                this.addStat(StatList.distanceByMinecartStat, var7);
                if (this.startMinecartRidingCoordinate == null) {
                    this.startMinecartRidingCoordinate = new ChunkCoordinates(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ));
                } else if (this.startMinecartRidingCoordinate.getSqDistanceTo(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ)) >= 1000.0) {
                    this.addStat(AchievementList.onARail, 1);
                }
            } else if (this.ridingEntity instanceof EntityBoat) {
                this.addStat(StatList.distanceByBoatStat, var7);
            } else if (this.ridingEntity instanceof EntityPig) {
                this.addStat(StatList.distanceByPigStat, var7);
            }
        }
    }

    @Override
    protected void fall(float var1) {
        if (this.capabilities.allowFlying || this.effecttimers[5] > 0) {
            return;
        }
        if (var1 >= 2.0f) {
            this.addStat(StatList.distanceFallenStat, (int)Math.round((double)var1 * 100.0));
        }
        super.fall(var1);
    }

    @Override
    public void onKillEntity(EntityLiving var1) {
        if (var1 instanceof EntityMob) {
            this.triggerAchievement(AchievementList.killEnemy);
        }
    }

    @Override
    public void setInPortal() {
        if (this.timeUntilPortal > 0) {
            this.timeUntilPortal = 10;
        } else {
            this.inPortal = true;
        }
    }

    protected void alertFoxes(EntityLiving var1, boolean var2) {
        if (!(var1 instanceof EntityCreeper || var1 instanceof EntityGhast || var1 instanceof EntityBlaze || var1 instanceof EntityWolf)) {
            EntityFox var3;
            if (var1 instanceof EntityFox && (var3 = (EntityFox)var1).isWolfTamed() && this.username.equals(var3.getWolfOwner())) {
                return;
            }
            if (!(var1 instanceof EntityPlayer) || this.func_27025_G()) {
                List var7 = this.worldObj.getEntitiesWithinAABB(EntityFox.class, AxisAlignedBB.getBoundingBoxFromPool(this.posX, this.posY, this.posZ, this.posX + 1.0, this.posY + 1.0, this.posZ + 1.0).expand(16.0, 4.0, 16.0));
                Iterator var4 = var7.iterator();
                while (true) {
                    if (!var4.hasNext()) {
                        return;
                    }
                    Entity var5 = (Entity)var4.next();
                    EntityFox var6 = (EntityFox)var5;
                    if (!var6.isWolfTamed() || var6.getTarget() != null || !this.username.equals(var6.getWolfOwner()) || var2 && var6.isWolfSitting()) continue;
                    var6.setWolfSitting(false);
                    var6.setTarget(var1);
                }
            }
        }
    }

    public void mountTileEntity(TileEntity var1) {
        this.entityRiderPitchDelta = 0.0;
        this.entityRiderYawDelta = 0.0;
        if (var1 == null) {
            if (this.ridingEntity != null) {
                this.setLocationAndAngles(this.ridingEntity.posX, this.ridingEntity.boundingBox.minY + (double)this.ridingEntity.height, this.ridingEntity.posZ, this.rotationYaw, this.rotationPitch);
                this.ridingEntity.riddenByEntity = null;
            }
            this.ridingEntity = null;
        } else if (this.ridingTileEntity == var1) {
            this.ridingEntity.riddenByEntity = null;
            this.ridingEntity = null;
            this.setLocationAndAngles(0.5, 0.5, 0.5, this.rotationYaw, this.rotationPitch);
        } else {
            if (this.ridingEntity != null) {
                this.ridingEntity.riddenByEntity = null;
            }
            if (var1.riddenByEntity != null) {
                var1.riddenByEntity.ridingEntity = null;
            }
            this.ridingTileEntity = var1;
            var1.riddenByEntity = this;
        }
    }

    public boolean func_35190_e(int i, int j, int k) {
        return true;
    }

    @Override
    public boolean canBreatheUnderwater() {
        ItemStack var9 = this.inventory.armorItemInSlot(3);
        return var9 != null && var9.itemID == Block.glass.blockID;
    }

    @Override
    public int getItemIcon(ItemStack itemstack, int i) {
        int j = super.getItemIcon(itemstack, i);
        if (itemstack.itemID == Item.fishingRod.itemID && this.fishEntity != null) {
            j = itemstack.getIconIndex() + 1;
        } else if (this.itemInUse != null && itemstack.itemID == Item.bow.itemID) {
            int k = itemstack.getMaxItemUseDuration() - this.itemInUseCount;
            if (k >= 18) {
                return 224;
            }
            if (k > 13) {
                return 208;
            }
            if (k > 0) {
                return 192;
            }
        }
        return j;
    }

    public EnumPlayerAction getAction() {
        return this.action;
    }

    public void setAction(EnumPlayerAction e) {
        if (e.equals((Object)EnumPlayerAction.BOW) && !this.action.equals((Object)EnumPlayerAction.BOW)) {
            this.bowCounter = 0;
        } else if (e.equals((Object)EnumPlayerAction.NORMAL)) {
            this.action.equals((Object)EnumPlayerAction.BOW);
        }
        this.action = e;
    }

    public int getBowCounter() {
        return this.bowCounter / 5;
    }

    @Override
    public float getEyeHeight() {
        return 0.12f;
    }

    public boolean isElytraFlying() {
        return this.getEntityFlag(7);
    }

    public int getTicksElytraFlying() {
        return this.ticksElytraFlying;
    }

    private void updateElytra() {
        boolean flag = this.getEntityFlag(7);
        if (flag && !this.onGround && !this.isRiding()) {
            ItemStack itemstack = this.inventory.armorItemInSlot(2);
            if (itemstack.getItem() == Item.elytra) {
                flag = true;
                if (!this.worldObj.multiplayerWorld && (this.ticksElytraFlying + 1) % 20 == 0) {
                    itemstack.damageItem(1, this);
                }
            } else {
                flag = false;
            }
        } else {
            flag = false;
        }
        if (!this.worldObj.multiplayerWorld) {
            this.setEntityFlag(7, flag);
        }
    }

    public void setElytraFlying() {
        this.setEntityFlag(7, true);
    }

    public void clearElytraFlying() {
        this.setEntityFlag(7, true);
        this.setEntityFlag(7, false);
    }

    public ItemStack getItemInUse() {
        return this.itemInUse;
    }

    public int getItemInUseCount() {
        return this.itemInUseCount;
    }

    public boolean isUsingItem() {
        return this.itemInUse != null;
    }

    public int getItemInUseDuration() {
        return this.isUsingItem() ? this.itemInUse.getMaxItemUseDuration() - this.itemInUseCount : 0;
    }

    public void stopUsingItem() {
        if (this.itemInUse != null) {
            this.itemInUse.onPlayerStoppedUsing(this.worldObj, this, this.itemInUseCount);
        }
        if (!Mouse.isButtonDown((int)1)) {
            this.clearItemInUse();
        }
    }

    public void clearItemInUse() {
        this.itemInUse = null;
        this.itemInUseCount = 0;
        if (!this.worldObj.isRemote) {
            this.setEating(false);
        }
    }

    public boolean isBlocking() {
        return this.isUsingItem() && Item.itemsList[this.itemInUse.itemID].getItemUseAction(this.itemInUse) == EnumAction.block;
    }

    protected void updateItemUse(ItemStack var1, int var2) {
        if (var1.getItemUseAction() == EnumAction.drink) {
            this.worldObj.playSoundAtEntity(this, "random.drink", 0.5f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
        }
        if (var1.getItemUseAction() == EnumAction.eat) {
            int var3 = 0;
            while (var3 < var2) {
                Vec3D var4 = Vec3D.createVector(((double)this.rand.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                var4.rotateAroundX(-this.rotationPitch * (float)Math.PI / 180.0f);
                var4.rotateAroundY(-this.rotationYaw * (float)Math.PI / 180.0f);
                Vec3D var5 = Vec3D.createVector(((double)this.rand.nextFloat() - 0.5) * 0.3, (double)(-this.rand.nextFloat()) * 0.6 - 0.3, 0.6);
                var5.rotateAroundX(-this.rotationPitch * (float)Math.PI / 180.0f);
                var5.rotateAroundY(-this.rotationYaw * (float)Math.PI / 180.0f);
                var5 = var5.addVector(this.posX, this.posY + (double)this.getEyeHeight(), this.posZ);
                this.worldObj.spawnParticle("iconcrack_" + var1.getItem().itemID, var5.xCoord, var5.yCoord, var5.zCoord, var4.xCoord, var4.yCoord + 0.05, var4.zCoord);
                ++var3;
            }
            this.worldObj.playSoundAtEntity(this, "step.grass", 0.5f + 0.5f * (float)this.rand.nextInt(2), (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.75f);
        }
    }

    protected void onItemUseFinish() {
        if (this.itemInUse != null) {
            this.updateItemUse(this.itemInUse, 16);
            int var1 = this.itemInUse.stackSize;
            ItemStack var2 = this.itemInUse.onFoodEaten(this.worldObj, this);
            if (var2 != this.itemInUse || var2 != null && var2.stackSize != var1) {
                this.inventory.mainInventory[this.inventory.currentItem] = var2;
                if (var2.stackSize == 0) {
                    this.inventory.mainInventory[this.inventory.currentItem] = null;
                }
            }
            this.clearItemInUse();
        }
    }

    public void setItemInUse(ItemStack var1, int var2) {
        if (var1 != this.itemInUse) {
            this.itemInUse = var1;
            this.itemInUseCount = var2;
            if (!this.worldObj.isRemote) {
                this.setEating(true);
            }
        }
    }
}

