/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.entity.other;

import java.util.List;
import net.minecraft.src.client.physics.MovingObjectPosition;
import net.minecraft.src.client.renderer.Vec3D;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.nbt.NBTTagCompound;

public class EntityTorch
extends Entity {
    private int xTileFirework = -1;
    private int yTileFirework = -1;
    private int zTileFirework = -1;
    private int inTileFirework = 0;
    private boolean inGroundFirework = false;
    public int shakeFirework = 0;
    private EntityLiving thrower;
    private int ticksInGroundFirework;
    private int ticksInAirFirework = 0;
    public int counter = 0;

    public EntityTorch(World var1) {
        super(var1);
        this.setSize(0.25f, 0.25f);
    }

    @Override
    protected void entityInit() {
    }

    public EntityTorch(World world, EntityLiving owner) {
        super(world);
        this.thrower = owner;
        this.setSize(0.5f, 0.5f);
        this.setPositionAndRotation(owner.posX, owner.posY, owner.posZ, owner.rotationYaw, owner.rotationPitch);
        this.posX -= (double)(MathHelper.cos(this.rotationYaw / 180.0f * (float)Math.PI) * 0.16f);
        this.posY -= (double)0.1f;
        this.posZ -= (double)(MathHelper.sin(this.rotationYaw / 180.0f * (float)Math.PI) * 0.16f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.yOffset = 0.0f;
        this.motionX = -MathHelper.sin(this.rotationYaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.rotationPitch / 180.0f * (float)Math.PI);
        this.motionZ = MathHelper.cos(this.rotationYaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.rotationPitch / 180.0f * (float)Math.PI);
        this.motionY = -MathHelper.sin(this.rotationPitch / 180.0f * (float)Math.PI);
        this.setFireworkHeading(this.motionX, this.motionY, this.motionZ, 1.5f, 1.0f);
    }

    public EntityTorch(World var1, float var2, float var4, float var6) {
        super(var1);
        this.ticksInGroundFirework = 0;
        this.setSize(0.1f, 0.1f);
        this.setPosition(var2, var4, var6);
        this.yOffset = 0.0f;
    }

    public void setFireworkHeading(double var1, double var3, double var5, float var7, float var8) {
        float var9 = MathHelper.sqrt_double(var1 * var1 + var3 * var3 + var5 * var5);
        var1 /= (double)var9;
        var3 /= (double)var9;
        var5 /= (double)var9;
        var1 += this.rand.nextGaussian() * (double)0.0075f * (double)var8;
        var3 += this.rand.nextGaussian() * (double)0.0075f * (double)var8;
        var5 += this.rand.nextGaussian() * (double)0.0075f * (double)var8;
        this.motionX = var1 *= (double)var7;
        this.motionY = var3 *= (double)var7;
        this.motionZ = var5 *= (double)var7;
        float var10 = MathHelper.sqrt_double(var1 * var1 + var5 * var5);
        this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(var1, var5) * 180.0 / 3.1415927410125732);
        this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(var3, var10) * 180.0 / 3.1415927410125732);
        this.ticksInGroundFirework = 0;
    }

    public void setVelocity(float var1, float var3, float var5) {
        this.motionX = var1;
        this.motionY = var3;
        this.motionZ = var5;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float var7 = MathHelper.sqrt_float(var1 * var1 + var5 * var5);
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(var1, var5) * 180.0 / 3.1415927410125732);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(var3, var7) * 180.0 / 3.1415927410125732);
        }
    }

    @Override
    public void onEntityUpdate() {
        if (!this.onGround) {
            ++this.counter;
            if (this.counter >= 20) {
                this.counter = 0;
            }
        }
        this.worldObj.spawnParticle("flame", this.posX, this.posY + 0.1, this.posZ, 0.0, 0.0, 0.0);
        this.worldObj.spawnParticle("smoke", this.posX, this.posY + 0.1, this.posZ, 0.0, 0.0, 0.0);
        this.lastTickPosX = this.posX;
        this.lastTickPosY = this.posY;
        this.lastTickPosZ = this.posZ;
        super.onEntityUpdate();
        if (this.shakeFirework > 0) {
            --this.shakeFirework;
        }
        if (this.inGroundFirework) {
            int var1 = this.worldObj.getBlockId(this.xTileFirework, this.yTileFirework, this.zTileFirework);
            if (var1 == this.inTileFirework) {
                ++this.ticksInGroundFirework;
                if (this.ticksInGroundFirework == 1200) {
                    this.setEntityDead();
                }
                return;
            }
            this.inGroundFirework = true;
            this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
            this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
            this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
            this.ticksInGroundFirework = 0;
            this.ticksInAirFirework = 0;
        } else {
            ++this.ticksInAirFirework;
        }
        Vec3D position = Vec3D.createVector(this.posX, this.posY, this.posZ);
        Vec3D anticipatedposition = Vec3D.createVector(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        MovingObjectPosition var3 = this.worldObj.rayTraceBlocks(position, anticipatedposition);
        position = Vec3D.createVector(this.posX, this.posY, this.posZ);
        anticipatedposition = Vec3D.createVector(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        if (var3 != null) {
            anticipatedposition = Vec3D.createVector(var3.hitVec.xCoord, var3.hitVec.yCoord, var3.hitVec.zCoord);
        }
        List nearentities = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
        int var8 = 0;
        while (var8 < nearentities.size()) {
            Entity var9 = (Entity)nearentities.get(var8);
            if (!var9.canBeCollidedWith() || var9 == this.thrower) {
                // empty if block
            }
            ++var8;
        }
        if (var3 != null) {
            if (var3.entityHit != null) {
                var3.entityHit.attackEntityFrom(this.thrower, 0);
            }
            int var16 = 0;
            while (var16 < 1) {
                Vec3D finpos = Vec3D.createVector(Math.floor((anticipatedposition.xCoord + this.posX) / 2.0), Math.floor((anticipatedposition.yCoord + this.posY) / 2.0), Math.floor((anticipatedposition.zCoord + this.posZ) / 2.0));
                if (this.worldObj.getBlockId((int)finpos.xCoord, (int)finpos.yCoord, (int)finpos.zCoord) == Block.stickyTorch.blockID) {
                    Block.stickyTorch.dropBlockAsItem(this.worldObj, (int)finpos.xCoord, (int)finpos.yCoord, (int)finpos.zCoord, 0);
                    this.setEntityDead();
                } else if (this.worldObj.getBlockId((int)finpos.xCoord, (int)finpos.yCoord, (int)finpos.zCoord) == 0) {
                    if (!this.worldObj.multiplayerWorld) {
                        this.worldObj.setBlockAndMetadataWithNotify((int)finpos.xCoord, (int)finpos.yCoord, (int)finpos.zCoord, Block.stickyTorch.blockID, 0);
                    }
                    this.worldObj.playSoundAtEntity(this, "step.wood", 2.0f, 1.0f);
                } else {
                    Block.stickyTorch.dropBlockAsItem(this.worldObj, (int)finpos.xCoord, (int)finpos.yCoord, (int)finpos.zCoord, 0);
                }
                ++var16;
            }
            this.setEntityDead();
        }
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        float var17 = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
        this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / 3.1415927410125732);
        this.rotationPitch = (float)(Math.atan2(this.motionY, var17) * 180.0 / 3.1415927410125732);
        while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
            this.prevRotationPitch -= 360.0f;
        }
        while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
            this.prevRotationPitch += 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
            this.prevRotationYaw -= 360.0f;
        }
        while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
            this.prevRotationYaw += 360.0f;
        }
        this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
        this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
        float var18 = 0.99f;
        float var19 = 0.03f;
        if (this.worldObj.getBlockMaterial((int)this.posX, (int)this.posY, (int)this.posZ) == Material.water) {
            int var7 = 0;
            while (var7 < 4) {
                float var20 = 0.25f;
                this.worldObj.spawnParticle("bubble", this.posX - this.motionX * (double)var20, this.posY - this.motionY * (double)var20, this.posZ - this.motionZ * (double)var20, this.motionX, this.motionY, this.motionZ);
                ++var7;
            }
            var18 = 0.8f;
        }
        this.motionX *= (double)var18;
        this.motionY *= (double)var18;
        this.motionZ *= (double)var18;
        this.motionY -= (double)var19;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound var1) {
        var1.setShort("xTile", (short)this.xTileFirework);
        var1.setShort("yTile", (short)this.yTileFirework);
        var1.setShort("zTile", (short)this.zTileFirework);
        var1.setByte("inTile", (byte)this.inTileFirework);
        var1.setByte("shake", (byte)this.shakeFirework);
        var1.setByte("inGround", (byte)(this.inGroundFirework ? 1 : 0));
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound var1) {
        this.xTileFirework = var1.getShort("xTile");
        this.yTileFirework = var1.getShort("yTile");
        this.zTileFirework = var1.getShort("zTile");
        this.inTileFirework = var1.getByte("inTile") & 0xFF;
        this.shakeFirework = var1.getByte("shake") & 0xFF;
        this.inGroundFirework = var1.getByte("inGround") == 1;
    }

    @Override
    public float getShadowSize() {
        return 0.0f;
    }

    @Override
    public float getEntityBrightness(float var1) {
        return 1.0f;
    }
}

