/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.entity.other;

import java.util.List;
import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.client.physics.MovingObjectPosition;
import net.minecraft.src.client.renderer.Vec3D;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.other.EntityItem;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.nbt.NBTTagCompound;
import net.minecraft.src.game.stats.StatList;

public class EntityFish
extends Entity {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private int inTile = 0;
    private boolean inGround = false;
    public int shake = 0;
    public EntityPlayer angler;
    private int ticksInGround;
    private int ticksInAir = 0;
    private int ticksCatchable = 0;
    public Entity bobber = null;
    private int field_6388_l;
    private double field_6387_m;
    private double field_6386_n;
    private double field_6385_o;
    private double field_6384_p;
    private double field_6383_q;
    private double velocityX;
    private double velocityY;
    private double velocityZ;

    public EntityFish(World var1) {
        super(var1);
        this.setSize(0.25f, 0.25f);
        this.ignoreFrustumCheck = true;
    }

    public EntityFish(World var1, double var2, double var4, double var6) {
        this(var1);
        this.setPosition(var2, var4, var6);
        this.ignoreFrustumCheck = true;
    }

    public EntityFish(World var1, EntityPlayer var2) {
        super(var1);
        this.ignoreFrustumCheck = true;
        this.angler = var2;
        this.angler.fishEntity = this;
        this.setSize(0.25f, 0.25f);
        this.setLocationAndAngles(var2.posX, var2.posY + 1.62 - (double)var2.yOffset, var2.posZ, var2.rotationYaw, var2.rotationPitch);
        this.posX -= (double)(MathHelper.cos(this.rotationYaw / 180.0f * (float)Math.PI) * 0.16f);
        this.posY -= (double)0.1f;
        this.posZ -= (double)(MathHelper.sin(this.rotationYaw / 180.0f * (float)Math.PI) * 0.16f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.yOffset = 0.0f;
        float var3 = 0.4f;
        this.motionX = -MathHelper.sin(this.rotationYaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.rotationPitch / 180.0f * (float)Math.PI) * var3;
        this.motionZ = MathHelper.cos(this.rotationYaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.rotationPitch / 180.0f * (float)Math.PI) * var3;
        this.motionY = -MathHelper.sin(this.rotationPitch / 180.0f * (float)Math.PI) * var3;
        this.func_4042_a(this.motionX, this.motionY, this.motionZ, 1.5f, 1.0f);
    }

    @Override
    protected void entityInit() {
    }

    @Override
    public boolean isInRangeToRenderDist(double var1) {
        double var3 = this.boundingBox.getAverageEdgeLength() * 4.0;
        return var1 < (var3 *= 64.0) * var3;
    }

    public void func_4042_a(double var1, double var3, double var5, float var7, float var8) {
        float var9 = MathHelper.sqrt_double(var1 * var1 + var3 * var3 + var5 * var5);
        var1 /= (double)var9;
        var3 /= (double)var9;
        var5 /= (double)var9;
        var1 += this.rand.nextGaussian() * (double)0.0075f * (double)var8;
        var3 += this.rand.nextGaussian() * (double)0.0075f * (double)var8;
        var5 += this.rand.nextGaussian() * (double)0.0075f * (double)var8;
        this.motionX = var1 *= (double)var7;
        this.motionY = var3 *= (double)var7;
        this.motionZ = var5 *= (double)var7;
        float var10 = MathHelper.sqrt_double(var1 * var1 + var5 * var5);
        this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(var1, var5) * 180.0 / 3.1415927410125732);
        this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(var3, var10) * 180.0 / 3.1415927410125732);
        this.ticksInGround = 0;
    }

    @Override
    public void setPositionAndRotation2(double var1, double var3, double var5, float var7, float var8, int var9) {
        this.field_6387_m = var1;
        this.field_6386_n = var3;
        this.field_6385_o = var5;
        this.field_6384_p = var7;
        this.field_6383_q = var8;
        this.field_6388_l = var9;
        this.motionX = this.velocityX;
        this.motionY = this.velocityY;
        this.motionZ = this.velocityZ;
    }

    @Override
    public void setVelocity(double var1, double var3, double var5) {
        this.velocityX = this.motionX = var1;
        this.velocityY = this.motionY = var3;
        this.velocityZ = this.motionZ = var5;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_6388_l > 0) {
            double var21 = this.posX + (this.field_6387_m - this.posX) / (double)this.field_6388_l;
            double var22 = this.posY + (this.field_6386_n - this.posY) / (double)this.field_6388_l;
            double var23 = this.posZ + (this.field_6385_o - this.posZ) / (double)this.field_6388_l;
            double var7 = this.field_6384_p - (double)this.rotationYaw;
            while (var7 < -180.0) {
                var7 += 360.0;
            }
            while (var7 >= 180.0) {
                var7 -= 360.0;
            }
            this.rotationYaw = (float)((double)this.rotationYaw + var7 / (double)this.field_6388_l);
            this.rotationPitch = (float)((double)this.rotationPitch + (this.field_6383_q - (double)this.rotationPitch) / (double)this.field_6388_l);
            --this.field_6388_l;
            this.setPosition(var21, var22, var23);
            this.setRotation(this.rotationYaw, this.rotationPitch);
        } else {
            double var13;
            if (!this.worldObj.multiplayerWorld) {
                ItemStack var1 = this.angler.getCurrentEquippedItem();
                if (this.angler.isDead || !this.angler.isEntityAlive() || var1 == null || var1.getItem() != Item.fishingRod || this.getDistanceSqToEntity(this.angler) > 1024.0) {
                    this.setEntityDead();
                    this.angler.fishEntity = null;
                    return;
                }
                if (this.bobber != null) {
                    if (!this.bobber.isDead) {
                        this.posX = this.bobber.posX;
                        this.posY = this.bobber.boundingBox.minY + (double)this.bobber.height * 0.8;
                        this.posZ = this.bobber.posZ;
                        return;
                    }
                    this.bobber = null;
                }
            }
            if (this.shake > 0) {
                --this.shake;
            }
            if (this.inGround) {
                int var19 = this.worldObj.getBlockId(this.xTile, this.yTile, this.zTile);
                if (var19 == this.inTile) {
                    ++this.ticksInGround;
                    if (this.ticksInGround == 1200) {
                        this.setEntityDead();
                    }
                    return;
                }
                this.inGround = false;
                this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
                this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
                this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            } else {
                ++this.ticksInAir;
            }
            Vec3D var20 = Vec3D.createVector(this.posX, this.posY, this.posZ);
            Vec3D var2 = Vec3D.createVector(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
            MovingObjectPosition var3 = this.worldObj.rayTraceBlocks(var20, var2);
            var20 = Vec3D.createVector(this.posX, this.posY, this.posZ);
            var2 = Vec3D.createVector(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
            if (var3 != null) {
                var2 = Vec3D.createVector(var3.hitVec.xCoord, var3.hitVec.yCoord, var3.hitVec.zCoord);
            }
            Entity var4 = null;
            List var5 = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
            double var6 = 0.0;
            int var8 = 0;
            while (var8 < var5.size()) {
                float var10;
                AxisAlignedBB var11;
                MovingObjectPosition var12;
                Entity var9 = (Entity)var5.get(var8);
                if (var9.canBeCollidedWith() && (var9 != this.angler || this.ticksInAir >= 5) && (var12 = (var11 = var9.boundingBox.expand(var10 = 0.3f, var10, var10)).func_1169_a(var20, var2)) != null && ((var13 = var20.distanceTo(var12.hitVec)) < var6 || var6 == 0.0)) {
                    var4 = var9;
                    var6 = var13;
                }
                ++var8;
            }
            if (var4 != null) {
                var3 = new MovingObjectPosition(var4);
            }
            if (var3 != null) {
                if (var3.entityHit != null) {
                    if (var3.entityHit.attackEntityFrom(this.angler, 0)) {
                        this.bobber = var3.entityHit;
                    }
                } else {
                    this.inGround = true;
                }
            }
            if (!this.inGround) {
                this.moveEntity(this.motionX, this.motionY, this.motionZ);
                float var24 = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
                this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / 3.1415927410125732);
                this.rotationPitch = (float)(Math.atan2(this.motionY, var24) * 180.0 / 3.1415927410125732);
                while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
                    this.prevRotationPitch -= 360.0f;
                }
                while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
                    this.prevRotationPitch += 360.0f;
                }
                while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
                    this.prevRotationYaw -= 360.0f;
                }
                while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
                    this.prevRotationYaw += 360.0f;
                }
                this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
                this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
                float var25 = 0.92f;
                if (this.onGround || this.isCollidedHorizontally) {
                    var25 = 0.5f;
                }
                int var26 = 5;
                double var27 = 0.0;
                int var28 = 0;
                while (var28 < var26) {
                    double var14 = this.boundingBox.minY + (this.boundingBox.maxY - this.boundingBox.minY) * (double)(var28 + 0) / (double)var26 - 0.125 + 0.125;
                    double var16 = this.boundingBox.minY + (this.boundingBox.maxY - this.boundingBox.minY) * (double)(var28 + 1) / (double)var26 - 0.125 + 0.125;
                    AxisAlignedBB var18 = AxisAlignedBB.getBoundingBoxFromPool(this.boundingBox.minX, var14, this.boundingBox.minZ, this.boundingBox.maxX, var16, this.boundingBox.maxZ);
                    if (this.worldObj.isAABBInMaterial(var18, Material.water)) {
                        var27 += 1.0 / (double)var26;
                    }
                    ++var28;
                }
                if (var27 > 0.0) {
                    if (this.ticksCatchable > 0) {
                        --this.ticksCatchable;
                    } else {
                        int var29 = 500;
                        if (this.worldObj.canBlockBeRainedOn(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY) + 1, MathHelper.floor_double(this.posZ))) {
                            var29 = 300;
                        }
                        if (this.rand.nextInt(var29) == 0) {
                            float var31;
                            this.ticksCatchable = this.rand.nextInt(30) + 10;
                            this.motionY -= (double)0.2f;
                            this.worldObj.playSoundAtEntity(this, "random.splash", 0.25f, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
                            float var30 = MathHelper.floor_double(this.boundingBox.minY);
                            int var15 = 0;
                            while ((float)var15 < 1.0f + this.width * 20.0f) {
                                var31 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                                float var17 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                                this.worldObj.spawnParticle("bubble", this.posX + (double)var31, var30 + 1.0f, this.posZ + (double)var17, this.motionX, this.motionY - (double)(this.rand.nextFloat() * 0.2f), this.motionZ);
                                ++var15;
                            }
                            var15 = 0;
                            while ((float)var15 < 1.0f + this.width * 20.0f) {
                                var31 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                                float var17 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                                this.worldObj.spawnParticle("splash", this.posX + (double)var31, var30 + 1.0f, this.posZ + (double)var17, this.motionX, this.motionY, this.motionZ);
                                ++var15;
                            }
                        }
                    }
                }
                if (this.ticksCatchable > 0) {
                    this.motionY -= (double)(this.rand.nextFloat() * this.rand.nextFloat() * this.rand.nextFloat()) * 0.2;
                }
                var13 = var27 * 2.0 - 1.0;
                this.motionY += (double)0.04f * var13;
                if (var27 > 0.0) {
                    var25 = (float)((double)var25 * 0.9);
                    this.motionY *= 0.8;
                }
                this.motionX *= (double)var25;
                this.motionY *= (double)var25;
                this.motionZ *= (double)var25;
                this.setPosition(this.posX, this.posY, this.posZ);
            }
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound var1) {
        var1.setShort("xTile", (short)this.xTile);
        var1.setShort("yTile", (short)this.yTile);
        var1.setShort("zTile", (short)this.zTile);
        var1.setByte("inTile", (byte)this.inTile);
        var1.setByte("shake", (byte)this.shake);
        var1.setByte("inGround", (byte)(this.inGround ? 1 : 0));
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound var1) {
        this.xTile = var1.getShort("xTile");
        this.yTile = var1.getShort("yTile");
        this.zTile = var1.getShort("zTile");
        this.inTile = var1.getByte("inTile") & 0xFF;
        this.shake = var1.getByte("shake") & 0xFF;
        this.inGround = var1.getByte("inGround") == 1;
    }

    @Override
    public float getShadowSize() {
        return 0.0f;
    }

    public int catchFish() {
        int var1 = 0;
        if (this.bobber != null) {
            double var2 = this.angler.posX - this.posX;
            double var4 = this.angler.posY - this.posY;
            double var6 = this.angler.posZ - this.posZ;
            double var8 = MathHelper.sqrt_double(var2 * var2 + var4 * var4 + var6 * var6);
            double var10 = 0.1;
            Entity var10000 = this.bobber;
            var10000.motionX += var2 * var10;
            var10000 = this.bobber;
            var10000.motionY += var4 * var10 + (double)MathHelper.sqrt_double(var8) * 0.08;
            var10000 = this.bobber;
            var10000.motionZ += var6 * var10;
            var1 = 3;
        } else if (this.ticksCatchable > 0) {
            EntityItem var13 = new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, new ItemStack(Item.fishRaw));
            double var3 = this.angler.posX - this.posX;
            double var5 = this.angler.posY - this.posY;
            double var7 = this.angler.posZ - this.posZ;
            double var9 = MathHelper.sqrt_double(var3 * var3 + var5 * var5 + var7 * var7);
            double var11 = 0.1;
            var13.motionX = var3 * var11;
            var13.motionY = var5 * var11 + (double)MathHelper.sqrt_double(var9) * 0.08;
            var13.motionZ = var7 * var11;
            this.worldObj.entityJoinedWorld(var13);
            this.angler.addStat(StatList.fishCaughtStat, 1);
            var1 = 1;
        }
        if (this.inGround) {
            var1 = 2;
        }
        this.setEntityDead();
        this.angler.fishEntity = null;
        return var1;
    }
}

