/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.entity.other;

import java.util.List;
import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.nbt.NBTTagCompound;

public class EntityChair
extends Entity {
    private int field_695_c = 0;
    public int direction = 0;
    public int xPosition;
    public int yPosition;
    public int zPosition;

    public EntityChair(World var1) {
        super(var1);
        this.setSize(0.5f, 0.5f);
    }

    @Override
    public double getMountedYOffset() {
        return (double)this.height - 0.25;
    }

    public EntityChair(World var1, double var2, double var4, double var6) {
        this(var1);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = var2;
        this.prevPosY = var4;
        this.prevPosZ = var6;
    }

    public EntityChair(World var1, int var2, int var3, int var4, int var5) {
        this(var1);
        this.xPosition = var2;
        this.yPosition = var3;
        this.zPosition = var4;
    }

    @Override
    protected void entityInit() {
    }

    @Override
    public void onUpdate() {
        int var1 = 5;
        int var4 = 0;
        while (var4 < var1) {
            double var5 = this.boundingBox.minY + (this.boundingBox.maxY - this.boundingBox.minY) * (double)(var4 + 0) / (double)var1 - 0.125;
            double var7 = this.boundingBox.minY + (this.boundingBox.maxY - this.boundingBox.minY) * (double)(var4 + 1) / (double)var1 - 0.125;
            AxisAlignedBB var9 = AxisAlignedBB.getBoundingBoxFromPool(this.boundingBox.minX, var5, this.boundingBox.minZ, this.boundingBox.maxX, var7, this.boundingBox.maxZ);
            if (this.field_695_c++ == 40 && !this.worldObj.multiplayerWorld) {
                this.field_695_c = 0;
                if (!this.worldObj.isAABBInMaterial(var9, Material.chair)) {
                    this.setEntityDead();
                }
            }
            ++var4;
        }
    }

    public boolean func_410_i() {
        int var7;
        if (this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox).size() > 0) {
            return false;
        }
        int var3 = this.xPosition;
        int var4 = this.yPosition;
        int var5 = this.zPosition;
        int var6 = 0;
        while (var6 < 1) {
            var7 = 0;
            while (var7 < 1) {
                Material var8 = this.direction != 0 && this.direction != 2 ? this.worldObj.getBlockMaterial(var3 + var6, this.yPosition - 1, var5 + var6) : this.worldObj.getBlockMaterial(var3 + var6, this.yPosition - 1, var5 + var6);
                if (!var8.isSolid()) {
                    return false;
                }
                ++var7;
            }
            ++var6;
        }
        List var9 = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox);
        var7 = 0;
        while (var7 < var9.size()) {
            if (var9.get(var7) instanceof EntityChair) {
                return false;
            }
            ++var7;
        }
        return true;
    }

    @Override
    public boolean canBeCollidedWith() {
        return true;
    }

    @Override
    public boolean attackEntityFrom(Entity var1, int var2) {
        return true;
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound var1) {
        var1.setByte("Dir", (byte)this.direction);
        var1.setInteger("TileX", this.xPosition);
        var1.setInteger("TileY", this.yPosition);
        var1.setInteger("TileZ", this.zPosition);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound var1) {
        this.direction = var1.getByte("Dir");
        this.xPosition = var1.getInteger("TileX");
        this.yPosition = var1.getInteger("TileY");
        this.zPosition = var1.getInteger("TileZ");
    }

    @Override
    public void moveEntity(double var1, double var3, double var5) {
        if (!this.worldObj.multiplayerWorld && var1 * var1 + var3 * var3 + var5 * var5 > 0.0) {
            this.setEntityDead();
        }
    }

    @Override
    public void addVelocity(double var1, double var3, double var5) {
        if (!this.worldObj.multiplayerWorld && var1 * var1 + var3 * var3 + var5 * var5 > 0.0) {
            this.setEntityDead();
        }
    }

    @Override
    public boolean interact(EntityPlayer var1) {
        if (this.riddenByEntity != null && this.riddenByEntity instanceof EntityPlayer && this.riddenByEntity != var1) {
            return true;
        }
        if (!this.worldObj.multiplayerWorld) {
            var1.mountEntity(this);
        }
        return true;
    }
}

