/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.entity.other;

import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.nbt.NBTTagCompound;

public class EntityBaseProjectile
extends Entity {
    private int xTileFirework = -1;
    private int yTileFirework = -1;
    private int zTileFirework = -1;
    private int inTileFirework = 0;
    private boolean inGroundFirework = false;
    public int shakeFirework = 0;
    private EntityLiving thrower;
    private int ticksInGroundFirework;
    private int ticksInAirFirework = 0;
    public int counter = 0;

    public EntityBaseProjectile(World var1) {
        super(var1);
        this.setSize(0.25f, 0.25f);
    }

    @Override
    protected void entityInit() {
    }

    @Override
    protected final String getEntityString() {
        return "Thrown";
    }

    public EntityBaseProjectile(World world, EntityLiving owner) {
        super(world);
        this.thrower = owner;
        this.setSize(0.5f, 0.5f);
        this.setPositionAndRotation(owner.posX, owner.posY, owner.posZ, owner.rotationYaw, owner.rotationPitch);
        this.posX -= (double)(MathHelper.cos(this.rotationYaw / 180.0f * (float)Math.PI) * 0.16f);
        this.posY -= (double)0.1f;
        this.posZ -= (double)(MathHelper.sin(this.rotationYaw / 180.0f * (float)Math.PI) * 0.16f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.yOffset = 0.0f;
        this.motionX = -MathHelper.sin(this.rotationYaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.rotationPitch / 180.0f * (float)Math.PI);
        this.motionZ = MathHelper.cos(this.rotationYaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.rotationPitch / 180.0f * (float)Math.PI);
        this.motionY = -MathHelper.sin(this.rotationPitch / 180.0f * (float)Math.PI);
        this.setFireworkHeading(this.motionX, this.motionY, this.motionZ, 1.5f, 1.0f);
    }

    public EntityBaseProjectile(World var1, float var2, float var4, float var6) {
        super(var1);
        this.ticksInGroundFirework = 0;
        this.setSize(0.25f, 0.25f);
        this.setPosition(var2, var4, var6);
        this.yOffset = 0.0f;
    }

    public void setFireworkHeading(double var1, double var3, double var5, float var7, float var8) {
        float var9 = MathHelper.sqrt_double(var1 * var1 + var3 * var3 + var5 * var5);
        var1 /= (double)var9;
        var3 /= (double)var9;
        var5 /= (double)var9;
        var1 += this.rand.nextGaussian() * (double)0.0075f * (double)var8;
        var3 += this.rand.nextGaussian() * (double)0.0075f * (double)var8;
        var5 += this.rand.nextGaussian() * (double)0.0075f * (double)var8;
        this.motionX = var1 *= (double)var7;
        this.motionY = var3 *= (double)var7;
        this.motionZ = var5 *= (double)var7;
        float var10 = MathHelper.sqrt_double(var1 * var1 + var5 * var5);
        this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(var1, var5) * 180.0 / 3.1415927410125732);
        this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(var3, var10) * 180.0 / 3.1415927410125732);
        this.ticksInGroundFirework = 0;
    }

    public void setVelocity(float var1, float var3, float var5) {
        this.motionX = var1;
        this.motionY = var3;
        this.motionZ = var5;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float var7 = MathHelper.sqrt_float(var1 * var1 + var5 * var5);
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(var1, var5) * 180.0 / 3.1415927410125732);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(var3, var7) * 180.0 / 3.1415927410125732);
        }
    }

    @Override
    public void onEntityUpdate() {
        if (!this.onGround) {
            ++this.counter;
            if (this.counter >= 20) {
                this.counter = 0;
            }
        }
        this.worldObj.spawnParticle("smoke", this.posX, this.posY, this.posZ, 0.0, 0.0, 0.0);
        this.worldObj.spawnParticle("smoke", this.posX, this.posY, this.posZ, 0.0, 0.0, 0.0);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound var1) {
        var1.setShort("xTile", (short)this.xTileFirework);
        var1.setShort("yTile", (short)this.yTileFirework);
        var1.setShort("zTile", (short)this.zTileFirework);
        var1.setByte("inTile", (byte)this.inTileFirework);
        var1.setByte("shake", (byte)this.shakeFirework);
        var1.setByte("inGround", (byte)(this.inGroundFirework ? 1 : 0));
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound var1) {
        this.xTileFirework = var1.getShort("xTile");
        this.yTileFirework = var1.getShort("yTile");
        this.zTileFirework = var1.getShort("zTile");
        this.inTileFirework = var1.getByte("inTile") & 0xFF;
        this.shakeFirework = var1.getByte("shake") & 0xFF;
        this.inGroundFirework = var1.getByte("inGround") == 1;
    }

    @Override
    public float getShadowSize() {
        return 0.0f;
    }
}

