/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.entity.other;

import java.util.List;
import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.client.physics.MovingObjectPosition;
import net.minecraft.src.client.renderer.Vec3D;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.nbt.NBTTagCompound;

public class EntityArrowPurple
extends Entity {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private int inTile = 0;
    private int inTileWithMetadata = 0;
    private boolean inGround = false;
    public boolean doesArrowBelongToPlayer = false;
    public int arrowShake = 0;
    public EntityLiving owner;
    private int ticksInGround;
    private int ticksInAir = 0;

    public EntityArrowPurple(World world) {
        super(world);
        this.setSize(0.5f, 0.5f);
    }

    public EntityArrowPurple(World world, double xCoord, double yCoord, double zCoord) {
        super(world);
        this.setSize(0.5f, 0.5f);
        this.setPosition(xCoord, yCoord, zCoord);
        this.yOffset = 0.0f;
    }

    public EntityArrowPurple(World world, EntityLiving entityLiving) {
        super(world);
        this.owner = entityLiving;
        this.doesArrowBelongToPlayer = entityLiving instanceof EntityPlayer;
        this.setSize(0.5f, 0.5f);
        this.setLocationAndAngles(entityLiving.posX, entityLiving.posY + (double)entityLiving.getEyeHeight(), entityLiving.posZ, entityLiving.rotationYaw, entityLiving.rotationPitch);
        this.posX -= (double)(MathHelper.cos(this.rotationYaw / 180.0f * (float)Math.PI) * 0.16f);
        this.posY -= (double)0.1f;
        this.posZ -= (double)(MathHelper.sin(this.rotationYaw / 180.0f * (float)Math.PI) * 0.16f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.yOffset = 0.0f;
        this.motionX = -MathHelper.sin(this.rotationYaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.rotationPitch / 180.0f * (float)Math.PI);
        this.motionZ = MathHelper.cos(this.rotationYaw / 180.0f * (float)Math.PI) * MathHelper.cos(this.rotationPitch / 180.0f * (float)Math.PI);
        this.motionY = -MathHelper.sin(this.rotationPitch / 180.0f * (float)Math.PI);
        this.setArrowHeading(this.motionX, this.motionY, this.motionZ, 1.5f, 1.0f);
    }

    @Override
    protected void entityInit() {
    }

    public void setArrowHeading(double xPosVelocity, double yPosVelocity, double zPosVelocity, float var7, float var8) {
        float combinedMotion = MathHelper.sqrt_double(xPosVelocity * xPosVelocity + yPosVelocity * yPosVelocity + zPosVelocity * zPosVelocity);
        xPosVelocity /= (double)combinedMotion;
        yPosVelocity /= (double)combinedMotion;
        zPosVelocity /= (double)combinedMotion;
        xPosVelocity += this.rand.nextGaussian() * (double)0.0075f * (double)var8;
        yPosVelocity += this.rand.nextGaussian() * (double)0.0075f * (double)var8;
        zPosVelocity += this.rand.nextGaussian() * (double)0.0075f * (double)var8;
        this.motionX = xPosVelocity *= (double)var7;
        this.motionY = yPosVelocity *= (double)var7;
        this.motionZ = zPosVelocity *= (double)var7;
        float combinedVelocity = MathHelper.sqrt_double(xPosVelocity * xPosVelocity + zPosVelocity * zPosVelocity);
        this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(xPosVelocity, zPosVelocity) * 180.0 / 3.1415927410125732);
        this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(yPosVelocity, combinedVelocity) * 180.0 / 3.1415927410125732);
        this.ticksInGround = 0;
    }

    @Override
    public void setVelocity(double velocityX, double velocityY, double velocityZ) {
        this.motionX = velocityX;
        this.motionY = velocityY;
        this.motionZ = velocityZ;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float combinedMotion = MathHelper.sqrt_double(velocityX * velocityX + velocityZ * velocityZ);
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(velocityX, velocityZ) * 180.0 / 3.1415927410125732);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(velocityY, combinedMotion) * 180.0 / 3.1415927410125732);
            this.prevRotationPitch = this.rotationPitch;
            this.prevRotationYaw = this.rotationYaw;
            this.setLocationAndAngles(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
            this.ticksInGround = 0;
        }
    }

    @Override
    public void onUpdate() {
        int blockTile;
        super.onUpdate();
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float combinedMotion = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / 3.1415927410125732);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(this.motionY, combinedMotion) * 180.0 / 3.1415927410125732);
        }
        if ((blockTile = this.worldObj.getBlockId(this.xTile, this.yTile, this.zTile)) > 0) {
            Block.blocksList[blockTile].setBlockBoundsBasedOnState(this.worldObj, this.xTile, this.yTile, this.zTile);
            AxisAlignedBB var2 = Block.blocksList[blockTile].getCollisionBoundingBoxFromPool(this.worldObj, this.xTile, this.yTile, this.zTile);
            if (var2 != null && var2.isVecInside(Vec3D.createVector(this.posX, this.posY, this.posZ))) {
                this.inGround = true;
            }
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.inGround) {
            blockTile = this.worldObj.getBlockId(this.xTile, this.yTile, this.zTile);
            int blockTileMetadata = this.worldObj.getBlockMetadata(this.xTile, this.yTile, this.zTile);
            if (blockTile == this.inTile && blockTileMetadata == this.inTileWithMetadata) {
                ++this.ticksInGround;
                if (this.ticksInGround == 1200) {
                    this.setEntityDead();
                }
            } else {
                this.inGround = false;
                this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
                this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
                this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            }
        } else {
            float boundingBoxFloat;
            ++this.ticksInAir;
            Vec3D currentPosition = Vec3D.createVector(this.posX, this.posY, this.posZ);
            Vec3D currentMotionPosition = Vec3D.createVector(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
            MovingObjectPosition raytracedEntity = this.worldObj.rayTraceBlocks_do_do(currentPosition, currentMotionPosition, false, true);
            currentPosition = Vec3D.createVector(this.posX, this.posY, this.posZ);
            currentMotionPosition = Vec3D.createVector(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
            if (raytracedEntity != null) {
                currentMotionPosition = Vec3D.createVector(raytracedEntity.hitVec.xCoord, raytracedEntity.hitVec.yCoord, raytracedEntity.hitVec.zCoord);
            }
            Entity entity = null;
            List boundingBoxCheck = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
            double var6 = 0.0;
            int checkAmount = 0;
            while (checkAmount < boundingBoxCheck.size()) {
                double var13;
                AxisAlignedBB aabb;
                MovingObjectPosition raytrace;
                Entity entityHitByArrow = (Entity)boundingBoxCheck.get(checkAmount);
                if (entityHitByArrow.canBeCollidedWith() && (entityHitByArrow != this.owner || this.ticksInAir >= 5) && (raytrace = (aabb = entityHitByArrow.boundingBox.expand(boundingBoxFloat = 0.3f, boundingBoxFloat, boundingBoxFloat)).func_1169_a(currentPosition, currentMotionPosition)) != null && ((var13 = currentPosition.distanceTo(raytrace.hitVec)) < var6 || var6 == 0.0)) {
                    entity = entityHitByArrow;
                    var6 = var13;
                }
                ++checkAmount;
            }
            if (entity != null) {
                raytracedEntity = new MovingObjectPosition(entity);
            }
            if (raytracedEntity != null) {
                if (raytracedEntity.entityHit != null) {
                    if (raytracedEntity.entityHit.attackEntityFrom(this.owner, 4)) {
                        this.worldObj.playSoundAtEntity(this, "random.drr", 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
                        this.setEntityDead();
                    } else {
                        this.motionX *= (double)-0.1f;
                        this.motionY *= (double)-0.1f;
                        this.motionZ *= (double)-0.1f;
                        this.rotationYaw += 180.0f;
                        this.prevRotationYaw += 180.0f;
                        this.ticksInAir = 0;
                    }
                } else {
                    this.xTile = raytracedEntity.blockX;
                    this.yTile = raytracedEntity.blockY;
                    this.zTile = raytracedEntity.blockZ;
                    this.inTile = this.worldObj.getBlockId(this.xTile, this.yTile, this.zTile);
                    this.inTileWithMetadata = this.worldObj.getBlockMetadata(this.xTile, this.yTile, this.zTile);
                    this.motionX = (float)(raytracedEntity.hitVec.xCoord - this.posX);
                    this.motionY = (float)(raytracedEntity.hitVec.yCoord - this.posY);
                    this.motionZ = (float)(raytracedEntity.hitVec.zCoord - this.posZ);
                    float var19 = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ);
                    this.posX -= this.motionX / (double)var19 * (double)0.05f;
                    this.posY -= this.motionY / (double)var19 * (double)0.05f;
                    this.posZ -= this.motionZ / (double)var19 * (double)0.05f;
                    this.worldObj.playSoundAtEntity(this, "random.drr", 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
                    this.inGround = true;
                    this.arrowShake = 7;
                }
            }
            this.posX += this.motionX;
            this.posY += this.motionY;
            this.posZ += this.motionZ;
            float var19 = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
            this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / 3.1415927410125732);
            this.rotationPitch = (float)(Math.atan2(this.motionY, var19) * 180.0 / 3.1415927410125732);
            while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
                this.prevRotationPitch -= 360.0f;
            }
            while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
                this.prevRotationPitch += 360.0f;
            }
            while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
                this.prevRotationYaw -= 360.0f;
            }
            while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
                this.prevRotationYaw += 360.0f;
            }
            this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
            this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
            float var20 = 0.99f;
            boundingBoxFloat = 0.03f;
            if (this.isInWater()) {
                int var21 = 0;
                while (var21 < 4) {
                    float var22 = 0.25f;
                    this.worldObj.spawnParticle("bubble", this.posX - this.motionX * (double)var22, this.posY - this.motionY * (double)var22, this.posZ - this.motionZ * (double)var22, this.motionX, this.motionY, this.motionZ);
                    ++var21;
                }
                var20 = 0.8f;
            }
            this.motionX *= (double)var20;
            this.motionY *= (double)var20;
            this.motionZ *= (double)var20;
            this.motionY -= (double)boundingBoxFloat;
            this.setPosition(this.posX, this.posY, this.posZ);
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbt) {
        nbt.setShort("xTile", (short)this.xTile);
        nbt.setShort("yTile", (short)this.yTile);
        nbt.setShort("zTile", (short)this.zTile);
        nbt.setByte("inTile", (byte)this.inTile);
        nbt.setByte("inData", (byte)this.inTileWithMetadata);
        nbt.setByte("shake", (byte)this.arrowShake);
        nbt.setByte("inGround", (byte)(this.inGround ? 1 : 0));
        nbt.setBoolean("player", this.doesArrowBelongToPlayer);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbt) {
        this.xTile = nbt.getShort("xTile");
        this.yTile = nbt.getShort("yTile");
        this.zTile = nbt.getShort("zTile");
        this.inTile = nbt.getByte("inTile") & 0xFF;
        this.inTileWithMetadata = nbt.getByte("inData") & 0xFF;
        this.arrowShake = nbt.getByte("shake") & 0xFF;
        this.inGround = nbt.getByte("inGround") == 1;
        this.doesArrowBelongToPlayer = nbt.getBoolean("player");
    }

    @Override
    public float getShadowSize() {
        return 0.0f;
    }
}

