/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.entity.monster;

import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.entity.EntityMob;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.EnumSkyBlock;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.nbt.NBTTagCompound;

public class EntityZombieArmored
extends EntityMob {
    private static final ItemStack defaultHeldItem = new ItemStack(Item.swordSteel, 1);
    boolean isKnight = this.rand.nextBoolean();

    public EntityZombieArmored(World var1) {
        super(var1);
        this.texture = "/mob/monsters/zombie_armored.png";
        this.moveSpeed = 1.25f;
        this.attackStrength = this.isKnight ? 6 : 3;
        this.health = 40;
    }

    @Override
    public boolean getCanSpawnHere() {
        int var3;
        int var2;
        int var1 = MathHelper.floor_double(this.posX);
        if (this.worldObj.getSavedLightValue(EnumSkyBlock.Sky, var1, var2 = MathHelper.floor_double(this.boundingBox.minY), var3 = MathHelper.floor_double(this.posZ)) > this.rand.nextInt(32)) {
            return false;
        }
        return super.getCanSpawnHere();
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
    }

    @Override
    protected String getLivingSound() {
        return "mob.zombie";
    }

    @Override
    protected String getHurtSound() {
        return "mob.zombiehurt";
    }

    @Override
    protected String getDeathSound() {
        return "mob.zombiedeath";
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound var1) {
        super.writeEntityToNBT(var1);
        var1.setBoolean("IsKnight", this.isKnight);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound var1) {
        super.readEntityFromNBT(var1);
        this.isKnight = var1.getBoolean("IsKnight");
    }

    @Override
    public ItemStack getHeldItem() {
        return this.isKnight ? defaultHeldItem : null;
    }
}

