/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.entity.monster;

import net.minecraft.src.client.physics.MovingObjectPosition;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.entity.DamageSource;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.EntityMob;
import net.minecraft.src.game.entity.other.EntitySmallFireball;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.nbt.NBTTagCompound;

public class EntityBlaze
extends EntityMob {
    private float field_40154_a = 0.5f;
    private int field_40153_b;
    private int field_40152_d;

    public EntityBlaze(World world) {
        super(world);
        this.texture = "/mob/monsters/fire.png";
        this.isImmuneToFire = true;
        this.attackStrength = 6;
        this.scoreValue = 20;
    }

    public int getMaxHealth() {
        return 20;
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, new Byte(0));
    }

    @Override
    protected String getLivingSound() {
        return "random.breath";
    }

    @Override
    protected String getHurtSound() {
        return "random.fizz";
    }

    @Override
    protected String getDeathSound() {
        return "random.fizz";
    }

    @Override
    public boolean attackEntityFrom(Entity damagesource, int i) {
        return super.attackEntityFrom(damagesource, i);
    }

    @Override
    public void onDeathSpecial(DamageSource damagesource) {
        super.onDeathSpecial(damagesource);
    }

    public int getEntityBrightnessForRender(float f) {
        return 0xF000F0;
    }

    @Override
    public float getEntityBrightness(float f) {
        return 1.0f;
    }

    @Override
    public void onLivingUpdate() {
        if (!this.worldObj.multiplayerWorld) {
            if (this.isWet()) {
                this.attackEntityFromSpecial(DamageSource.drown, 1);
            }
            --this.field_40153_b;
            if (this.field_40153_b <= 0) {
                this.field_40153_b = 100;
                this.field_40154_a = 0.5f + (float)this.rand.nextGaussian() * 3.0f;
            }
            if (this.getEntityToAttack() != null && this.getEntityToAttack().posY + (double)this.getEntityToAttack().getEyeHeight() > this.posY + (double)this.getEyeHeight() + (double)this.field_40154_a) {
                this.motionY += ((double)0.3f - this.motionY) * (double)0.3f;
            }
        }
        if (this.rand.nextInt(24) == 0) {
            this.worldObj.playSoundEffect(this.posX + 0.5, this.posY + 0.5, this.posZ + 0.5, "fire.fire", 1.0f + this.rand.nextFloat(), this.rand.nextFloat() * 0.7f + 0.3f);
        }
        if (!this.onGround && this.motionY < 0.0) {
            this.motionY *= 0.6;
        }
        int i = 0;
        while (i < 2) {
            this.worldObj.spawnParticle("largesmoke", this.posX + (this.rand.nextDouble() - 0.5) * (double)this.width, this.posY + this.rand.nextDouble() * (double)this.height, this.posZ + (this.rand.nextDouble() - 0.5) * (double)this.width, 0.0, 0.0, 0.0);
            ++i;
        }
        super.onLivingUpdate();
    }

    @Override
    protected void attackEntity(Entity entity, float f) {
        MovingObjectPosition movingobjectposition = new MovingObjectPosition(entity);
        if (this.attackTime <= 0 && f < 2.0f && entity.boundingBox.maxY > this.boundingBox.minY && entity.boundingBox.minY < this.boundingBox.maxY) {
            this.attackTime = 20;
            movingobjectposition.entityHit.attackEntityFrom(this, 5);
        } else if (f < 30.0f) {
            double d = entity.posX - this.posX;
            double d1 = entity.boundingBox.minY + (double)(entity.height / 2.0f) - (this.posY + (double)(this.height / 2.0f));
            double d2 = entity.posZ - this.posZ;
            if (this.attackTime == 0) {
                ++this.field_40152_d;
                if (this.field_40152_d == 1) {
                    this.attackTime = 60;
                    this.func_40150_a(true);
                } else if (this.field_40152_d <= 4) {
                    this.attackTime = 6;
                } else {
                    this.attackTime = 100;
                    this.field_40152_d = 0;
                    this.func_40150_a(false);
                }
                if (this.field_40152_d > 1) {
                    float f1 = MathHelper.sqrt_float(f) * 0.5f;
                    this.worldObj.playSoundAtEntity(this, "random.explode", this.getSoundVolume() * 2.0f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) * 0.8f);
                    int i = 0;
                    while (i < 1) {
                        EntitySmallFireball entitysmallfireball = new EntitySmallFireball(this.worldObj, this, d + this.rand.nextGaussian() * (double)f1, d1, d2 + this.rand.nextGaussian() * (double)f1);
                        entitysmallfireball.posY = this.posY + (double)(this.height / 2.0f) + 0.5;
                        this.worldObj.entityJoinedWorld(entitysmallfireball);
                        ++i;
                    }
                }
            }
            this.rotationYaw = (float)(Math.atan2(d2, d) * 180.0 / 3.1415927410125732) - 90.0f;
            this.hasAttacked = true;
        }
    }

    @Override
    protected void fall(float f) {
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        super.writeEntityToNBT(nbttagcompound);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        super.readEntityFromNBT(nbttagcompound);
    }

    @Override
    protected int getDropItemId() {
        return Item.lightStoneDust.itemID;
    }

    @Override
    public boolean isBurning() {
        return this.func_40151_ac();
    }

    protected void dropFewItems(boolean flag, int i) {
        if (flag) {
            int j = this.rand.nextInt(2 + i);
            int k = 0;
            while (k < j) {
                this.dropItem(Item.lightStoneDust.itemID, 1);
                ++k;
            }
        }
    }

    public boolean func_40151_ac() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 1) != 0;
    }

    public void func_40150_a(boolean flag) {
        byte byte0 = this.dataWatcher.getWatchableObjectByte(16);
        byte0 = flag ? (byte)(byte0 | 1) : (byte)(byte0 & 0xFE);
        this.dataWatcher.updateObject(16, byte0);
    }

    protected boolean func_40147_Y() {
        return true;
    }
}

