/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.entity.animals;

import net.minecraft.src.game.achievements.AchievementList;
import net.minecraft.src.game.entity.animals.EntityAnimal;
import net.minecraft.src.game.entity.monster.EntityPigZombie;
import net.minecraft.src.game.entity.other.EntityLightningBolt;
import net.minecraft.src.game.entity.other.EntitySpeechBubble;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.nbt.NBTTagCompound;

public class EntityPig
extends EntityAnimal {
    public boolean isSpeaking = false;
    public int counter = 0;

    public EntityPig(World var1) {
        super(var1);
        this.texture = "/mob/animals/pig/pig.png";
        this.setSize(0.9f, 0.9f);
    }

    @Override
    protected void entityInit() {
        this.dataWatcher.addObject(16, (byte)0);
    }

    public boolean getSpeaking() {
        return this.isSpeaking;
    }

    public boolean setSpeaking(boolean bool) {
        this.isSpeaking = bool;
        return this.isSpeaking;
    }

    @Override
    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (!this.worldObj.multiplayerWorld) {
            if (this.rand.nextInt(20000) == 0 && !this.isSpeaking) {
                this.pigCreatesTextBubble();
            }
            if (this.isSpeaking) {
                ++this.counter;
                if (this.counter >= 140) {
                    this.counter = 0;
                    this.setSpeaking(false);
                }
            }
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbt) {
        super.writeEntityToNBT(nbt);
        nbt.setBoolean("Saddle", this.getSaddled());
        nbt.setBoolean("Speaking", this.getSpeaking());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbt) {
        super.readEntityFromNBT(nbt);
        this.setSpeaking(nbt.getBoolean("Speaking"));
    }

    public void pigCreatesTextBubble() {
        if (!this.worldObj.multiplayerWorld) {
            EntitySpeechBubble textbubble = new EntitySpeechBubble(this.worldObj);
            textbubble.setLocationAndAngles(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
            textbubble.thrower = this;
            this.worldObj.entityJoinedWorld(textbubble);
            this.worldObj.playSoundAtEntity(this, "mob.pig", 1.0f, 1.0f);
            this.setSpeaking(true);
        }
    }

    @Override
    protected String getLivingSound() {
        return "mob.pig";
    }

    @Override
    protected String getHurtSound() {
        return "mob.pig";
    }

    @Override
    protected String getDeathSound() {
        return "mob.pigdeath";
    }

    @Override
    public boolean interact(EntityPlayer var1) {
        ItemStack var2 = var1.inventory.getCurrentItem();
        if (var2 != null && var2.itemID == Item.carrot.itemID && !this.worldObj.multiplayerWorld) {
            if (!var1.capabilities.depleteItems) {
                --var2.stackSize;
            }
            this.pigCreatesTextBubble();
            return true;
        }
        if (!this.getSaddled() || this.worldObj.multiplayerWorld || this.riddenByEntity != null && this.riddenByEntity != var1) {
            return false;
        }
        var1.mountEntity(this);
        return true;
    }

    @Override
    protected int getDropItemId() {
        return this.fire > 0 ? Item.porkCooked.itemID : Item.porkRaw.itemID;
    }

    public boolean getSaddled() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 1) != 0;
    }

    public void setSaddled(boolean var1) {
        if (var1) {
            this.dataWatcher.updateObject(16, (byte)1);
        } else {
            this.dataWatcher.updateObject(16, (byte)0);
        }
    }

    @Override
    public void onStruckByLightning(EntityLightningBolt var1) {
        if (!this.worldObj.multiplayerWorld) {
            EntityPigZombie var2 = new EntityPigZombie(this.worldObj);
            var2.setLocationAndAngles(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
            this.worldObj.entityJoinedWorld(var2);
            this.setEntityDead();
        }
    }

    @Override
    protected void fall(float var1) {
        super.fall(var1);
        if (var1 > 5.0f && this.riddenByEntity instanceof EntityPlayer) {
            ((EntityPlayer)this.riddenByEntity).triggerAchievement(AchievementList.flyPig);
        }
    }
}

