/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.entity;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.entity.EntityMob;
import net.minecraft.src.game.entity.animals.EntityChicken;
import net.minecraft.src.game.entity.animals.EntityCow;
import net.minecraft.src.game.entity.animals.EntityFox;
import net.minecraft.src.game.entity.animals.EntityMoobloom;
import net.minecraft.src.game.entity.animals.EntityMooshroom;
import net.minecraft.src.game.entity.animals.EntityPig;
import net.minecraft.src.game.entity.animals.EntitySheep;
import net.minecraft.src.game.entity.animals.EntitySquid;
import net.minecraft.src.game.entity.animals.EntityWolf;
import net.minecraft.src.game.entity.monster.EntityBlaze;
import net.minecraft.src.game.entity.monster.EntityCreeper;
import net.minecraft.src.game.entity.monster.EntityGhast;
import net.minecraft.src.game.entity.monster.EntityGiantZombie;
import net.minecraft.src.game.entity.monster.EntityPigZombie;
import net.minecraft.src.game.entity.monster.EntitySkeleton;
import net.minecraft.src.game.entity.monster.EntitySkeletonArmored;
import net.minecraft.src.game.entity.monster.EntitySlime;
import net.minecraft.src.game.entity.monster.EntitySpider;
import net.minecraft.src.game.entity.monster.EntityZombie;
import net.minecraft.src.game.entity.monster.EntityZombieArmored;
import net.minecraft.src.game.entity.other.EntityArrow;
import net.minecraft.src.game.entity.other.EntityArrowGolden;
import net.minecraft.src.game.entity.other.EntityArrowPurple;
import net.minecraft.src.game.entity.other.EntityBoat;
import net.minecraft.src.game.entity.other.EntityBrick;
import net.minecraft.src.game.entity.other.EntityChair;
import net.minecraft.src.game.entity.other.EntityDynamite;
import net.minecraft.src.game.entity.other.EntityFallingSand;
import net.minecraft.src.game.entity.other.EntityItem;
import net.minecraft.src.game.entity.other.EntityMinecart;
import net.minecraft.src.game.entity.other.EntityPainting;
import net.minecraft.src.game.entity.other.EntitySnowball;
import net.minecraft.src.game.entity.other.EntityTNTPrimed;
import net.minecraft.src.game.entity.other.EntityTorch;
import net.minecraft.src.game.entity.other.SignEntity;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.nbt.NBTTagCompound;

public class EntityList {
    private static Map stringToClassMapping = new HashMap();
    private static Map classToStringMapping = new HashMap();
    private static Map IDtoClassMapping = new HashMap();
    private static Map classToIDMapping = new HashMap();

    static {
        EntityList.addMapping(EntityArrow.class, "Arrow", 10);
        EntityList.addMapping(EntitySnowball.class, "Snowball", 11);
        EntityList.addMapping(EntityItem.class, "Item", 1);
        EntityList.addMapping(EntityPainting.class, "Painting", 9);
        EntityList.addMapping(EntityLiving.class, "Mob", 48);
        EntityList.addMapping(EntityMob.class, "Monster", 49);
        EntityList.addMapping(EntityCreeper.class, "Creeper", 50);
        EntityList.addMapping(EntitySkeleton.class, "Skeleton", 51);
        EntityList.addMapping(EntitySpider.class, "Spider", 52);
        EntityList.addMapping(EntityGiantZombie.class, "Giant", 53);
        EntityList.addMapping(EntityZombie.class, "Zombie", 54);
        EntityList.addMapping(EntitySlime.class, "Slime", 55);
        EntityList.addMapping(EntityGhast.class, "Ghast", 56);
        EntityList.addMapping(EntityPigZombie.class, "PigZombie", 57);
        EntityList.addMapping(EntityPig.class, "Pig", 90);
        EntityList.addMapping(EntitySheep.class, "Sheep", 91);
        EntityList.addMapping(EntityCow.class, "Cow", 92);
        EntityList.addMapping(EntityChicken.class, "Chicken", 93);
        EntityList.addMapping(EntitySquid.class, "Squid", 94);
        EntityList.addMapping(EntityWolf.class, "Wolf", 95);
        EntityList.addMapping(EntityTNTPrimed.class, "PrimedTnt", 20);
        EntityList.addMapping(EntityFallingSand.class, "FallingSand", 21);
        EntityList.addMapping(EntityMinecart.class, "Minecart", 40);
        EntityList.addMapping(EntityBoat.class, "Boat", 41);
        EntityList.addMapping(EntityFox.class, "Fox", 96);
        EntityList.addMapping(EntityArrowGolden.class, "GoldenArrow", 97);
        EntityList.addMapping(EntityBlaze.class, "Blaze", 98);
        EntityList.addMapping(EntityMooshroom.class, "Mooshroom", 99);
        EntityList.addMapping(EntityMoobloom.class, "Moobloom", 89);
        EntityList.addMapping(EntityChair.class, "ChairEntity", 88);
        EntityList.addMapping(SignEntity.class, "SignEntity", 87);
        EntityList.addMapping(EntityDynamite.class, "Dynamite", 86);
        EntityList.addMapping(EntityTorch.class, "Torch", 85);
        EntityList.addMapping(EntityBrick.class, "Brick", 84);
        EntityList.addMapping(EntityZombieArmored.class, "ArmoredZombie", 83);
        EntityList.addMapping(EntitySkeletonArmored.class, "ArmoredSkeleton", 82);
        EntityList.addMapping(EntityArrowPurple.class, "PurpleArrow", 81);
    }

    private static void addMapping(Class var0, String var1, int var2) {
        stringToClassMapping.put(var1, var0);
        classToStringMapping.put(var0, var1);
        IDtoClassMapping.put(var2, var0);
        classToIDMapping.put(var0, var2);
    }

    public static Entity createEntityInWorld(String var0, World var1) {
        Entity var2 = null;
        try {
            Class var3 = (Class)stringToClassMapping.get(var0);
            if (var3 != null) {
                var2 = (Entity)var3.getConstructor(World.class).newInstance(var1);
            }
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
        return var2;
    }

    public static Entity createEntityFromNBT(NBTTagCompound var0, World var1) {
        Entity var2 = null;
        try {
            Class var3 = (Class)stringToClassMapping.get(var0.getString("id"));
            if (var3 != null) {
                var2 = (Entity)var3.getConstructor(World.class).newInstance(var1);
            }
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
        if (var2 != null) {
            var2.readFromNBT(var0);
        } else {
            System.out.println("Skipping Entity with id " + var0.getString("id"));
        }
        return var2;
    }

    public static Entity createEntity(int var0, World var1) {
        Entity var2 = null;
        try {
            Class var3 = (Class)IDtoClassMapping.get(var0);
            if (var3 != null) {
                var2 = (Entity)var3.getConstructor(World.class).newInstance(var1);
            }
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
        if (var2 == null) {
            System.out.println("Skipping Entity with id " + var0);
        }
        return var2;
    }

    public static int getEntityID(Entity var0) {
        return (Integer)classToIDMapping.get(var0.getClass());
    }

    public static String getEntityString(Entity var0) {
        return (String)classToStringMapping.get(var0.getClass());
    }
}

