/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.entity;

import java.util.List;
import java.util.Random;
import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.client.player.EntityPlayerSP;
import net.minecraft.src.client.renderer.Vec3D;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.BlockFluid;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.block.StepSound;
import net.minecraft.src.game.block.tileentity.TileEntity;
import net.minecraft.src.game.entity.DamageSource;
import net.minecraft.src.game.entity.EntityList;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.entity.animals.EntityPig;
import net.minecraft.src.game.entity.animals.EntitySheep;
import net.minecraft.src.game.entity.other.EntityItem;
import net.minecraft.src.game.entity.other.EntityLightningBolt;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.entity.player.EnumPlayerAction;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.DataWatcher;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.nbt.NBTTagCompound;
import net.minecraft.src.game.nbt.NBTTagDouble;
import net.minecraft.src.game.nbt.NBTTagFloat;
import net.minecraft.src.game.nbt.NBTTagList;

public abstract class Entity {
    private static int nextEntityID = 0;
    public int entityId = nextEntityID++;
    public double renderDistanceWeight = 1.0;
    public boolean preventEntitySpawning = false;
    public Entity riddenByEntity;
    public Entity ridingEntity;
    public TileEntity ridingTileEntity;
    public World worldObj;
    public double prevPosX;
    public double prevPosY;
    public double prevPosZ;
    public double posX;
    public double posY;
    public double posZ;
    public double motionX;
    public double motionY;
    public double motionZ;
    public float rotationYaw;
    public float rotationPitch;
    public float prevRotationYaw;
    public float prevRotationPitch;
    public final AxisAlignedBB boundingBox = AxisAlignedBB.getBoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public boolean onGround = false;
    public boolean isCollidedHorizontally;
    public boolean isCollidedVertically;
    public boolean isCollided = false;
    public boolean beenAttacked = false;
    public boolean isInWeb;
    public boolean field_9293_aM = true;
    public boolean isDead = false;
    public float yOffset = 0.0f;
    public float width = 0.6f;
    public float height = 1.8f;
    public float prevDistanceWalkedModified = 0.0f;
    public float distanceWalkedModified = 0.0f;
    protected float fallDistance = 0.0f;
    protected int nextStepDistance = 1;
    public double lastTickPosX;
    public double lastTickPosY;
    public double lastTickPosZ;
    public float ySize = 0.0f;
    public float stepHeight = 0.0f;
    public boolean noClip = false;
    public float entityCollisionReduction = 0.0f;
    protected Random rand = new Random();
    public int ticksExisted = 0;
    public int fireResistance = 1;
    public int fire = 0;
    protected int maxAir = 300;
    protected boolean inWater = false;
    public int heartsLife = 0;
    public int air = 300;
    private boolean isFirstUpdate = true;
    public String skinUrl;
    public String cloakUrl;
    protected boolean isImmuneToFire = false;
    protected DataWatcher dataWatcher = new DataWatcher();
    public float entityBrightness = 0.0f;
    protected double entityRiderPitchDelta;
    protected double entityRiderYawDelta;
    public boolean addedToChunk = false;
    public int chunkCoordX;
    public int chunkCoordY;
    public int chunkCoordZ;
    public int serverPosX;
    public int serverPosY;
    public int serverPosZ;
    public boolean ignoreFrustumCheck;
    public boolean isInQuicksand;
    public boolean isInDeadlyQuicksand = false;
    public int timeUntilQuicksand = 20;
    public float timeInQuicksand;
    public float prevTimeInQuicksand;

    public Entity(World var1) {
        this.worldObj = var1;
        this.setPosition(0.0, 0.0, 0.0);
        this.dataWatcher.addObject(0, (byte)0);
        this.entityInit();
    }

    protected abstract void entityInit();

    public DataWatcher getDataWatcher() {
        return this.dataWatcher;
    }

    public boolean equals(Object var1) {
        if (var1 instanceof Entity) {
            return ((Entity)var1).entityId == this.entityId;
        }
        return false;
    }

    public int hashCode() {
        return this.entityId;
    }

    protected void preparePlayerToSpawn() {
        if (this.worldObj != null) {
            while (this.posY > 0.0) {
                this.setPosition(this.posX, this.posY, this.posZ);
                if (this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox).size() == 0) break;
                this.posY += 1.0;
            }
            this.motionZ = 0.0;
            this.motionY = 0.0;
            this.motionX = 0.0;
            this.rotationPitch = 0.0f;
        }
    }

    public void setEntityDead() {
        this.isDead = true;
    }

    protected void setSize(float var1, float var2) {
        this.width = var1;
        this.height = var2;
    }

    protected void setRotation(float var1, float var2) {
        this.rotationYaw = var1 % 360.0f;
        this.rotationPitch = var2 % 360.0f;
    }

    public void setPosition(double var1, double var3, double var5) {
        this.posX = var1;
        this.posY = var3;
        this.posZ = var5;
        float var7 = this.width / 2.0f;
        float var8 = this.height;
        this.boundingBox.setBounds(var1 - (double)var7, var3 - (double)this.yOffset + (double)this.ySize, var5 - (double)var7, var1 + (double)var7, var3 - (double)this.yOffset + (double)this.ySize + (double)var8, var5 + (double)var7);
    }

    public void func_346_d(float var1, float var2) {
        float var3 = this.rotationPitch;
        float var4 = this.rotationYaw;
        this.rotationYaw = (float)((double)this.rotationYaw + (double)var1 * 0.15);
        this.rotationPitch = (float)((double)this.rotationPitch - (double)var2 * 0.15);
        if (this.rotationPitch < -90.0f) {
            this.rotationPitch = -90.0f;
        }
        if (this.rotationPitch > 90.0f) {
            this.rotationPitch = 90.0f;
        }
        this.prevRotationPitch += this.rotationPitch - var3;
        this.prevRotationYaw += this.rotationYaw - var4;
    }

    public void onUpdate() {
        this.onEntityUpdate();
    }

    public void onEntityUpdate() {
        if (this.ridingEntity != null && this.ridingEntity.isDead) {
            this.ridingEntity = null;
        }
        ++this.ticksExisted;
        this.prevDistanceWalkedModified = this.distanceWalkedModified;
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.prevRotationPitch = this.rotationPitch;
        this.prevRotationYaw = this.rotationYaw;
        if (this.handleWaterMovement()) {
            if (!this.inWater && !this.isFirstUpdate) {
                float var5;
                float var4;
                float var1 = MathHelper.sqrt_double(this.motionX * this.motionX * (double)0.2f + this.motionY * this.motionY + this.motionZ * this.motionZ * (double)0.2f) * 0.2f;
                if (var1 > 1.0f) {
                    var1 = 1.0f;
                }
                this.worldObj.playSoundAtEntity(this, "random.splash", var1, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
                float var2 = MathHelper.floor_double(this.boundingBox.minY);
                int var3 = 0;
                while ((float)var3 < 1.0f + this.width * 20.0f) {
                    var4 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    var5 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    this.worldObj.spawnParticle("bubble", this.posX + (double)var4, var2 + 1.0f, this.posZ + (double)var5, this.motionX, this.motionY - (double)(this.rand.nextFloat() * 0.2f), this.motionZ);
                    ++var3;
                }
                var3 = 0;
                while ((float)var3 < 1.0f + this.width * 20.0f) {
                    var4 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    var5 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                    this.worldObj.spawnParticle("splash", this.posX + (double)var4, var2 + 1.0f, this.posZ + (double)var5, this.motionX, this.motionY, this.motionZ);
                    ++var3;
                }
            }
            this.fallDistance = 0.0f;
            this.inWater = true;
            this.fire = 0;
        } else {
            this.inWater = false;
        }
        if (this.worldObj.multiplayerWorld) {
            this.fire = 0;
        } else if (this.fire > 0) {
            if (this.isImmuneToFire) {
                this.fire -= 4;
                if (this.fire < 0) {
                    this.fire = 0;
                }
            } else {
                if (this.fire % 20 == 0) {
                    this.attackEntityFrom(null, 1);
                }
                --this.fire;
            }
        }
        if (this.handleLavaMovement()) {
            this.setOnFireFromLava();
        }
        if (this.posY < -64.0) {
            this.kill();
        }
        if (!this.worldObj.multiplayerWorld) {
            this.setEntityFlag(0, this.fire > 0);
            this.setEntityFlag(2, this.ridingEntity != null);
        }
        this.isFirstUpdate = false;
    }

    public void setOnFireFromLava() {
        if (!this.isImmuneToFire) {
            this.attackEntityFrom(null, 4);
            this.fire = 600;
        }
    }

    public void setOnFireFromLavaSword() {
        if (!this.isImmuneToFire) {
            this.attackEntityFrom(null, 5);
            this.fire = 600;
        }
    }

    protected void kill() {
        this.setEntityDead();
    }

    public boolean isOffsetPositionInLiquid(double var1, double var3, double var5) {
        AxisAlignedBB var7 = this.boundingBox.getOffsetBoundingBox(var1, var3, var5);
        List var8 = this.worldObj.getCollidingBoundingBoxes(this, var7);
        if (var8.size() > 0) {
            return false;
        }
        return !this.worldObj.getIsAnyLiquid(var7);
    }

    public void moveEntity(double x, double y, double z) {
        if (this.noClip) {
            this.boundingBox.offset(x, y, z);
            this.posX = (this.boundingBox.minX + this.boundingBox.maxX) / 2.0;
            this.posY = this.boundingBox.minY + (double)this.yOffset - (double)this.ySize;
            this.posZ = (this.boundingBox.minZ + this.boundingBox.maxZ) / 2.0;
        } else {
            int var30;
            int var40;
            int var39;
            int var26;
            int var38;
            int var28;
            double var23;
            double var37;
            boolean var18;
            EntityPlayer player;
            this.ySize *= 0.4f;
            double var7 = this.posX;
            double var9 = this.posZ;
            if (this.isInWeb) {
                this.isInWeb = false;
                x *= 0.25;
                y *= (double)0.05f;
                z *= 0.25;
                this.motionX = 0.0;
                this.motionY = 0.0;
                this.motionZ = 0.0;
            }
            if (this.isInQuicksand) {
                this.isInQuicksand = false;
                x *= 0.25;
                y *= 0.20000000074505805;
                z *= 0.25;
                this.motionX = 0.0;
                this.motionY = 0.0;
                this.motionZ = 0.0;
            }
            if (this instanceof EntityPlayer) {
                player = (EntityPlayer)this;
                if (player.getAction().equals((Object)EnumPlayerAction.BLOCKING) || player.getAction().equals((Object)EnumPlayerAction.BOW)) {
                    x *= 0.5;
                    z *= 0.5;
                }
                if (player.speedCounter > 0 && !this.worldObj.multiplayerWorld) {
                    x *= 1.75;
                    z *= 1.75;
                }
            }
            if (this instanceof EntityPlayerSP) {
                player = (EntityPlayerSP)this;
                if (((EntityPlayerSP)player).isRunning && !((EntityPlayerSP)player).exhausted && this.worldObj.difficultySetting <= 2) {
                    x *= 1.75;
                    z *= 1.75;
                }
            }
            if (this instanceof EntityPig) {
                EntityPig piggy = (EntityPig)this;
                if (piggy.isSpeaking) {
                    x = 0.0;
                    z = 0.0;
                }
            }
            if (this instanceof EntitySheep) {
                EntitySheep sheep = (EntitySheep)this;
                if (sheep.grazing && this.onGround) {
                    x = 0.0;
                    z = 0.0;
                }
            }
            double var11 = x;
            double var13 = y;
            double var15 = z;
            AxisAlignedBB var17 = this.boundingBox.copy();
            boolean bl = var18 = this.onGround && this.isSneaking();
            if (var18) {
                double var19 = 0.05;
                while (x != 0.0 && this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.getOffsetBoundingBox(x, -1.0, 0.0)).size() == 0) {
                    x = x < var19 && x >= -var19 ? 0.0 : (x > 0.0 ? (x -= var19) : (x += var19));
                    var11 = x;
                }
                while (z != 0.0 && this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.getOffsetBoundingBox(0.0, -1.0, z)).size() == 0) {
                    z = z < var19 && z >= -var19 ? 0.0 : (z > 0.0 ? (z -= var19) : (z += var19));
                    var15 = z;
                }
            }
            List var35 = this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.addCoord(x, y, z));
            int var20 = 0;
            while (var20 < var35.size()) {
                y = ((AxisAlignedBB)var35.get(var20)).calculateYOffset(this.boundingBox, y);
                ++var20;
            }
            this.boundingBox.offset(0.0, y, 0.0);
            if (!this.field_9293_aM && var13 != y) {
                z = 0.0;
                y = 0.0;
                x = 0.0;
            }
            boolean var36 = this.onGround || var13 != y && var13 < 0.0;
            int var21 = 0;
            while (var21 < var35.size()) {
                x = ((AxisAlignedBB)var35.get(var21)).calculateXOffset(this.boundingBox, x);
                ++var21;
            }
            this.boundingBox.offset(x, 0.0, 0.0);
            if (!this.field_9293_aM && var11 != x) {
                z = 0.0;
                y = 0.0;
                x = 0.0;
            }
            var21 = 0;
            while (var21 < var35.size()) {
                z = ((AxisAlignedBB)var35.get(var21)).calculateZOffset(this.boundingBox, z);
                ++var21;
            }
            this.boundingBox.offset(0.0, 0.0, z);
            if (!this.field_9293_aM && var15 != z) {
                z = 0.0;
                y = 0.0;
                x = 0.0;
            }
            if (this.stepHeight > 0.0f && var36 && (var18 || this.ySize < 0.05f) && (var11 != x || var15 != z)) {
                var37 = x;
                var23 = y;
                double var25 = z;
                x = var11;
                y = this.stepHeight;
                z = var15;
                AxisAlignedBB var27 = this.boundingBox.copy();
                this.boundingBox.setBB(var17);
                var35 = this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.addCoord(var11, y, var15));
                var28 = 0;
                while (var28 < var35.size()) {
                    y = ((AxisAlignedBB)var35.get(var28)).calculateYOffset(this.boundingBox, y);
                    ++var28;
                }
                this.boundingBox.offset(0.0, y, 0.0);
                if (!this.field_9293_aM && var13 != y) {
                    z = 0.0;
                    y = 0.0;
                    x = 0.0;
                }
                var28 = 0;
                while (var28 < var35.size()) {
                    x = ((AxisAlignedBB)var35.get(var28)).calculateXOffset(this.boundingBox, x);
                    ++var28;
                }
                this.boundingBox.offset(x, 0.0, 0.0);
                if (!this.field_9293_aM && var11 != x) {
                    z = 0.0;
                    y = 0.0;
                    x = 0.0;
                }
                var28 = 0;
                while (var28 < var35.size()) {
                    z = ((AxisAlignedBB)var35.get(var28)).calculateZOffset(this.boundingBox, z);
                    ++var28;
                }
                this.boundingBox.offset(0.0, 0.0, z);
                if (!this.field_9293_aM && var15 != z) {
                    z = 0.0;
                    y = 0.0;
                    x = 0.0;
                }
                if (!this.field_9293_aM && var13 != y) {
                    z = 0.0;
                    y = 0.0;
                    x = 0.0;
                } else {
                    y = -this.stepHeight;
                    var28 = 0;
                    while (var28 < var35.size()) {
                        y = ((AxisAlignedBB)var35.get(var28)).calculateYOffset(this.boundingBox, y);
                        ++var28;
                    }
                    this.boundingBox.offset(0.0, y, 0.0);
                }
                if (var37 * var37 + var25 * var25 >= x * x + z * z) {
                    x = var37;
                    y = var23;
                    z = var25;
                    this.boundingBox.setBB(var27);
                } else {
                    double var41 = this.boundingBox.minY - (double)((int)this.boundingBox.minY);
                    if (var41 > 0.0) {
                        this.ySize = (float)((double)this.ySize + var41 + 0.01);
                    }
                }
            }
            if (!this.worldObj.multiplayerWorld || this instanceof EntityPlayer || !(this instanceof EntityLiving)) {
                this.posX = (this.boundingBox.minX + this.boundingBox.maxX) / 2.0;
                this.posY = this.boundingBox.minY + (double)this.yOffset - (double)this.ySize;
                this.posZ = (this.boundingBox.minZ + this.boundingBox.maxZ) / 2.0;
            }
            this.isCollidedHorizontally = var11 != x || var15 != z;
            this.isCollidedVertically = var13 != y;
            this.onGround = var13 != y && var13 < 0.0;
            this.isCollided = this.isCollidedHorizontally || this.isCollidedVertically;
            this.updateFallState(y, this.onGround);
            if (var11 != x) {
                this.motionX = 0.0;
            }
            if (var13 != y) {
                this.motionY = 0.0;
            }
            if (var15 != z) {
                this.motionZ = 0.0;
            }
            var37 = this.posX - var7;
            var23 = this.posZ - var9;
            if (this.canTriggerWalking() && !var18 && this.ridingEntity == null) {
                this.distanceWalkedModified = (float)((double)this.distanceWalkedModified + (double)MathHelper.sqrt_double(var37 * var37 + var23 * var23) * 0.6);
                var38 = MathHelper.floor_double(this.posX);
                int var262 = MathHelper.floor_double(this.posY - (double)0.2f - (double)this.yOffset);
                int var392 = MathHelper.floor_double(this.posZ);
                var28 = this.worldObj.getBlockId(var38, var262, var392);
                if (this.worldObj.getBlockId(var38, var262 - 1, var392) == Block.fence.blockID) {
                    var28 = this.worldObj.getBlockId(var38, var262 - 1, var392);
                }
                if (this.distanceWalkedModified > (float)this.nextStepDistance && var28 > 0) {
                    ++this.nextStepDistance;
                    StepSound var29 = Block.blocksList[var28].stepSound;
                    if (this.worldObj.getBlockId(var38, var262 + 1, var392) == Block.snowPile.blockID) {
                        var29 = Block.snowPile.stepSound;
                        this.worldObj.playSoundAtEntity(this, var29.func_1145_d(), var29.getVolume() * 0.15f, var29.getPitch());
                    } else if (!Block.blocksList[var28].blockMaterial.getIsLiquid()) {
                        this.worldObj.playSoundAtEntity(this, var29.func_1145_d(), var29.getVolume() * 0.15f, var29.getPitch());
                    }
                    Block.blocksList[var28].onEntityWalking(this.worldObj, var38, var262, var392, this);
                }
            }
            if (this.worldObj.checkChunksExist(var38 = MathHelper.floor_double(this.boundingBox.minX + 0.001), var26 = MathHelper.floor_double(this.boundingBox.minY + 0.001), var39 = MathHelper.floor_double(this.boundingBox.minZ + 0.001), var28 = MathHelper.floor_double(this.boundingBox.maxX - 0.001), var40 = MathHelper.floor_double(this.boundingBox.maxY - 0.001), var30 = MathHelper.floor_double(this.boundingBox.maxZ - 0.001))) {
                int var31 = var38;
                while (var31 <= var28) {
                    int var32 = var26;
                    while (var32 <= var40) {
                        int var33 = var39;
                        while (var33 <= var30) {
                            int var34 = this.worldObj.getBlockId(var31, var32, var33);
                            if (var34 > 0) {
                                Block.blocksList[var34].onEntityCollidedWithBlock(this.worldObj, var31, var32, var33, this);
                            }
                            ++var33;
                        }
                        ++var32;
                    }
                    ++var31;
                }
            }
            boolean var42 = this.isWet();
            if (this.worldObj.isBoundingBoxBurning(this.boundingBox.func_28195_e(0.001, 0.001, 0.001))) {
                this.dealFireDamage(1);
                if (!var42) {
                    ++this.fire;
                    if (this.fire == 0) {
                        this.fire = 300;
                    }
                }
            } else if (this.fire <= 0) {
                this.fire = -this.fireResistance;
            }
            if (var42 && this.fire > 0) {
                this.worldObj.playSoundAtEntity(this, "random.fizz", 0.7f, 1.6f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
                this.fire = -this.fireResistance;
            }
        }
    }

    protected boolean canTriggerWalking() {
        return true;
    }

    protected void updateFallState(double var1, boolean var3) {
        if (var3) {
            if (this.fallDistance > 0.0f) {
                this.fall(this.fallDistance);
                this.fallDistance = 0.0f;
            }
        } else if (var1 < 0.0) {
            this.fallDistance = (float)((double)this.fallDistance - var1);
        }
    }

    public AxisAlignedBB getBoundingBox() {
        return null;
    }

    protected void dealFireDamage(int var1) {
        if (!this.isImmuneToFire) {
            this.attackEntityFrom(null, var1);
        }
    }

    protected void fall(float var1) {
        if (this.riddenByEntity != null) {
            this.riddenByEntity.fall(var1);
        }
    }

    public boolean isWet() {
        return this.inWater || this.worldObj.canBlockBeRainedOn(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ));
    }

    public boolean isInWater() {
        return this.inWater;
    }

    public boolean handleWaterMovement() {
        return this.worldObj.handleMaterialAcceleration(this.boundingBox.expand(0.0, -0.4f, 0.0).func_28195_e(0.001, 0.001, 0.001), Material.water, this);
    }

    public boolean isInsideOfMaterial(Material var1) {
        int var6;
        int var5;
        double var2 = this.posY + (double)this.getEyeHeight();
        int var4 = MathHelper.floor_double(this.posX);
        int var7 = this.worldObj.getBlockId(var4, var5 = MathHelper.floor_float(MathHelper.floor_double(var2)), var6 = MathHelper.floor_double(this.posZ));
        if (var7 != 0 && Block.blocksList[var7].blockMaterial == var1) {
            float var8 = BlockFluid.getPercentAir(this.worldObj.getBlockMetadata(var4, var5, var6)) - 0.11111111f;
            float var9 = (float)(var5 + 1) - var8;
            return var2 < (double)var9;
        }
        return false;
    }

    public float getEyeHeight() {
        return 0.0f;
    }

    public boolean handleLavaMovement() {
        return this.worldObj.isMaterialInBB(this.boundingBox.expand(-0.1f, -0.4f, -0.1f), Material.lava);
    }

    public void moveFlying(float var1, float var2, float var3) {
        float var4 = MathHelper.sqrt_float(var1 * var1 + var2 * var2);
        if (var4 >= 0.01f) {
            if (var4 < 1.0f) {
                var4 = 1.0f;
            }
            var4 = var3 / var4;
            float var5 = MathHelper.sin(this.rotationYaw * (float)Math.PI / 180.0f);
            float var6 = MathHelper.cos(this.rotationYaw * (float)Math.PI / 180.0f);
            this.motionX += (double)((var1 *= var4) * var6 - (var2 *= var4) * var5);
            this.motionZ += (double)(var2 * var6 + var1 * var5);
        }
    }

    public int getBrightnessForRender(float var1) {
        int var3;
        int var2 = MathHelper.floor_double(this.posX);
        if (this.worldObj.blockExists(var2, 0, var3 = MathHelper.floor_double(this.posZ))) {
            double var4 = (this.boundingBox.maxY - this.boundingBox.minY) * 0.66;
            int var6 = MathHelper.floor_double(this.posY - (double)this.yOffset + var4);
            return this.worldObj.getLightBrightnessForSkyBlocks(var2, var6, var3, 0);
        }
        return 0;
    }

    public float getEntityBrightness(float var1) {
        int var2 = MathHelper.floor_double(this.posX);
        double var3 = (this.boundingBox.maxY - this.boundingBox.minY) * 0.66;
        int var5 = MathHelper.floor_double(this.posY - (double)this.yOffset + var3);
        int var6 = MathHelper.floor_double(this.posZ);
        if (this.worldObj.checkChunksExist(MathHelper.floor_double(this.boundingBox.minX), MathHelper.floor_double(this.boundingBox.minY), MathHelper.floor_double(this.boundingBox.minZ), MathHelper.floor_double(this.boundingBox.maxX), MathHelper.floor_double(this.boundingBox.maxY), MathHelper.floor_double(this.boundingBox.maxZ))) {
            float var7 = this.worldObj.getLightBrightness(var2, var5, var6);
            if (var7 < this.entityBrightness) {
                var7 = this.entityBrightness;
            }
            return var7;
        }
        return this.entityBrightness;
    }

    public void setWorld(World var1) {
        this.worldObj = var1;
    }

    public void setPositionAndRotation(double var1, double var3, double var5, float var7, float var8) {
        this.prevPosX = this.posX = var1;
        this.prevPosY = this.posY = var3;
        this.prevPosZ = this.posZ = var5;
        this.prevRotationYaw = this.rotationYaw = var7;
        this.prevRotationPitch = this.rotationPitch = var8;
        this.ySize = 0.0f;
        double var9 = this.prevRotationYaw - var7;
        if (var9 < -180.0) {
            this.prevRotationYaw += 360.0f;
        }
        if (var9 >= 180.0) {
            this.prevRotationYaw -= 360.0f;
        }
        this.setPosition(this.posX, this.posY, this.posZ);
        this.setRotation(var7, var8);
    }

    public void setLocationAndAngles(double var1, double var3, double var5, float var7, float var8) {
        this.prevPosX = this.posX = var1;
        this.lastTickPosX = this.posX;
        this.prevPosY = this.posY = var3 + (double)this.yOffset;
        this.lastTickPosY = this.posY;
        this.prevPosZ = this.posZ = var5;
        this.lastTickPosZ = this.posZ;
        this.rotationYaw = var7;
        this.rotationPitch = var8;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    public float getDistanceToEntity(Entity var1) {
        float var2 = (float)(this.posX - var1.posX);
        float var3 = (float)(this.posY - var1.posY);
        float var4 = (float)(this.posZ - var1.posZ);
        return MathHelper.sqrt_float(var2 * var2 + var3 * var3 + var4 * var4);
    }

    public double getDistanceSq(double var1, double var3, double var5) {
        double var7 = this.posX - var1;
        double var9 = this.posY - var3;
        double var11 = this.posZ - var5;
        return var7 * var7 + var9 * var9 + var11 * var11;
    }

    public double getDistance(double var1, double var3, double var5) {
        double var7 = this.posX - var1;
        double var9 = this.posY - var3;
        double var11 = this.posZ - var5;
        return MathHelper.sqrt_double(var7 * var7 + var9 * var9 + var11 * var11);
    }

    public double getDistanceSqToEntity(Entity var1) {
        double var2 = this.posX - var1.posX;
        double var4 = this.posY - var1.posY;
        double var6 = this.posZ - var1.posZ;
        return var2 * var2 + var4 * var4 + var6 * var6;
    }

    public void onCollideWithPlayer(EntityPlayer var1) {
    }

    public void applyEntityCollision(Entity var1) {
        double var4;
        double var2;
        double var6;
        if (var1.riddenByEntity != this && var1.ridingEntity != this && (var6 = MathHelper.abs_max(var2 = var1.posX - this.posX, var4 = var1.posZ - this.posZ)) >= (double)0.01f) {
            var6 = MathHelper.sqrt_double(var6);
            var2 /= var6;
            var4 /= var6;
            double var8 = 1.0 / var6;
            if (var8 > 1.0) {
                var8 = 1.0;
            }
            var2 *= var8;
            var4 *= var8;
            var2 *= (double)0.05f;
            var4 *= (double)0.05f;
            this.addVelocity(-(var2 *= (double)(1.0f - this.entityCollisionReduction)), 0.0, -(var4 *= (double)(1.0f - this.entityCollisionReduction)));
            var1.addVelocity(var2, 0.0, var4);
        }
    }

    public void addVelocity(double var1, double var3, double var5) {
        this.motionX += var1;
        this.motionY += var3;
        this.motionZ += var5;
    }

    protected void setBeenAttacked() {
        this.beenAttacked = true;
    }

    public boolean attackEntityFrom(Entity var1, int var2) {
        this.setBeenAttacked();
        return false;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean canBePushed() {
        return false;
    }

    public void addToPlayerScore(Entity var1, int var2) {
    }

    public boolean isInRangeToRenderVec3D(Vec3D var1) {
        double var2 = this.posX - var1.xCoord;
        double var4 = this.posY - var1.yCoord;
        double var6 = this.posZ - var1.zCoord;
        double var8 = var2 * var2 + var4 * var4 + var6 * var6;
        return this.isInRangeToRenderDist(var8);
    }

    public boolean isInRangeToRenderDist(double var1) {
        double var3 = this.boundingBox.getAverageEdgeLength();
        return var1 < (var3 *= 64.0 * this.renderDistanceWeight) * var3;
    }

    public String getEntityTexture() {
        return null;
    }

    public boolean addEntityID(NBTTagCompound var1) {
        String var2 = this.getEntityString();
        if (!this.isDead && var2 != null) {
            var1.setString("id", var2);
            this.writeToNBT(var1);
            return true;
        }
        return false;
    }

    public void writeToNBT(NBTTagCompound var1) {
        var1.setTag("Pos", this.newDoubleNBTList(this.posX, this.posY + (double)this.ySize, this.posZ));
        var1.setTag("Motion", this.newDoubleNBTList(this.motionX, this.motionY, this.motionZ));
        var1.setTag("Rotation", this.newFloatNBTList(this.rotationYaw, this.rotationPitch));
        var1.setFloat("FallDistance", this.fallDistance);
        var1.setShort("Fire", (short)this.fire);
        var1.setShort("Air", (short)this.air);
        var1.setBoolean("OnGround", this.onGround);
        this.writeEntityToNBT(var1);
    }

    public void readFromNBT(NBTTagCompound var1) {
        NBTTagList var2 = var1.getTagList("Pos");
        NBTTagList var3 = var1.getTagList("Motion");
        NBTTagList var4 = var1.getTagList("Rotation");
        this.motionX = ((NBTTagDouble)var3.tagAt((int)0)).doubleValue;
        this.motionY = ((NBTTagDouble)var3.tagAt((int)1)).doubleValue;
        this.motionZ = ((NBTTagDouble)var3.tagAt((int)2)).doubleValue;
        if (Math.abs(this.motionX) > 10.0) {
            this.motionX = 0.0;
        }
        if (Math.abs(this.motionY) > 10.0) {
            this.motionY = 0.0;
        }
        if (Math.abs(this.motionZ) > 10.0) {
            this.motionZ = 0.0;
        }
        this.lastTickPosX = this.posX = ((NBTTagDouble)var2.tagAt((int)0)).doubleValue;
        this.prevPosX = this.posX;
        this.lastTickPosY = this.posY = ((NBTTagDouble)var2.tagAt((int)1)).doubleValue;
        this.prevPosY = this.posY;
        this.lastTickPosZ = this.posZ = ((NBTTagDouble)var2.tagAt((int)2)).doubleValue;
        this.prevPosZ = this.posZ;
        this.prevRotationYaw = this.rotationYaw = ((NBTTagFloat)var4.tagAt((int)0)).floatValue;
        this.prevRotationPitch = this.rotationPitch = ((NBTTagFloat)var4.tagAt((int)1)).floatValue;
        this.fallDistance = var1.getFloat("FallDistance");
        this.fire = var1.getShort("Fire");
        this.air = var1.getShort("Air");
        this.onGround = var1.getBoolean("OnGround");
        this.setPosition(this.posX, this.posY, this.posZ);
        this.setRotation(this.rotationYaw, this.rotationPitch);
        this.readEntityFromNBT(var1);
    }

    protected String getEntityString() {
        return EntityList.getEntityString(this);
    }

    protected abstract void readEntityFromNBT(NBTTagCompound var1);

    protected abstract void writeEntityToNBT(NBTTagCompound var1);

    protected NBTTagList newDoubleNBTList(double ... var1) {
        NBTTagList var2 = new NBTTagList();
        double[] var3 = var1;
        int var4 = var1.length;
        int var5 = 0;
        while (var5 < var4) {
            double var6 = var3[var5];
            var2.setTag(new NBTTagDouble(var6));
            ++var5;
        }
        return var2;
    }

    protected NBTTagList newFloatNBTList(float ... var1) {
        NBTTagList var2 = new NBTTagList();
        float[] var3 = var1;
        int var4 = var1.length;
        int var5 = 0;
        while (var5 < var4) {
            float var6 = var3[var5];
            var2.setTag(new NBTTagFloat(var6));
            ++var5;
        }
        return var2;
    }

    public float getShadowSize() {
        return this.height / 2.0f;
    }

    public EntityItem dropItem(int var1, int var2) {
        return this.dropItemWithOffset(var1, var2, 0.0f);
    }

    public EntityItem dropItemWithOffset(int var1, int var2, float var3) {
        return this.entityDropItem(new ItemStack(var1, var2, 0), var3);
    }

    public EntityItem entityDropItem(ItemStack var1, float var2) {
        EntityItem var3 = new EntityItem(this.worldObj, this.posX, this.posY + 0.5 + (double)var2, this.posZ, var1);
        var3.delayBeforeCanPickup = 10;
        this.worldObj.entityJoinedWorld(var3);
        return var3;
    }

    public boolean isEntityAlive() {
        return !this.isDead;
    }

    public boolean isEntityInsideOpaqueBlock() {
        int var1 = 0;
        while (var1 < 8) {
            int var7;
            int var6;
            float var2 = ((float)((var1 >> 0) % 2) - 0.5f) * this.width * 0.9f;
            float var3 = ((float)((var1 >> 1) % 2) - 0.5f) * 0.1f;
            float var4 = ((float)((var1 >> 2) % 2) - 0.5f) * this.width * 0.9f;
            int var5 = MathHelper.floor_double(this.posX + (double)var2);
            if (this.worldObj.isBlockNormalCube(var5, var6 = MathHelper.floor_double(this.posY + (double)this.getEyeHeight() + (double)var3), var7 = MathHelper.floor_double(this.posZ + (double)var4))) {
                return true;
            }
            ++var1;
        }
        return false;
    }

    public boolean interact(EntityPlayer var1) {
        return false;
    }

    public AxisAlignedBB getCollisionBox(Entity var1) {
        return null;
    }

    public void updateRidden() {
        if (this.ridingEntity.isDead) {
            this.ridingEntity = null;
        } else {
            this.motionX = 0.0;
            this.motionY = 0.0;
            this.motionZ = 0.0;
            this.onUpdate();
            if (this.ridingEntity != null) {
                this.ridingEntity.updateRiderPosition();
                this.entityRiderYawDelta += (double)(this.ridingEntity.rotationYaw - this.ridingEntity.prevRotationYaw);
                this.entityRiderPitchDelta += (double)(this.ridingEntity.rotationPitch - this.ridingEntity.prevRotationPitch);
                while (this.entityRiderYawDelta >= 180.0) {
                    this.entityRiderYawDelta -= 360.0;
                }
                while (this.entityRiderYawDelta < -180.0) {
                    this.entityRiderYawDelta += 360.0;
                }
                while (this.entityRiderPitchDelta >= 180.0) {
                    this.entityRiderPitchDelta -= 360.0;
                }
                while (this.entityRiderPitchDelta < -180.0) {
                    this.entityRiderPitchDelta += 360.0;
                }
                double var1 = this.entityRiderYawDelta * 0.5;
                double var3 = this.entityRiderPitchDelta * 0.5;
                float var5 = 10.0f;
                if (var1 > (double)var5) {
                    var1 = var5;
                }
                if (var1 < (double)(-var5)) {
                    var1 = -var5;
                }
                if (var3 > (double)var5) {
                    var3 = var5;
                }
                if (var3 < (double)(-var5)) {
                    var3 = -var5;
                }
                this.entityRiderYawDelta -= var1;
                this.entityRiderPitchDelta -= var3;
                this.rotationYaw = (float)((double)this.rotationYaw + var1);
                this.rotationPitch = (float)((double)this.rotationPitch + var3);
            }
        }
    }

    public void updateRiderPosition() {
        this.riddenByEntity.setPosition(this.posX, this.posY + this.getMountedYOffset() + this.riddenByEntity.getYOffset(), this.posZ);
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public double getMountedYOffset() {
        return (double)this.height * 0.75;
    }

    public void mountEntity(Entity var1) {
        this.entityRiderPitchDelta = 0.0;
        this.entityRiderYawDelta = 0.0;
        if (var1 == null) {
            if (this.ridingEntity != null) {
                this.setLocationAndAngles(this.ridingEntity.posX, this.ridingEntity.boundingBox.minY + (double)this.ridingEntity.height, this.ridingEntity.posZ, this.rotationYaw, this.rotationPitch);
                this.ridingEntity.riddenByEntity = null;
            }
            this.ridingEntity = null;
        } else if (this.ridingEntity == var1) {
            this.ridingEntity.riddenByEntity = null;
            this.ridingEntity = null;
            this.setLocationAndAngles(var1.posX, var1.boundingBox.minY + (double)var1.height, var1.posZ, this.rotationYaw, this.rotationPitch);
        } else {
            if (this.ridingEntity != null) {
                this.ridingEntity.riddenByEntity = null;
            }
            if (var1.riddenByEntity != null) {
                var1.riddenByEntity.ridingEntity = null;
            }
            this.ridingEntity = var1;
            var1.riddenByEntity = this;
        }
    }

    public void setPositionAndRotation2(double var1, double var3, double var5, float var7, float var8, int var9) {
        this.setPosition(var1, var3, var5);
        this.setRotation(var7, var8);
        List var10 = this.worldObj.getCollidingBoundingBoxes(this, this.boundingBox.func_28195_e(0.03125, 0.0, 0.03125));
        if (var10.size() > 0) {
            double var11 = 0.0;
            int var13 = 0;
            while (var13 < var10.size()) {
                AxisAlignedBB var14 = (AxisAlignedBB)var10.get(var13);
                if (var14.maxY > var11) {
                    var11 = var14.maxY;
                }
                ++var13;
            }
            this.setPosition(var1, var3 += var11 - this.boundingBox.minY, var5);
        }
    }

    public float getCollisionBorderSize() {
        return 0.1f;
    }

    public Vec3D getLookVec() {
        return null;
    }

    public void setInPortal() {
    }

    public void setVelocity(double var1, double var3, double var5) {
        this.motionX = var1;
        this.motionY = var3;
        this.motionZ = var5;
    }

    public void handleHealthUpdate(byte var1) {
    }

    public void performHurtAnimation() {
    }

    public void updateCloak() {
    }

    public void outfitWithItem(int var1, int var2, int var3) {
    }

    public boolean isBurning() {
        return this.fire > 0 || this.getEntityFlag(0);
    }

    public boolean isRiding() {
        return this.ridingEntity != null || this.getEntityFlag(2);
    }

    public boolean isSneaking() {
        return this.getEntityFlag(1);
    }

    protected void setEntityFlag(int var1, boolean var2) {
        byte var3 = this.dataWatcher.getWatchableObjectByte(0);
        if (var2) {
            this.dataWatcher.updateObject(0, (byte)(var3 | 1 << var1));
        } else {
            this.dataWatcher.updateObject(0, (byte)(var3 & ~(1 << var1)));
        }
    }

    public void onStruckByLightning(EntityLightningBolt var1) {
        this.dealFireDamage(5);
        ++this.fire;
        if (this.fire == 0) {
            this.fire = 300;
        }
    }

    public void onKillEntity(EntityLiving var1) {
    }

    protected boolean pushOutOfBlocks(double var1, double var3, double var5) {
        int var7 = MathHelper.floor_double(var1);
        int var8 = MathHelper.floor_double(var3);
        int var9 = MathHelper.floor_double(var5);
        double var10 = var1 - (double)var7;
        double var12 = var3 - (double)var8;
        double var14 = var5 - (double)var9;
        if (this.worldObj.isBlockNormalCube(var7, var8, var9)) {
            boolean var16 = !this.worldObj.isBlockNormalCube(var7 - 1, var8, var9);
            boolean var17 = !this.worldObj.isBlockNormalCube(var7 + 1, var8, var9);
            boolean var18 = !this.worldObj.isBlockNormalCube(var7, var8 - 1, var9);
            boolean var19 = !this.worldObj.isBlockNormalCube(var7, var8 + 1, var9);
            boolean var20 = !this.worldObj.isBlockNormalCube(var7, var8, var9 - 1);
            boolean var21 = !this.worldObj.isBlockNormalCube(var7, var8, var9 + 1);
            int var22 = -1;
            double var23 = 9999.0;
            if (var16 && var10 < var23) {
                var23 = var10;
                var22 = 0;
            }
            if (var17 && 1.0 - var10 < var23) {
                var23 = 1.0 - var10;
                var22 = 1;
            }
            if (var18 && var12 < var23) {
                var23 = var12;
                var22 = 2;
            }
            if (var19 && 1.0 - var12 < var23) {
                var23 = 1.0 - var12;
                var22 = 3;
            }
            if (var20 && var14 < var23) {
                var23 = var14;
                var22 = 4;
            }
            if (var21 && 1.0 - var14 < var23) {
                var23 = 1.0 - var14;
                var22 = 5;
            }
            float var25 = this.rand.nextFloat() * 0.2f + 0.1f;
            if (var22 == 0) {
                this.motionX = -var25;
            }
            if (var22 == 1) {
                this.motionX = var25;
            }
            if (var22 == 2) {
                this.motionY = -var25;
            }
            if (var22 == 3) {
                this.motionY = var25;
            }
            if (var22 == 4) {
                this.motionZ = -var25;
            }
            if (var22 == 5) {
                this.motionZ = var25;
            }
        }
        return false;
    }

    public void func_40046_d(int i) {
        int j = i * 20;
        if (this.fire < j) {
            this.fire = j;
        }
    }

    public final boolean func_40047_D() {
        return this.isImmuneToFire;
    }

    public boolean attackEntityFromSpecial(DamageSource damageSource, int i) {
        this.setBeenAttacked();
        return false;
    }

    public boolean func_41004_h(Entity entity) {
        return this == entity;
    }

    public void func_40045_B() {
        this.fire = 0;
    }

    public void setInQuicksand() {
    }

    protected boolean getEntityFlag(int i) {
        return (this.dataWatcher.getWatchableObjectByte(0) & 1 << i) != 0;
    }

    public boolean isEating() {
        return this.getEntityFlag(4);
    }

    public void setEating(boolean var1) {
        this.setEntityFlag(4, var1);
    }
}

