/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.effect;

import net.minecraft.src.game.effect.EffectBreathing;
import net.minecraft.src.game.effect.EffectFireResistance;
import net.minecraft.src.game.effect.EffectFlight;
import net.minecraft.src.game.effect.EffectFragility;
import net.minecraft.src.game.effect.EffectHaste;
import net.minecraft.src.game.effect.EffectJumpBoost;
import net.minecraft.src.game.effect.EffectMiningFatigue;
import net.minecraft.src.game.effect.EffectPoison;
import net.minecraft.src.game.effect.EffectRegeneration;
import net.minecraft.src.game.effect.EffectResistance;
import net.minecraft.src.game.effect.EffectSlipperiness;
import net.minecraft.src.game.effect.EffectSlowness;
import net.minecraft.src.game.effect.EffectSpeed;
import net.minecraft.src.game.effect.EffectStinky;
import net.minecraft.src.game.effect.EffectStrength;
import net.minecraft.src.game.effect.EffectWeakness;
import net.minecraft.src.game.entity.EntityLiving;

public class Effect {
    public static int effectcount = 20;
    public int iconid;
    public int color;
    public String name;
    public static Effect[] effectlist = new Effect[effectcount];

    public Effect(int iconid) {
        this.iconid = iconid;
    }

    public void doEffect(EntityLiving entity, int level, int time) {
    }

    public static void initEffects() {
        Effect.effectlist[0] = new EffectStinky(69);
        Effect.effectlist[1] = new EffectFireResistance(34);
        Effect.effectlist[2] = new EffectBreathing(64);
        Effect.effectlist[3] = new EffectRegeneration(32);
        Effect.effectlist[4] = new EffectPoison(48);
        Effect.effectlist[5] = new EffectFlight(50);
        Effect.effectlist[6] = new EffectHaste(0);
        Effect.effectlist[7] = new EffectMiningFatigue(16);
        Effect.effectlist[8] = new EffectStrength(3);
        Effect.effectlist[9] = new EffectWeakness(19);
        Effect.effectlist[10] = new EffectSpeed(1);
        Effect.effectlist[11] = new EffectSlowness(17);
        Effect.effectlist[12] = new EffectJumpBoost(18);
        Effect.effectlist[13] = new EffectResistance(35);
        Effect.effectlist[14] = new EffectFragility(51);
        Effect.effectlist[15] = new EffectSlipperiness(2);
    }

    public static void applyEffect(EntityLiving entity, int id, int level, int time) {
        entity.effecttimers[id] = time;
        entity.effectlevel[id] = (byte)level;
    }

    public static int getColorFromDamage(int var1) {
        if (var1 % 128 + 1 > 15 || (var1 >> 7) + 1 > 15) {
            return 0;
        }
        return Effect.blendColors(Effect.effectlist[var1 % 128 + 1].color, Effect.effectlist[(var1 >> 7) + 1].color);
    }

    public static int convertDenseToLoose(int var1) {
        return var1 % 15 + (var1 / 15 << 7);
    }

    public static int convertLooseToDense(int var1) {
        return var1 % 128 + (var1 >> 7) * 15;
    }

    public static int getBlueFromColor(int color) {
        return color % 256;
    }

    public static int getGreenFromColor(int color) {
        return (color >> 8) % 256;
    }

    public static int getRedFromColor(int color) {
        return (color >> 16) % 256;
    }

    public static int blendColors(int color, int color2) {
        return (Effect.getBlueFromColor(color) + Effect.getBlueFromColor(color2)) / 2 + ((Effect.getGreenFromColor(color) + Effect.getGreenFromColor(color2)) / 2 << 8) + ((Effect.getRedFromColor(color) + Effect.getRedFromColor(color2)) / 2 << 16);
    }
}

