/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block.tileentity;

import java.util.Random;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.tileentity.TileEntity;
import net.minecraft.src.game.entity.other.EntityFallingSand;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.nbt.NBTTagCompound;

public class TileEntityTableGlass
extends TileEntity {
    public int delay = 100;

    public boolean anyPlayerInRange() {
        return this.worldObj.getClosestPlayer((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, 16.0) != null;
    }

    @Override
    public void updateEntity() {
        if (this.anyPlayerInRange() && this.worldObj.getBlockId(this.xCoord, this.yCoord + 1, this.zCoord) == Block.brick.blockID) {
            if (!this.worldObj.multiplayerWorld) {
                if (this.delay == -1) {
                    this.updateDelay();
                }
                if (this.delay > 0) {
                    --this.delay;
                    return;
                }
                int var8 = 0;
                int var7 = 4;
                if (var8 < var7) {
                    this.updateBlock(this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.worldObj.rand);
                    return;
                }
            }
            super.updateEntity();
        }
    }

    public void updateBlock(World world, int xCoord, int yCoord, int zCoord, Random rand) {
        world.playSoundEffect(xCoord, yCoord, zCoord, "random.glass", 1.0f, 1.0f);
        world.setBlockWithNotify(xCoord, yCoord, zCoord, 0);
        world.setBlockWithNotify(xCoord, yCoord + 1, zCoord, 0);
        int var18 = 0;
        while (var18 < 64) {
            this.worldObj.spawnParticle("glassTable", (double)xCoord + 0.5, yCoord, (double)zCoord + 0.5, 0.0, 0.0, 0.0);
            ++var18;
        }
        int var8 = 32;
        if (!world.multiplayerWorld && world.checkChunksExist(xCoord - var8, yCoord - var8, zCoord - var8, xCoord + var8, yCoord + var8, zCoord + var8)) {
            EntityFallingSand var9 = new EntityFallingSand(world, (float)xCoord + 0.5f, (float)yCoord + 1.0f, (float)zCoord + 0.5f, Block.brick.blockID, 0);
            world.entityJoinedWorld(var9);
        }
    }

    private void updateDelay() {
        this.delay = 0;
    }

    @Override
    public void readFromNBT(NBTTagCompound var1) {
        super.readFromNBT(var1);
        this.delay = var1.getShort("Delay");
    }

    @Override
    public void writeToNBT(NBTTagCompound var1) {
        super.writeToNBT(var1);
        var1.setShort("Delay", (short)this.delay);
    }
}

