/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block.tileentity;

import net.minecraft.src.client.inventory.IInventory;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.tileentity.TileEntity;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.nbt.NBTTagCompound;
import net.minecraft.src.game.nbt.NBTTagList;

public class TileEntityAnvil
extends TileEntity
implements IInventory {
    public ItemStack[] anvilItemStacks = new ItemStack[2];

    @Override
    public int getSizeInventory() {
        return this.anvilItemStacks.length;
    }

    @Override
    public ItemStack getStackInSlot(int var1) {
        return this.anvilItemStacks[var1];
    }

    @Override
    public ItemStack decrStackSize(int var1, int var2) {
        if (this.anvilItemStacks[var1] != null) {
            if (this.anvilItemStacks[var1].stackSize <= var2) {
                ItemStack var3 = this.anvilItemStacks[var1];
                this.anvilItemStacks[var1] = null;
                return var3;
            }
            ItemStack var3 = this.anvilItemStacks[var1].splitStack(var2);
            if (this.anvilItemStacks[var1].stackSize == 0) {
                this.anvilItemStacks[var1] = null;
            }
            return var3;
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int var1, ItemStack var2) {
        this.anvilItemStacks[var1] = var2;
        if (var2 != null && var2.stackSize > this.getInventoryStackLimit()) {
            var2.stackSize = this.getInventoryStackLimit();
        }
    }

    @Override
    public String getInvName() {
        return "Anvil";
    }

    @Override
    public void readFromNBT(NBTTagCompound var1) {
        super.readFromNBT(var1);
        NBTTagList var2 = var1.getTagList("Items");
        this.anvilItemStacks = new ItemStack[this.getSizeInventory()];
        int var3 = 0;
        while (var3 < var2.tagCount()) {
            NBTTagCompound var4 = (NBTTagCompound)var2.tagAt(var3);
            byte var5 = var4.getByte("Slot");
            if (var5 >= 0 && var5 < this.anvilItemStacks.length) {
                this.anvilItemStacks[var5] = new ItemStack(var4);
            }
            ++var3;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound var1) {
        super.writeToNBT(var1);
        NBTTagList var2 = new NBTTagList();
        int var3 = 0;
        while (var3 < this.anvilItemStacks.length) {
            if (this.anvilItemStacks[var3] != null) {
                NBTTagCompound var4 = new NBTTagCompound();
                var4.setByte("Slot", (byte)var3);
                this.anvilItemStacks[var3].writeToNBT(var4);
                var2.setTag(var4);
            }
            ++var3;
        }
        var1.setTag("Items", var2);
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
    }

    public boolean canRepair() {
        if (this.anvilItemStacks[0] == null || this.anvilItemStacks[1] == null) {
            return false;
        }
        Item item = this.anvilItemStacks[0].getItem();
        int material = this.anvilItemStacks[1].getItem().itemID;
        if (item == null) {
            return false;
        }
        if (material == 0) {
            return false;
        }
        if (material == Block.obsidian.blockID && item == Item.pickaxeObsidian) {
            return true;
        }
        if (material == Block.obsidian.blockID && item == Item.axeObsidian) {
            return true;
        }
        if (material == Block.obsidian.blockID && item == Item.shovelObsidian) {
            return true;
        }
        if (material == Item.leather.itemID && item == Item.helmetLeather) {
            return true;
        }
        if (material == Item.leather.itemID && item == Item.plateLeather) {
            return true;
        }
        if (material == Item.leather.itemID && item == Item.legsLeather) {
            return true;
        }
        if (material == Item.leather.itemID && item == Item.bootsLeather) {
            return true;
        }
        if (material == Item.ingotIron.itemID && item == Item.pickaxeSteel) {
            return true;
        }
        if (material == Item.ingotIron.itemID && item == Item.axeSteel) {
            return true;
        }
        if (material == Item.ingotIron.itemID && item == Item.shovelSteel) {
            return true;
        }
        if (material == Item.ingotIron.itemID && item == Item.hoeSteel) {
            return true;
        }
        if (material == Item.ingotIron.itemID && item == Item.swordSteel) {
            return true;
        }
        if (material == Item.ingotIron.itemID && item == Item.helmetSteel) {
            return true;
        }
        if (material == Item.ingotIron.itemID && item == Item.plateSteel) {
            return true;
        }
        if (material == Item.ingotIron.itemID && item == Item.legsSteel) {
            return true;
        }
        if (material == Item.ingotIron.itemID && item == Item.bootsSteel) {
            return true;
        }
        if (material == Item.ingotGold.itemID && item == Item.pickaxeGold) {
            return true;
        }
        if (material == Item.ingotGold.itemID && item == Item.axeGold) {
            return true;
        }
        if (material == Item.ingotGold.itemID && item == Item.shovelGold) {
            return true;
        }
        if (material == Item.ingotGold.itemID && item == Item.hoeGold) {
            return true;
        }
        if (material == Item.ingotGold.itemID && item == Item.swordGold) {
            return true;
        }
        if (material == Item.ingotGold.itemID && item == Item.helmetGold) {
            return true;
        }
        if (material == Item.ingotGold.itemID && item == Item.plateGold) {
            return true;
        }
        if (material == Item.ingotGold.itemID && item == Item.legsGold) {
            return true;
        }
        if (material == Item.ingotGold.itemID && item == Item.bootsGold) {
            return true;
        }
        if (material == Item.diamond.itemID && item == Item.pickaxeDiamond) {
            return true;
        }
        if (material == Item.diamond.itemID && item == Item.axeDiamond) {
            return true;
        }
        if (material == Item.diamond.itemID && item == Item.shovelDiamond) {
            return true;
        }
        if (material == Item.diamond.itemID && item == Item.hoeDiamond) {
            return true;
        }
        if (material == Item.diamond.itemID && item == Item.swordDiamond) {
            return true;
        }
        if (material == Item.diamond.itemID && item == Item.helmetDiamond) {
            return true;
        }
        if (material == Item.diamond.itemID && item == Item.plateDiamond) {
            return true;
        }
        if (material == Item.diamond.itemID && item == Item.legsDiamond) {
            return true;
        }
        return material == Item.diamond.itemID && item == Item.bootsDiamond;
    }

    @Override
    public boolean canInteractWith(EntityPlayer var1) {
        if (this.worldObj.getBlockTileEntity(this.xCoord, this.yCoord, this.zCoord) != this) {
            return false;
        }
        return var1.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }

    public void func_183_c() {
    }

    @Override
    public void onInventoryChanged() {
    }
}

