/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import java.util.Random;
import net.minecraft.src.game.MathHelper;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.EntityLiving;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;

public class BlockTreadmill
extends Block {
    private final boolean powered;

    public BlockTreadmill(int id, boolean isActive) {
        super(id, 260, Material.moveableCircuit);
        this.powered = isActive;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int var1, int var2) {
        if (var1 == 1 && this.powered) {
            return this.blockIndexInTexture + 32;
        }
        if (var1 == 1) {
            return this.blockIndexInTexture;
        }
        if (var1 == 3 && var2 == 2 && this.powered) {
            return this.blockIndexInTexture + 33;
        }
        if (var1 == 2 && var2 == 2 && this.powered) {
            return this.blockIndexInTexture + 16;
        }
        if (var1 == 4 && var2 == 2 && this.powered) {
            return this.blockIndexInTexture + 34;
        }
        if (var1 == 5 && var2 == 2 && this.powered) {
            return this.blockIndexInTexture + 34;
        }
        if (var1 == 3 && var2 == 5 && this.powered) {
            return this.blockIndexInTexture + 34;
        }
        if (var1 == 2 && var2 == 5 && this.powered) {
            return this.blockIndexInTexture + 34;
        }
        if (var1 == 4 && var2 == 5 && this.powered) {
            return this.blockIndexInTexture + 16;
        }
        if (var1 == 5 && var2 == 5 && this.powered) {
            return this.blockIndexInTexture + 33;
        }
        if (var1 == 3 && var2 == 4 && this.powered) {
            return this.blockIndexInTexture + 16;
        }
        if (var1 == 2 && var2 == 4 && this.powered) {
            return this.blockIndexInTexture + 33;
        }
        if (var1 == 4 && var2 == 4 && this.powered) {
            return this.blockIndexInTexture + 34;
        }
        if (var1 == 5 && var2 == 4 && this.powered) {
            return this.blockIndexInTexture + 34;
        }
        if (var1 == 3 && var2 == 3 && this.powered) {
            return this.blockIndexInTexture + 34;
        }
        if (var1 == 2 && var2 == 3 && this.powered) {
            return this.blockIndexInTexture + 34;
        }
        if (var1 == 4 && var2 == 3 && this.powered) {
            return this.blockIndexInTexture + 33;
        }
        if (var1 == 5 && var2 == 3 && this.powered) {
            return this.blockIndexInTexture + 16;
        }
        if (var1 == 3 && var2 == 2) {
            return this.blockIndexInTexture + 1;
        }
        if (var1 == 2 && var2 == 2) {
            return this.blockIndexInTexture + 1;
        }
        if (var1 == 4 && var2 == 2) {
            return this.blockIndexInTexture + 2;
        }
        if (var1 == 5 && var2 == 2) {
            return this.blockIndexInTexture + 2;
        }
        if (var1 == 3 && var2 == 5) {
            return this.blockIndexInTexture + 2;
        }
        if (var1 == 2 && var2 == 5) {
            return this.blockIndexInTexture + 2;
        }
        if (var1 == 4 && var2 == 5) {
            return this.blockIndexInTexture + 1;
        }
        if (var1 == 5 && var2 == 5) {
            return this.blockIndexInTexture + 1;
        }
        if (var1 == 3 && var2 == 4) {
            return this.blockIndexInTexture + 1;
        }
        if (var1 == 2 && var2 == 4) {
            return this.blockIndexInTexture + 1;
        }
        if (var1 == 4 && var2 == 4) {
            return this.blockIndexInTexture + 2;
        }
        if (var1 == 5 && var2 == 4) {
            return this.blockIndexInTexture + 2;
        }
        if (var1 == 3 && var2 == 3) {
            return this.blockIndexInTexture + 2;
        }
        if (var1 == 2 && var2 == 3) {
            return this.blockIndexInTexture + 2;
        }
        if (var1 == 4 && var2 == 3) {
            return this.blockIndexInTexture + 1;
        }
        if (var1 == 5 && var2 == 3) {
            return this.blockIndexInTexture + 1;
        }
        if (var1 == 0) {
            return 6;
        }
        return 0;
    }

    @Override
    public int getBlockTextureFromSide(int var1) {
        switch (var1) {
            case 0: {
                return 6;
            }
            case 1: {
                return this.blockIndexInTexture;
            }
            case 2: {
                return this.blockIndexInTexture + 1;
            }
            case 3: {
                return this.blockIndexInTexture + 1;
            }
            case 4: {
                return this.blockIndexInTexture + 2;
            }
            case 5: {
                return this.blockIndexInTexture + 2;
            }
        }
        return 0;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess var1, int var2, int var3, int var4, int var5) {
        return var5 != 0 && var5 != 1;
    }

    @Override
    public int getRenderType() {
        return 15;
    }

    @Override
    public void onBlockPlacedBy(World world, int xCoord, int yCoord, int zCoord, EntityLiving var5) {
        int var6 = MathHelper.floor_double((double)(var5.rotationYaw * 4.0f / 360.0f) + 0.5) & 3;
        if (var6 == 0) {
            world.setBlockMetadataWithNotify(xCoord, yCoord, zCoord, 2);
        }
        if (var6 == 3) {
            world.setBlockMetadataWithNotify(xCoord, yCoord, zCoord, 5);
        }
        if (var6 == 1) {
            world.setBlockMetadataWithNotify(xCoord, yCoord, zCoord, 3);
        }
        if (var6 == 2) {
            world.setBlockMetadataWithNotify(xCoord, yCoord, zCoord, 4);
        }
    }

    @Override
    public void onEntityCollidedWithBlock(World var1, int var2, int var3, int var4, Entity var5) {
        int metadata = var1.getBlockMetadata(var2, var3, var4);
        double speed = 0.2;
        if (this.powered && metadata == 2) {
            var5.motionZ += speed;
        }
        if (this.powered && metadata == 3) {
            var5.motionX -= speed;
        }
        if (this.powered && metadata == 4) {
            var5.motionZ -= speed;
        }
        if (this.powered && metadata == 5) {
            var5.motionX += speed;
        }
    }

    @Override
    public void onBlockAdded(World world, int par2, int par3, int par4) {
        if (!world.multiplayerWorld) {
            int metadata = world.getBlockMetadata(par2, par3, par4);
            if (this.powered && !world.isBlockIndirectlyGettingPowered(par2, par3, par4)) {
                world.scheduleBlockUpdate(par2, par3, par4, this.blockID, 4);
            } else if (!this.powered && world.isBlockIndirectlyGettingPowered(par2, par3, par4)) {
                world.setBlockAndMetadataWithNotify(par2, par3, par4, Block.treadmillActive.blockID, metadata);
            }
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int par2, int par3, int par4, int par5) {
        if (!world.multiplayerWorld) {
            int metadata = world.getBlockMetadata(par2, par3, par4);
            if (this.powered && !world.isBlockIndirectlyGettingPowered(par2, par3, par4)) {
                world.scheduleBlockUpdate(par2, par3, par4, this.blockID, 4);
            } else if (!this.powered && world.isBlockIndirectlyGettingPowered(par2, par3, par4)) {
                world.setBlockAndMetadataWithNotify(par2, par3, par4, Block.treadmillActive.blockID, metadata);
            }
        }
    }

    @Override
    public void updateTick(World world, int par2, int par3, int par4, Random par5Random) {
        int metadata = world.getBlockMetadata(par2, par3, par4);
        if (!world.multiplayerWorld && this.powered && !world.isBlockIndirectlyGettingPowered(par2, par3, par4)) {
            world.setBlockAndMetadataWithNotify(par2, par3, par4, Block.treadmillIdle.blockID, metadata);
        }
    }

    @Override
    public int idDropped(int damageMetadata, Random rand) {
        return Block.treadmillIdle.blockID;
    }

    @Override
    public int idPicked(World world, int xCoord, int yCoord, int zCoord) {
        return Block.treadmillIdle.blockID;
    }
}

