/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.client.physics.MovingObjectPosition;
import net.minecraft.src.client.renderer.Vec3D;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.level.IBlockAccess;
import net.minecraft.src.game.level.World;

public class BlockTrapDoor
extends Block {
    protected BlockTrapDoor(int var1, Material var2) {
        super(var1, var2);
        this.blockIndexInTexture = 84;
        if (var2 == Material.iron) {
            ++this.blockIndexInTexture;
        }
        float var3 = 0.5f;
        float var4 = 1.0f;
        this.setBlockBounds(0.5f - var3, 0.0f, 0.5f - var3, 0.5f + var3, var4, 0.5f + var3);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 0;
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World var1, int var2, int var3, int var4) {
        this.setBlockBoundsBasedOnState(var1, var2, var3, var4);
        return super.getSelectedBoundingBoxFromPool(var1, var2, var3, var4);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World var1, int var2, int var3, int var4) {
        this.setBlockBoundsBasedOnState(var1, var2, var3, var4);
        return super.getCollisionBoundingBoxFromPool(var1, var2, var3, var4);
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess var1, int var2, int var3, int var4) {
        this.setBlockBoundsForBlockRender(var1.getBlockMetadata(var2, var3, var4));
    }

    @Override
    public void setBlockBoundsForItemRender() {
        float var1 = 0.1875f;
        this.setBlockBounds(0.0f, 0.5f - var1 / 2.0f, 0.0f, 1.0f, 0.5f + var1 / 2.0f, 1.0f);
    }

    public void setBlockBoundsForBlockRender(int var1) {
        float var2 = 0.1875f;
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, var2, 1.0f);
        if (BlockTrapDoor.isTrapdoorOpen(var1)) {
            if ((var1 & 3) == 0) {
                this.setBlockBounds(0.0f, 0.0f, 1.0f - var2, 1.0f, 1.0f, 1.0f);
            }
            if ((var1 & 3) == 1) {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, var2);
            }
            if ((var1 & 3) == 2) {
                this.setBlockBounds(1.0f - var2, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
            if ((var1 & 3) == 3) {
                this.setBlockBounds(0.0f, 0.0f, 0.0f, var2, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public void onBlockClicked(World var1, int var2, int var3, int var4, EntityPlayer var5) {
        this.blockActivated(var1, var2, var3, var4, var5);
    }

    @Override
    public boolean blockActivated(World var1, int var2, int var3, int var4, EntityPlayer var5) {
        if (this.blockMaterial == Material.iron) {
            return true;
        }
        if (var5.isSneaking()) {
            return false;
        }
        int var6 = var1.getBlockMetadata(var2, var3, var4);
        var1.setBlockMetadataWithNotify(var2, var3, var4, var6 ^ 4);
        var1.func_28107_a(var5, 1003, var2, var3, var4, 0);
        return true;
    }

    public void onPoweredBlockChange(World var1, int var2, int var3, int var4, boolean var5) {
        boolean var7;
        int var6 = var1.getBlockMetadata(var2, var3, var4);
        boolean bl = var7 = (var6 & 4) > 0;
        if (var7 != var5) {
            var1.setBlockMetadataWithNotify(var2, var3, var4, var6 ^ 4);
            var1.func_28107_a(null, 1003, var2, var3, var4, 0);
        }
    }

    @Override
    public void onNeighborBlockChange(World var1, int var2, int var3, int var4, int var5) {
        if (!var1.multiplayerWorld) {
            int var6 = var1.getBlockMetadata(var2, var3, var4);
            int var7 = var2;
            int var8 = var4;
            if ((var6 & 3) == 0) {
                var8 = var4 + 1;
            }
            if ((var6 & 3) == 1) {
                --var8;
            }
            if ((var6 & 3) == 2) {
                var7 = var2 + 1;
            }
            if ((var6 & 3) == 3) {
                --var7;
            }
            if (var5 > 0 && Block.blocksList[var5].canProvidePower()) {
                boolean var9 = var1.isBlockIndirectlyGettingPowered(var2, var3, var4);
                this.onPoweredBlockChange(var1, var2, var3, var4, var9);
            }
        }
    }

    @Override
    public MovingObjectPosition collisionRayTrace(World var1, int var2, int var3, int var4, Vec3D var5, Vec3D var6) {
        this.setBlockBoundsBasedOnState(var1, var2, var3, var4);
        return super.collisionRayTrace(var1, var2, var3, var4, var5, var6);
    }

    @Override
    public void onBlockPlaced(World var1, int var2, int var3, int var4, int var5) {
        int var6 = 0;
        if (var5 == 2) {
            var6 = 0;
        }
        if (var5 == 3) {
            var6 = 1;
        }
        if (var5 == 4) {
            var6 = 2;
        }
        if (var5 == 5) {
            var6 = 3;
        }
        var1.setBlockMetadataWithNotify(var2, var3, var4, var6);
    }

    public static boolean isTrapdoorOpen(int var0) {
        return (var0 & 4) != 0;
    }
}

