/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.game.block;

import net.minecraft.src.client.physics.AxisAlignedBB;
import net.minecraft.src.game.block.Block;
import net.minecraft.src.game.block.Material;
import net.minecraft.src.game.entity.Entity;
import net.minecraft.src.game.entity.player.EntityPlayer;
import net.minecraft.src.game.item.Item;
import net.minecraft.src.game.item.ItemStack;
import net.minecraft.src.game.level.World;
import net.minecraft.src.game.stats.StatList;

public class BlockSoulSand
extends Block {
    public BlockSoulSand(int var1, int var2) {
        super(var1, var2, Material.sand);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World var1, int var2, int var3, int var4) {
        float var5 = 0.125f;
        return AxisAlignedBB.getBoundingBoxFromPool(var2, var3, var4, var2 + 1, (float)(var3 + 1) - var5, var4 + 1);
    }

    @Override
    public void onEntityCollidedWithBlock(World var1, int var2, int var3, int var4, Entity var5) {
        var5.motionX *= 0.4;
        var5.motionZ *= 0.4;
    }

    @Override
    public void harvestBlock(World world, EntityPlayer thePlayer, int xCoord, int yCoord, int zCoord, int damageMetadata) {
        if (!world.multiplayerWorld && thePlayer.getCurrentEquippedItem() != null && thePlayer.getCurrentEquippedItem().itemID == Item.shovelFire.itemID) {
            thePlayer.addStat(StatList.mineBlockStatArray[this.blockID], 1);
            this.dropBlockAsItem_do(world, xCoord, yCoord, zCoord, new ItemStack(Block.temperedGlass.blockID, 1, damageMetadata & 3));
        } else {
            super.harvestBlock(world, thePlayer, xCoord, yCoord, zCoord, damageMetadata);
        }
    }
}

